/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.util.validation.metadata;

import java.util.List;
import java.util.Objects;
import shaded.net.sf.jsqlparser.util.validation.metadata.NamedObject;

public class Named {
    private final NamedObject namedObject;
    private final String fqn;
    private String alias;
    private List<NamedObject> parents;
    private String fqnLookup;
    private String aliasLookup;

    public Named(NamedObject namedObject, String fqn) {
        Objects.requireNonNull(namedObject, "named object must not be null");
        Objects.requireNonNull(fqn, "fully qualified name must not be null");
        this.namedObject = namedObject;
        this.fqn = fqn;
    }

    public String getFqn() {
        return this.fqn;
    }

    public String getAlias() {
        return this.alias;
    }

    public Named setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public NamedObject getNamedObject() {
        return this.namedObject;
    }

    public List<NamedObject> getParents() {
        return this.parents;
    }

    public Named setParents(List<NamedObject> parents) {
        this.parents = parents;
        return this;
    }

    public Named setFqnLookup(String fqnLookup) {
        this.fqnLookup = fqnLookup;
        return this;
    }

    public Named setAliasLookup(String aliasLookup) {
        this.aliasLookup = aliasLookup;
        return this;
    }

    public String getFqnLookup() {
        return this.fqnLookup;
    }

    public String getAliasLookup() {
        return this.aliasLookup;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + this.fqn.hashCode();
        result = 31 * result + this.namedObject.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Named other = (Named)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (!this.fqn.equals(other.fqn)) {
            return false;
        }
        return this.namedObject == other.namedObject;
    }

    public String toString() {
        return "Named [namedObject=" + (Object)((Object)this.namedObject) + ", fqn=" + this.fqn + ", alias=" + this.alias + ", parents=" + this.parents + "]";
    }
}

