/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal.db;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.execution.MongoExecutionsDto;
import org.evomaster.client.java.controller.api.dto.database.execution.MongoFailedQuery;
import org.evomaster.client.java.controller.internal.TaintHandlerExecutionTracer;
import org.evomaster.client.java.controller.internal.db.MongoCommandWithDistance;
import org.evomaster.client.java.controller.internal.db.MongoDistanceWithMetrics;
import org.evomaster.client.java.controller.mongo.MongoHeuristicsCalculator;
import org.evomaster.client.java.controller.mongo.MongoOperation;
import org.evomaster.client.java.instrumentation.MongoCollectionSchema;
import org.evomaster.client.java.instrumentation.MongoFindCommand;
import org.evomaster.client.java.utils.SimpleLogger;

public class MongoHandler {
    public static final String MONGO_COLLECTION_CLASS_NAME = "com.mongodb.client.MongoCollection";
    private final List<MongoFindCommand> operations;
    private volatile boolean extractMongoExecution = true;
    private final List<MongoCommandWithDistance> mongoCommandWithDistances;
    private volatile boolean calculateHeuristics = true;
    private final List<MongoOperation> emptyCollections;
    private final Map<String, String> collectionSchemas;
    private Object mongoClient = null;
    private final MongoHeuristicsCalculator calculator = new MongoHeuristicsCalculator(new TaintHandlerExecutionTracer());

    public MongoHandler() {
        this.mongoCommandWithDistances = new ArrayList<MongoCommandWithDistance>();
        this.operations = new ArrayList<MongoFindCommand>();
        this.emptyCollections = new ArrayList<MongoOperation>();
        this.collectionSchemas = new HashMap<String, String>();
    }

    public void reset() {
        this.operations.clear();
        this.mongoCommandWithDistances.clear();
        this.emptyCollections.clear();
    }

    public boolean isCalculateHeuristics() {
        return this.calculateHeuristics;
    }

    public boolean isExtractMongoExecution() {
        return this.extractMongoExecution;
    }

    public void setCalculateHeuristics(boolean calculateHeuristics) {
        this.calculateHeuristics = calculateHeuristics;
    }

    public void setExtractMongoExecution(boolean extractMongoExecution) {
        this.extractMongoExecution = extractMongoExecution;
    }

    public void handle(MongoFindCommand info) {
        if (this.extractMongoExecution) {
            this.operations.add(info);
        }
    }

    public void handle(MongoCollectionSchema info) {
        if (this.extractMongoExecution) {
            this.collectionSchemas.put(info.getCollectionName(), info.getCollectionSchema());
        }
    }

    public List<MongoCommandWithDistance> getEvaluatedMongoCommands() {
        this.operations.stream().filter(info -> info.getQuery() != null).forEach(mongoInfo -> {
            MongoDistanceWithMetrics distanceWithMetrics = this.computeFindDistance((MongoFindCommand)mongoInfo);
            this.mongoCommandWithDistances.add(new MongoCommandWithDistance(mongoInfo.getQuery(), distanceWithMetrics));
        });
        this.operations.clear();
        return this.mongoCommandWithDistances;
    }

    public MongoExecutionsDto getExecutionDto() {
        MongoExecutionsDto dto = new MongoExecutionsDto();
        dto.failedQueries = this.emptyCollections.stream().map(this::extractRelevantInfo).collect(Collectors.toList());
        return dto;
    }

    private static Class<?> getCollectionClass(Object collection) throws ClassNotFoundException {
        return Arrays.stream(collection.getClass().getInterfaces()).filter(iface -> iface.getName().equals(MONGO_COLLECTION_CLASS_NAME)).findFirst().orElseThrow(() -> new ClassNotFoundException("Could not find class com.mongodb.client.MongoCollection"));
    }

    private Iterable<?> getDocuments(Object collection) {
        try {
            Class<?> collectionClass = MongoHandler.getCollectionClass(collection);
            Iterable findIterable = (Iterable)collectionClass.getMethod("find", new Class[0]).invoke(collection, new Object[0]);
            return findIterable;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to retrieve all documents from a mongo collection", e);
        }
    }

    private MongoDistanceWithMetrics computeFindDistance(MongoFindCommand info) {
        boolean collectionIsEmpty;
        String collectionName;
        String databaseName = info.getDatabaseName();
        Object collection = this.getCollection(databaseName, collectionName = info.getCollectionName());
        Iterable<?> documents = this.getDocuments(collection);
        boolean bl = collectionIsEmpty = !documents.iterator().hasNext();
        if (collectionIsEmpty) {
            this.emptyCollections.add(new MongoOperation(info.getCollectionName(), info.getQuery(), info.getDatabaseName(), info.getDocumentsType()));
        }
        double min = Double.MAX_VALUE;
        int numberOfEvaluatedDocuments = 0;
        for (Object doc : documents) {
            double findDistance;
            ++numberOfEvaluatedDocuments;
            try {
                findDistance = this.calculator.computeExpression(info.getQuery(), doc);
            }
            catch (Exception ex) {
                SimpleLogger.uniqueWarn("Failed to compute find: " + info.getQuery() + " with data " + doc);
                findDistance = Double.MAX_VALUE;
            }
            if (findDistance == 0.0) {
                return new MongoDistanceWithMetrics(0.0, numberOfEvaluatedDocuments);
            }
            if (!(findDistance < min)) continue;
            min = findDistance;
        }
        return new MongoDistanceWithMetrics(min, numberOfEvaluatedDocuments);
    }

    private Object getCollection(String databaseName, String collectionName) {
        try {
            Class<?> mongoClientClass = this.mongoClient.getClass();
            Method getDatabaseMethod = mongoClientClass.getMethod("getDatabase", String.class);
            Object database = getDatabaseMethod.invoke(this.mongoClient, databaseName);
            Class<?> mongoDatabaseClass = database.getClass();
            Method getCollectionMethod = mongoDatabaseClass.getMethod("getCollection", String.class);
            Object collection = getCollectionMethod.invoke(database, collectionName);
            return collection;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to retrieve a Mongo collection instance", e);
        }
    }

    private MongoFailedQuery extractRelevantInfo(MongoOperation operation) {
        String documentsType = this.collectionSchemaIsRegistered(operation.getCollectionName()) ? this.collectionSchemas.get(operation.getCollectionName()) : operation.getDocumentsType();
        return new MongoFailedQuery(operation.getDatabaseName(), operation.getCollectionName(), documentsType);
    }

    private boolean collectionSchemaIsRegistered(String collectionName) {
        return this.collectionSchemas.containsKey(collectionName);
    }

    public void setMongoClient(Object mongoClient) {
        this.mongoClient = mongoClient;
    }
}

