/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.visitor.classv;

import org.evomaster.client.java.instrumentation.Constants;
import org.evomaster.client.java.instrumentation.coverage.visitor.methodv.BranchCovMethodVisitor;
import org.evomaster.client.java.instrumentation.coverage.visitor.methodv.CheckCastMethodVisitor;
import org.evomaster.client.java.instrumentation.coverage.visitor.methodv.LineCovMethodVisitor;
import org.evomaster.client.java.instrumentation.coverage.visitor.methodv.MethodReplacementMethodVisitor;
import org.evomaster.client.java.instrumentation.coverage.visitor.methodv.NonIntegerComparisonsMethodVisitor;
import org.evomaster.client.java.instrumentation.coverage.visitor.methodv.ScheduledMethodVisitor;
import org.evomaster.client.java.instrumentation.coverage.visitor.methodv.SuccessCallMethodVisitor;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.shared.ObjectiveNaming;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import shaded.org.objectweb.asm.ClassVisitor;
import shaded.org.objectweb.asm.MethodVisitor;
import shaded.org.objectweb.asm.commons.JSRInlinerAdapter;

public class CoverageClassVisitor
extends ClassVisitor {
    private final String bytecodeClassName;

    public CoverageClassVisitor(ClassVisitor cv, ClassName className) {
        super(589824, cv);
        this.bytecodeClassName = className.getBytecodeName();
        UnitsInfoRecorder.markNewUnit(className.getFullNameWithDots());
    }

    @Override
    public MethodVisitor visitMethod(int methodAccess, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, name, descriptor, signature, exceptions);
        mv = new JSRInlinerAdapter(mv, methodAccess, name, descriptor, signature, exceptions);
        if (Constants.isMethodBridge(methodAccess)) {
            return mv;
        }
        if (name.equals("<clinit>")) {
            return mv;
        }
        if (this.bytecodeClassName.contains("$InterceptedDefinition") || this.bytecodeClassName.contains("$Definition") || this.bytecodeClassName.contains("$Introspection")) {
            return mv;
        }
        ObjectiveRecorder.registerTarget(ObjectiveNaming.classObjectiveName(this.bytecodeClassName));
        mv = new ScheduledMethodVisitor(mv);
        mv = new LineCovMethodVisitor(mv, this.bytecodeClassName, name, descriptor);
        mv = new BranchCovMethodVisitor(mv, this.bytecodeClassName, name, descriptor);
        mv = new SuccessCallMethodVisitor(mv, this.bytecodeClassName, name, descriptor);
        mv = new MethodReplacementMethodVisitor(true, true, mv, this.bytecodeClassName, name, descriptor);
        mv = new NonIntegerComparisonsMethodVisitor(mv, this.bytecodeClassName, name, descriptor);
        mv = new CheckCastMethodVisitor(mv);
        return mv;
    }
}

