/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.delete.Delete;
import shaded.net.sf.jsqlparser.statement.insert.Insert;
import shaded.net.sf.jsqlparser.statement.select.FromItem;
import shaded.net.sf.jsqlparser.statement.select.Join;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.update.Update;

public class ColumnTableAnalyzer {
    public static Set<String> getDeletedTables(String delete) {
        if (!SqlParserUtils.isDelete(delete)) {
            throw new IllegalArgumentException("Input string is not a valid SQL DELETE: " + delete);
        }
        HashSet<String> set = new HashSet<String>();
        Delete stmt = (Delete)SqlParserUtils.parseSqlCommand(delete);
        Table table = stmt.getTable();
        if (table == null) {
            throw new IllegalArgumentException("Cannot handle delete: " + delete);
        }
        set.add(table.getName());
        return set;
    }

    public static Map<String, Set<String>> getInsertedDataFields(String insert) {
        if (!SqlParserUtils.isInsert(insert)) {
            throw new IllegalArgumentException("Input string is not a valid SQL INSERT: " + insert);
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        Insert stmt = (Insert)SqlParserUtils.parseSqlCommand(insert);
        Table table = stmt.getTable();
        if (table == null) {
            throw new IllegalArgumentException("Cannot handle insert: " + insert);
        }
        ColumnTableAnalyzer.handleTable(map, table);
        return map;
    }

    public static Map<String, Set<String>> getUpdatedDataFields(String update) {
        if (!SqlParserUtils.isUpdate(update)) {
            throw new IllegalArgumentException("Input string is not a valid SQL INSERT: " + update);
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        Update stmt = (Update)SqlParserUtils.parseSqlCommand(update);
        Table table = stmt.getTable();
        if (table == null) {
            throw new IllegalArgumentException("Cannot handle update: " + update);
        }
        ColumnTableAnalyzer.handleTable(map, table);
        return map;
    }

    public static Map<String, Set<String>> getSelectReadDataFields(String select) {
        if (!SqlParserUtils.isSelect(select)) {
            throw new IllegalArgumentException("Input string is not a valid SQL SELECT: " + select);
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        Select stmt = (Select)SqlParserUtils.parseSqlCommand(select);
        PlainSelect plainSelect = stmt.getPlainSelect();
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem == null) {
            return map;
        }
        ColumnTableAnalyzer.extractUsedColumnsAndTables(map, fromItem);
        List<Join> joins = plainSelect.getJoins();
        if (joins != null) {
            for (Join join : joins) {
                FromItem rightItem = join.getRightItem();
                ColumnTableAnalyzer.extractUsedColumnsAndTables(map, rightItem);
            }
        }
        return map;
    }

    private static void handleTable(Map<String, Set<String>> map, Table table) {
        Set columns = map.computeIfAbsent(table.getName(), k -> new HashSet());
        if (!columns.contains("*")) {
            columns.add("*");
        }
    }

    private static void extractUsedColumnsAndTables(Map<String, Set<String>> map, FromItem fromItem) {
        if (!(fromItem instanceof Table)) {
            throw new IllegalArgumentException("Cannot handle fromItem: " + fromItem.toString());
        }
        Table table = (Table)fromItem;
        ColumnTableAnalyzer.handleTable(map, table);
    }
}

