/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.evomaster.client.java.utils.SimpleLogger;

public class ColumnTypeParser {
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss.SSSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "HH:mm:ss.SSSS", "HH:mm:ss"};

    public static Instant getAsInstant(String content) {
        List<Function> parsers = Arrays.asList(s -> ZonedDateTime.parse(s).toInstant(), Instant::parse, s -> OffsetDateTime.parse(s, DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSX")).toInstant(), s -> {
            DateTimeFormatter df = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("dd-MMM-yy").toFormatter(Locale.ENGLISH);
            return LocalDate.parse(content.toString(), df).atStartOfDay().toInstant(ZoneOffset.UTC);
        }, s -> ColumnTypeParser.parseDate(s));
        for (Function p : parsers) {
            try {
                return (Instant)p.apply(content);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        SimpleLogger.warn("Cannot handle time value in the format: " + content);
        return null;
    }

    private static Instant parseDate(String str) {
        for (String dformat : DATE_FORMATS) {
            try {
                return new SimpleDateFormat(dformat).parse(str).toInstant();
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException("Cannot parse to yyyy-MM-dd HH:mm:ss.SSSS, yyyy-MM-dd HH:mm:ss");
    }
}

