/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import shaded.net.sf.jsqlparser.JSQLParserException;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.delete.Delete;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.update.Update;

public class SqlParserUtils {
    public static boolean isSelect(String sqlCommand) {
        return SqlParserUtils.startsWithIgnoreCase(sqlCommand, "select") && !SqlParserUtils.isASequence(sqlCommand);
    }

    public static boolean isDelete(String sqlCommand) {
        return SqlParserUtils.startsWithIgnoreCase(sqlCommand, "delete");
    }

    public static boolean isUpdate(String sqlCommand) {
        return SqlParserUtils.startsWithIgnoreCase(sqlCommand, "update");
    }

    public static boolean isInsert(String sqlCommand) {
        return SqlParserUtils.startsWithIgnoreCase(sqlCommand, "insert");
    }

    private static boolean startsWithIgnoreCase(String input, String prefix) {
        return input != null && input.trim().toLowerCase().startsWith(prefix);
    }

    private static boolean isASequence(String input) {
        return input != null && input.trim().toLowerCase().matches(".*(currval|nextval).*");
    }

    public static boolean isSelectOne(String sqlCommand) {
        return sqlCommand != null && sqlCommand.trim().toLowerCase().matches("select\\s+-?\\d+\\s*;?");
    }

    public static Expression getWhere(Statement parsedStatement) {
        if (parsedStatement instanceof Select) {
            Select select = (Select)parsedStatement;
            PlainSelect plainSelect = select.getPlainSelect();
            return plainSelect.getWhere();
        }
        if (parsedStatement instanceof Delete) {
            return ((Delete)parsedStatement).getWhere();
        }
        if (parsedStatement instanceof Update) {
            return ((Update)parsedStatement).getWhere();
        }
        throw new IllegalArgumentException("Cannot handle statement: " + parsedStatement.toString());
    }

    public static Statement parseSqlCommand(String sqlCommand) {
        try {
            Statement stmt = CCJSqlParserUtil.parse(sqlCommand);
            return stmt;
        }
        catch (JSQLParserException e) {
            throw new IllegalArgumentException("Cannot parse SQL command: " + sqlCommand + "\n" + e.getMessage(), e);
        }
    }

    public static boolean canParseSqlStatement(String sqlCommand) {
        try {
            CCJSqlParserUtil.parse(sqlCommand);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

