/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.ActionDto;
import org.evomaster.client.java.controller.api.dto.BootTimeInfoDto;
import org.evomaster.client.java.controller.api.dto.ExternalServiceMappingDto;
import org.evomaster.client.java.controller.api.dto.UnitsInfoDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ScheduleTaskInvocationDto;
import org.evomaster.client.java.controller.internal.SutController;
import org.evomaster.client.java.instrumentation.Action;
import org.evomaster.client.java.instrumentation.AdditionalInfo;
import org.evomaster.client.java.instrumentation.ExternalService;
import org.evomaster.client.java.instrumentation.ExternalServiceMapping;
import org.evomaster.client.java.instrumentation.InstrumentationController;
import org.evomaster.client.java.instrumentation.TargetInfo;
import org.evomaster.client.java.instrumentation.external.JarAgentLocator;
import org.evomaster.client.java.instrumentation.external.ServerController;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import org.evomaster.client.java.utils.SimpleLogger;

public abstract class ExternalSutController
extends SutController {
    public static final String PROP_MUTE_SUT = "em.muteSUT";
    protected volatile Process process;
    private volatile boolean instrumentation;
    private volatile Thread processKillHook;
    private volatile Thread outputPrinter;
    private volatile Thread sutStartChecker;
    private volatile CountDownLatch latch;
    private volatile ServerController serverController;
    private volatile boolean initialized;
    private volatile StringBuffer errorBuffer;
    private volatile String javaCommand = "java";
    private volatile String jaCoCoAgentLocation = "";
    private volatile String jaCoCoCliLocation = "";
    private volatile String jaCoCoOutputFile = "";
    private volatile int jaCoCoPort = 0;
    private volatile boolean needsJdk17Options = false;

    public final ExternalSutController setJaCoCo(String jaCoCoAgentLocation, String jaCoCoCliLocation, String jaCoCoOutputFile, int port) {
        this.jaCoCoAgentLocation = jaCoCoAgentLocation;
        this.jaCoCoCliLocation = jaCoCoCliLocation;
        this.jaCoCoOutputFile = jaCoCoOutputFile;
        this.jaCoCoPort = port;
        return this;
    }

    public int getWaitingSecondsForIncomingConnection() {
        return 20000;
    }

    @Override
    public final void setupForGeneratedTest() {
    }

    public void setNeedsJdk17Options(boolean needsJdk17Options) {
        this.needsJdk17Options = needsJdk17Options;
    }

    public final void setInstrumentation(boolean instrumentation) {
        this.instrumentation = instrumentation;
    }

    public abstract String[] getInputParameters();

    public abstract String[] getJVMParameters();

    public abstract String getBaseURL();

    public abstract String getPathToExecutableJar();

    public abstract String getLogMessageOfInitializedServer();

    public Boolean isSUTInitialized() {
        return null;
    }

    public abstract long getMaxAwaitForInitializationInSeconds();

    public abstract void preStart();

    public abstract void postStart();

    public abstract void preStop();

    public abstract void postStop();

    public final ExternalSutController setJavaCommand(String command) {
        if (command == null || command.isEmpty()) {
            throw new IllegalArgumentException("Empty java command");
        }
        this.javaCommand = command;
        return this;
    }

    @Override
    public final String startSut() {
        boolean completed;
        boolean connected;
        String toSkip;
        SimpleLogger.info("Going to start the SUT");
        this.initialized = false;
        this.validateJarPath();
        this.preStart();
        this.processKillHook = new Thread(() -> this.killProcess());
        Runtime.getRuntime().addShutdownHook(this.processKillHook);
        this.latch = new CountDownLatch(1);
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.javaCommand);
        if (this.instrumentation) {
            String jarPath;
            if (this.serverController == null) {
                this.serverController = new ServerController();
            }
            int port = this.serverController.startServer();
            command.add("-Devomaster.javaagent.external.port=" + port);
            String categories = System.getProperty("evomaster.javaagent.replacement_categories");
            if (categories != null && !categories.isEmpty()) {
                command.add("-Devomaster.javaagent.replacement_categories=" + categories);
            }
            if ((jarPath = JarAgentLocator.getAgentJarPath()) == null) {
                throw new IllegalStateException("Cannot locate JAR file with EvoMaster Java Agent");
            }
            command.add("-javaagent:" + jarPath + "=" + this.getPackagePrefixesToCover());
        }
        for (String s2 : this.getJVMParameters()) {
            String token;
            if (s2 == null || (token = s2.trim()).isEmpty()) continue;
            command.add(token);
        }
        if (this.needsJdk17Options) {
            Arrays.stream("--add-opens java.base/java.util.regex=ALL-UNNAMED --add-opens java.base/java.net=ALL-UNNAMED --add-opens java.base/java.lang=ALL-UNNAMED".split(" ")).forEach(it -> command.add((String)it));
        }
        if ((toSkip = System.getProperty("em.skipClasses")) != null && !toSkip.isEmpty()) {
            command.add("-Dem.skipClasses=" + toSkip);
        }
        if (command.stream().noneMatch(s -> s.startsWith("-Xmx"))) {
            command.add("-Xmx2G");
        }
        if (command.stream().noneMatch(s -> s.startsWith("-Xms"))) {
            command.add("-Xms1G");
        }
        if (this.isUsingJaCoCo()) {
            command.add("-javaagent:" + this.jaCoCoAgentLocation + "=output=tcpserver,port=" + this.jaCoCoPort + ",append=false,dumponexit=true");
        }
        command.add("-jar");
        command.add(this.getPathToExecutableJar());
        for (String s3 : this.getInputParameters()) {
            String token;
            if (s3 == null || (token = s3.trim()).isEmpty()) continue;
            command.add(token);
        }
        SimpleLogger.info("Going to start SUT with command:\n" + String.join((CharSequence)" ", command));
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        try {
            this.process = builder.start();
        }
        catch (IOException e) {
            SimpleLogger.error("Failed to start external process", e);
            return null;
        }
        this.checkSutInitialized();
        if (this.instrumentation && this.serverController != null && !(connected = this.serverController.waitForIncomingConnection(this.getWaitingSecondsForIncomingConnection()))) {
            SimpleLogger.error("Could not establish connection to retrieve code metrics");
            if (this.errorBuffer != null) {
                SimpleLogger.error("SUT output:\n" + this.errorBuffer.toString());
            }
            this.stopSut();
            return null;
        }
        long timeout = this.getMaxAwaitForInitializationInSeconds();
        try {
            completed = this.latch.await(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            SimpleLogger.error("Interrupted controller");
            this.stopSut();
            return null;
        }
        if (!completed) {
            SimpleLogger.error("SUT has not started properly within " + timeout + " seconds");
            if (this.errorBuffer != null) {
                SimpleLogger.error("SUT output:\n" + this.errorBuffer.toString());
            }
            this.stopSut();
            return null;
        }
        if (!this.isSutRunning()) {
            SimpleLogger.error("SUT started but then terminated. Likely a possible misconfiguration");
            if (this.errorBuffer != null) {
                SimpleLogger.error("SUT output:\n" + this.errorBuffer.toString());
            }
            this.stopSut();
            return null;
        }
        if (!this.initialized) {
            SimpleLogger.error("SUT is started but not initialized");
            if (this.errorBuffer != null) {
                SimpleLogger.error("SUT output:\n" + this.errorBuffer.toString());
            }
            this.stopSut();
            return null;
        }
        this.postStart();
        return this.getBaseURL();
    }

    @Override
    public final boolean isSutRunning() {
        return this.process != null && this.process.isAlive();
    }

    @Override
    public final void stopSut() {
        SimpleLogger.info("Going to stop the SUT");
        this.preStop();
        if (this.serverController != null) {
            this.serverController.closeServer();
        }
        this.killProcess();
        this.initialized = false;
        this.postStop();
    }

    @Override
    public final boolean isInstrumentationActivated() {
        return this.instrumentation && this.isConnectedToServerController();
    }

    public final boolean isConnectedToServerController() {
        return this.serverController != null && this.serverController.isConnectionOn();
    }

    @Override
    public final void newSearch() {
        if (this.isInstrumentationActivated()) {
            this.serverController.resetForNewSearch();
        }
    }

    @Override
    public final void newTestSpecificHandler() {
        if (this.isInstrumentationActivated()) {
            this.serverController.resetForNewTest();
        }
        InstrumentationController.resetForNewTest();
    }

    @Override
    public final List<TargetInfo> getTargetInfos(Collection<Integer> ids, boolean fullyCovered, boolean descriptiveIds) {
        this.checkInstrumentation();
        return this.serverController.getTargetsInfo(ids, fullyCovered, descriptiveIds);
    }

    @Override
    public final List<AdditionalInfo> getAdditionalInfoList() {
        this.checkInstrumentation();
        List<AdditionalInfo> info = this.serverController.getAdditionalInfoList();
        List<AdditionalInfo> local = ExecutionTracer.exposeAdditionalInfoList();
        AdditionalInfo first = info.get(0);
        local.stream().flatMap(x -> x.getStringSpecializationsView().entrySet().stream()).forEach(p -> ((Set)p.getValue()).stream().forEach(s -> first.addSpecialization((String)p.getKey(), (StringSpecializationInfo)s)));
        return info;
    }

    @Override
    public BootTimeInfoDto getBootTimeInfoDto() {
        if (!this.isInstrumentationActivated()) {
            return null;
        }
        return this.getBootTimeInfoDto(this.serverController.handleBootTimeObjectiveInfo());
    }

    @Override
    public final void newActionSpecificHandler(ActionDto dto) {
        if (this.isInstrumentationActivated()) {
            this.serverController.setAction(new Action(dto.index, dto.name, dto.inputVariables, dto.externalServiceMapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ExternalServiceMapping(((ExternalServiceMappingDto)e.getValue()).remoteHostname, ((ExternalServiceMappingDto)e.getValue()).localIPAddress, ((ExternalServiceMappingDto)e.getValue()).signature, ((ExternalServiceMappingDto)e.getValue()).isActive))), dto.localAddressMapping, dto.skippedExternalServices.stream().map(e -> new ExternalService(e.hostname, e.port)).collect(Collectors.toList())));
        }
    }

    @Override
    public final void newScheduleActionSpecificHandler(ScheduleTaskInvocationDto dto) {
        if (this.isInstrumentationActivated()) {
            ArrayList<String> inputVariables = new ArrayList<String>();
            if (dto.requestParams != null && !dto.requestParams.isEmpty()) {
                inputVariables.addAll(dto.requestParams.stream().map(e -> e.stringValue).collect(Collectors.toList()));
            } else if (dto.requestParamsAsStrings != null) {
                inputVariables.addAll(dto.requestParamsAsStrings);
            }
            this.serverController.setAction(new Action(dto.index, dto.taskName, inputVariables, new HashMap<String, ExternalServiceMapping>(), new HashMap<String, String>(), new ArrayList<ExternalService>()));
        }
    }

    @Override
    public final UnitsInfoDto getUnitsInfoDto() {
        if (!this.isInstrumentationActivated()) {
            return null;
        }
        UnitsInfoRecorder recorder = this.serverController.getUnitsInfoRecorder();
        assert (recorder.areClassesAnalyzed());
        return this.getUnitsInfoDto(this.serverController.getUnitsInfoRecorder());
    }

    @Override
    public final void setKillSwitch(boolean b) {
        this.checkInstrumentation();
        this.serverController.setKillSwitch(b);
        ExecutionTracer.setKillSwitch(b);
    }

    @Override
    public final void setExecutingInitSql(boolean executingInitSql) {
        this.checkInstrumentation();
        this.serverController.setExecutingInitSql(executingInitSql);
        ExecutionTracer.setExecutingInitSql(executingInitSql);
    }

    @Override
    public final void setExecutingInitMongo(boolean executingInitMongo) {
        this.checkInstrumentation();
        this.serverController.setExecutingInitMongo(executingInitMongo);
        ExecutionTracer.setExecutingInitMongo(executingInitMongo);
    }

    @Override
    public final void setExecutingAction(boolean executingAction) {
        this.checkInstrumentation();
        this.serverController.setExecutingAction(executingAction);
        ExecutionTracer.setExecutingAction(executingAction);
    }

    @Override
    public final void bootingSut(boolean bootingSut) {
        if (bootingSut && !this.isConnectedToServerController()) {
            return;
        }
        this.checkInstrumentation();
        this.serverController.setBootingSut(bootingSut);
        ObjectiveRecorder.setBooting(bootingSut);
    }

    @Override
    public final String getExecutableFullPath() {
        this.validateJarPath();
        String path = this.getPathToExecutableJar();
        return Paths.get(path, new String[0]).toAbsolutePath().toString();
    }

    @Override
    public final void getJvmDtoSchema(List<String> dtoNames) {
        if (!this.isInstrumentationActivated()) {
            return;
        }
        this.serverController.extractSpecifiedDto(dtoNames);
    }

    private boolean isUsingJaCoCo() {
        return !this.jaCoCoAgentLocation.isEmpty() && !this.jaCoCoOutputFile.isEmpty() && !this.jaCoCoCliLocation.isEmpty();
    }

    private void checkInstrumentation() {
        if (!this.isInstrumentationActivated()) {
            throw new IllegalStateException("Instrumentation is not active");
        }
    }

    private void validateJarPath() {
        String path = this.getPathToExecutableJar();
        if (!path.endsWith(".jar")) {
            throw new IllegalStateException("Invalid jar path does not end with '.jar': " + path);
        }
        if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("File does not exist: " + path);
        }
    }

    private void killProcess() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.processKillHook);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.process != null) {
            if (this.isUsingJaCoCo()) {
                this.dumpJaCoCo();
            }
            this.process.destroy();
            try {
                this.process.getOutputStream().close();
                this.process.getInputStream().close();
                this.process.getErrorStream().close();
            }
            catch (Exception t) {
                SimpleLogger.error("Failed to close process stream: " + t.toString());
            }
            this.process = null;
        }
    }

    private void dumpJaCoCo() {
        try {
            Process dump = Runtime.getRuntime().exec(new String[]{"java", "-jar", this.jaCoCoCliLocation, "dump", "--destfile", this.jaCoCoOutputFile, "--port", "" + this.jaCoCoPort});
            dump.waitFor(5L, TimeUnit.SECONDS);
            if (dump.exitValue() > 0) {
                SimpleLogger.error("Failed to dump JaCoCo report");
            }
        }
        catch (Exception e) {
            SimpleLogger.error("Failed to dump JaCoCo report", e);
        }
    }

    private void attemptGracefulShutdown(Process process) {
        long pid = 42L;
        String killCommand = "kill -n 2 " + pid;
        boolean ok = false;
        String os = System.getProperty("os.name");
        try {
            Process killer;
            if (os.toLowerCase().contains("window")) {
                String path = System.getenv("PROGRAMFILES");
                path = path + "\\Git\\git-bash.exe";
                killer = Runtime.getRuntime().exec(new String[]{path, "-c", killCommand});
            } else {
                killer = Runtime.getRuntime().exec(killCommand);
            }
            killer.waitFor(3L, TimeUnit.SECONDS);
            if (killer.exitValue() > 0) {
                SimpleLogger.error("Failed to SIGINT the SUT");
                return;
            }
            ok = true;
        }
        catch (Exception e) {
            SimpleLogger.error("Failed to SIGINT the SUT", e);
            return;
        }
        if (ok) {
            try {
                process.waitFor(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void checkSutInitialized() {
        Boolean started = this.isSUTInitialized();
        if (started != null) {
            this.startSutStartChecker(started);
        }
        this.startExternalProcessPrinter(started == null);
    }

    private void startSutStartChecker(boolean started) {
        if (this.sutStartChecker == null || !this.sutStartChecker.isAlive()) {
            this.sutStartChecker = new Thread(() -> {
                try {
                    while (!started && !this.isSUTInitialized().booleanValue()) {
                        Thread.sleep(2000L);
                    }
                    this.initialized = true;
                    this.errorBuffer = null;
                    this.latch.countDown();
                }
                catch (Exception e) {
                    SimpleLogger.error("Failed to check ", e);
                }
            });
            this.sutStartChecker.start();
        }
    }

    protected void startExternalProcessPrinter(boolean checkSutInitializedWithLog) {
        if (this.outputPrinter == null || !this.outputPrinter.isAlive()) {
            this.outputPrinter = new Thread(() -> {
                try {
                    boolean muted = Boolean.parseBoolean(System.getProperty(PROP_MUTE_SUT));
                    if (muted) {
                        this.errorBuffer = new StringBuffer(4096);
                    }
                    Scanner scanner = new Scanner(new BufferedReader(new InputStreamReader(this.process.getInputStream())));
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        if (!muted) {
                            SimpleLogger.info("SUT: " + line);
                        } else if (this.errorBuffer != null) {
                            this.errorBuffer.append(line);
                            this.errorBuffer.append("\n");
                        }
                        if (!checkSutInitializedWithLog || !line.contains(this.getLogMessageOfInitializedServer())) continue;
                        this.initialized = true;
                        this.errorBuffer = null;
                        this.latch.countDown();
                    }
                    if (this.process == null) {
                        SimpleLogger.warn("SUT was manually terminated ('process' reference is null)");
                    } else if (!this.initialized) {
                        if (!this.process.isAlive()) {
                            SimpleLogger.warn("SUT was terminated before initialization. Exit code: " + this.process.exitValue());
                        } else {
                            SimpleLogger.warn("SUT is still alive, but its output was closed before producing the initialization message.");
                        }
                    } else {
                        SimpleLogger.info("Process output has been closed");
                    }
                    this.latch.countDown();
                }
                catch (Exception e) {
                    SimpleLogger.error("Failed to handle external process printer", e);
                }
            });
            this.outputPrinter.start();
        }
    }
}

