/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.evomaster.client.java.instrumentation.MongoCollectionSchema;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyCast;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyMethodReplacementClass;
import org.evomaster.client.java.instrumentation.object.ClassToSchema;
import org.evomaster.client.java.instrumentation.object.CustomTypeToOasConverter;
import org.evomaster.client.java.instrumentation.object.GeoJsonPointToOasConverter;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class MappingMongoEntityInformationClassReplacement
extends ThirdPartyMethodReplacementClass {
    private static final MappingMongoEntityInformationClassReplacement singleton = new MappingMongoEntityInformationClassReplacement();
    private static ThreadLocal<Object> instance = new ThreadLocal();

    @Override
    protected String getNameOfThirdPartyTargetClass() {
        return "org.springframework.data.mongodb.repository.support.MappingMongoEntityInformation";
    }

    public static Object consumeInstance() {
        Object mappingMongoEntityInformation = instance.get();
        if (mappingMongoEntityInformation == null) {
            throw new IllegalStateException("No instance to consume");
        }
        instance.set(null);
        return mappingMongoEntityInformation;
    }

    private static void addInstance(Object x) {
        Object mappingMongoEntityInformation = instance.get();
        if (mappingMongoEntityInformation != null) {
            throw new IllegalStateException("Previous instance was not consumed");
        }
        instance.set(x);
    }

    @Replacement(replacingConstructor=true, type=ReplacementType.TRACKER, category=ReplacementCategory.MONGO, id="constructorEntity", castTo="org.springframework.data.mongodb.repository.support.MappingMongoEntityInformation")
    public static void MappingMongoEntityInformation(@ThirdPartyCast(actualType="org.springframework.data.mongodb.core.mapping.MongoPersistentEntity") Object entity) {
        MappingMongoEntityInformationClassReplacement.handleMappingMongoEntityInformationConstructor("constructorEntity", Collections.singletonList(entity));
    }

    @Replacement(replacingConstructor=true, type=ReplacementType.TRACKER, category=ReplacementCategory.MONGO, id="constructorEntityCustomCollectionName", castTo="org.springframework.data.mongodb.repository.support.MappingMongoEntityInformation")
    public static void MappingMongoEntityInformation(@ThirdPartyCast(actualType="org.springframework.data.mongodb.core.mapping.MongoPersistentEntity") Object entity, String customCollectionName) {
        MappingMongoEntityInformationClassReplacement.handleMappingMongoEntityInformationConstructor("constructorEntityCustomCollectionName", Arrays.asList(entity, customCollectionName));
    }

    @Replacement(replacingConstructor=true, type=ReplacementType.TRACKER, category=ReplacementCategory.MONGO, id="constructorEntityFallbackIdType", castTo="org.springframework.data.mongodb.repository.support.MappingMongoEntityInformation")
    public static void MappingMongoEntityInformation(@ThirdPartyCast(actualType="org.springframework.data.mongodb.core.mapping.MongoPersistentEntity") Object entity, Class<?> fallbackIdType) {
        MappingMongoEntityInformationClassReplacement.handleMappingMongoEntityInformationConstructor("constructorEntityFallbackIdType", Arrays.asList(entity, fallbackIdType));
    }

    private static void handleMappingMongoEntityInformationConstructor(String id, List<Object> args) {
        Constructor original = MappingMongoEntityInformationClassReplacement.getOriginalConstructor(singleton, id);
        try {
            Object mappingMongoEntityInformation = original.newInstance(args.toArray());
            MappingMongoEntityInformationClassReplacement.addInstance(mappingMongoEntityInformation);
            String collectionName = (String)mappingMongoEntityInformation.getClass().getMethod("getCollectionName", new Class[0]).invoke(mappingMongoEntityInformation, new Object[0]);
            Class repositoryType = (Class)mappingMongoEntityInformation.getClass().getMethod("getJavaType", new Class[0]).invoke(mappingMongoEntityInformation, new Object[0]);
            List<CustomTypeToOasConverter> converters = Collections.singletonList(new GeoJsonPointToOasConverter());
            String schema = ClassToSchema.getOrDeriveSchemaWithItsRef(repositoryType, true, converters);
            ExecutionTracer.addMongoCollectionType(new MongoCollectionSchema(collectionName, schema));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

