/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.evomaster.client.java.instrumentation.OpenSearchCommand;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyCast;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyMethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class OpenSearchClientClassReplacement
extends ThirdPartyMethodReplacementClass {
    private static final OpenSearchClientClassReplacement singleton = new OpenSearchClientClassReplacement();
    private static final String THIRD_PARTY_CLASS = "org.opensearch.client.opensearch.OpenSearchClient";
    private static final String GET_METHOD = "get";
    private static final String SEARCH_METHOD = "search";
    private static final String INDEX_METHOD = "index";

    @Override
    protected String getNameOfThirdPartyTargetClass() {
        return THIRD_PARTY_CLASS;
    }

    @Replacement(type=ReplacementType.TRACKER, id="get", usageFilter=UsageFilter.ANY, category=ReplacementCategory.OPENSEARCH, castTo="org.opensearch.client.opensearch.core.GetResponse")
    public static <T> Object get(Object openSearchClient, @ThirdPartyCast(actualType="org.opensearch.client.opensearch.core.GetRequest") Object request, Class<T> documentClass) {
        return OpenSearchClientClassReplacement.handleMethod(openSearchClient, GET_METHOD, Arrays.asList(request, documentClass), request);
    }

    @Replacement(type=ReplacementType.TRACKER, id="search", usageFilter=UsageFilter.ANY, category=ReplacementCategory.OPENSEARCH, castTo="org.opensearch.client.opensearch.core.SearchResponse")
    public static <T> Object search(Object openSearchClient, @ThirdPartyCast(actualType="org.opensearch.client.opensearch.core.SearchRequest") Object request, Class<T> documentClass) {
        return OpenSearchClientClassReplacement.handleMethod(openSearchClient, SEARCH_METHOD, Arrays.asList(request, documentClass), request);
    }

    private static Object handleMethod(Object openSearchClient, String method, List<Object> args, Object query) {
        try {
            long start = System.currentTimeMillis();
            Method clientMethod = OpenSearchClientClassReplacement.retrieveMethod(openSearchClient, method);
            Object result = clientMethod.invoke(openSearchClient, args.toArray());
            long end = System.currentTimeMillis();
            OpenSearchClientClassReplacement.addOpenSearchInfo(method, query, end - start);
            return result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    private static Method retrieveMethod(Object openSearchClient, String id) {
        return OpenSearchClientClassReplacement.getOriginal(singleton, id, openSearchClient);
    }

    private static void addOpenSearchInfo(String method, Object query, long executionTime) {
        OpenSearchCommand info = new OpenSearchCommand(OpenSearchClientClassReplacement.getIndex(query), method, query, executionTime);
        ExecutionTracer.addOpenSearchInfo(info);
    }

    private static Object getIndex(Object query) {
        try {
            return query.getClass().getMethod(INDEX_METHOD, new Class[0]).invoke(query, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

