/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.sql.Clob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.operations.DataRowDto;
import org.evomaster.client.java.sql.VariableDescriptor;
import org.evomaster.client.java.sql.heuristic.SqlStringUtils;
import org.evomaster.client.java.utils.SimpleLogger;

public class DataRow {
    private final List<VariableDescriptor> variableDescriptors;
    private final List<Object> values;
    private static final String NULL_VALUE = "NULL";

    public DataRow(String tableName, List<String> columnNames, List<Object> values) {
        this(columnNames.stream().map(c -> new VariableDescriptor((String)c, null, tableName)).collect(Collectors.toList()), values);
    }

    public DataRow(String columnName, Object value, String tableName) {
        this(Arrays.asList(new VariableDescriptor(columnName, null, tableName)), Arrays.asList(value));
    }

    public DataRow(List<VariableDescriptor> descriptors, List<Object> values) {
        Objects.requireNonNull(descriptors);
        Objects.requireNonNull(values);
        if (descriptors.size() != values.size()) {
            throw new IllegalArgumentException("Size mismatch");
        }
        ArrayList<VariableDescriptor> list = new ArrayList<VariableDescriptor>();
        list.addAll(descriptors);
        this.variableDescriptors = Collections.unmodifiableList(list);
        ArrayList<Object> valList = new ArrayList<Object>();
        valList.addAll(values);
        this.values = Collections.unmodifiableList(valList);
    }

    public List<VariableDescriptor> getVariableDescriptors() {
        return this.variableDescriptors;
    }

    public List<Object> seeValues() {
        return this.values;
    }

    public Object getValue(int index) {
        Object value = this.values.get(index);
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (Exception e) {
                SimpleLogger.error("Failed to retrieve CLOB data");
                return null;
            }
        }
        return value;
    }

    public Object getValueByName(String name) {
        return this.getValueByName(name, null);
    }

    public boolean hasValueByName(String columnName, String baseTableName) {
        try {
            this.getValueByName(columnName, baseTableName);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Object getValueByName(String name, String table) {
        VariableDescriptor desc;
        int i;
        String t;
        String n = name == null ? null : name.trim();
        String string = t = table == null ? null : table.trim();
        if (n != null && n.equalsIgnoreCase("true")) {
            return true;
        }
        if (n != null && n.equalsIgnoreCase("false")) {
            return false;
        }
        if (t == null || t.isEmpty()) {
            for (i = 0; i < this.variableDescriptors.size(); ++i) {
                desc = this.variableDescriptors.get(i);
                if (!SqlStringUtils.nullSafeEqualsIgnoreCase(n, desc.getAliasColumnName())) continue;
                return this.getValue(i);
            }
        }
        for (i = 0; i < this.variableDescriptors.size(); ++i) {
            desc = this.variableDescriptors.get(i);
            if (!SqlStringUtils.nullSafeEqualsIgnoreCase(n, desc.getColumnName()) && !SqlStringUtils.nullSafeEqualsIgnoreCase(n, desc.getAliasColumnName()) || t != null && !t.isEmpty() && !SqlStringUtils.nullSafeEqualsIgnoreCase(t, desc.getTableName()) && !SqlStringUtils.nullSafeEqualsIgnoreCase(t, "___unnamed_table___")) continue;
            return this.getValue(i);
        }
        throw new IllegalArgumentException("No variable called '" + name + "' for table '" + table + "'");
    }

    public String getAsLine() {
        return this.values.stream().map(obj -> obj != null ? obj.toString() : NULL_VALUE).collect(Collectors.joining(","));
    }

    public DataRowDto toDto() {
        DataRowDto dto = new DataRowDto();
        dto.columnData = this.values.stream().map(obj -> obj != null ? obj.toString() : NULL_VALUE).collect(Collectors.toList());
        return dto;
    }

    public Object getValueByName(String columnName, String baseTableName, String aliasTableName) {
        Objects.requireNonNull(aliasTableName);
        for (int i = 0; i < this.variableDescriptors.size(); ++i) {
            VariableDescriptor desc = this.variableDescriptors.get(i);
            if (!SqlStringUtils.nullSafeEqualsIgnoreCase(columnName, desc.getColumnName()) && !SqlStringUtils.nullSafeEqualsIgnoreCase(columnName, desc.getAliasColumnName()) || !SqlStringUtils.nullSafeEqualsIgnoreCase(baseTableName, desc.getTableName()) || !SqlStringUtils.nullSafeEqualsIgnoreCase(aliasTableName, desc.getAliasTableName())) continue;
            return this.values.get(i);
        }
        throw new IllegalArgumentException("No variable called '" + columnName + "' for table '" + baseTableName + "/" + aliasTableName + "'");
    }
}

