/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.distance.heuristics.TruthnessUtils;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.QueryResultSet;
import org.evomaster.client.java.sql.VariableDescriptor;
import org.evomaster.client.java.sql.heuristic.QueryResultUtils;
import org.evomaster.client.java.sql.heuristic.SqlBaseTableReference;
import org.evomaster.client.java.sql.heuristic.SqlColumnReference;
import org.evomaster.client.java.sql.heuristic.SqlExpressionEvaluator;
import org.evomaster.client.java.sql.heuristic.SqlHeuristicResult;
import org.evomaster.client.java.sql.heuristic.TableColumnResolver;
import org.evomaster.client.java.sql.heuristic.function.FunctionFinder;
import org.evomaster.client.java.sql.heuristic.function.SqlAggregateFunction;
import org.evomaster.client.java.sql.heuristic.function.SqlFunction;
import org.evomaster.client.java.sql.internal.SqlDistanceWithMetrics;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import org.evomaster.client.java.sql.internal.TaintHandler;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.Function;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.delete.Delete;
import shaded.net.sf.jsqlparser.statement.select.AllColumns;
import shaded.net.sf.jsqlparser.statement.select.AllTableColumns;
import shaded.net.sf.jsqlparser.statement.select.FromItem;
import shaded.net.sf.jsqlparser.statement.select.Join;
import shaded.net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import shaded.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.select.SelectItem;
import shaded.net.sf.jsqlparser.statement.select.SetOperationList;
import shaded.net.sf.jsqlparser.statement.select.TableFunction;
import shaded.net.sf.jsqlparser.statement.update.Update;

public class SqlHeuristicsCalculator {
    public static double C = 0.1;
    public static double C_BETTER = C + C / 2.0;
    public static Truthness TRUE_TRUTHNESS = new Truthness(1.0, C);
    public static Truthness FALSE_TRUTHNESS = TRUE_TRUTHNESS.invert();
    public static Truthness FALSE_TRUTHNESS_BETTER = new Truthness(C_BETTER, 1.0);
    private final SqlExpressionEvaluator parentExpressionEvaluator;
    private final QueryResultSet sourceQueryResultSet;
    private final TaintHandler taintHandler;
    private final TableColumnResolver tableColumnResolver;
    private final Deque<DataRow> stackOfEvaluatedDataRows = new ArrayDeque<DataRow>();

    private SqlHeuristicsCalculator(SqlHeuristicsCalculatorBuilder builder) {
        this.parentExpressionEvaluator = builder.parentExpressionEvaluator;
        this.tableColumnResolver = builder.tableColumnResolver;
        this.taintHandler = builder.taintHandler;
        this.sourceQueryResultSet = builder.queryResultSet != null ? builder.queryResultSet : new QueryResultSet();
        if (builder.stackOfDataRows != null) {
            this.stackOfEvaluatedDataRows.addAll(builder.stackOfDataRows);
        }
    }

    public static boolean isValidSqlCommandForSqlHeuristicsCalculation(String sqlCommand) {
        return SqlHeuristicsCalculator.isValidSqlCommandForSqlHeuristicsCalculation(SqlParserUtils.parseSqlCommand(sqlCommand));
    }

    public static boolean isValidSqlCommandForSqlHeuristicsCalculation(Statement statement) {
        return statement instanceof Update || statement instanceof Delete || statement instanceof Select;
    }

    public SqlDistanceWithMetrics computeDistance(String sqlCommand) {
        Objects.requireNonNull(sqlCommand, "sqlCommand cannot be null");
        try {
            Truthness t;
            Statement parsedSqlCommand = SqlParserUtils.parseSqlCommand(sqlCommand);
            if (parsedSqlCommand instanceof Select) {
                Select select = (Select)parsedSqlCommand;
                t = this.computeHeuristic(select).getTruthness();
            } else if (parsedSqlCommand instanceof Update) {
                Update update = (Update)parsedSqlCommand;
                t = this.computeHeuristic(update).getTruthness();
            } else if (parsedSqlCommand instanceof Delete) {
                Delete delete = (Delete)parsedSqlCommand;
                t = this.computeHeuristic(delete).getTruthness();
            } else {
                SimpleLogger.uniqueWarn("Cannot compute SQL complete heuristics for statement subclass: " + parsedSqlCommand.getClass().getName());
                return new SqlDistanceWithMetrics(Double.MAX_VALUE, 0, true);
            }
            double distanceToTrue = 1.0 - t.getOfTrue();
            return new SqlDistanceWithMetrics(distanceToTrue, 0, false);
        }
        catch (Exception ex) {
            SimpleLogger.uniqueWarn("Failed to compute complete SQL heuristics for: " + sqlCommand);
            return new SqlDistanceWithMetrics(Double.MAX_VALUE, 0, true);
        }
    }

    private SqlHeuristicResult computeHeuristicStatement(Statement statement) {
        this.tableColumnResolver.enterStatementeContext(statement);
        SqlHeuristicResult heuristicResult = this.computeHeuristic(SqlParserUtils.getFrom(statement), SqlParserUtils.getJoins(statement), SqlParserUtils.getWhere(statement));
        this.tableColumnResolver.exitCurrentStatementContext();
        return heuristicResult;
    }

    SqlHeuristicResult computeHeuristic(Update update) {
        return this.computeHeuristicStatement(update);
    }

    SqlHeuristicResult computeHeuristic(Delete delete) {
        return this.computeHeuristicStatement(delete);
    }

    private SqlHeuristicResult computeHeuristic(FromItem fromItem) {
        if (fromItem == null) {
            return new SqlHeuristicResult(TRUE_TRUTHNESS, new QueryResult(Collections.emptyList()));
        }
        if (fromItem instanceof Table) {
            QueryResult tableContents = this.createQueryResult(fromItem);
            int len = tableContents.size();
            Truthness truthness = TruthnessUtils.getTruthnessToEmpty(len).invert();
            return new SqlHeuristicResult(truthness, tableContents);
        }
        if (fromItem instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)fromItem;
            Select subquery = parenthesedSelect.getSelect();
            return this.computeHeuristic(subquery);
        }
        if (fromItem instanceof TableFunction) {
            throw new UnsupportedOperationException("Must implement TableFunction for computing heuristics");
        }
        if (fromItem instanceof ParenthesedFromItem) {
            throw new UnsupportedOperationException("Must implement ParenthesedFromItem for computing heuristics");
        }
        throw new IllegalArgumentException("Cannot compute heuristics for FROM item of type " + fromItem.getClass().getName());
    }

    private SqlHeuristicResult computeHeuristic(FromItem fromItem, List<Join> joins) {
        SqlHeuristicResult fromItemResult = this.computeHeuristic(fromItem);
        if (joins != null && !joins.isEmpty()) {
            SqlHeuristicResult joinResult = fromItemResult;
            for (Join join : joins) {
                if (join.isInnerJoin()) {
                    joinResult = this.computeHeuristicInnerJoin(joinResult, join);
                    continue;
                }
                if (join.isLeft()) {
                    joinResult = this.computeHeuristicLeftJoin(joinResult, join);
                    continue;
                }
                if (join.isRight()) {
                    joinResult = this.computeHeuristicRightJoin(joinResult, join);
                    continue;
                }
                if (join.isCross()) {
                    joinResult = this.computeHeuristicCrossJoin(joinResult, join);
                    continue;
                }
                if (join.isFull()) {
                    joinResult = this.computeHeuristicFullJoin(joinResult, join);
                    continue;
                }
                throw new IllegalArgumentException("Join type not supported: " + join);
            }
            return joinResult;
        }
        return fromItemResult;
    }

    private SqlHeuristicResult computeHeuristicFullJoin(SqlHeuristicResult leftRowSetResult, Join fullJoin) {
        if (!fullJoin.isFull()) {
            throw new IllegalArgumentException("Join is not a FULL JOIN");
        }
        FromItem rightFromItem = fullJoin.getRightItem();
        Collection<Expression> onExpressions = fullJoin.getOnExpressions();
        SqlHeuristicResult rightRowSetResult = this.computeHeuristic(rightFromItem);
        QueryResult leftQueryResult = leftRowSetResult.getQueryResult();
        QueryResult rightQueryResult = rightRowSetResult.getQueryResult();
        QueryResult fullJoinQueryResult = this.createQueryResultFullJoin(leftQueryResult, rightQueryResult, onExpressions);
        Truthness truthness = TruthnessUtils.buildOrAggregationTruthness(leftRowSetResult.getTruthness(), rightRowSetResult.getTruthness());
        return new SqlHeuristicResult(truthness, fullJoinQueryResult);
    }

    private SqlHeuristicResult computeHeuristicCrossJoin(SqlHeuristicResult leftRowSetResult, Join crossJoin) {
        if (!crossJoin.isCross()) {
            throw new IllegalArgumentException("Join is not a CROSS JOIN");
        }
        FromItem rightFromItem = crossJoin.getRightItem();
        SqlHeuristicResult rightRowSetResult = this.computeHeuristic(rightFromItem);
        QueryResult leftQueryResult = leftRowSetResult.getQueryResult();
        QueryResult rightQueryResult = rightRowSetResult.getQueryResult();
        QueryResult cartesianProduct = QueryResultUtils.createCartesianProduct(leftQueryResult, rightQueryResult);
        Truthness truthness = TruthnessUtils.buildAndAggregationTruthness(leftRowSetResult.getTruthness(), rightRowSetResult.getTruthness());
        return new SqlHeuristicResult(truthness, cartesianProduct);
    }

    private SqlHeuristicResult computeHeuristicInnerJoin(SqlHeuristicResult leftRowSetResult, Join innerJoin) {
        if (!innerJoin.isInnerJoin()) {
            throw new IllegalArgumentException("Join is not a INNER JOIN");
        }
        FromItem rightFromItem = innerJoin.getRightItem();
        Collection<Expression> onExpressions = innerJoin.getOnExpressions();
        SqlHeuristicResult rightRowSetResult = this.computeHeuristic(rightFromItem);
        QueryResult leftQueryResult = leftRowSetResult.getQueryResult();
        QueryResult rightQueryResult = rightRowSetResult.getQueryResult();
        QueryResult cartesianProduct = QueryResultUtils.createCartesianProduct(leftQueryResult, rightQueryResult);
        SqlHeuristicResult conditionResult = this.computeHeuristic(cartesianProduct, onExpressions);
        Truthness truthness = TruthnessUtils.buildAndAggregationTruthness(leftRowSetResult.getTruthness(), rightRowSetResult.getTruthness(), conditionResult.getTruthness());
        return new SqlHeuristicResult(truthness, conditionResult.getQueryResult());
    }

    private SqlHeuristicResult computeHeuristicRightJoin(SqlHeuristicResult leftRowSetResult, Join rightJoin) {
        if (!rightJoin.isRight()) {
            throw new IllegalArgumentException("Join is not a RIGHT JOIN");
        }
        FromItem rightFromItem = rightJoin.getRightItem();
        Collection<Expression> onExpressions = rightJoin.getOnExpressions();
        SqlHeuristicResult rightRowSetResult = this.computeHeuristic(rightFromItem);
        QueryResult leftQueryResult = leftRowSetResult.getQueryResult();
        QueryResult rightQueryResult = rightRowSetResult.getQueryResult();
        QueryResult queryResult = this.createQueryResultRightJoin(leftQueryResult, rightQueryResult, onExpressions);
        return new SqlHeuristicResult(rightRowSetResult.getTruthness(), queryResult);
    }

    private QueryResult createQueryResultRightJoin(QueryResult leftQueryResult, QueryResult rightQueryResult, Collection<Expression> onExpressions) {
        QueryResult queryResult = QueryResultUtils.createEmptyCartesianProduct(leftQueryResult, rightQueryResult);
        for (DataRow rightRow : rightQueryResult.seeRows()) {
            boolean foundMatch = false;
            for (DataRow leftRow : leftQueryResult.seeRows()) {
                DataRow joinedDataRow = QueryResultUtils.createJoinedRow(leftRow, rightRow, queryResult.seeVariableDescriptors());
                Truthness truthness = onExpressions.isEmpty() ? TRUE_TRUTHNESS : this.evaluateAll(onExpressions, joinedDataRow);
                if (!truthness.isTrue()) continue;
                queryResult.addRow(joinedDataRow);
                foundMatch = true;
            }
            if (foundMatch) continue;
            DataRow nullDataRow = QueryResultUtils.createDataRowOfNullValues(leftQueryResult);
            DataRow joinedDataRow = QueryResultUtils.createJoinedRow(nullDataRow, rightRow, queryResult.seeVariableDescriptors());
            queryResult.addRow(joinedDataRow);
        }
        return queryResult;
    }

    private SqlHeuristicResult computeHeuristicLeftJoin(SqlHeuristicResult leftRowSetResult, Join leftJoin) {
        if (!leftJoin.isLeft()) {
            throw new IllegalArgumentException("Join is not a LEFT JOIN");
        }
        FromItem rightFromItem = leftJoin.getRightItem();
        Collection<Expression> onExpressions = leftJoin.getOnExpressions();
        SqlHeuristicResult rightRowSetResult = this.computeHeuristic(rightFromItem);
        QueryResult leftQueryResult = leftRowSetResult.getQueryResult();
        QueryResult rightQueryResult = rightRowSetResult.getQueryResult();
        QueryResult queryResult = this.createQueryResultLeftJoin(leftQueryResult, rightQueryResult, onExpressions);
        return new SqlHeuristicResult(leftRowSetResult.getTruthness(), queryResult);
    }

    private QueryResult createQueryResultFullJoin(QueryResult leftQueryResult, QueryResult rightQueryResult, Collection<Expression> onExpressions) {
        QueryResult queryResult = QueryResultUtils.createEmptyCartesianProduct(leftQueryResult, rightQueryResult);
        boolean[] rightRowMatched = new boolean[rightQueryResult.size()];
        for (DataRow leftRow : leftQueryResult.seeRows()) {
            boolean foundMatch = false;
            for (int i = 0; i < rightQueryResult.seeRows().size(); ++i) {
                Truthness truthness;
                DataRow rightRow = rightQueryResult.seeRows().get(i);
                DataRow joinedDataRow = QueryResultUtils.createJoinedRow(leftRow, rightRow, queryResult.seeVariableDescriptors());
                Truthness truthness2 = truthness = onExpressions.isEmpty() ? TRUE_TRUTHNESS : this.evaluateAll(onExpressions, joinedDataRow);
                if (!truthness.isTrue()) continue;
                queryResult.addRow(joinedDataRow);
                foundMatch = true;
                rightRowMatched[i] = true;
            }
            if (foundMatch) continue;
            DataRow nullDataRow = QueryResultUtils.createDataRowOfNullValues(rightQueryResult);
            DataRow joinedDataRow = QueryResultUtils.createJoinedRow(leftRow, nullDataRow, queryResult.seeVariableDescriptors());
            queryResult.addRow(joinedDataRow);
        }
        for (int i = 0; i < rightRowMatched.length; ++i) {
            if (rightRowMatched[i]) continue;
            DataRow rightRow = rightQueryResult.seeRows().get(i);
            DataRow nullDataRow = QueryResultUtils.createDataRowOfNullValues(leftQueryResult);
            DataRow joinedDataRow = QueryResultUtils.createJoinedRow(nullDataRow, rightRow, queryResult.seeVariableDescriptors());
            queryResult.addRow(joinedDataRow);
        }
        return queryResult;
    }

    private QueryResult createQueryResultLeftJoin(QueryResult leftQueryResult, QueryResult rightQueryResult, Collection<Expression> onExpressions) {
        QueryResult queryResult = QueryResultUtils.createEmptyCartesianProduct(leftQueryResult, rightQueryResult);
        for (DataRow leftRow : leftQueryResult.seeRows()) {
            boolean foundMatch = false;
            for (DataRow rightRow : rightQueryResult.seeRows()) {
                DataRow joinedDataRow = QueryResultUtils.createJoinedRow(leftRow, rightRow, queryResult.seeVariableDescriptors());
                Truthness truthness = onExpressions.isEmpty() ? TRUE_TRUTHNESS : this.evaluateAll(onExpressions, joinedDataRow);
                if (!truthness.isTrue()) continue;
                queryResult.addRow(joinedDataRow);
                foundMatch = true;
            }
            if (foundMatch) continue;
            DataRow nullDataRow = QueryResultUtils.createDataRowOfNullValues(rightQueryResult);
            DataRow joinedDataRow = QueryResultUtils.createJoinedRow(leftRow, nullDataRow, queryResult.seeVariableDescriptors());
            queryResult.addRow(joinedDataRow);
        }
        return queryResult;
    }

    SqlHeuristicResult computeHeuristic(Select select) {
        SqlHeuristicResult heuristicResult;
        this.tableColumnResolver.enterStatementeContext(select);
        if (select instanceof SetOperationList) {
            SetOperationList unionQuery = (SetOperationList)select;
            List<Select> subqueries = unionQuery.getSelects();
            heuristicResult = this.computeHeuristicUnion(subqueries);
        } else if (select instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)select;
            Select subquery = parenthesedSelect.getSelect();
            heuristicResult = this.computeHeuristic(subquery);
        } else if (select instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)select;
            FromItem fromItem = SqlParserUtils.getFrom(plainSelect);
            List<Join> joins = SqlParserUtils.getJoins(plainSelect);
            Expression whereClause = SqlParserUtils.getWhere(plainSelect);
            heuristicResult = plainSelect.getGroupBy() != null ? this.computeHeuristicSelectGroupByHaving(plainSelect.getSelectItems(), fromItem, joins, whereClause, plainSelect.getGroupBy().getGroupByExpressionList(), plainSelect.getHaving()) : this.computeHeuristicSelect(plainSelect.getSelectItems(), fromItem, joins, whereClause);
        } else {
            throw new IllegalArgumentException("Cannot calculate heuristics for SQL command of type " + select.getClass().getName());
        }
        this.tableColumnResolver.exitCurrentStatementContext();
        return heuristicResult;
    }

    private SqlHeuristicResult computeHeuristicSelect(List<SelectItem<?>> selectItems, FromItem fromItem, List<Join> joins, Expression whereClause) {
        SqlHeuristicResult intermediateHeuristicResult = this.computeHeuristic(fromItem, joins, whereClause);
        QueryResult queryResult = this.createQueryResult(intermediateHeuristicResult.getQueryResult(), selectItems);
        SqlHeuristicResult heuristicResult = new SqlHeuristicResult(intermediateHeuristicResult.getTruthness(), queryResult);
        return heuristicResult;
    }

    private SqlHeuristicResult computeHeuristicSelectGroupByHaving(List<SelectItem<?>> selectItems, FromItem fromItem, List<Join> joins, Expression whereClause, List<Expression> groupByExpressions, Expression having) {
        SqlHeuristicResult intermediateHeuristicResult = this.computeHeuristic(fromItem, joins, whereClause);
        QueryResult sourceQueryResult = intermediateHeuristicResult.getQueryResult();
        HashMap<List, QueryResult> groupByQueryResults = new HashMap<List, QueryResult>();
        for (DataRow dataRow : sourceQueryResult.seeRows()) {
            ArrayList key = new ArrayList();
            for (Expression groupByExpression : groupByExpressions) {
                Object value = this.evaluate(groupByExpression, dataRow);
                key.add(value);
            }
            groupByQueryResults.computeIfAbsent(key, k -> new QueryResult(sourceQueryResult.seeVariableDescriptors())).addRow(dataRow);
        }
        ArrayList<DataRow> groupByDataRows = new ArrayList<DataRow>();
        ArrayList<Truthness> truthnesses = new ArrayList<Truthness>();
        for (QueryResult groupByQueryResult : groupByQueryResults.values()) {
            QueryResult aggregatedQueryResult = this.createQueryResult(groupByQueryResult, selectItems);
            if (aggregatedQueryResult.size() != 1) {
                throw new IllegalStateException("An aggregated query result cannot have " + aggregatedQueryResult.size() + "rows");
            }
            DataRow dataRow = aggregatedQueryResult.seeRows().get(0);
            if (having != null) {
                Truthness truthness = this.evaluateAll(Collections.singletonList(having), groupByQueryResult);
                truthnesses.add(truthness);
                if (!truthness.isTrue()) continue;
                groupByDataRows.add(dataRow);
                continue;
            }
            groupByDataRows.add(dataRow);
        }
        List<VariableDescriptor> variableDescriptors = this.createSelectVariableDescriptors(selectItems, sourceQueryResult.seeVariableDescriptors());
        QueryResult queryResult = new QueryResult(variableDescriptors);
        for (DataRow groupByDataRow : groupByDataRows) {
            queryResult.addRow(groupByDataRow);
        }
        Truthness havingTruthness = truthnesses.isEmpty() ? TRUE_TRUTHNESS : TruthnessUtils.buildOrAggregationTruthness(truthnesses.toArray(new Truthness[0]));
        Truthness groupByHavingTruthness = TruthnessUtils.buildAndAggregationTruthness(intermediateHeuristicResult.getTruthness(), havingTruthness);
        return new SqlHeuristicResult(groupByHavingTruthness, queryResult);
    }

    private SqlHeuristicResult computeHeuristic(FromItem fromItem, List<Join> joins, Expression whereExpression) {
        SqlHeuristicResult heuristicResult = this.computeHeuristic(fromItem, joins);
        QueryResult queryResult = heuristicResult.getQueryResult();
        if (whereExpression == null) {
            return heuristicResult;
        }
        SqlHeuristicResult conditionResult = this.computeHeuristic(queryResult, whereExpression);
        Truthness truthness = TruthnessUtils.buildAndAggregationTruthness(heuristicResult.getTruthness(), conditionResult.getTruthness());
        return new SqlHeuristicResult(truthness, conditionResult.getQueryResult());
    }

    private QueryResult createQueryResult(QueryResult queryResult, List<SelectItem<?>> selectItems) {
        if (selectItems == null || selectItems.isEmpty()) {
            return queryResult;
        }
        List<VariableDescriptor> variableDescriptors = this.createSelectVariableDescriptors(selectItems, queryResult.seeVariableDescriptors());
        QueryResult filteredQueryResult = new QueryResult(variableDescriptors);
        if (queryResult.isEmpty() && !SqlHeuristicsCalculator.hasAnyTableColumn(selectItems)) {
            List<Object> rowValues = this.evaluate(selectItems);
            DataRow singleRow = new DataRow(variableDescriptors, rowValues);
            filteredQueryResult.addRow(singleRow);
        } else if (SqlHeuristicsCalculator.hasAnyAggregateFunction(selectItems)) {
            DataRow witnessDataRow = queryResult.isEmpty() ? null : queryResult.seeRows().get(0);
            List<Object> filteredValues = this.evaluate(selectItems, witnessDataRow, queryResult);
            DataRow filteredRow = new DataRow(variableDescriptors, filteredValues);
            filteredQueryResult.addRow(filteredRow);
        } else {
            for (DataRow row : queryResult.seeRows()) {
                List<Object> filteredValues = this.evaluate(selectItems, row, queryResult);
                DataRow filteredRow = new DataRow(variableDescriptors, filteredValues);
                filteredQueryResult.addRow(filteredRow);
            }
        }
        return filteredQueryResult;
    }

    private List<Object> evaluate(List<SelectItem<?>> selectItems, DataRow currentDataRow, QueryResult currentQueryResult) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (SelectItem<?> selectItem : selectItems) {
            Object expression = selectItem.getExpression();
            Object value = this.evaluate((Expression)expression, currentDataRow, currentQueryResult);
            if (value != null && value instanceof QueryResult) {
                QueryResult queryResult = (QueryResult)value;
                if (queryResult.isEmpty()) {
                    values.add(null);
                    continue;
                }
                if (queryResult.seeRows().size() == 1) {
                    Object singleValue = queryResult.seeRows().get(0).getValue(0);
                    values.add(singleValue);
                    continue;
                }
                throw new IllegalArgumentException("Cannot evaluate " + expression.toString() + " if resulting subquery size is greater than 1" + currentDataRow.toString());
            }
            if (value != null && value instanceof List) {
                List evaluatedValues = (List)value;
                values.addAll(evaluatedValues);
                continue;
            }
            values.add(value);
        }
        return values;
    }

    private static boolean isAggregateFunction(String functionName) {
        SqlFunction function = FunctionFinder.getInstance().getFunction(functionName);
        return function != null && function instanceof SqlAggregateFunction;
    }

    private Object evaluate(Expression expressionToEvaluate) {
        return this.evaluate(expressionToEvaluate, null, null);
    }

    private Object evaluate(Expression expressionToEvaluate, DataRow currentDataRow) {
        SqlExpressionEvaluator sqlExpressionEvaluator = new SqlExpressionEvaluator.SqlExpressionEvaluatorBuilder().withParentStatementEvaluator(this).withTableColumnResolver(this.tableColumnResolver).withTaintHandler(this.taintHandler).withQueryResultSet(this.sourceQueryResultSet).withDataRowStack(this.stackOfEvaluatedDataRows).withCurrentDataRow(currentDataRow).build();
        expressionToEvaluate.accept(sqlExpressionEvaluator);
        Object value = sqlExpressionEvaluator.getEvaluatedValue();
        return value;
    }

    private Object evaluate(Expression expressionToEvaluate, DataRow currentDataRow, QueryResult currentQueryResult) {
        SqlExpressionEvaluator sqlExpressionEvaluator = new SqlExpressionEvaluator.SqlExpressionEvaluatorBuilder().withParentStatementEvaluator(this).withTableColumnResolver(this.tableColumnResolver).withTaintHandler(this.taintHandler).withQueryResultSet(this.sourceQueryResultSet).withDataRowStack(this.stackOfEvaluatedDataRows).withCurrentDataRow(currentDataRow).withCurrentQueryResult(currentQueryResult).build();
        expressionToEvaluate.accept(sqlExpressionEvaluator);
        Object value = sqlExpressionEvaluator.getEvaluatedValue();
        return value;
    }

    private List<Object> evaluate(List<SelectItem<?>> selectItems) {
        ArrayList<Object> filteredValues = new ArrayList<Object>();
        for (SelectItem<?> selectItem : selectItems) {
            Object expression = selectItem.getExpression();
            Object value = this.evaluate((Expression)expression);
            filteredValues.add(value);
        }
        return filteredValues;
    }

    private static boolean hasAnyTableColumn(List<SelectItem<?>> selectItems) {
        for (SelectItem<?> selectItem : selectItems) {
            if (!SqlHeuristicsCalculator.hasAnyTableColumn(selectItem.getExpression())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyTableColumn(Expression expression) {
        Function functionExpression;
        String functionName;
        if (expression instanceof AllTableColumns) {
            return true;
        }
        if (expression instanceof AllColumns) {
            return true;
        }
        if (expression instanceof Column) {
            return true;
        }
        if (expression instanceof Function && SqlHeuristicsCalculator.isAggregateFunction(functionName = (functionExpression = (Function)expression).getName())) {
            for (int i = 0; i < functionExpression.getParameters().size(); ++i) {
                if (!SqlHeuristicsCalculator.hasAnyTableColumn((Expression)functionExpression.getParameters().get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasAnyAggregateFunction(List<SelectItem<?>> selectItems) {
        for (SelectItem<?> selectItem : selectItems) {
            if (!(selectItem.getExpression() instanceof Function) || !SqlHeuristicsCalculator.isAggregateFunction(((Function)selectItem.getExpression()).getName())) continue;
            return true;
        }
        return false;
    }

    private List<VariableDescriptor> createSelectVariableDescriptors(List<SelectItem<?>> selectItems, List<VariableDescriptor> variableDescriptors) {
        ArrayList<VariableDescriptor> selectVariableDescriptors = new ArrayList<VariableDescriptor>();
        for (SelectItem<?> selectItem : selectItems) {
            if (selectItem.getExpression() instanceof AllTableColumns) {
                AllTableColumns allTableColumns = (AllTableColumns)selectItem.getExpression();
                String tableName = allTableColumns.getTable().getName();
                for (VariableDescriptor variableDescriptor : variableDescriptors) {
                    if (!tableName.equalsIgnoreCase(variableDescriptor.getAliasTableName()) && !tableName.equalsIgnoreCase(variableDescriptor.getTableName())) continue;
                    selectVariableDescriptors.add(variableDescriptor);
                }
                continue;
            }
            if (selectItem.getExpression() instanceof AllColumns) {
                selectVariableDescriptors.addAll(variableDescriptors);
                continue;
            }
            if (selectItem.getExpression() instanceof Column) {
                Column column = (Column)selectItem.getExpression();
                SqlColumnReference columnReference = this.tableColumnResolver.resolve(column);
                String columnName = columnReference.getColumnName();
                String aliasName = selectItem.getAlias() != null ? selectItem.getAlias().getName() : columnName;
                String tableName = columnReference.getTableReference() instanceof SqlBaseTableReference ? ((SqlBaseTableReference)columnReference.getTableReference()).getName() : null;
                VariableDescriptor variableDescriptor = new VariableDescriptor(columnName, aliasName, tableName);
                selectVariableDescriptors.add(variableDescriptor);
                continue;
            }
            String columnName = selectItem.getAlias() != null ? selectItem.getAlias().getName() : null;
            VariableDescriptor variableDescriptor = new VariableDescriptor(columnName);
            selectVariableDescriptors.add(variableDescriptor);
        }
        return selectVariableDescriptors;
    }

    private SqlHeuristicResult computeHeuristicUnion(List<Select> subqueries) {
        ArrayList<SqlHeuristicResult> subqueryResults = new ArrayList<SqlHeuristicResult>();
        for (Select subquery : subqueries) {
            SqlHeuristicResult subqueryResult = this.computeHeuristic(subquery);
            subqueryResults.add(subqueryResult);
        }
        Truthness[] truthnesses = (Truthness[])subqueryResults.stream().map(SqlHeuristicResult::getTruthness).toArray(Truthness[]::new);
        Truthness t = TruthnessUtils.buildOrAggregationTruthness(truthnesses);
        List<QueryResult> queryResults = subqueryResults.stream().map(SqlHeuristicResult::getQueryResult).collect(Collectors.toList());
        QueryResult unionRowSet = QueryResultUtils.createUnionRowSet(queryResults);
        return new SqlHeuristicResult(t, unionRowSet);
    }

    private SqlHeuristicResult computeHeuristic(QueryResult queryResult, Expression condition) {
        Objects.requireNonNull(condition);
        Objects.requireNonNull(queryResult);
        return this.computeHeuristic(queryResult, Collections.singletonList(condition));
    }

    private SqlHeuristicResult computeHeuristic(QueryResult queryResult, Collection<Expression> conditions) {
        Objects.requireNonNull(conditions);
        Objects.requireNonNull(queryResult);
        double maxOfTrue = 0.0;
        if (queryResult.isEmpty()) {
            return new SqlHeuristicResult(FALSE_TRUTHNESS, queryResult);
        }
        QueryResult filteredQueryResult = new QueryResult(queryResult.seeVariableDescriptors());
        for (DataRow row : queryResult.seeRows()) {
            Truthness truthnessForRow;
            Truthness truthness = truthnessForRow = conditions.isEmpty() ? TRUE_TRUTHNESS : this.evaluateAll(conditions, row);
            if (truthnessForRow.isTrue()) {
                filteredQueryResult.addRow(row);
                continue;
            }
            if (!(truthnessForRow.getOfTrue() > maxOfTrue)) continue;
            maxOfTrue = truthnessForRow.getOfTrue();
        }
        Truthness truthness = !filteredQueryResult.isEmpty() ? TRUE_TRUTHNESS : TruthnessUtils.buildScaledTruthness(C, maxOfTrue);
        return new SqlHeuristicResult(truthness, filteredQueryResult);
    }

    private Truthness evaluateAll(Collection<Expression> conditions, QueryResult currentQueryResult) {
        Objects.requireNonNull(currentQueryResult);
        return this.evaluateAll(conditions, null, currentQueryResult);
    }

    private Truthness evaluateAll(Collection<Expression> conditions, DataRow currentDataRow, QueryResult currentQueryResult) {
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("Cannot evaluate empty conditions");
        }
        ArrayList<Truthness> truthnesses = new ArrayList<Truthness>();
        for (Expression condition : conditions) {
            SqlExpressionEvaluator expressionEvaluator = new SqlExpressionEvaluator.SqlExpressionEvaluatorBuilder().withParentStatementEvaluator(this).withTableColumnResolver(this.tableColumnResolver).withTaintHandler(this.taintHandler).withQueryResultSet(this.sourceQueryResultSet).withDataRowStack(this.stackOfEvaluatedDataRows).withCurrentDataRow(currentDataRow).withCurrentQueryResult(currentQueryResult).build();
            condition.accept(expressionEvaluator);
            truthnesses.add(expressionEvaluator.getEvaluatedTruthness());
        }
        return TruthnessUtils.buildAndAggregationTruthness(truthnesses.toArray(new Truthness[0]));
    }

    private Truthness evaluateAll(Collection<Expression> conditions, DataRow row) {
        Objects.requireNonNull(row);
        return this.evaluateAll(conditions, row, null);
    }

    private QueryResult createQueryResult(FromItem fromItem) {
        QueryResult tableData;
        if (fromItem == null) {
            tableData = new QueryResult(Collections.emptyList());
        } else {
            if (!SqlParserUtils.isTable(fromItem)) {
                throw new IllegalArgumentException("Cannot compute Truthness for form item that it is not a table " + fromItem);
            }
            String tableName = SqlParserUtils.getTableName(fromItem);
            tableData = fromItem.getAlias() != null ? QueryResultUtils.addAliasToQueryResult(this.sourceQueryResultSet.getQueryResultForNamedTable(tableName), fromItem.getAlias().getName()) : this.sourceQueryResultSet.getQueryResultForNamedTable(tableName);
        }
        return tableData;
    }

    public static class SqlHeuristicsCalculatorBuilder {
        private SqlExpressionEvaluator parentExpressionEvaluator;
        private TableColumnResolver tableColumnResolver;
        private TaintHandler taintHandler;
        private QueryResultSet queryResultSet;
        private Deque<DataRow> stackOfDataRows;

        public SqlHeuristicsCalculatorBuilder withParentExpressionEvaluator(SqlExpressionEvaluator evaluator) {
            this.parentExpressionEvaluator = evaluator;
            return this;
        }

        public SqlHeuristicsCalculatorBuilder withTableColumnResolver(TableColumnResolver resolver) {
            this.tableColumnResolver = resolver;
            return this;
        }

        public SqlHeuristicsCalculatorBuilder withTaintHandler(TaintHandler handler) {
            this.taintHandler = handler;
            return this;
        }

        public SqlHeuristicsCalculatorBuilder withSourceQueryResultSet(QueryResultSet resultSet) {
            this.queryResultSet = resultSet;
            return this;
        }

        public SqlHeuristicsCalculatorBuilder withStackOfDataRows(Deque<DataRow> rows) {
            this.stackOfDataRows = rows;
            return this;
        }

        public SqlHeuristicsCalculator build() {
            return new SqlHeuristicsCalculator(this);
        }
    }
}

