/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.List;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import shaded.net.sf.jsqlparser.expression.Function;
import shaded.net.sf.jsqlparser.expression.LongValue;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.select.AllColumns;
import shaded.net.sf.jsqlparser.statement.select.AllTableColumns;
import shaded.net.sf.jsqlparser.statement.select.Limit;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.select.SelectItem;
import shaded.net.sf.jsqlparser.statement.select.SetOperationList;

public class SelectTransformer {
    public static String addFieldsToSelect(String select) {
        Select stmt = SelectTransformer.asSelectStatement(select);
        PlainSelect plainSelect = stmt.getPlainSelect();
        Expression where = plainSelect.getWhere();
        if (where == null) {
            return select;
        }
        final List<SelectItem<?>> fields = plainSelect.getSelectItems();
        boolean allColumns = fields.stream().anyMatch(f -> f.getExpression() instanceof AllColumns || f.getExpression() instanceof AllTableColumns);
        if (!allColumns) {
            where.accept(new ExpressionVisitorAdapter(){

                @Override
                public void visit(Column column) {
                    String target = column.toString();
                    boolean found = false;
                    for (SelectItem si : fields) {
                        String exp = si.getExpression().toString();
                        if (!target.equals(exp)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        SelectItem<Column> item = new SelectItem<Column>();
                        item.setExpression(column);
                        fields.add(item);
                    }
                }
            });
        }
        return stmt.toString();
    }

    public static String removeOperations(String select) {
        Select stmt = SelectTransformer.asSelectStatement(select);
        PlainSelect plainSelect = stmt.getPlainSelect();
        plainSelect.getSelectItems().removeIf(item -> item instanceof SelectItem && item.getExpression() instanceof Function);
        if (plainSelect.getSelectItems().isEmpty()) {
            plainSelect.getSelectItems().add(new SelectItem<AllColumns>(new AllColumns()));
        }
        return stmt.toString();
    }

    public static String removeConstraints(String select) {
        Select stmt = SelectTransformer.asSelectStatement(select);
        SelectTransformer.handleSelect(stmt);
        return stmt.toString();
    }

    public static String addLimitForHandlingRowCount(String select, boolean doRemoveOtherConstraints, int limitedRowCount) {
        Select stmt = SelectTransformer.asSelectStatement(select);
        if (doRemoveOtherConstraints) {
            SelectTransformer.handleSelect(stmt);
        }
        if (limitedRowCount > 0) {
            Limit limit = new Limit();
            limit.setRowCount(new LongValue(limitedRowCount));
            SelectTransformer.addLimitForSelect(stmt, limit);
        }
        return stmt.toString();
    }

    private static Select asSelectStatement(String select) {
        Statement stmt = SqlParserUtils.parseSqlCommand(select);
        if (!(stmt instanceof Select)) {
            throw new IllegalArgumentException("SQL statement is not a SELECT: " + select);
        }
        return (Select)stmt;
    }

    private static void handleSelect(Select select) {
        if (select instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)select;
            plainSelect.setWhere(null);
            plainSelect.setLimit(null);
            plainSelect.setGroupByElement(null);
        } else if (select instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)select;
            for (Select innerSelect : setOperationList.getSelects()) {
                SelectTransformer.handleSelect(innerSelect);
            }
        } else {
            throw new RuntimeException("Cannot handle " + select.getClass());
        }
    }

    private static void addLimitForSelect(Select select, Limit limit) {
        if (select instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)select;
            plainSelect.setLimit(limit);
        } else if (select instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)select;
            for (Select innerSelect : setOperationList.getSelects()) {
                SelectTransformer.addLimitForSelect(innerSelect, limit);
            }
        } else {
            throw new RuntimeException("Cannot add limit for " + select.getClass());
        }
    }
}

