/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import shaded.org.jgrapht.DirectedGraph;

public final class EdmondsKarpMaximumFlow<V, E> {
    public static final double DEFAULT_EPSILON = 1.0E-9;
    private DirectedGraph<V, E> network;
    private double epsilon;
    private int currentSource;
    private int currentSink;
    private Map<E, Double> maximumFlow;
    private Double maximumFlowValue;
    private int numNodes;
    private Map<V, Integer> indexer;
    private List<Node> nodes;

    public EdmondsKarpMaximumFlow(DirectedGraph<V, E> directedGraph) {
        this(directedGraph, 1.0E-9);
    }

    public EdmondsKarpMaximumFlow(DirectedGraph<V, E> directedGraph, double d) {
        if (directedGraph == null) {
            throw new NullPointerException("network is null");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("invalid epsilon (must be positive)");
        }
        for (Object e : directedGraph.edgeSet()) {
            if (!(directedGraph.getEdgeWeight(e) < -d)) continue;
            throw new IllegalArgumentException("invalid capacity (must be non-negative)");
        }
        this.network = directedGraph;
        this.epsilon = d;
        this.currentSource = -1;
        this.currentSink = -1;
        this.maximumFlow = null;
        this.maximumFlowValue = null;
        this.buildInternalNetwork();
    }

    private void buildInternalNetwork() {
        Object v;
        int n;
        this.numNodes = this.network.vertexSet().size();
        this.nodes = new ArrayList<Node>();
        Iterator iterator = this.network.vertexSet().iterator();
        this.indexer = new HashMap<V, Integer>();
        for (n = 0; n < this.numNodes; ++n) {
            v = iterator.next();
            this.nodes.add(new Node(v));
            this.indexer.put((Integer)v, n);
        }
        for (n = 0; n < this.numNodes; ++n) {
            v = this.nodes.get((int)n).prototype;
            for (E e : this.network.outgoingEdgesOf(v)) {
                Arc arc;
                Object v2 = this.network.getEdgeTarget(e);
                int n2 = this.indexer.get(v2);
                Arc arc2 = new Arc(n, n2, this.network.getEdgeWeight(e), e);
                arc2.reversed = arc = new Arc(n2, n, 0.0, null);
                arc.reversed = arc2;
                this.nodes.get((int)n).outgoingArcs.add(arc2);
                this.nodes.get((int)n2).outgoingArcs.add(arc);
            }
        }
    }

    public void calculateMaximumFlow(V v, V v2) {
        int n;
        if (!this.network.containsVertex(v)) {
            throw new IllegalArgumentException("invalid source (null or not from this network)");
        }
        if (!this.network.containsVertex(v2)) {
            throw new IllegalArgumentException("invalid sink (null or not from this network)");
        }
        if (v.equals(v2)) {
            throw new IllegalArgumentException("source is equal to sink");
        }
        this.currentSource = this.indexer.get(v);
        this.currentSink = this.indexer.get(v2);
        for (n = 0; n < this.numNodes; ++n) {
            for (Arc arc : this.nodes.get((int)n).outgoingArcs) {
                arc.flow = 0.0;
            }
        }
        this.maximumFlowValue = 0.0;
        while (true) {
            this.breadthFirstSearch();
            if (!this.nodes.get((int)this.currentSink).visited) {
                this.maximumFlow = new HashMap<E, Double>();
                for (n = 0; n < this.numNodes; ++n) {
                    for (Arc arc : this.nodes.get((int)n).outgoingArcs) {
                        if (arc.prototype == null) continue;
                        this.maximumFlow.put(arc.prototype, arc.flow);
                    }
                }
                return;
            }
            this.augmentFlow();
        }
    }

    private void breadthFirstSearch() {
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodes.get((int)i).visited = false;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.offer(this.currentSource);
        this.nodes.get((int)this.currentSource).visited = true;
        this.nodes.get((int)this.currentSource).flowAmount = Double.POSITIVE_INFINITY;
        while (linkedList.size() != 0) {
            int n = (Integer)linkedList.poll();
            for (Arc arc : this.nodes.get((int)n).outgoingArcs) {
                if (!(arc.flow + this.epsilon < arc.capacity) || this.nodes.get((int)arc.head).visited) continue;
                this.nodes.get((int)arc.head).visited = true;
                this.nodes.get((int)arc.head).flowAmount = Math.min(this.nodes.get((int)n).flowAmount, arc.capacity - arc.flow);
                this.nodes.get((int)arc.head).lastArc = arc;
                linkedList.add(arc.head);
            }
        }
    }

    private void augmentFlow() {
        double d = this.nodes.get((int)this.currentSink).flowAmount;
        this.maximumFlowValue = this.maximumFlowValue + d;
        int n = this.currentSink;
        while (n != this.currentSource) {
            this.nodes.get((int)n).lastArc.flow += d;
            this.nodes.get((int)n).lastArc.reversed.flow -= d;
            n = this.nodes.get((int)n).lastArc.tail;
        }
    }

    public Double getMaximumFlowValue() {
        return this.maximumFlowValue;
    }

    public Map<E, Double> getMaximumFlow() {
        if (this.maximumFlow == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.maximumFlow);
    }

    public V getCurrentSource() {
        if (this.currentSource == -1) {
            return null;
        }
        return this.nodes.get((int)this.currentSource).prototype;
    }

    public V getCurrentSink() {
        if (this.currentSink == -1) {
            return null;
        }
        return this.nodes.get((int)this.currentSink).prototype;
    }

    class Arc {
        int tail;
        int head;
        double capacity;
        double flow;
        Arc reversed;
        E prototype;

        Arc(int n, int n2, double d, E e) {
            this.tail = n;
            this.head = n2;
            this.capacity = d;
            this.prototype = e;
        }
    }

    class Node {
        V prototype;
        List<Arc> outgoingArcs = new ArrayList<Arc>();
        boolean visited;
        Arc lastArc;
        double flowAmount;

        Node(V v) {
            this.prototype = v;
        }
    }
}

