/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal.constraint;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.database.schema.ColumnDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.sql.internal.constraint.DbTableCheckExpression;
import org.evomaster.client.java.sql.internal.constraint.DbTableConstraint;
import org.evomaster.client.java.sql.internal.constraint.DbTableUniqueConstraint;
import org.evomaster.client.java.sql.internal.constraint.TableConstraintExtractor;
import org.evomaster.client.java.utils.SimpleLogger;

public class MySQLConstraintExtractor
extends TableConstraintExtractor {
    private static final String MYSQL_CONSTRAINT_TYPE_CHECK = "CHECK";
    private static final String MYSQL_CONSTRAINT_TYPE_FOREIGN_KEY = "FOREIGN KEY";
    private static final String MYSQL_CONSTRAINT_TYPE_PRIMARY_KEY = "PRIMARY KEY";
    private static final String MYSQL_CONSTRAINT_TYPE_UNIQUE = "UNIQUE";
    private static final String MYSQL_CONSTRAINT_NAME = "CONSTRAINT_NAME";
    private static final String MYSQL_CONSTRAINT_TYPE = "CONSTRAINT_TYPE";
    private static final String MYSQL_CHECK_CLAUSE = "CHECK_CLAUSE";
    private static final String MYSQL_COLUMN_NAME = "COLUMN_NAME";
    private static final String MYSQL_ENUM_COLUMN_TYPE = "COLUMN_TYPE";

    private static void cannotHandle(String constraintType) {
        SimpleLogger.uniqueWarn((String)("WARNING, EvoMaster cannot extract MySQL constraints with type '" + constraintType));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DbTableConstraint> extract(Connection connectionToMySQL, DbSchemaDto schemaDto) throws SQLException {
        String tableSchema = schemaDto.name;
        ArrayList<DbTableConstraint> constraints = new ArrayList<DbTableConstraint>();
        Iterator iterator = schemaDto.tables.iterator();
        block29: while (iterator.hasNext()) {
            TableDto tableDto = (TableDto)iterator.next();
            String tableName = tableDto.name;
            try (Statement statement = connectionToMySQL.createStatement();){
                String query = String.format("SELECT *\n       FROM information_schema.table_constraints\n       WHERE table_schema = '%s'\n             AND table_name = '%s';", tableSchema, tableName);
                try (ResultSet columns = statement.executeQuery(query);){
                    block30: while (columns.next()) {
                        String type;
                        switch (type = columns.getString(MYSQL_CONSTRAINT_TYPE)) {
                            case "PRIMARY KEY": 
                            case "FOREIGN KEY": {
                                continue block30;
                            }
                            case "CHECK": {
                                String constraintName = columns.getString(MYSQL_CONSTRAINT_NAME);
                                DbTableCheckExpression check = this.getCheckConstraint(connectionToMySQL, tableName, constraintName);
                                constraints.add(check);
                                continue block30;
                            }
                            case "UNIQUE": {
                                String uniqueConstraintName = columns.getString(MYSQL_CONSTRAINT_NAME);
                                DbTableUniqueConstraint uniqueConstraint = this.getUniqueConstraint(connectionToMySQL, tableSchema, tableName, uniqueConstraintName);
                                constraints.add(uniqueConstraint);
                                continue block30;
                            }
                        }
                        MySQLConstraintExtractor.cannotHandle("Unknown constraint type " + type);
                    }
                }
            }
            Iterator iterator2 = tableDto.columns.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block29;
                ColumnDto column = (ColumnDto)iterator2.next();
                if (!column.type.equalsIgnoreCase("enum")) continue;
                DbTableCheckExpression enumConstraint = this.handleEnum(connectionToMySQL, tableSchema, tableName, column.name);
                constraints.add(enumConstraint);
            }
            break;
        }
        return constraints;
    }

    /*
     * Exception decompiling
     */
    private DbTableUniqueConstraint getUniqueConstraint(Connection connectionToMySQL, String tableSchema, String tableName, String constraintName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private DbTableCheckExpression getCheckConstraint(Connection connectionToMySQL, String tableName, String constraintName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String postCheckConstraintHandling(String check_exp) {
        return check_exp.replaceAll("`", "").replaceAll("_utf8mb4", "").replaceAll("\\\\'", "'");
    }

    /*
     * Exception decompiling
     */
    private DbTableCheckExpression handleEnum(Connection connectionToMySQL, String schemaName, String tableName, String columnName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

