/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.evomaster.ci.utils.CIUtils;
import org.evomaster.client.java.controller.api.dto.database.schema.DatabaseType;
import org.evomaster.client.java.sql.DbCleaner;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.SqlScriptRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class DbCleanerSQLServerWithSchemaTest {
    private static final int PORT = 1433;
    private static final String PASSWORD = "A_Str0ng_Required_Password";
    public static final GenericContainer mssqlserver = new GenericContainer(DockerImageName.parse((String)"mcr.microsoft.com/mssql/server").withTag("2019-CU9-ubuntu-16.04")).withEnv((Map)new HashMap<String, String>(){
        {
            this.put("ACCEPT_EULA", "Y");
            this.put("MSSQL_SA_PASSWORD", DbCleanerSQLServerWithSchemaTest.PASSWORD);
        }
    }).withStartupTimeout(Duration.ofSeconds(240L)).withExposedPorts(new Integer[]{1433});
    private static Connection connection;

    @Test
    public void testSkipTableMisconfigured() throws Exception {
        CIUtils.skipIfOnGA();
        CIUtils.skipIfOnCircleCI();
        CIUtils.skipIfOnWindows();
        mssqlserver.start();
        String host = mssqlserver.getContainerIpAddress();
        int port = mssqlserver.getMappedPort(1433);
        String url = "jdbc:sqlserver://" + host + ":" + port;
        connection = DriverManager.getConnection(url, "sa", PASSWORD);
        Assertions.assertTrue((connection != null ? 1 : 0) != 0);
        SqlScriptRunner.execCommand((Connection)connection, (String)"CREATE SCHEMA Foo AUTHORIZATION dbo;");
        SqlScriptRunner.execCommand((Connection)connection, (String)"CREATE TABLE Foo.Foo(x int, primary key (x));");
        SqlScriptRunner.execCommand((Connection)connection, (String)"INSERT INTO Foo.Foo(x) VALUES (42)");
        QueryResult res = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT * FROM Foo.Foo;");
        Assertions.assertEquals((int)1, (int)res.seeRows().size());
        Assertions.assertThrows(RuntimeException.class, () -> DbCleaner.clearDatabase((Connection)connection, (String)"", null, null, (DatabaseType)DatabaseType.MS_SQL_SERVER));
        DbCleaner.clearDatabase((Connection)connection, (String)"Foo", null, null, (DatabaseType)DatabaseType.MS_SQL_SERVER);
        res = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT * FROM Foo.Foo;");
        Assertions.assertEquals((int)0, (int)res.seeRows().size());
    }
}

