/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionDto;
import org.evomaster.client.java.controller.api.dto.database.schema.ColumnDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.dsl.SqlDsl;
import org.evomaster.client.java.sql.internal.HeuristicsCalculator;
import org.evomaster.client.java.sql.internal.QueryResultTransformer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HeuristicsCalculatorWithInsertionDtoTest {
    private final Map<String, Set<String>> selectWhereXofFoo = new HashMap<String, Set<String>>(){
        {
            this.put("Foo", Collections.singleton("x"));
        }
    };

    private DbSchemaDto createSchemaDtoWithFooTableAndXColumn(String xDataType) {
        DbSchemaDto schemaDto = new DbSchemaDto();
        TableDto tableDto = new TableDto();
        tableDto.name = "Foo";
        ColumnDto dto = new ColumnDto();
        dto.name = "x";
        dto.type = xDataType;
        tableDto.columns.add(dto);
        schemaDto.tables.add(tableDto);
        return schemaDto;
    }

    @Test
    public void testEmptyWithInsertionDto() {
        String sql = "select x from Foo";
        QueryResult data = new QueryResult(Arrays.asList("x"), "Foo");
        double dist = HeuristicsCalculator.computeDistance((String)sql, (QueryResult[])new QueryResult[]{data});
        Assertions.assertTrue((dist > 0.0 ? 1 : 0) != 0);
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "1").dtos();
        QueryResult[] newData = QueryResultTransformer.convertInsertionDtosToQueryResults((List)insertions, this.selectWhereXofFoo, (DbSchemaDto)this.createSchemaDtoWithFooTableAndXColumn("INT"));
        dist = HeuristicsCalculator.computeDistance((String)sql, (QueryResult[])newData);
        Assertions.assertEquals((double)0.0, (double)dist);
    }

    private void checkIncreasingTillCovered(String name, List<Object> values, List<InsertionDto> insertionDtos, Map<String, Set<String>> columns, DbSchemaDto dto, String sql) {
        QueryResult data = new QueryResult(Arrays.asList(name), "Foo");
        double prev = -1.0;
        for (Object val : values) {
            data.addRow(new DataRow(name, val, "Foo"));
            double dist = HeuristicsCalculator.computeDistance((String)sql, (QueryResult[])new QueryResult[]{data});
            Assertions.assertTrue((dist > 0.0 ? 1 : 0) != 0);
            if (prev >= 0.0) {
                Assertions.assertTrue((dist < prev ? 1 : 0) != 0, (String)("dist=" + dist + " , previous=" + prev));
            }
            prev = dist;
        }
        QueryResult[] newData = QueryResultTransformer.convertInsertionDtosToQueryResults(insertionDtos, columns, (DbSchemaDto)dto);
        double target = HeuristicsCalculator.computeDistance((String)sql, (QueryResult[])newData);
        Assertions.assertTrue((target < prev ? 1 : 0) != 0);
        Assertions.assertEquals((double)0.0, (double)target, (String)("dist=" + target + " , previous=" + prev));
    }

    @Test
    public void testTrue() {
        String sql = "select a from Foo where x = true";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "true").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(false), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("BOOL"), sql);
    }

    @Test
    public void testFalse() {
        String sql = "select a from Foo where x = false";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "false").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(true), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("BOOL"), sql);
    }

    @Test
    public void testNotTrue() {
        String sql = "select a from Foo where x != true";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "false").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(true), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("BOOL"), sql);
    }

    @Test
    public void testNotFalse() {
        String sql = "select a from Foo where x != FALSE";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "true").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(false), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("BOOL"), sql);
    }

    @Test
    public void testWithParentheses() {
        String sql = "select a from Foo where x = (5)";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "5").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(9, 3, 6), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testNegativeWithParentheses() {
        String sql = "select a from Foo where x = (-5)";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "-5").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(9, 3, -7), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testEqualInt() {
        String sql = "select x from Foo where x=5";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "5").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(9, 3, 6), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testEqualToNull() {
        String sql = "select x from Foo where x = NULL";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", null).dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList("foo"), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("CHARACTER"), sql);
    }

    @Test
    public void testIsNull() {
        String sql = "select x from Foo where x IS NULL";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", null).dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList("foo"), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("CHARACTER"), sql);
    }

    @Test
    public void testIsNotNull() {
        String sql = "select x from Foo where x IS NOT NULL";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(null);
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "foo").dtos();
        this.checkIncreasingTillCovered("x", list, insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("CHARACTER"), sql);
    }

    @Test
    public void testDifferentFromNull() {
        String sql = "select x from Foo where x != NULL";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(null);
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "foo").dtos();
        this.checkIncreasingTillCovered("x", list, insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("CHARACTER"), sql);
    }

    @Test
    public void testInNumeric() {
        String sql = "select x from Foo where x IN (10, 20)";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "10").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(-4, 6, 23, 12, 19), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testInNumericWithParenthesis() {
        String sql = "select x from Foo where (x IN (10, 20))";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "10").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(-4, 6, 23, 12, 19), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testInStrings() {
        String sql = "select x from Foo where x IN ('a1', 'e5')";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "a1").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList("z9", "z7", "c7", "c2", "b2", "b1"), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("CHARACTER"), sql);
    }

    @Test
    public void testNotInNumeric() {
        String sql = "select x from Foo where x Not IN (10, 20)";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "11").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(10), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testEqualString() {
        String sql = "select t.bar as X from Foo t where X='abc123'";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "abc123").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList("a", "ab", "xxx123x", "xxx123", "axx123", "abc234"), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("CHARACTER"), sql);
    }

    @Test
    public void testNotEqualString() {
        String sql = "select t.bar as X from Foo t where X!='foo'";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "blabla").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList("foo"), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("CHARACTER"), sql);
    }

    @Test
    public void testNotEqual() {
        String sql = "select x from Foo where x != 5";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "6").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(5), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testGreaterThanEquals() {
        String sql = "select x from Foo where x >= 5";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "5").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(-4, 2, 3), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testGreaterThan() {
        String sql = "select x from Foo where x > 5";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "6").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(-4, 2, 3, 5), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testMinorThan() {
        String sql = "select x from Foo where x < 5";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "-2").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(10, 7, 6, 5), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testMinorThanEquals() {
        String sql = "select x from Foo where x <= 5";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "5").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(10, 7, 6), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testAnd() {
        String sql = "select x from Foo where x > 5 and x < 10";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "7").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(20, -1, 4), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testOr() {
        String sql = "select x from Foo where x < 0 or x > 100";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "-3").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(50, 60, 20, 90, 5), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testDeleteBase() {
        String sql = "delete from Foo where x=0";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "0").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(10, -5, 2), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testUpdateBase() {
        String sql = "update Foo set x=42 where x=0";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "0").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(10, -5, 2), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("INT"), sql);
    }

    @Test
    public void testTimestamp() {
        String sql = "select x from Foo where x > '28-Feb-17'";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "2017-03-01 00:00:00").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(Timestamp.valueOf("1870-01-01 00:00:00"), Timestamp.valueOf("1900-01-01 00:00:00"), Timestamp.valueOf("2010-03-12 13:21:42"), Timestamp.valueOf("2017-02-27 00:00:00")), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("TIMESTAMP"), sql);
    }

    @Test
    public void testTimestampBetween() {
        String sql = "select x from Foo where x BETWEEN '28-Feb-17' AND '25-Mar-19'";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "2018-03-01 00:00:00").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(Timestamp.valueOf("1870-01-01 00:00:00"), Timestamp.valueOf("1900-01-01 00:00:00"), Timestamp.valueOf("2021-03-12 13:21:42"), Timestamp.valueOf("2016-02-27 00:00:00")), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("TIMESTAMP"), sql);
    }

    @Test
    public void testTimestampMinorThanEquals() {
        String sql = "select x from Foo where x <= TIMESTAMP '2022-11-30 16:00:00.0'";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "2022-11-30 16:00:00.0").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(Timestamp.valueOf("2023-11-30 00:00:00"), Timestamp.valueOf("2023-06-30 16:00:00.0"), Timestamp.valueOf("2022-12-30 16:00:00.0"), Timestamp.valueOf("2022-11-30 17:00:00.0")), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("TIMESTAMP"), sql);
    }

    @Test
    public void testTimestampMinorThan() {
        String sql = "select x from Foo where x < TIMESTAMP '2022-11-30 16:00:00.0'";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "2022-11-29 16:00:00.0").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(Timestamp.valueOf("2023-11-30 00:00:00"), Timestamp.valueOf("2023-06-30 16:00:00.0"), Timestamp.valueOf("2022-12-30 16:00:00.0"), Timestamp.valueOf("2022-11-30 17:00:00.0")), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("TIMESTAMP"), sql);
    }

    @Test
    public void testTimestampGreaterThan() {
        String sql = "select x from Foo where x > TIMESTAMP '2022-11-30 16:00:00.0'";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "2022-12-01 16:00:00.0").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(Timestamp.valueOf("2020-11-30 16:00:00"), Timestamp.valueOf("2021-11-30 16:00:00.0"), Timestamp.valueOf("2022-11-30 15:00:00.0"), Timestamp.valueOf("2022-11-30 16:00:00.0")), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("TIMESTAMP"), sql);
    }

    @Test
    public void testTimestampGreaterThanEquals() {
        String sql = "select x from Foo where x >= TIMESTAMP '2022-11-30 16:00:00.0'";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "2022-11-30 16:00:00.0").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(Timestamp.valueOf("2020-11-30 16:00:00"), Timestamp.valueOf("2021-11-30 16:00:00.0"), Timestamp.valueOf("2022-11-30 15:00:00.0")), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("TIMESTAMP"), sql);
    }

    @Test
    public void testTimestampEqualsTo() {
        String sql = "select x from Foo where x = TIMESTAMP '2022-11-30 16:00:00.0'";
        List insertions = SqlDsl.sql().insertInto("Foo", Long.valueOf(1L)).d("x", "2022-11-30 16:00:00.0").dtos();
        this.checkIncreasingTillCovered("x", Arrays.asList(Timestamp.valueOf("2020-11-30 16:00:00"), Timestamp.valueOf("2021-11-30 16:00:00.0"), Timestamp.valueOf("2022-11-29 16:00:00.0")), insertions, this.selectWhereXofFoo, this.createSchemaDtoWithFooTableAndXColumn("TIMESTAMP"), sql);
    }
}

