/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionDto;
import org.evomaster.client.java.controller.api.dto.database.schema.ColumnDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;

public class SqlDatabaseDtoUtils {
    public static List<String> extractColumnNames(InsertionDto dto, Set<String> filter) {
        return dto.data.stream().filter(i -> filter == null || filter.stream().anyMatch(f -> i.variableName.equalsIgnoreCase((String)f))).map(i -> i.variableName).collect(Collectors.toList());
    }

    public static List<String> extractColumnPrintableValues(InsertionDto dto, Set<String> filter) {
        return dto.data.stream().filter(i -> filter == null || filter.stream().anyMatch(f -> i.variableName.equalsIgnoreCase((String)f))).map(i -> i.printableValue).collect(Collectors.toList());
    }

    public static ColumnDto extractColumnInfo(TableDto dto, String columnName) {
        Optional<ColumnDto> op = dto.columns.stream().filter(c -> columnName.equalsIgnoreCase(c.name)).findAny();
        return op.orElse(null);
    }
}

