/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.schema.ColumnDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.dsl.SqlDsl;
import org.evomaster.client.java.sql.internal.QueryResultTransformer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QueryResultTransformerTest {
    private TableDto createTableDate(List<String> columnTypes, List<String> columnNames, String tableName) {
        Assertions.assertEquals((int)columnTypes.size(), (int)columnNames.size());
        TableDto tableDto = new TableDto();
        tableDto.name = tableName;
        for (int i = 0; i < columnTypes.size(); ++i) {
            ColumnDto dto = new ColumnDto();
            dto.name = columnNames.get(i);
            dto.type = columnTypes.get(i);
            tableDto.columns.add(dto);
        }
        return tableDto;
    }

    @Test
    public void testConvertInsertionDtosToQueryResults() {
        List insertions = SqlDsl.sql().insertInto("FooTable", Long.valueOf(1L)).d("fooA", "a1").d("fooB", "b1").d("fooC", "c1").and().insertInto("FooTable", Long.valueOf(2L)).d("fooA", "a2").d("fooB", "b2").d("fooC", "c2").and().insertInto("BarTable", Long.valueOf(3L)).d("barA", "11").d("barB", "12").d("barC", "13").d("barD", "14").d("barE", "15").and().insertInto("BarTable", Long.valueOf(4L)).d("barA", "21").d("barB", "22").d("barC", "23").d("barD", "24").d("barE", "25").dtos();
        HashMap<String, Set<String>> columns = new HashMap<String, Set<String>>(){
            {
                this.put("FooTable", new HashSet<String>(Arrays.asList("fooA", "fooC")));
                this.put("BarTable", new HashSet<String>(Arrays.asList("barB", "barC", "barD", "barE")));
            }
        };
        DbInfoDto schemaDto = new DbInfoDto();
        TableDto fooTable = this.createTableDate(Arrays.asList("CHARACTER", "CHARACTER", "CHARACTER"), Arrays.asList("fooA", "fooB", "fooC"), "FooTable");
        TableDto barTable = this.createTableDate(Arrays.asList("INT", "INT", "INT", "INT", "INT"), Arrays.asList("barA", "barB", "barC", "barD", "barE"), "BarTable");
        schemaDto.tables.add(fooTable);
        schemaDto.tables.add(barTable);
        QueryResult[] results = QueryResultTransformer.convertInsertionDtosToQueryResults((List)insertions, (Map)columns, (DbInfoDto)schemaDto);
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((int)1, (int)results.length);
        Assertions.assertEquals((int)4, (int)results[0].size());
        Assertions.assertEquals((Object)"12,13,14,15,a1,c1", (Object)((DataRow)results[0].seeRows().get(0)).seeValues().stream().map(Object::toString).collect(Collectors.joining(",")));
        Assertions.assertEquals((Object)"12,13,14,15,a2,c2", (Object)((DataRow)results[0].seeRows().get(1)).seeValues().stream().map(Object::toString).collect(Collectors.joining(",")));
        Assertions.assertEquals((Object)"22,23,24,25,a1,c1", (Object)((DataRow)results[0].seeRows().get(2)).seeValues().stream().map(Object::toString).collect(Collectors.joining(",")));
        Assertions.assertEquals((Object)"22,23,24,25,a2,c2", (Object)((DataRow)results[0].seeRows().get(3)).seeValues().stream().map(Object::toString).collect(Collectors.joining(",")));
    }

    @Test
    public void testCartesianProductIntList() {
        final List<Integer> setA = Arrays.asList(1, 2, 3);
        final List<Integer> setB = Arrays.asList(7, 8, 9, 0);
        ArrayList<List<Integer>> intValues = new ArrayList<List<Integer>>(){
            {
                this.add(setA);
                this.add(setB);
            }
        };
        List results = QueryResultTransformer.cartesianProduct((List)intValues);
        Assertions.assertEquals((int)12, (int)results.size());
        int index = 0;
        for (int indexA = 0; indexA < setA.size(); ++indexA) {
            for (int indexB = 0; indexB < setB.size(); ++indexB) {
                List row = (List)results.get(index);
                Assertions.assertEquals((int)2, (int)row.size());
                Assertions.assertEquals((Integer)setA.get(indexA), (Integer)((Integer)row.get(0)));
                Assertions.assertEquals((Integer)setB.get(indexB), (Integer)((Integer)row.get(1)));
                ++index;
            }
        }
    }

    @Test
    public void testCartesianProductStringList() {
        final List<String> setA = Arrays.asList("aaa", "bbb");
        final List<String> setB = Arrays.asList("nmt", "xyz");
        final List<String> setC = Arrays.asList("foo", "bar");
        ArrayList<List<String>> intValues = new ArrayList<List<String>>(){
            {
                this.add(setA);
                this.add(setB);
                this.add(setC);
            }
        };
        List results = QueryResultTransformer.cartesianProduct((List)intValues);
        List<String> expected = Arrays.asList("aaa,nmt,foo", "aaa,nmt,bar", "aaa,xyz,foo", "aaa,xyz,bar", "bbb,nmt,foo", "bbb,nmt,bar", "bbb,xyz,foo", "bbb,xyz,bar");
        Assertions.assertEquals((int)expected.size(), (int)results.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertEquals((Object)expected.get(i), (Object)String.join((CharSequence)",", (Iterable)results.get(i)));
        }
    }

    @Test
    public void testCartesianProductEmptyList() {
        List intValues = Collections.emptyList();
        List results = QueryResultTransformer.cartesianProduct(intValues);
        Assertions.assertTrue((boolean)results.isEmpty());
    }

    @Test
    public void testCartesianProductContainEmptySet() {
        final List<String> setA = Arrays.asList("aaa", "bbb");
        final List<String> setB = Arrays.asList("nmt", "xyz");
        final List setC = Collections.emptyList();
        ArrayList<List<String>> intValues = new ArrayList<List<String>>(){
            {
                this.add(setA);
                this.add(setB);
                this.add(setC);
            }
        };
        List results = QueryResultTransformer.cartesianProduct((List)intValues);
        List<String> expected = Arrays.asList("aaa,nmt", "aaa,xyz", "bbb,nmt", "bbb,xyz");
        Assertions.assertEquals((int)expected.size(), (int)results.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertEquals((Object)expected.get(i), (Object)String.join((CharSequence)",", (Iterable)results.get(i)));
        }
    }
}

