/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Stack;
import net.sf.jsqlparser.expression.AllValue;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.ArrayConstructor;
import net.sf.jsqlparser.expression.ArrayExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.CollateExpression;
import net.sf.jsqlparser.expression.ConnectByRootOperator;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.JsonAggregateFunction;
import net.sf.jsqlparser.expression.JsonExpression;
import net.sf.jsqlparser.expression.JsonFunction;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import net.sf.jsqlparser.expression.NextValExpression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.OracleNamedFunctionParameter;
import net.sf.jsqlparser.expression.OverlapsCondition;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.RangeExpression;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.RowGetExpression;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.TimezoneExpression;
import net.sf.jsqlparser.expression.TranscodingFunction;
import net.sf.jsqlparser.expression.TrimFunction;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.VariableAssignment;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.XMLSerializeExpr;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.IntegerDivision;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.conditional.XorExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.ContainedBy;
import net.sf.jsqlparser.expression.operators.relational.Contains;
import net.sf.jsqlparser.expression.operators.relational.DoubleAnd;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.FullTextSearch;
import net.sf.jsqlparser.expression.operators.relational.GeometryDistance;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import net.sf.jsqlparser.expression.operators.relational.IsDistinctExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MemberOfExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.expression.operators.relational.SimilarToExpression;
import net.sf.jsqlparser.expression.operators.relational.TSQLLeftJoin;
import net.sf.jsqlparser.expression.operators.relational.TSQLRightJoin;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.distance.heuristics.TruthnessUtils;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.internal.SqlHeuristicsCalculator;
import org.evomaster.client.java.sql.internal.SqlNameContext;

public class SqlExpressionEvaluator
extends ExpressionVisitorAdapter {
    private final DataRow dataRow;
    private final SqlNameContext sqlNameContext;
    private final Stack<Truthness> computedTruthnesses = new Stack();
    private final Stack<Object> concreteValues = new Stack();

    public SqlExpressionEvaluator(SqlNameContext sqlNameContext, DataRow dataRow) {
        this.sqlNameContext = sqlNameContext;
        this.dataRow = dataRow;
    }

    public Truthness getEvaluatedTruthness() {
        if (this.computedTruthnesses.isEmpty()) {
            throw new IllegalStateException("no Truthness was computed");
        }
        return this.computedTruthnesses.peek();
    }

    private void visitComparisonOperator(ComparisonOperator comparisonOperator) {
        Object concreteRightValue = this.concreteValues.pop();
        Object concreteLeftValue = this.concreteValues.pop();
        Truthness truthness = this.computeTruthnessForComparisonOperator(concreteLeftValue, concreteRightValue, comparisonOperator);
        this.computedTruthnesses.push(truthness);
    }

    public void visit(EqualsTo equalsTo) {
        super.visit(equalsTo);
        this.visitComparisonOperator((ComparisonOperator)equalsTo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Truthness computeTruthnessForComparisonOperator(Object concreteLeftValue, Object concreteRightValue, ComparisonOperator comparisonOperator) {
        Truthness truthnessOfExpression;
        if (concreteLeftValue == null && concreteRightValue == null) {
            return SqlHeuristicsCalculator.FALSE_TRUTHNESS;
        }
        if (concreteLeftValue == null) return SqlHeuristicsCalculator.FALSE_TRUTHNESS_BETTER;
        if (concreteRightValue == null) {
            return SqlHeuristicsCalculator.FALSE_TRUTHNESS_BETTER;
        }
        if (concreteLeftValue instanceof Number && concreteRightValue instanceof Number) {
            double leftValueAsDouble = ((Number)concreteLeftValue).doubleValue();
            double rightValueAsDouble = ((Number)concreteRightValue).doubleValue();
            if (comparisonOperator instanceof EqualsTo) {
                truthnessOfExpression = TruthnessUtils.getEqualityTruthness((double)leftValueAsDouble, (double)rightValueAsDouble);
            } else if (comparisonOperator instanceof NotEqualsTo) {
                truthnessOfExpression = TruthnessUtils.getEqualityTruthness((double)leftValueAsDouble, (double)rightValueAsDouble).invert();
            } else if (comparisonOperator instanceof GreaterThan) {
                truthnessOfExpression = TruthnessUtils.getLessThanTruthness((double)rightValueAsDouble, (double)leftValueAsDouble);
            } else if (comparisonOperator instanceof MinorThan) {
                truthnessOfExpression = TruthnessUtils.getLessThanTruthness((double)leftValueAsDouble, (double)rightValueAsDouble);
            } else if (comparisonOperator instanceof MinorThanEquals) {
                truthnessOfExpression = TruthnessUtils.getLessThanTruthness((double)rightValueAsDouble, (double)leftValueAsDouble).invert();
            } else {
                if (!(comparisonOperator instanceof GreaterThanEquals)) throw new UnsupportedOperationException("Unsupported comparison operator: " + comparisonOperator);
                truthnessOfExpression = TruthnessUtils.getLessThanTruthness((double)leftValueAsDouble, (double)rightValueAsDouble).invert();
            }
        } else {
            if (concreteRightValue instanceof String && concreteLeftValue instanceof String) {
                throw new UnsupportedOperationException("String comparison not yet supported");
            }
            if (concreteLeftValue instanceof Timestamp) throw new UnsupportedOperationException("Timestamp/Instant comparison not yet supported");
            if (concreteRightValue instanceof Timestamp) throw new UnsupportedOperationException("Timestamp/Instant comparison not yet supported");
            if (concreteLeftValue instanceof Instant) throw new UnsupportedOperationException("Timestamp/Instant comparison not yet supported");
            if (concreteRightValue instanceof Instant) {
                throw new UnsupportedOperationException("Timestamp/Instant comparison not yet supported");
            }
            if (!(concreteLeftValue instanceof Boolean)) throw new UnsupportedOperationException("type not supported");
            if (!(concreteRightValue instanceof Boolean)) throw new UnsupportedOperationException("type not supported");
            throw new UnsupportedOperationException("Boolean comparison not yet supported");
        }
        if (!truthnessOfExpression.isTrue()) return TruthnessUtils.buildScaledTruthness((double)SqlHeuristicsCalculator.C_BETTER, (double)truthnessOfExpression.getOfTrue());
        return truthnessOfExpression;
    }

    public void visit(BitwiseRightShift bitwiseRightShift) {
        throw new UnsupportedOperationException("Bitwise right shift not supported");
    }

    public void visit(BitwiseLeftShift bitwiseLeftShift) {
        throw new UnsupportedOperationException("Bitwise left shift not supported");
    }

    public void visit(NullValue nullValue) {
        throw new UnsupportedOperationException("Null value not supported");
    }

    public void visit(Function function) {
        throw new UnsupportedOperationException("Function not supported");
    }

    public void visit(SignedExpression signedExpression) {
        throw new UnsupportedOperationException("Signed expression not supported");
    }

    public void visit(JdbcParameter jdbcParameter) {
        throw new UnsupportedOperationException("JdbcParameter not supported");
    }

    public void visit(JdbcNamedParameter jdbcNamedParameter) {
        throw new UnsupportedOperationException("JdbcNamedParameter not supported");
    }

    public void visit(DoubleValue doubleValue) {
        throw new UnsupportedOperationException("DoubleValue not supported");
    }

    public void visit(LongValue longValue) {
        long concreteValue = longValue.getValue();
        this.concreteValues.push(concreteValue);
    }

    public void visit(HexValue hexValue) {
        throw new UnsupportedOperationException("HexValue not supported");
    }

    public void visit(DateValue dateValue) {
        throw new UnsupportedOperationException("DateValue not supported");
    }

    public void visit(TimeValue timeValue) {
        throw new UnsupportedOperationException("TimeValue not supported");
    }

    public void visit(TimestampValue timestampValue) {
        throw new UnsupportedOperationException("TimestampValue not supported");
    }

    public void visit(Parenthesis parenthesis) {
        throw new UnsupportedOperationException("Parenthesis not supported");
    }

    public void visit(IntegerDivision integerDivision) {
        throw new UnsupportedOperationException("visit(IntegerDivision) not supported");
    }

    public void visit(Multiplication multiplication) {
        throw new UnsupportedOperationException("visit(Multiplication) not supported");
    }

    public void visit(Subtraction subtraction) {
        throw new UnsupportedOperationException("visit(Subtraction) not supported");
    }

    public void visit(AndExpression andExpression) {
        throw new UnsupportedOperationException("visit(AndExpression) not supported");
    }

    public void visit(OrExpression orExpression) {
        throw new UnsupportedOperationException("visit(OrExpression) not supported");
    }

    public void visit(XorExpression xorExpression) {
        throw new UnsupportedOperationException("visit(XorExpression) not supported");
    }

    public void visit(Between between) {
        throw new UnsupportedOperationException("visit(Between) not supported");
    }

    public void visit(OverlapsCondition overlapsCondition) {
        throw new UnsupportedOperationException("visit(OverlapsCondition) not supported");
    }

    public void visit(GreaterThan greaterThan) {
        super.visit(greaterThan);
        this.visitComparisonOperator((ComparisonOperator)greaterThan);
    }

    public void visit(GreaterThanEquals greaterThanEquals) {
        super.visit(greaterThanEquals);
        this.visitComparisonOperator((ComparisonOperator)greaterThanEquals);
    }

    public void visit(InExpression inExpression) {
        throw new UnsupportedOperationException("visit(InExpression) not supported");
    }

    public void visit(FullTextSearch fullTextSearch) {
        throw new UnsupportedOperationException("visit(FullTextSearch) not supported");
    }

    public void visit(IsNullExpression isNullExpression) {
        throw new UnsupportedOperationException("visit(IsNullExpression) not supported");
    }

    public void visit(IsBooleanExpression isBooleanExpression) {
        throw new UnsupportedOperationException("visit(IsBooleanExpression) not supported");
    }

    public void visit(LikeExpression likeExpression) {
        throw new UnsupportedOperationException("visit(LikeExpression) not supported");
    }

    public void visit(MinorThan minorThan) {
        super.visit(minorThan);
        this.visitComparisonOperator((ComparisonOperator)minorThan);
    }

    public void visit(MinorThanEquals minorThanEquals) {
        super.visit(minorThanEquals);
        this.visitComparisonOperator((ComparisonOperator)minorThanEquals);
    }

    public void visit(NotEqualsTo notEqualsTo) {
        super.visit(notEqualsTo);
        this.visitComparisonOperator((ComparisonOperator)notEqualsTo);
    }

    public void visit(DoubleAnd doubleAnd) {
        throw new UnsupportedOperationException("visit(DoubleAnd) not supported");
    }

    public void visit(Contains contains) {
        throw new UnsupportedOperationException("visit(Contains) not supported");
    }

    public void visit(ContainedBy containedBy) {
        throw new UnsupportedOperationException("visit(ContainedBy) not supported");
    }

    public void visit(ParenthesedSelect parenthesedSelect) {
        throw new UnsupportedOperationException("visit(ParenthesedSelect) not supported");
    }

    public void visit(Column column) {
        String name = column.getColumnName();
        String table = this.sqlNameContext.getTableName(column);
        Object value = this.dataRow.getValueByName(name, table);
        this.concreteValues.push(value);
    }

    public void visit(CaseExpression caseExpression) {
        throw new UnsupportedOperationException("visit(CaseExpression) not supported");
    }

    public void visit(WhenClause whenClause) {
        throw new UnsupportedOperationException("visit(WhenClause) not supported");
    }

    public void visit(ExistsExpression existsExpression) {
        throw new UnsupportedOperationException("visit(ExistsExpression) not supported");
    }

    public void visit(MemberOfExpression memberOfExpression) {
        throw new UnsupportedOperationException("visit(MemberOfExpression) not supported");
    }

    public void visit(AnyComparisonExpression anyComparisonExpression) {
        throw new UnsupportedOperationException("visit(AnyComparisonExpression) not supported");
    }

    public void visit(Concat concat) {
        throw new UnsupportedOperationException("visit(Concat) not supported");
    }

    public void visit(Matches matches) {
        throw new UnsupportedOperationException("visit(Matches) not supported");
    }

    public void visit(BitwiseAnd bitwiseAnd) {
        throw new UnsupportedOperationException("visit(BitwiseAnd) not supported");
    }

    public void visit(BitwiseOr bitwiseOr) {
        throw new UnsupportedOperationException("visit(BitwiseOr) not supported");
    }

    public void visit(BitwiseXor bitwiseXor) {
        throw new UnsupportedOperationException("visit(BitwiseXor) not supported");
    }

    public void visit(CastExpression castExpression) {
        throw new UnsupportedOperationException("visit(CastExpression) not supported");
    }

    public void visit(Modulo modulo) {
        throw new UnsupportedOperationException("visit(Modulo) not supported");
    }

    public void visit(AnalyticExpression analyticExpression) {
        throw new UnsupportedOperationException("visit(AnalyticExpression) not supported");
    }

    public void visit(ExtractExpression extractExpression) {
        throw new UnsupportedOperationException("visit(ExtractExpression) not supported");
    }

    public void visit(IntervalExpression intervalExpression) {
        throw new UnsupportedOperationException("visit(IntervalExpression) not supported");
    }

    public void visit(OracleHierarchicalExpression oracleHierarchicalExpression) {
        throw new UnsupportedOperationException("visit(OracleHierarchicalExpression) not supported");
    }

    public void visit(RegExpMatchOperator regExpMatchOperator) {
        throw new UnsupportedOperationException("visit(RegExpMatchOperator) not supported");
    }

    public void visit(JsonExpression jsonExpression) {
        throw new UnsupportedOperationException("visit(JsonExpression) not supported");
    }

    public void visit(JsonOperator jsonOperator) {
        throw new UnsupportedOperationException("visit(JsonOperator) not supported");
    }

    public void visit(UserVariable userVariable) {
        throw new UnsupportedOperationException("visit(UserVariable) not supported");
    }

    public void visit(NumericBind numericBind) {
        throw new UnsupportedOperationException("visit(NumericBind) not supported");
    }

    public void visit(KeepExpression keepExpression) {
        throw new UnsupportedOperationException("visit(KeepExpression) not supported");
    }

    public void visit(MySQLGroupConcat mySQLGroupConcat) {
        throw new UnsupportedOperationException("visit(MySQLGroupConcat) not supported");
    }

    public void visit(ExpressionList<?> expressionList) {
        throw new UnsupportedOperationException("visit(ExpressionList) not supported");
    }

    public void visit(RowConstructor<?> rowConstructor) {
        throw new UnsupportedOperationException("visit(RowConstructor) not supported");
    }

    public void visit(RowGetExpression rowGetExpression) {
        throw new UnsupportedOperationException("visit(RowGetExpression) not supported");
    }

    public void visit(OracleHint oracleHint) {
        throw new UnsupportedOperationException("visit(OracleHint) not supported");
    }

    public void visit(TimeKeyExpression timeKeyExpression) {
        throw new UnsupportedOperationException("visit(TimeKeyExpression) not supported");
    }

    public void visit(DateTimeLiteralExpression dateTimeLiteralExpression) {
        throw new UnsupportedOperationException("visit(DateTimeLiteralExpression) not supported");
    }

    public void visit(NotExpression notExpression) {
        throw new UnsupportedOperationException("visit(NotExpression) not supported");
    }

    public void visit(NextValExpression nextValExpression) {
        throw new UnsupportedOperationException("visit(NextValExpression) not supported");
    }

    public void visit(CollateExpression collateExpression) {
        throw new UnsupportedOperationException("visit(CollateExpression) not supported");
    }

    public void visit(SimilarToExpression similarToExpression) {
        throw new UnsupportedOperationException("visit(SimilarToExpression) not supported");
    }

    public void visit(ArrayExpression arrayExpression) {
        throw new UnsupportedOperationException("visit(ArrayExpression) not supported");
    }

    public void visit(ArrayConstructor arrayConstructor) {
        throw new UnsupportedOperationException("visit(ArrayConstructor) not supported");
    }

    public void visit(VariableAssignment variableAssignment) {
        throw new UnsupportedOperationException("visit(VariableAssignment) not supported");
    }

    public void visit(XMLSerializeExpr xmlSerializeExpr) {
        throw new UnsupportedOperationException("visit(XMLSerializeExpr) not supported");
    }

    public void visit(TimezoneExpression timezoneExpression) {
        throw new UnsupportedOperationException("visit(TimezoneExpression) not supported");
    }

    public void visit(JsonAggregateFunction jsonAggregateFunction) {
        throw new UnsupportedOperationException("visit(JsonAggregateFunction) not supported");
    }

    public void visit(JsonFunction jsonFunction) {
        throw new UnsupportedOperationException("visit(JsonFunction) not supported");
    }

    public void visit(ConnectByRootOperator connectByRootOperator) {
        throw new UnsupportedOperationException("visit(ConnectByRootOperator) not supported");
    }

    public void visit(OracleNamedFunctionParameter oracleNamedFunctionParameter) {
        throw new UnsupportedOperationException("visit(OracleNamedFunctionParameter) not supported");
    }

    public void visit(AllColumns allColumns) {
        throw new UnsupportedOperationException("visit(AllColumns) not supported");
    }

    public void visit(AllTableColumns allTableColumns) {
        throw new UnsupportedOperationException("visit(AllTableColumns) not supported");
    }

    public void visit(AllValue allValue) {
        throw new UnsupportedOperationException("visit(AllValue) not supported");
    }

    public void visit(IsDistinctExpression isDistinctExpression) {
        throw new UnsupportedOperationException("visit(IsDistinctExpression) not supported");
    }

    public void visit(GeometryDistance geometryDistance) {
        throw new UnsupportedOperationException("visit(GeometryDistance) not supported");
    }

    public void visit(Select select) {
        throw new UnsupportedOperationException("visit(Select) not supported");
    }

    public void visit(TranscodingFunction transcodingFunction) {
        throw new UnsupportedOperationException("visit(TranscodingFunction) not supported");
    }

    public void visit(TrimFunction trimFunction) {
        throw new UnsupportedOperationException("visit(TrimFunction) not supported");
    }

    public void visit(RangeExpression rangeExpression) {
        throw new UnsupportedOperationException("visit(RangeExpression) not supported");
    }

    public void visit(TSQLLeftJoin tsqlLeftJoin) {
        throw new UnsupportedOperationException("visit(TSQLLeftJoin) not supported");
    }

    public void visit(TSQLRightJoin tsqlRightJoin) {
        throw new UnsupportedOperationException("visit(TSQLRightJoin) not supported");
    }

    public void visit(StringValue stringValue) {
        throw new UnsupportedOperationException("visit(StringValue) not supported");
    }

    public void visit(Addition addition) {
        throw new UnsupportedOperationException("visit(Addition) not supported");
    }

    public void visit(Division division) {
        throw new UnsupportedOperationException("visit(Division) not supported");
    }
}

