/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.evomaster.client.java.sql.heuristic.ConversionHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ConversionHelperTest {
    public static final LocalDate UNIX_EPOCH_LOCAL_DATE = LocalDate.of(1970, 1, 1);

    ConversionHelperTest() {
    }

    @Test
    public void testNull() {
        Object input = null;
        Instant result = ConversionHelper.convertToInstant(input);
        Assertions.assertNull((Object)result, (String)"Result should be null when input is null");
    }

    @Test
    public void testSQLTime() {
        LocalTime localTime = LocalTime.of(10, 30, 45, 123456789);
        Time sqlTime = Time.valueOf(localTime);
        LocalDateTime localDateTime = LocalDateTime.of(UNIX_EPOCH_LOCAL_DATE, sqlTime.toLocalTime());
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        Instant expected = zonedDateTime.toInstant();
        Instant result = ConversionHelper.convertToInstant((Object)sqlTime);
        Assertions.assertEquals((int)0, (int)sqlTime.toLocalTime().getNano());
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Result should match the Instant derived from the SQL Time input");
    }

    @Test
    public void testDate() {
        Date date = new Date();
        Instant expected = date.toInstant();
        Instant result = ConversionHelper.convertToInstant((Object)date);
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Result should match the Instant derived from the java.util.Date input");
    }

    @Test
    public void testOffsetDateTime() {
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        Instant expected = offsetDateTime.toInstant();
        Instant result = ConversionHelper.convertToInstant((Object)offsetDateTime);
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Result should match the Instant derived from the OffsetDateTime input");
    }

    @Test
    public void testString() {
        String dateTimeString = "2023-01-01T10:30:45Z";
        Instant expected = Instant.parse(dateTimeString);
        Instant result = ConversionHelper.convertToInstant((Object)dateTimeString);
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Result should match the Instant parsed from the String input");
    }

    @Test
    public void testInvalidInput() {
        Integer invalidInput = 12345;
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ConversionHelper.convertToInstant((Object)invalidInput));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Argument must be date, local date time or string"), (String)"Exception message should mention the invalid argument type");
    }

    @Test
    public void testSameOutcome() {
        String timeAsString = "12:30:45";
        Time time = Time.valueOf(timeAsString);
        Instant instantFromTime = ConversionHelper.convertToInstant((Object)time);
        Instant instantFromString = ConversionHelper.convertToInstant((Object)timeAsString);
        Assertions.assertEquals((Object)instantFromTime, (Object)instantFromString);
    }

    @Test
    public void convertPositiveYearToInstant() throws ParseException {
        Long year = 2023L;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Instant expected = sdf.parse("2023-01-01").toInstant();
        Instant actual = ConversionHelper.convertToInstant((Object)year);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void convertNegativeYearLongToInstant() throws ParseException {
        Long invalidYear = -1L;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Instant expected = sdf.parse("-1-01-01").toInstant();
        Instant actual = ConversionHelper.convertToInstant((Object)invalidYear);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

