/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.Map;
import java.util.Set;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.sql.internal.ColumnTableAnalyzer;
import org.evomaster.client.java.sql.internal.SqlColumnId;
import org.evomaster.client.java.sql.internal.SqlTableId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ColumnTableAnalyzerTest {
    @Test
    public void testInsertWithQualifier() {
        String sql = "insert into Bar.Foo (x) values (42)";
        Map.Entry data = ColumnTableAnalyzer.getInsertedDataFields((String)sql);
        Assertions.assertEquals((Object)new SqlTableId("Bar.Foo"), data.getKey());
    }

    @Test
    public void testInsertInSimpleTable() {
        String sql = "insert into Foo (x) values (42)";
        Map.Entry data = ColumnTableAnalyzer.getInsertedDataFields((String)sql);
        Assertions.assertEquals((Object)new SqlTableId("Foo"), data.getKey());
    }

    @Test
    public void testUpdateInSimpleTable() {
        String sql = "update Foo set x=42";
        Map.Entry data = ColumnTableAnalyzer.getUpdatedDataFields((String)sql);
        Assertions.assertEquals((Object)new SqlTableId("Foo"), data.getKey());
    }

    @Test
    public void testDeleteSimpleTable() {
        String sql = "delete from Foo";
        DbInfoDto schema = new DbInfoDto();
        TableDto fooTableDto = new TableDto();
        fooTableDto.name = "Foo";
        schema.tables.add(fooTableDto);
        SqlTableId deletedTableId = ColumnTableAnalyzer.getDeletedTable((String)sql);
        Assertions.assertNotNull((Object)deletedTableId);
        Assertions.assertEquals((Object)new SqlTableId("Foo"), (Object)deletedTableId);
    }

    @Test
    public void testDeleteWithQualifier() {
        String sql = "delete from v1.Foo";
        DbInfoDto schema = new DbInfoDto();
        TableDto tableDto = new TableDto();
        tableDto.name = "v1.Foo";
        schema.tables.add(tableDto);
        SqlTableId deletedTableId = ColumnTableAnalyzer.getDeletedTable((String)sql);
        Assertions.assertNotNull((Object)deletedTableId);
        Assertions.assertEquals((Object)new SqlTableId("v1.Foo"), (Object)deletedTableId);
    }

    @Test
    public void testSelectReadAllFromSingleTable() {
        String select = "SELECT * FROM Foo";
        Map data = ColumnTableAnalyzer.getSelectReadDataFields((String)select);
        Assertions.assertEquals((int)1, (int)data.size());
        Set columns = (Set)data.get(new SqlTableId("Foo"));
        Assertions.assertEquals((int)1, (int)columns.size());
        Assertions.assertTrue((boolean)columns.contains(new SqlColumnId("*")));
    }

    @Test
    public void testSelectReadFromJoinedTables() {
        String select = "SELECT Orders.OrderID, Customers.CustomerName, Orders.OrderDate FROM Orders  INNER JOIN Customers ON Orders.CustomerID=Customers.CustomerID;";
        Map data = ColumnTableAnalyzer.getSelectReadDataFields((String)select);
        Assertions.assertEquals((int)2, (int)data.size());
        Set ordersColumns = (Set)data.get(new SqlTableId("Orders"));
        Assertions.assertEquals((int)1, (int)ordersColumns.size());
        Assertions.assertTrue((boolean)ordersColumns.contains(new SqlColumnId("*")));
        Set customersColumns = (Set)data.get(new SqlTableId("Customers"));
        Assertions.assertEquals((int)1, (int)customersColumns.size());
        Assertions.assertTrue((boolean)customersColumns.contains(new SqlColumnId("*")));
    }
}

