/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import org.evomaster.client.java.controller.api.dto.database.execution.SqlExecutionLogDto;
import org.evomaster.client.java.controller.api.dto.database.schema.ColumnDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.sql.dsl.SqlDsl;
import org.evomaster.client.java.sql.internal.SqlCommandWithDistance;
import org.evomaster.client.java.sql.internal.SqlHandler;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import org.evomaster.client.java.sql.internal.TaintHandler;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class SqlHandlerTest {
    @Test
    public void testPatioIssue() throws Exception {
        String select = "SELECT v.* FROM voting v, groups g WHERE v.expired = false AND '2021-04-28T16:02:27.426+0200' >= v.created_at + g.voting_duration * INTERVAL '1 hour' AND v.group_id = g.id";
        Statement stmt = CCJSqlParserUtil.parse((String)select);
        Map columnsInvolvedInWhere = new SqlHandler(null).extractColumnsInvolvedInWhere(stmt);
        Assertions.assertTrue((boolean)columnsInvolvedInWhere.values().stream().flatMap(s -> s.stream()).noneMatch(c -> c.getColumnId().equals("false")));
    }

    @Test
    public void testBooleans() throws Exception {
        String select = "SELECT f.* FROM Foo WHERE f.a = TRUE AND f.b = On AND f.c = false AND f.d = f";
        Statement stmt = CCJSqlParserUtil.parse((String)select);
        Map columns = new SqlHandler(null).extractColumnsInvolvedInWhere(stmt);
        Assertions.assertTrue((boolean)columns.isEmpty());
    }

    @Test
    public void testCreateCachedLocalTemporaryTable() {
        String createSql = "create cached local temporary table if not exists HT_feature_constraint (id bigint not null) on commit drop transactional";
        boolean canParseSqlStatement = SqlParserUtils.canParseSqlStatement((String)createSql);
        Assertions.assertFalse((boolean)canParseSqlStatement);
    }

    @Test
    public void testNoWhere() throws Exception {
        String select = "SELECT * FROM Table v";
        Statement stmt = CCJSqlParserUtil.parse((String)select);
        Map columns = new SqlHandler(null).extractColumnsInvolvedInWhere(stmt);
        Assertions.assertTrue((boolean)columns.isEmpty());
    }

    @Test
    public void testNoFromNoWhere() throws Exception {
        String select = "SELECT 1";
        Statement stmt = CCJSqlParserUtil.parse((String)select);
        Map columns = new SqlHandler(null).extractColumnsInvolvedInWhere(stmt);
        Assertions.assertTrue((boolean)columns.isEmpty());
    }

    @Test
    public void testWhereButNoColumns() throws Exception {
        String select = "SELECT * FROM table WHERE 1 = 1";
        Statement stmt = CCJSqlParserUtil.parse((String)select);
        Map columns = new SqlHandler(null).extractColumnsInvolvedInWhere(stmt);
        Assertions.assertTrue((boolean)columns.isEmpty());
    }

    @Test
    public void testCompleteSqlDistancesInSimpleSelect() throws Exception {
        TaintHandler mockTaintHandler = (TaintHandler)Mockito.mock(TaintHandler.class);
        Connection mockConnection = SqlHandlerTest.createMockConnectionForSimpleSelect();
        DbInfoDto schema = SqlHandlerTest.createSchema();
        SqlHandler sqlHandler = new SqlHandler(mockTaintHandler);
        sqlHandler.setConnection(mockConnection);
        sqlHandler.setSchema(schema);
        sqlHandler.setCompleteSqlHeuristics(true);
        SqlExecutionLogDto sqlExecutionLogDto = new SqlExecutionLogDto();
        sqlExecutionLogDto.sqlCommand = "SELECT name, income FROM Employees WHERE income > 100";
        sqlExecutionLogDto.threwSqlExeception = false;
        sqlHandler.handle(sqlExecutionLogDto);
        List distances = sqlHandler.getSqlDistances(Collections.emptyList(), true);
        Assertions.assertNotNull((Object)distances);
        Assertions.assertFalse((boolean)distances.isEmpty());
        Assertions.assertEquals((int)1, (int)distances.size());
        Assertions.assertEquals((Object)"SELECT name, income FROM Employees WHERE income > 100", (Object)((SqlCommandWithDistance)distances.get((int)0)).sqlCommand);
    }

    @Test
    public void testCompleteSqlDistancesWithSimpleJoin() throws Exception {
        TaintHandler mockTaintHandler = (TaintHandler)Mockito.mock(TaintHandler.class);
        Connection mockConnection = SqlHandlerTest.createMockConnectionForSimpleJoin();
        DbInfoDto schema = SqlHandlerTest.createSchema();
        SqlHandler sqlHandler = new SqlHandler(mockTaintHandler);
        sqlHandler.setConnection(mockConnection);
        sqlHandler.setSchema(schema);
        sqlHandler.setCompleteSqlHeuristics(true);
        SqlExecutionLogDto sqlExecutionLogDto = new SqlExecutionLogDto();
        sqlExecutionLogDto.sqlCommand = "SELECT e.name, d.name FROM Employees e JOIN Departments d ON e.department_id = d.id WHERE e.income > 100";
        sqlExecutionLogDto.threwSqlExeception = false;
        sqlHandler.handle(sqlExecutionLogDto);
        List distances = sqlHandler.getSqlDistances(Collections.emptyList(), true);
        Assertions.assertNotNull((Object)distances);
        Assertions.assertFalse((boolean)distances.isEmpty());
        Assertions.assertEquals((int)1, (int)distances.size());
        Assertions.assertEquals((Object)"SELECT e.name, d.name FROM Employees e JOIN Departments d ON e.department_id = d.id WHERE e.income > 100", (Object)((SqlCommandWithDistance)distances.get((int)0)).sqlCommand);
    }

    private static ColumnDto createColumnDto(String tableName, String columnName, String typeName) {
        ColumnDto columnDto = new ColumnDto();
        columnDto.table = tableName;
        columnDto.name = columnName;
        columnDto.type = typeName;
        return columnDto;
    }

    @NotNull
    private static DbInfoDto createSchema() {
        TableDto employeesTable = new TableDto();
        employeesTable.name = "Employees";
        employeesTable.columns.add(SqlHandlerTest.createColumnDto("employees", "id", "INTEGER"));
        employeesTable.columns.add(SqlHandlerTest.createColumnDto("employees", "name", "VARCHAR"));
        employeesTable.columns.add(SqlHandlerTest.createColumnDto("employees", "income", "INTEGER"));
        employeesTable.columns.add(SqlHandlerTest.createColumnDto("employees", "department_id", "INTEGER"));
        TableDto departmentsTable = new TableDto();
        departmentsTable.name = "Departments";
        departmentsTable.columns.add(SqlHandlerTest.createColumnDto("departments", "id", "INTEGER"));
        departmentsTable.columns.add(SqlHandlerTest.createColumnDto("departments", "name", "VARCHAR"));
        departmentsTable.columns.add(SqlHandlerTest.createColumnDto("departments", "location_id", "INTEGER"));
        TableDto locationsTable = new TableDto();
        locationsTable.name = "Locations";
        locationsTable.columns.add(SqlHandlerTest.createColumnDto("locations", "id", "INTEGER"));
        locationsTable.columns.add(SqlHandlerTest.createColumnDto("locations", "city", "VARCHAR"));
        DbInfoDto schema = new DbInfoDto();
        schema.tables.add(employeesTable);
        schema.tables.add(departmentsTable);
        schema.tables.add(locationsTable);
        return schema;
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testCallNextValue(boolean isCompleteSqlHeuristics) {
        String sqlCommand = "CALL next value for hibernate_sequence";
        SqlHandler sqlHandler = new SqlHandler(null);
        sqlHandler.setCalculateHeuristics(true);
        sqlHandler.setCompleteSqlHeuristics(isCompleteSqlHeuristics);
        SqlExecutionLogDto sqlExecutionLogDto = new SqlExecutionLogDto();
        sqlExecutionLogDto.sqlCommand = sqlCommand;
        sqlExecutionLogDto.threwSqlExeception = false;
        sqlHandler.handle(sqlExecutionLogDto);
    }

    @NotNull
    private static Connection createMockConnectionForSimpleSelect() throws SQLException {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        ResultSet mockEmployeeResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        PreparedStatement mockPreparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ResultSetMetaData mockEmployeeMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)mockConnection.createStatement()).thenReturn((Object)mockPreparedStatement);
        Mockito.when((Object)mockPreparedStatement.getResultSet()).thenReturn((Object)mockEmployeeResultSet);
        Mockito.when((Object)mockEmployeeResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)mockEmployeeResultSet.getObject(1)).thenReturn((Object)"Alice", new Object[]{"Bob"});
        Mockito.when((Object)mockEmployeeResultSet.getObject(2)).thenReturn((Object)35, new Object[]{99});
        Mockito.when((Object)mockEmployeeResultSet.getMetaData()).thenReturn((Object)mockEmployeeMetaData);
        Mockito.when((Object)mockEmployeeMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)mockEmployeeMetaData.getColumnName(1)).thenReturn((Object)"name");
        Mockito.when((Object)mockEmployeeMetaData.getColumnName(2)).thenReturn((Object)"income");
        Mockito.when((Object)mockEmployeeMetaData.getTableName(1)).thenReturn((Object)"Employees");
        Mockito.when((Object)mockEmployeeMetaData.getTableName(2)).thenReturn((Object)"Employees");
        return mockConnection;
    }

    @NotNull
    private static Connection createMockConnectionForSimpleJoin() throws SQLException {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement mockPreparedStatementForDepartments = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        PreparedStatement mockPreparedStatementForEmployees = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ResultSet mockDepartmentsResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSet mockEmployeeResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData mockEmployeeMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        ResultSetMetaData mockDepartmentsMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)mockConnection.createStatement()).thenReturn((Object)mockPreparedStatementForDepartments, (Object[])new java.sql.Statement[]{mockPreparedStatementForEmployees});
        Mockito.when((Object)mockPreparedStatementForDepartments.getResultSet()).thenReturn((Object)mockDepartmentsResultSet);
        Mockito.when((Object)mockPreparedStatementForEmployees.getResultSet()).thenReturn((Object)mockEmployeeResultSet);
        Mockito.when((Object)mockDepartmentsResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)mockDepartmentsResultSet.getObject(1)).thenReturn((Object)1, new Object[]{2});
        Mockito.when((Object)mockDepartmentsResultSet.getObject(2)).thenReturn((Object)"Sales", new Object[]{"Marketing"});
        Mockito.when((Object)mockDepartmentsResultSet.getMetaData()).thenReturn((Object)mockDepartmentsMetaData);
        Mockito.when((Object)mockDepartmentsMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)mockDepartmentsMetaData.getColumnName(1)).thenReturn((Object)"id");
        Mockito.when((Object)mockDepartmentsMetaData.getColumnName(2)).thenReturn((Object)"name");
        Mockito.when((Object)mockDepartmentsMetaData.getTableName(1)).thenReturn((Object)"Departments");
        Mockito.when((Object)mockDepartmentsMetaData.getTableName(2)).thenReturn((Object)"Departments");
        Mockito.when((Object)mockEmployeeResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)mockEmployeeResultSet.getObject(1)).thenReturn((Object)1, new Object[]{2});
        Mockito.when((Object)mockEmployeeResultSet.getObject(2)).thenReturn((Object)35, new Object[]{99});
        Mockito.when((Object)mockEmployeeResultSet.getObject(3)).thenReturn((Object)"Alice", new Object[]{"Bob"});
        Mockito.when((Object)mockEmployeeResultSet.getMetaData()).thenReturn((Object)mockEmployeeMetaData);
        Mockito.when((Object)mockEmployeeMetaData.getColumnCount()).thenReturn((Object)3);
        Mockito.when((Object)mockEmployeeMetaData.getColumnName(1)).thenReturn((Object)"department_id");
        Mockito.when((Object)mockEmployeeMetaData.getColumnName(2)).thenReturn((Object)"income");
        Mockito.when((Object)mockEmployeeMetaData.getColumnName(3)).thenReturn((Object)"name");
        Mockito.when((Object)mockEmployeeMetaData.getTableName(1)).thenReturn((Object)"Employees");
        Mockito.when((Object)mockEmployeeMetaData.getTableName(2)).thenReturn((Object)"Employees");
        Mockito.when((Object)mockEmployeeMetaData.getTableName(3)).thenReturn((Object)"Employees");
        return mockConnection;
    }

    @Test
    public void testGetSqlDistancesNotQueryingFromDatabase() {
        SqlHandler sqlHandler = new SqlHandler(null);
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DbInfoDto schema = SqlHandlerTest.createSchema();
        sqlHandler.setSchema(schema);
        sqlHandler.setCompleteSqlHeuristics(true);
        sqlHandler.setConnection(mockConnection);
        SqlExecutionLogDto sqlExecutionLogDto = new SqlExecutionLogDto();
        sqlExecutionLogDto.sqlCommand = "SELECT e.name, d.name FROM Employees e JOIN Departments d ON e.department_id = d.id WHERE e.income > 100";
        sqlExecutionLogDto.threwSqlExeception = false;
        sqlHandler.handle(sqlExecutionLogDto);
        List insertionDtos = SqlDsl.sql().insertInto("employees", Long.valueOf(1L)).d("id", "1").d("name", "John").d("income", "50000").d("department_id", "2").and().insertInto("employees", Long.valueOf(2L)).d("id", "2").d("name", "Jack").d("income", "40000").d("department_id", "2").and().insertInto("departments", Long.valueOf(3L)).d("id", "2").d("name", "Sales").d("location_id", null).dtos();
        boolean queryFromDatabase = false;
        List distances = sqlHandler.getSqlDistances(insertionDtos, false);
        Assertions.assertNotNull((Object)distances);
        Assertions.assertFalse((boolean)distances.isEmpty());
        Assertions.assertEquals((int)1, (int)distances.size());
        Assertions.assertEquals((Object)"SELECT e.name, d.name FROM Employees e JOIN Departments d ON e.department_id = d.id WHERE e.income > 100", (Object)((SqlCommandWithDistance)distances.get((int)0)).sqlCommand);
        Assertions.assertEquals((double)0.0, (double)((SqlCommandWithDistance)distances.get((int)0)).sqlDistanceWithMetrics.sqlDistance);
    }

    @Test
    public void testGetSqlDistancesNotQueryFromDatabaseUsingEmptyTables() {
        SqlHandler sqlHandler = new SqlHandler(null);
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DbInfoDto schema = SqlHandlerTest.createSchema();
        sqlHandler.setSchema(schema);
        sqlHandler.setCompleteSqlHeuristics(true);
        sqlHandler.setConnection(mockConnection);
        SqlExecutionLogDto sqlExecutionLogDto = new SqlExecutionLogDto();
        sqlExecutionLogDto.sqlCommand = "SELECT e.name, d.name FROM Employees e JOIN Departments d ON e.department_id = d.id WHERE e.income > 100";
        sqlExecutionLogDto.threwSqlExeception = false;
        sqlHandler.handle(sqlExecutionLogDto);
        List insertionDtos = SqlDsl.sql().insertInto("employees", Long.valueOf(1L)).d("id", "1").d("name", "John").d("income", "50000").d("department_id", "2").and().insertInto("employees", Long.valueOf(2L)).d("id", "2").d("name", "Jack").d("income", "40000").d("department_id", "2").dtos();
        boolean queryFromDatabase = false;
        List distances = sqlHandler.getSqlDistances(insertionDtos, false);
        Assertions.assertNotNull((Object)distances);
        Assertions.assertFalse((boolean)distances.isEmpty());
        Assertions.assertEquals((int)1, (int)distances.size());
        Assertions.assertEquals((Object)"SELECT e.name, d.name FROM Employees e JOIN Departments d ON e.department_id = d.id WHERE e.income > 100", (Object)((SqlCommandWithDistance)distances.get((int)0)).sqlCommand);
        Assertions.assertNotEquals((double)0.0, (double)((SqlCommandWithDistance)distances.get((int)0)).sqlDistanceWithMetrics.sqlDistance);
    }

    @Test
    public void testGetSqlDistancesNoInsertions() {
        SqlHandler sqlHandler = new SqlHandler(null);
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DbInfoDto schema = SqlHandlerTest.createSchema();
        sqlHandler.setSchema(schema);
        sqlHandler.setCompleteSqlHeuristics(true);
        sqlHandler.setConnection(mockConnection);
        SqlExecutionLogDto sqlExecutionLogDto = new SqlExecutionLogDto();
        sqlExecutionLogDto.sqlCommand = "SELECT e.name, d.name FROM Employees e JOIN Departments d ON e.department_id = d.id WHERE e.income > 100";
        sqlExecutionLogDto.threwSqlExeception = false;
        sqlHandler.handle(sqlExecutionLogDto);
        List insertionDtos = Collections.emptyList();
        boolean queryFromDatabase = false;
        List distances = sqlHandler.getSqlDistances(insertionDtos, false);
        Assertions.assertNotNull((Object)distances);
        Assertions.assertFalse((boolean)distances.isEmpty());
        Assertions.assertEquals((int)1, (int)distances.size());
        Assertions.assertEquals((Object)"SELECT e.name, d.name FROM Employees e JOIN Departments d ON e.department_id = d.id WHERE e.income > 100", (Object)((SqlCommandWithDistance)distances.get((int)0)).sqlCommand);
        Assertions.assertNotEquals((double)0.0, (double)((SqlCommandWithDistance)distances.get((int)0)).sqlDistanceWithMetrics.sqlDistance);
    }
}

