/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.evomaster.client.java.sql.internal.SqlColumnId;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import org.evomaster.client.java.sql.internal.SqlTableId;

public class ColumnTableAnalyzer {
    public static SqlTableId getDeletedTable(String delete) {
        if (!SqlParserUtils.isDelete(delete)) {
            throw new IllegalArgumentException("Input string is not a valid SQL DELETE: " + delete);
        }
        Delete stmt = (Delete)SqlParserUtils.parseSqlCommand(delete);
        Table table = stmt.getTable();
        if (table != null) {
            SqlTableId sqlTableId = new SqlTableId(table.getFullyQualifiedName());
            return sqlTableId;
        }
        throw new IllegalArgumentException("Cannot handle delete: " + delete);
    }

    public static Map.Entry<SqlTableId, Set<SqlColumnId>> getInsertedDataFields(String insert) {
        if (!SqlParserUtils.isInsert(insert)) {
            throw new IllegalArgumentException("Input string is not a valid SQL INSERT: " + insert);
        }
        Insert stmt = (Insert)SqlParserUtils.parseSqlCommand(insert);
        Table table = stmt.getTable();
        if (table != null) {
            AbstractMap.SimpleEntry<SqlTableId, Set<SqlColumnId>> insertedDataFields = new AbstractMap.SimpleEntry<SqlTableId, Set<SqlColumnId>>(new SqlTableId(table.getFullyQualifiedName()), Collections.singleton(new SqlColumnId("*")));
            return insertedDataFields;
        }
        throw new IllegalArgumentException("Cannot handle insert: " + insert);
    }

    public static Map.Entry<SqlTableId, Set<SqlColumnId>> getUpdatedDataFields(String update) {
        if (!SqlParserUtils.isUpdate(update)) {
            throw new IllegalArgumentException("Input string is not a valid SQL INSERT: " + update);
        }
        Update stmt = (Update)SqlParserUtils.parseSqlCommand(update);
        Table table = stmt.getTable();
        if (table != null) {
            AbstractMap.SimpleEntry<SqlTableId, Set<SqlColumnId>> updatedDataFields = new AbstractMap.SimpleEntry<SqlTableId, Set<SqlColumnId>>(new SqlTableId(table.getFullyQualifiedName()), Collections.singleton(new SqlColumnId("*")));
            return updatedDataFields;
        }
        throw new IllegalArgumentException("Cannot handle update: " + update);
    }

    public static Map<SqlTableId, Set<SqlColumnId>> getSelectReadDataFields(String select) {
        if (!SqlParserUtils.isSelect(select)) {
            throw new IllegalArgumentException("Input string is not a valid SQL SELECT: " + select);
        }
        HashMap<SqlTableId, Set<SqlColumnId>> map = new HashMap<SqlTableId, Set<SqlColumnId>>();
        Select stmt = (Select)SqlParserUtils.parseSqlCommand(select);
        PlainSelect plainSelect = stmt.getPlainSelect();
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem == null) {
            return map;
        }
        ColumnTableAnalyzer.extractUsedColumnsAndTables(map, fromItem);
        List joins = plainSelect.getJoins();
        if (joins != null) {
            for (Join join : joins) {
                FromItem rightItem = join.getRightItem();
                ColumnTableAnalyzer.extractUsedColumnsAndTables(map, rightItem);
            }
        }
        return map;
    }

    private static void handleTable(Map<SqlTableId, Set<SqlColumnId>> map, Table table) {
        Set columns = map.computeIfAbsent(new SqlTableId(table.getFullyQualifiedName()), k -> new HashSet());
        if (!columns.contains("*")) {
            columns.add(new SqlColumnId("*"));
        }
    }

    private static void extractUsedColumnsAndTables(Map<SqlTableId, Set<SqlColumnId>> map, FromItem fromItem) {
        if (!(fromItem instanceof Table)) {
            throw new IllegalArgumentException("Cannot handle fromItem: " + fromItem.toString());
        }
        Table table = (Table)fromItem;
        ColumnTableAnalyzer.handleTable(map, table);
    }
}

