/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.evomaster.client.java.controller.api.dto.database.schema.DatabaseType;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.QueryResultTestBase;
import org.evomaster.client.java.sql.SqlScriptRunner;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.GenericContainer;

public class QueryResultMySQLTest
extends QueryResultTestBase {
    private static final String DB_NAME = "test";
    private static final int PORT = 3306;
    private static final String MYSQL_VERSION = "8.0.27";
    public static final GenericContainer mysql = new GenericContainer("mysql:8.0.27").withEnv((Map)new HashMap<String, String>(){
        {
            this.put("MYSQL_ROOT_PASSWORD", "root");
            this.put("MYSQL_DATABASE", QueryResultMySQLTest.DB_NAME);
            this.put("MYSQL_USER", QueryResultMySQLTest.DB_NAME);
            this.put("MYSQL_PASSWORD", QueryResultMySQLTest.DB_NAME);
        }
    }).withExposedPorts(new Integer[]{3306});
    private static Connection connection;

    @BeforeAll
    public static void initClass() throws Exception {
        mysql.start();
        String host = mysql.getContainerIpAddress();
        int port = mysql.getMappedPort(3306);
        String url = "jdbc:mysql://" + host + ":" + port + "/" + DB_NAME;
        connection = DriverManager.getConnection(url, DB_NAME, DB_NAME);
    }

    @AfterAll
    public static void afterClass() throws Exception {
        connection.close();
        mysql.stop();
    }

    @AfterEach
    public void afterTest() throws SQLException {
        SqlScriptRunner.execCommand((Connection)connection, (String)"DROP TABLE IF EXISTS example_table;");
    }

    @Override
    protected DatabaseType getDbType() {
        return DatabaseType.MYSQL;
    }

    @Override
    protected Connection getConnection() {
        return connection;
    }

    @Test
    public void testYearColumn() throws Exception {
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE example_table (\n    id INT PRIMARY KEY AUTO_INCREMENT,\n    year_column YEAR NOT NULL\n);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO example_table (year_column)\nVALUES (2022);\n");
        QueryResult queryResult = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM example_table");
        Assertions.assertEquals((int)1, (int)queryResult.seeRows().size());
        DataRow row = (DataRow)queryResult.seeRows().get(0);
        Object actual = row.getValueByName("year_column", "example_table");
        Assertions.assertTrue((boolean)(actual instanceof Date));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date expected = sdf.parse("2022-01-01");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

