/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.cleaner;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.database.schema.DatabaseType;
import org.evomaster.client.java.sql.DbCleaner;
import org.evomaster.client.java.sql.SqlScriptRunner;
import org.evomaster.client.java.sql.cleaner.DbCleanerTestBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public class DbCleanerH2Test
extends DbCleanerTestBase {
    private static Connection connection;

    @BeforeAll
    public static void initClass() throws Exception {
        connection = DriverManager.getConnection("jdbc:h2:mem:db_test", "sa", "");
    }

    @AfterAll
    public static void afterClass() throws Exception {
        connection.close();
    }

    @BeforeEach
    public void initTest() throws Exception {
        SqlScriptRunner.execCommand((Connection)connection, (String)"DROP ALL OBJECTS;");
    }

    @Override
    protected Connection getConnection() {
        return connection;
    }

    @Override
    protected void clearDatabase(List<String> tablesToSkip, List<String> tableToClean) {
        DbCleaner.clearDatabase_H2((Connection)connection, tablesToSkip, tableToClean);
    }

    @Override
    protected DatabaseType getDbType() {
        return DatabaseType.H2;
    }
}

