/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.cleaner;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evomaster.client.java.controller.api.dto.database.schema.DatabaseType;
import org.evomaster.client.java.sql.DbCleaner;
import org.evomaster.client.java.sql.cleaner.DbCleanerTestBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.testcontainers.containers.GenericContainer;

public class DbCleanerMariaDBTest
extends DbCleanerTestBase {
    private static final String DB_NAME = "test";
    private static final int PORT = 3306;
    public static final GenericContainer mariadb = new GenericContainer("mariadb:10.5.9").withEnv((Map)new HashMap<String, String>(){
        {
            this.put("MYSQL_ROOT_PASSWORD", "root");
            this.put("MYSQL_DATABASE", DbCleanerMariaDBTest.DB_NAME);
            this.put("MYSQL_USER", DbCleanerMariaDBTest.DB_NAME);
            this.put("MYSQL_PASSWORD", DbCleanerMariaDBTest.DB_NAME);
        }
    }).withExposedPorts(new Integer[]{3306});
    private static Connection connection;

    @BeforeAll
    public static void initClass() throws Exception {
        mariadb.start();
        String host = mariadb.getContainerIpAddress();
        int port = mariadb.getMappedPort(3306);
        String url = "jdbc:mariadb://" + host + ":" + port + "/" + DB_NAME;
        connection = DriverManager.getConnection(url, DB_NAME, DB_NAME);
    }

    @AfterAll
    public static void afterClass() throws Exception {
        connection.close();
        mariadb.stop();
    }

    @AfterEach
    public void afterTest() {
        DbCleaner.dropDatabaseTables((Connection)connection, (String)DB_NAME, null, (DatabaseType)this.getDbType());
    }

    @Override
    protected Connection getConnection() {
        return connection;
    }

    @Override
    protected void clearDatabase(List<String> tablesToSkip, List<String> tableToClean) {
        DbCleaner.clearDatabase((Connection)connection, (String)DB_NAME, tablesToSkip, tableToClean, (DatabaseType)this.getDbType(), (boolean)true);
    }

    @Override
    protected DatabaseType getDbType() {
        return DatabaseType.MARIADB;
    }
}

