/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.evomaster.client.java.controller.api.dto.database.schema.ColumnDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableIdDto;
import org.evomaster.client.java.sql.heuristic.SqlBaseTableReference;
import org.evomaster.client.java.sql.heuristic.SqlColumnReference;
import org.evomaster.client.java.sql.heuristic.SqlDerivedTableReference;
import org.evomaster.client.java.sql.heuristic.TableColumnResolver;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import org.evomaster.client.java.sql.internal.SqlTableId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TableColumnResolverTest {
    private DbInfoDto schema;
    private TableColumnResolver resolver;

    TableColumnResolverTest() {
    }

    @BeforeEach
    void setUp() {
        this.schema = new DbInfoDto();
        TableDto employeesTable = TableColumnResolverTest.createTableDto("employees");
        employeesTable.columns.add(TableColumnResolverTest.createColumnDto("employees", "id"));
        employeesTable.columns.add(TableColumnResolverTest.createColumnDto("employees", "first_name"));
        employeesTable.columns.add(TableColumnResolverTest.createColumnDto("employees", "department_id"));
        employeesTable.columns.add(TableColumnResolverTest.createColumnDto("employees", "salary"));
        TableDto departmentsTable = TableColumnResolverTest.createTableDto("departments");
        departmentsTable.columns.add(TableColumnResolverTest.createColumnDto("departments", "id"));
        departmentsTable.columns.add(TableColumnResolverTest.createColumnDto("departments", "department_name"));
        TableDto ordersTable = TableColumnResolverTest.createTableDto("orders");
        ordersTable.columns.add(TableColumnResolverTest.createColumnDto("orders", "order_id"));
        ordersTable.columns.add(TableColumnResolverTest.createColumnDto("orders", "order_date"));
        ordersTable.columns.add(TableColumnResolverTest.createColumnDto("orders", "customer_id"));
        TableDto customersTable = TableColumnResolverTest.createTableDto("customers");
        customersTable.columns.add(TableColumnResolverTest.createColumnDto("customers", "customer_id"));
        customersTable.columns.add(TableColumnResolverTest.createColumnDto("customers", "customer_name"));
        this.schema.tables.add(employeesTable);
        this.schema.tables.add(departmentsTable);
        this.schema.tables.add(ordersTable);
        this.schema.tables.add(customersTable);
        this.resolver = new TableColumnResolver(this.schema);
    }

    private static ColumnDto createColumnDto(String tableName, String columnName) {
        ColumnDto column = new ColumnDto();
        column.name = columnName;
        column.table = tableName;
        return column;
    }

    private static TableDto createTableDto(String tableName) {
        TableDto table = new TableDto();
        table.id = new TableIdDto();
        table.id.name = tableName;
        return table;
    }

    @Test
    void testResolveColumnWithExplicitTable() throws Exception {
        String sql = "SELECT e.first_name FROM employees e";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("first_name");
        column.setTable(new Table("e"));
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)reference.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"first_name", (Object)reference.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnWithoutExplicitTable() throws Exception {
        String sql = "SELECT first_name FROM employees";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("first_name");
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)reference.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"first_name", (Object)reference.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInJoin() throws Exception {
        String sql = "SELECT e.first_name, d.department_name FROM employees e JOIN departments d ON e.department_id = d.id";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column columnE = new Column();
        columnE.setColumnName("first_name");
        columnE.setTable(new Table("e"));
        SqlColumnReference referenceE = this.resolver.resolve(columnE);
        Assertions.assertNotNull((Object)referenceE);
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)referenceE.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"first_name", (Object)referenceE.getColumnName());
        Column columnD = new Column();
        columnD.setColumnName("department_name");
        columnD.setTable(new Table("d"));
        SqlColumnReference referenceD = this.resolver.resolve(columnD);
        Assertions.assertNotNull((Object)referenceD);
        Assertions.assertEquals((Object)new SqlTableId("departments"), (Object)((SqlBaseTableReference)referenceD.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"department_name", (Object)referenceD.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInSubquery() throws Exception {
        String sql = "SELECT e.first_name FROM (SELECT * FROM employees) e";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("first_name");
        column.setTable(new Table("e"));
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertTrue((boolean)(reference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"(SELECT * FROM employees) e", (Object)((SqlDerivedTableReference)reference.getTableReference()).getSelect().toString());
        Assertions.assertEquals((Object)"first_name", (Object)reference.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInNestedSubquery() throws Exception {
        String sql = "SELECT subquery1.first_name FROM (SELECT first_name FROM (SELECT * FROM employees) subquery2) subquery1";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("first_name");
        column.setTable(new Table("subquery1"));
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertTrue((boolean)(reference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"first_name", (Object)reference.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInWithClause() throws Exception {
        String sql = "WITH subquery AS (SELECT id, first_name FROM employees) SELECT subquery.first_name FROM subquery";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("first_name");
        column.setTable(new Table("subquery"));
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertTrue((boolean)(reference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"first_name", (Object)reference.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveAmbiguousColumnInJoin() throws Exception {
        String sql = "SELECT id FROM employees e JOIN departments d ON e.department_id = d.id";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("id");
        SqlColumnReference sqlColumnReference = this.resolver.resolve(column);
        Assertions.assertEquals((Object)"id", (Object)sqlColumnReference.getColumnName());
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)sqlColumnReference.getTableReference()).getTableId());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInUnion() throws Exception {
        String sql = "SELECT id FROM employees UNION SELECT id FROM departments";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("id");
        SqlColumnReference sqlColumnReference = this.resolver.resolve(column);
        Assertions.assertEquals((Object)"id", (Object)sqlColumnReference.getColumnName());
        Assertions.assertEquals((Object)"SELECT id FROM employees UNION SELECT id FROM departments", (Object)((SqlDerivedTableReference)sqlColumnReference.getTableReference()).getSelect().toString());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInComplexJoinWithSubquery() throws Exception {
        String sql = "SELECT e.first_name, subquery.department_name FROM employees e JOIN (SELECT id, department_name FROM departments) subquery ON e.department_id = subquery.id";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column columnE = new Column();
        columnE.setColumnName("first_name");
        columnE.setTable(new Table("e"));
        SqlColumnReference referenceE = this.resolver.resolve(columnE);
        Assertions.assertNotNull((Object)referenceE);
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)referenceE.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"first_name", (Object)referenceE.getColumnName());
        Column columnSubquery = new Column();
        columnSubquery.setColumnName("department_name");
        columnSubquery.setTable(new Table("subquery"));
        SqlColumnReference referenceSubquery = this.resolver.resolve(columnSubquery);
        Assertions.assertNotNull((Object)referenceSubquery);
        Assertions.assertTrue((boolean)(referenceSubquery.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"department_name", (Object)referenceSubquery.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveAmbiguousColumnInRightJoin() throws Exception {
        String sql = "SELECT department_name FROM employees e JOIN departments d ON e.department_id = d.id";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("department_name");
        SqlColumnReference sqlColumnReference = this.resolver.resolve(column);
        Assertions.assertEquals((Object)"department_name", (Object)sqlColumnReference.getColumnName());
        Assertions.assertEquals((Object)new SqlTableId("departments"), (Object)((SqlBaseTableReference)sqlColumnReference.getTableReference()).getTableId());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveMissingColumn() throws Exception {
        String sql = "SELECT department_address FROM departments";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("department_address");
        Assertions.assertEquals(null, (Object)this.resolver.resolve(column));
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnFromSubquery() throws Exception {
        String sql = "SELECT first_name FROM (SELECT first_name FROM employees)";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("first_name");
        SqlColumnReference sqlColumnReference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)sqlColumnReference);
        Assertions.assertTrue((boolean)(sqlColumnReference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"first_name", (Object)sqlColumnReference.getColumnName());
        Assertions.assertEquals((Object)"(SELECT first_name FROM employees)", (Object)((SqlDerivedTableReference)sqlColumnReference.getTableReference()).getSelect().toString());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInJoinWithSubquery() throws Exception {
        String sql = "SELECT employee_id, department_name FROM (     SELECT id AS employee_id, department_id     FROM employees     WHERE salary > 50000 ) e INNER JOIN departments d ON e.department_id = d.department_id";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column columnEmployeeId = new Column();
        columnEmployeeId.setColumnName("employee_id");
        SqlColumnReference referenceEmployeeId = this.resolver.resolve(columnEmployeeId);
        Assertions.assertNotNull((Object)referenceEmployeeId);
        Assertions.assertTrue((boolean)(referenceEmployeeId.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"employee_id", (Object)referenceEmployeeId.getColumnName());
        Assertions.assertEquals((Object)"(SELECT id AS employee_id, department_id FROM employees WHERE salary > 50000) e", (Object)((SqlDerivedTableReference)referenceEmployeeId.getTableReference()).getSelect().toString());
        Column columnDepartmentName = new Column();
        columnDepartmentName.setColumnName("department_name");
        SqlColumnReference referenceDepartmentName = this.resolver.resolve(columnDepartmentName);
        Assertions.assertNotNull((Object)referenceDepartmentName);
        Assertions.assertEquals((Object)new SqlTableId("departments"), (Object)((SqlBaseTableReference)referenceDepartmentName.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"department_name", (Object)referenceDepartmentName.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInSubqueryWithNoAlias() throws Exception {
        String sql = "SELECT first_name FROM (SELECT * FROM employees)";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("first_name");
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertTrue((boolean)(reference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"first_name", (Object)reference.getColumnName());
        Assertions.assertEquals((Object)"(SELECT * FROM employees)", (Object)((SqlDerivedTableReference)reference.getTableReference()).getSelect().toString());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void resolveColumnAliasInSubqueryWithWhereClause() throws Exception {
        String sql = "SELECT name, income FROM (SELECT first_name AS name, salary AS income FROM Employees) AS subquery WHERE income > 100";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column columnName = new Column();
        columnName.setColumnName("name");
        columnName.setTable(new Table("subquery"));
        SqlColumnReference referenceName = this.resolver.resolve(columnName);
        Assertions.assertNotNull((Object)referenceName);
        Assertions.assertTrue((boolean)(referenceName.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"name", (Object)referenceName.getColumnName());
        Assertions.assertEquals((Object)"(SELECT first_name AS name, salary AS income FROM Employees) AS subquery", (Object)((SqlDerivedTableReference)referenceName.getTableReference()).getSelect().toString());
        Column columnIncome = new Column();
        columnIncome.setColumnName("income");
        columnIncome.setTable(new Table("subquery"));
        SqlColumnReference referenceIncome = this.resolver.resolve(columnIncome);
        Assertions.assertNotNull((Object)referenceIncome);
        Assertions.assertTrue((boolean)(referenceIncome.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"income", (Object)referenceIncome.getColumnName());
        Assertions.assertEquals((Object)"(SELECT first_name AS name, salary AS income FROM Employees) AS subquery", (Object)((SqlDerivedTableReference)referenceIncome.getTableReference()).getSelect().toString());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveAllTableColumns() throws Exception {
        String sql = "SELECT first_name  FROM (SELECT employees.* FROM employees) AS e";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("first_name");
        column.setTable(new Table("e"));
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertEquals((Object)"(SELECT employees.* FROM employees) AS e", (Object)((SqlDerivedTableReference)reference.getTableReference()).getSelect().toString());
        Assertions.assertEquals((Object)"first_name", (Object)reference.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnWithAlias() throws Exception {
        String sql = "SELECT e.first_name AS fname FROM employees e";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("fname");
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)reference.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"first_name", (Object)reference.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnAliasInSubquery() throws Exception {
        String sql = "SELECT subquery.fname FROM (SELECT first_name AS fname FROM employees) subquery";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("fname");
        column.setTable(new Table("subquery"));
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertTrue((boolean)(reference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"fname", (Object)reference.getColumnName());
        Assertions.assertEquals((Object)"(SELECT first_name AS fname FROM employees) subquery", (Object)((SqlDerivedTableReference)reference.getTableReference()).getSelect().toString());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnAliasInJoin() throws Exception {
        String sql = "SELECT e.fname, d.department_name FROM (SELECT first_name AS fname FROM employees) e JOIN departments d ON e.department_id = d.id";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column columnE = new Column();
        columnE.setColumnName("fname");
        columnE.setTable(new Table("e"));
        SqlColumnReference referenceE = this.resolver.resolve(columnE);
        Assertions.assertNotNull((Object)referenceE);
        Assertions.assertTrue((boolean)(referenceE.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"fname", (Object)referenceE.getColumnName());
        Column columnD = new Column();
        columnD.setColumnName("department_name");
        columnD.setTable(new Table("d"));
        SqlColumnReference referenceD = this.resolver.resolve(columnD);
        Assertions.assertNotNull((Object)referenceD);
        Assertions.assertEquals((Object)new SqlTableId("departments"), (Object)((SqlBaseTableReference)referenceD.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"department_name", (Object)referenceD.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testColumnInParenthesizedSelect() throws Exception {
        String sql = "SELECT first_name FROM ((SELECT first_name FROM employees))";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("first_name");
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertTrue((boolean)(reference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"first_name", (Object)reference.getColumnName());
        Assertions.assertEquals((Object)"(SELECT first_name FROM employees)", (Object)((SqlDerivedTableReference)reference.getTableReference()).getSelect().toString());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testColumnInNestedParenthesizedSelect() throws Exception {
        String sql = "SELECT first_name FROM (((SELECT first_name FROM employees)))";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("first_name");
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertTrue((boolean)(reference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"first_name", (Object)reference.getColumnName());
        Assertions.assertEquals((Object)"(SELECT first_name FROM employees)", (Object)((SqlDerivedTableReference)reference.getTableReference()).getSelect().toString());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testColumnInSetOperationListWithAlias() throws Exception {
        String sql = "SELECT id AS emp_id FROM employees UNION SELECT id AS dept_id FROM departments";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("emp_id");
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertTrue((boolean)(reference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"emp_id", (Object)reference.getColumnName());
        Assertions.assertEquals((Object)"SELECT id AS emp_id FROM employees UNION SELECT id AS dept_id FROM departments", (Object)((SqlDerivedTableReference)reference.getTableReference()).getSelect().toString());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInDeleteStatement() throws Exception {
        String sql = "DELETE FROM employees WHERE department_id = 1";
        Delete delete = (Delete)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)delete);
        Column column = new Column();
        column.setColumnName("department_id");
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)reference.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"department_id", (Object)reference.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInUpdateStatement() throws Exception {
        String sql = "UPDATE employees SET salary = 50000 WHERE department_id = 1";
        Update update = (Update)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)update);
        Column setColumn = new Column();
        setColumn.setColumnName("salary");
        SqlColumnReference setReference = this.resolver.resolve(setColumn);
        Assertions.assertNotNull((Object)setReference);
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)setReference.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"salary", (Object)setReference.getColumnName());
        Column whereColumn = new Column();
        whereColumn.setColumnName("department_id");
        SqlColumnReference whereReference = this.resolver.resolve(whereColumn);
        Assertions.assertNotNull((Object)whereReference);
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)whereReference.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"department_id", (Object)whereReference.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInDeleteWithSubquery() throws Exception {
        String sql = "DELETE FROM employees WHERE department_id IN (SELECT d.id AS dept_id FROM departments d WHERE d.department_name = 'HR')";
        Delete delete = (Delete)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)delete);
        Column column = new Column();
        column.setColumnName("department_id");
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)reference.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"department_id", (Object)reference.getColumnName());
        Column d_dept_id_column = new Column();
        d_dept_id_column.setColumnName("dept_id");
        d_dept_id_column.setTable(new Table("d"));
        Assertions.assertNull((Object)this.resolver.resolve(d_dept_id_column));
        InExpression inExpression = (InExpression)delete.getWhere();
        Select subquery = (Select)inExpression.getRightExpression();
        this.resolver.enterStatementeContext((Statement)subquery);
        Assertions.assertNull((Object)this.resolver.resolve(d_dept_id_column));
        Column d_id_column = new Column();
        d_id_column.setColumnName("id");
        d_id_column.setTable(new Table("d"));
        SqlColumnReference subqueryReference = this.resolver.resolve(d_id_column);
        Assertions.assertNotNull((Object)subqueryReference);
        Assertions.assertEquals((Object)new SqlTableId("departments"), (Object)((SqlBaseTableReference)subqueryReference.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"id", (Object)subqueryReference.getColumnName());
        this.resolver.exitCurrentStatementContext();
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnsInInnerJoin() throws Exception {
        String sql = "SELECT orders.order_id, customers.customer_name, orders.order_date FROM orders INNER JOIN customers ON orders.customer_id = customers.customer_id";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column orderIdColumn = new Column();
        orderIdColumn.setColumnName("order_id");
        orderIdColumn.setTable(new Table("orders"));
        SqlColumnReference orderIdReference = this.resolver.resolve(orderIdColumn);
        Assertions.assertNotNull((Object)orderIdReference);
        Assertions.assertEquals((Object)new SqlTableId("orders"), (Object)((SqlBaseTableReference)orderIdReference.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"order_id", (Object)orderIdReference.getColumnName());
        Column customerNameColumn = new Column();
        customerNameColumn.setColumnName("customer_name");
        customerNameColumn.setTable(new Table("customers"));
        SqlColumnReference customerNameReference = this.resolver.resolve(customerNameColumn);
        Assertions.assertNotNull((Object)customerNameReference);
        Assertions.assertEquals((Object)new SqlTableId("customers"), (Object)((SqlBaseTableReference)customerNameReference.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"customer_name", (Object)customerNameReference.getColumnName());
        Column orderDateColumn = new Column();
        orderDateColumn.setColumnName("order_date");
        orderDateColumn.setTable(new Table("orders"));
        SqlColumnReference orderDateReference = this.resolver.resolve(orderDateColumn);
        Assertions.assertNotNull((Object)orderDateReference);
        Assertions.assertEquals((Object)new SqlTableId("orders"), (Object)((SqlBaseTableReference)orderDateReference.getTableReference()).getTableId());
        Assertions.assertEquals((Object)"order_date", (Object)orderDateReference.getColumnName());
        Column customerIdColumn = new Column();
        customerIdColumn.setColumnName("customer_id");
        customerIdColumn.setTable(new Table("customers"));
        SqlColumnReference customerIdReference = this.resolver.resolve(customerIdColumn);
        Assertions.assertNotNull((Object)customerIdReference);
        Assertions.assertEquals((Object)"customer_id", (Object)customerIdReference.getColumnName());
        Assertions.assertEquals((Object)new SqlTableId("customers"), (Object)((SqlBaseTableReference)customerIdReference.getTableReference()).getTableId());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInSubqueryWithAlias() throws Exception {
        String sql = "SELECT sub.dept_id FROM (     SELECT d.id AS dept_id     FROM departments d     WHERE d.department_name = 'HR' ) sub";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("dept_id");
        column.setTable(new Table("sub"));
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertTrue((boolean)(reference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"dept_id", (Object)reference.getColumnName());
        Assertions.assertEquals((Object)"(SELECT d.id AS dept_id FROM departments d WHERE d.department_name = 'HR') sub", (Object)((SqlDerivedTableReference)reference.getTableReference()).getSelect().toString());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveColumnInNestedSubqueryNoAlliases() throws Exception {
        String sql = "SELECT * FROM (SELECT first_name FROM (SELECT * FROM employees))";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("first_name");
        SqlColumnReference reference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)reference);
        Assertions.assertTrue((boolean)(reference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"first_name", (Object)reference.getColumnName());
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveOuterColumn() throws Exception {
        String sql = "SELECT 1 FROM employees WHERE EXISTS (SELECT 1 FROM departments WHERE first_name = department_name)";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("first_name");
        SqlColumnReference outerReference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)outerReference);
        Assertions.assertTrue((boolean)(outerReference.getTableReference() instanceof SqlBaseTableReference));
        Assertions.assertEquals((Object)"first_name", (Object)outerReference.getColumnName());
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)outerReference.getTableReference()).getTableId());
        String innerSql = "SELECT 1 FROM departments WHERE first_name = department_name";
        Select innerSelect = (Select)SqlParserUtils.parseSqlCommand((String)innerSql);
        this.resolver.enterStatementeContext((Statement)innerSelect);
        SqlColumnReference innerReference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)innerReference);
        Assertions.assertTrue((boolean)(innerReference.getTableReference() instanceof SqlBaseTableReference));
        Assertions.assertEquals((Object)"first_name", (Object)innerReference.getColumnName());
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)innerReference.getTableReference()).getTableId());
        this.resolver.exitCurrentStatementContext();
        this.resolver.exitCurrentStatementContext();
    }

    @Test
    void testResolveNullColumn() throws Exception {
        String sql = "SELECT e.null_value FROM (SELECT NULL AS null_value) e";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("null_value");
        column.setTable(new Table("e"));
        SqlColumnReference columnReference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)columnReference);
        Assertions.assertEquals((Object)"null_value", (Object)columnReference.getColumnName());
        Assertions.assertTrue((boolean)(columnReference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"(SELECT NULL AS null_value) e", (Object)((SqlDerivedTableReference)columnReference.getTableReference()).getSelect().toString());
    }

    @Test
    void testResolveNonNullColumn() throws Exception {
        String sql = "SELECT non_null_value FROM (SELECT 42 AS non_null_value)";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("non_null_value");
        SqlColumnReference outerReference = this.resolver.resolve(column);
        Assertions.assertNotNull((Object)outerReference);
    }

    @Test
    void testResolveColumnTableNotInSchema() throws Exception {
        Assumptions.assumeTrue((this.schema.tables.stream().filter(t -> t.id.name.equals("Foo")).count() == 0L ? 1 : 0) != 0);
        String sql = "SELECT * FROM Foo";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("bar");
        column.setTable(new Table("Foo"));
        SqlColumnReference columnReference = this.resolver.resolve(column);
        Assertions.assertNull((Object)columnReference);
    }

    @Test
    void testResolveTableNotInSchema() throws Exception {
        Assumptions.assumeTrue((this.schema.tables.stream().filter(t -> t.id.name.equals("Foo")).count() == 0L ? 1 : 0) != 0);
        String sql = "SELECT * FROM Foo";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        this.resolver.enterStatementeContext((Statement)select);
        Column column = new Column();
        column.setColumnName("bar");
        SqlColumnReference columnReference = this.resolver.resolve(column);
        Assertions.assertNull((Object)columnReference);
    }
}

