/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TablesNamesFinderTest {
    @Test
    void findsSingleTableInSimpleQuery() throws JSQLParserException {
        String sql = "SELECT * FROM Users";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Set tables = finder.getTables(statement);
        Assertions.assertEquals((int)1, (int)tables.size());
        Assertions.assertTrue((boolean)tables.contains("Users"));
    }

    @Test
    void findsMultipleTablesInJoinQuery() throws JSQLParserException {
        String sql = "SELECT e.name, d.department_name FROM Employees e JOIN Departments d ON e.department_id = d.id";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Set tables = finder.getTables(statement);
        Assertions.assertEquals((int)2, (int)tables.size());
        Assertions.assertTrue((boolean)tables.contains("Employees"));
        Assertions.assertTrue((boolean)tables.contains("Departments"));
    }

    @Test
    void findsTableInSubquery() throws JSQLParserException {
        String sql = "SELECT name FROM (SELECT name, age FROM Users WHERE age > 30) AS subquery";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Set tables = finder.getTables(statement);
        Assertions.assertEquals((int)1, (int)tables.size());
        Assertions.assertTrue((boolean)tables.contains("Users"));
    }

    @Test
    void handlesQueryWithoutTables() throws JSQLParserException {
        String sql = "SELECT 1";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Set tables = finder.getTables(statement);
        Assertions.assertTrue((boolean)tables.isEmpty());
    }

    @Test
    void findsAliasedTableNames() throws JSQLParserException {
        String sql = "SELECT u.name FROM Users u";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Set tables = finder.getTables(statement);
        Assertions.assertEquals((int)1, (int)tables.size());
        Assertions.assertTrue((boolean)tables.contains("Users"));
    }

    @Test
    void handlesCaseInsensitiveKeywords() throws JSQLParserException {
        String sql = "select * from USERS";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Set tables = finder.getTables(statement);
        Assertions.assertEquals((int)1, (int)tables.size());
        Assertions.assertTrue((boolean)tables.contains("USERS"));
    }

    @Test
    void findsTablesInComplexQuery() throws JSQLParserException {
        String sql = "SELECT e.name, d.name FROM Employees e, Departments d WHERE e.department_id = d.id";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Set tables = finder.getTables(statement);
        Assertions.assertEquals((int)2, (int)tables.size());
        Assertions.assertTrue((boolean)tables.contains("Employees"));
        Assertions.assertTrue((boolean)tables.contains("Departments"));
    }

    @Test
    void handlesQueryWithUnion() throws JSQLParserException {
        String sql = "SELECT name FROM Users UNION SELECT name FROM Admins";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Set tables = finder.getTables(statement);
        Assertions.assertEquals((int)2, (int)tables.size());
        Assertions.assertTrue((boolean)tables.contains("Users"));
        Assertions.assertTrue((boolean)tables.contains("Admins"));
    }

    @Test
    void handlesQueryWithNestedSubqueries() throws JSQLParserException {
        String sql = "SELECT * FROM (SELECT * FROM (SELECT * FROM Users) AS innerSubquery) AS outerSubquery";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Set tables = finder.getTables(statement);
        Assertions.assertEquals((int)1, (int)tables.size());
        Assertions.assertTrue((boolean)tables.contains("Users"));
    }

    @Test
    void findsTablesInUnionWithSubqueries() throws JSQLParserException {
        String sql = "SELECT name FROM (SELECT name FROM Users WHERE age > 30) AS subquery1 UNION SELECT name FROM (SELECT name FROM Admins WHERE role = 'manager') AS subquery2";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Set tables = finder.getTables(statement);
        Assertions.assertEquals((int)2, (int)tables.size());
        Assertions.assertTrue((boolean)tables.contains("Users"));
        Assertions.assertTrue((boolean)tables.contains("Admins"));
    }

    @Test
    void findsTablesInNestedUnionsAndSubqueries() throws JSQLParserException {
        String sql = "SELECT * FROM (  SELECT * FROM (    SELECT * FROM Users     UNION     SELECT * FROM Admins  ) AS innerUnion   UNION   SELECT * FROM Employees) AS outerUnion";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Set tables = finder.getTables(statement);
        Assertions.assertEquals((int)3, (int)tables.size());
        Assertions.assertTrue((boolean)tables.contains("Users"));
        Assertions.assertTrue((boolean)tables.contains("Admins"));
        Assertions.assertTrue((boolean)tables.contains("Employees"));
    }

    @Test
    void findsTablesInUnionWithMultipleSubqueries() throws JSQLParserException {
        String sql = "SELECT name FROM (  SELECT name FROM Users WHERE age > 30   UNION   SELECT name FROM Admins WHERE role = 'manager') AS subquery1 UNION SELECT name FROM Employees";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder finder = new TablesNamesFinder();
        Set tables = finder.getTables(statement);
        Assertions.assertEquals((int)3, (int)tables.size());
        Assertions.assertTrue((boolean)tables.contains("Users"));
        Assertions.assertTrue((boolean)tables.contains("Admins"));
        Assertions.assertTrue((boolean)tables.contains("Employees"));
    }
}

