/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import java.util.Objects;
import org.evomaster.client.java.sql.heuristic.SqlTableReference;
import org.evomaster.client.java.sql.internal.SqlColumnId;

public class SqlColumnReference {
    private final SqlTableReference sqlTableReference;
    private final SqlColumnId columnId;

    public SqlColumnReference(SqlTableReference sqlTableReference, String columnName) {
        Objects.requireNonNull(columnName, "Column name must not be null");
        this.sqlTableReference = sqlTableReference;
        this.columnId = new SqlColumnId(columnName);
    }

    public SqlTableReference getTableReference() {
        return this.sqlTableReference;
    }

    public String getColumnName() {
        return this.columnId.getColumnId();
    }

    public String toString() {
        return this.sqlTableReference + "." + this.columnId.getColumnId();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SqlColumnReference) {
            SqlColumnReference other = (SqlColumnReference)obj;
            return Objects.equals(this.sqlTableReference, other.sqlTableReference) && Objects.equals(this.columnId, other.columnId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.sqlTableReference, this.columnId);
    }
}

