/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.update.Update;
import org.evomaster.client.java.controller.api.dto.SqlDtoUtils;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;

public class SqlNameContext {
    private DbInfoDto schema = null;
    private final Map<String, String> tableAliases = new HashMap<String, String>();
    private final Statement statement;
    public static final String UNNAMED_TABLE = "___unnamed_table___";

    public SqlNameContext(Statement statement) {
        this.statement = Objects.requireNonNull(statement);
        this.computeAliases();
    }

    public void setSchema(DbInfoDto schema) {
        this.schema = Objects.requireNonNull(schema);
    }

    public boolean hasColumn(String fullyQualifyingTableName, String columnName) {
        Objects.requireNonNull(fullyQualifyingTableName);
        Objects.requireNonNull(columnName);
        if (this.schema == null) {
            return false;
        }
        return this.schema.tables.stream().filter(t -> SqlDtoUtils.matchByName((TableDto)t, (String)fullyQualifyingTableName)).flatMap(t -> t.columns.stream()).filter(c -> c.name.equalsIgnoreCase(columnName)).count() > 0L;
    }

    public String getFullyQualifiedTableName(Column column) {
        Table table = column.getTable();
        if (table != null) {
            return this.tableAliases.getOrDefault(table.getFullyQualifiedName().toLowerCase(), table.getFullyQualifiedName().toLowerCase());
        }
        if (this.statement instanceof Select) {
            List<String> candidates = this.getTableNamesInFrom();
            assert (!candidates.isEmpty());
            if (candidates.size() == 1) {
                return candidates.get(0);
            }
            throw new IllegalArgumentException("TODO ambiguity");
        }
        if (this.statement instanceof Delete) {
            Delete delete = (Delete)this.statement;
            return delete.getTable().getFullyQualifiedName().toLowerCase();
        }
        if (this.statement instanceof Update) {
            Update update = (Update)this.statement;
            return update.getTable().getFullyQualifiedName().toLowerCase();
        }
        throw new IllegalArgumentException("Cannot handle table name for: " + this.statement);
    }

    private List<String> getTableNamesInFrom() {
        final ArrayList<String> names = new ArrayList<String>();
        if (this.hasFromItem()) {
            FromItem fromItem = this.getFromItem();
            FromItemVisitorAdapter visitor = new FromItemVisitorAdapter(){

                public void visit(Table table) {
                    names.add(table.getName().toLowerCase());
                }

                public void visit(ParenthesedSelect selectBody) {
                    PlainSelect plainSelect = selectBody.getPlainSelect();
                    SqlNameContext subContext = new SqlNameContext((Statement)plainSelect);
                    SqlNameContext.this.tableAliases.putAll(subContext.tableAliases);
                }

                public void visit(LateralSubSelect lateralSubSelect) {
                    throw new UnsupportedOperationException("Nested SELECTs not supported");
                }

                public void visit(TableFunction valuesList) {
                    throw new UnsupportedOperationException("Nested SELECTs not supported");
                }

                public void visit(ParenthesedFromItem aThis) {
                    throw new UnsupportedOperationException("Nested SELECTs not supported");
                }
            };
            fromItem.accept((FromItemVisitor)visitor);
        }
        return names;
    }

    private boolean hasFromItem() {
        Select select;
        if (this.statement instanceof Select && (select = (Select)this.statement) instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)select;
            FromItem fromItem = plainSelect.getFromItem();
            return fromItem != null;
        }
        return false;
    }

    private FromItem getFromItem() {
        if (!this.hasFromItem()) {
            throw new IllegalStateException("Cannot get FromItem from statement without a FROM clause");
        }
        if (!(this.statement instanceof Select)) {
            throw new IllegalStateException("Cannot get FromItem from statement without a SELECT clause");
        }
        Select select = (Select)this.statement;
        PlainSelect plainSelect = select.getPlainSelect();
        FromItem fromItem = plainSelect.getFromItem();
        return fromItem;
    }

    private void computeAliases() {
        if (this.statement instanceof Select) {
            if (this.hasFromItem()) {
                FromItem fromItem = this.getFromItem();
                fromItem.accept((FromItemVisitor)new AliasVisitor(this.tableAliases));
                Select select = (Select)this.statement;
                PlainSelect plainSelect = select.getPlainSelect();
                List joins = plainSelect.getJoins();
                if (joins != null) {
                    joins.forEach(j -> j.getRightItem().accept((FromItemVisitor)new AliasVisitor(this.tableAliases)));
                }
            }
        } else {
            if (this.statement instanceof Delete) {
                return;
            }
            if (this.statement instanceof Update) {
                return;
            }
        }
    }

    private static void handleAlias(Map<String, String> aliases, PlainSelect plainSelect) {
        String aliasName;
        Alias alias = plainSelect.getFromItem().getAlias();
        if (alias != null && (aliasName = alias.getName()) != null) {
            String tableName = UNNAMED_TABLE;
            aliases.put(aliasName.trim().toLowerCase(), tableName.trim().toLowerCase());
        }
    }

    private static void handleAlias(Map<String, String> aliases, Table table) {
        String aliasName;
        Alias alias = table.getAlias();
        if (alias != null && (aliasName = alias.getName()) != null) {
            String tableName = table.getName().toLowerCase();
            aliases.put(aliasName.trim().toLowerCase(), tableName.trim().toLowerCase());
        }
    }

    private static class AliasVisitor
    extends FromItemVisitorAdapter {
        private final Map<String, String> aliases;

        private AliasVisitor(Map<String, String> aliases) {
            this.aliases = aliases;
        }

        public void visit(Table table) {
            SqlNameContext.handleAlias((Map<String, String>)this.aliases, table);
        }

        public void visit(ParenthesedSelect selectBody) {
            SqlNameContext.handleAlias((Map<String, String>)this.aliases, selectBody.getPlainSelect());
        }

        public void visit(LateralSubSelect lateralSubSelect) {
            throw new UnsupportedOperationException();
        }

        public void visit(TableFunction valuesList) {
            throw new UnsupportedOperationException();
        }

        public void visit(ParenthesedFromItem aThis) {
            throw new UnsupportedOperationException();
        }
    }
}

