/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal.constraint;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.sql.h2.H2VersionUtils;
import org.evomaster.client.java.sql.internal.constraint.DbTableCheckExpression;
import org.evomaster.client.java.sql.internal.constraint.DbTableConstraint;
import org.evomaster.client.java.sql.internal.constraint.DbTableUniqueConstraint;
import org.evomaster.client.java.sql.internal.constraint.TableConstraintExtractor;
import org.evomaster.client.java.utils.SimpleLogger;

public class H2ConstraintExtractor
extends TableConstraintExtractor {
    private static final String CONSTRAINT_TYPE = "CONSTRAINT_TYPE";
    private static final String CHECK_EXPRESSION = "CHECK_EXPRESSION";
    private static final String COLUMN_LIST = "COLUMN_LIST";
    private static final String UNIQUE = "UNIQUE";
    private static final String REFERENTIAL = "REFERENTIAL";
    private static final String PRIMARY_KEY = "PRIMARY_KEY";
    private static final String PRIMARY_KEY_BLANK = "PRIMARY KEY";
    private static final String CHECK = "CHECK";
    private static final String CHECK_CONSTRAINT = "CHECK_CONSTRAINT";
    private static final String CONSTRAINT_CATALOG = "CONSTRAINT_CATALOG";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String CONSTRAINT_SCHEMA = "CONSTRAINT_SCHEMA";
    private static final String CONSTRAINT_NAME = "CONSTRAINT_NAME";

    @Override
    public List<DbTableConstraint> extract(Connection connectionToH2, DbInfoDto schemaDto) throws SQLException {
        String h2DatabaseVersion = H2VersionUtils.getH2Version(connectionToH2);
        List<DbTableConstraint> columnConstraints = this.extractColumnConstraints(connectionToH2, schemaDto, h2DatabaseVersion);
        List<DbTableConstraint> tableCheckExpressions = this.extractTableConstraints(connectionToH2, schemaDto, h2DatabaseVersion);
        ArrayList<DbTableConstraint> allConstraints = new ArrayList<DbTableConstraint>();
        allConstraints.addAll(columnConstraints);
        allConstraints.addAll(tableCheckExpressions);
        return allConstraints;
    }

    private static void cannotHandle(String constraintType) {
        SimpleLogger.uniqueWarn((String)("WARNING, EvoMaster cannot extract H2 constraints with type '" + constraintType));
    }

    private List<DbTableConstraint> extractColumnConstraints(Connection connectionToH2, DbInfoDto schemaDto, String h2DatabaseVersion) throws SQLException {
        if (H2VersionUtils.isVersionGreaterOrEqual(h2DatabaseVersion, "2.0.0")) {
            return new ArrayList<DbTableConstraint>();
        }
        return this.extractColumnConstraintsVersion1OrLower(connectionToH2, schemaDto, h2DatabaseVersion);
    }

    private List<DbTableConstraint> extractTableConstraints(Connection connectionToH2, DbInfoDto schemaDto, String h2DatabaseVersion) throws SQLException {
        if (H2VersionUtils.isVersionGreaterOrEqual(h2DatabaseVersion, "2.0.0")) {
            return this.extractTableConstraintsVersionTwoOrHigher(connectionToH2, schemaDto);
        }
        return this.extractTableConstraintsVersionOneOrLower(connectionToH2, schemaDto);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DbTableConstraint> extractTableConstraintsVersionTwoOrHigher(Connection connectionToH2, DbInfoDto schemaDto) throws SQLException {
        ArrayList<DbTableConstraint> tableCheckExpressions = new ArrayList<DbTableConstraint>();
        Iterator iterator = schemaDto.tables.iterator();
        block22: while (iterator.hasNext()) {
            TableDto tableDto = (TableDto)iterator.next();
            String tableSchema = tableDto.id.schema;
            String tableName = tableDto.id.name;
            Statement statement = connectionToH2.createStatement();
            try {
                String query = String.format("Select CONSTRAINT_CATALOG,CONSTRAINT_SCHEMA,CONSTRAINT_NAME,CONSTRAINT_TYPE From INFORMATION_SCHEMA.TABLE_CONSTRAINTS\n where TABLE_CONSTRAINTS.TABLE_SCHEMA='%s' \n and TABLE_CONSTRAINTS.TABLE_NAME='%s' ", tableSchema, tableName);
                ResultSet constraints = statement.executeQuery(query);
                try {
                    block23: while (true) {
                        String constraintType;
                        if (!constraints.next()) continue block22;
                        String constraintCatalog = constraints.getString(CONSTRAINT_CATALOG);
                        String constraintSchema = constraints.getString(CONSTRAINT_SCHEMA);
                        String constraintName = constraints.getString(CONSTRAINT_NAME);
                        switch (constraintType = constraints.getString(CONSTRAINT_TYPE)) {
                            case "UNIQUE": {
                                DbTableConstraint constraint = this.getTableUniqueConstraint(connectionToH2, tableName, constraintCatalog, constraintSchema, constraintName);
                                tableCheckExpressions.add(constraint);
                                continue block23;
                            }
                            case "CHECK": {
                                DbTableConstraint constraint = this.getTableCheckExpression(connectionToH2, tableName, constraintCatalog, constraintSchema, constraintName);
                                tableCheckExpressions.add(constraint);
                                continue block23;
                            }
                            case "PRIMARY_KEY": 
                            case "PRIMARY KEY": 
                            case "REFERENTIAL": {
                                continue block23;
                            }
                        }
                        H2ConstraintExtractor.cannotHandle(constraintType);
                    }
                }
                finally {
                    if (constraints == null) continue;
                    constraints.close();
                    continue;
                }
            }
            finally {
                if (statement == null) continue;
                statement.close();
                continue;
            }
            break;
        }
        return tableCheckExpressions;
    }

    private DbTableUniqueConstraint getTableUniqueConstraint(Connection connectionToH2, String tableName, String constraintCatalog, String constraintSchema, String constraintName) throws SQLException {
        try (Statement columnsUsageStatement = connectionToH2.createStatement();){
            DbTableUniqueConstraint dbTableUniqueConstraint;
            block13: {
                String columnsUsageQuery = String.format("SELECT TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME FROM INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE WHERE CONSTRAINT_CATALOG='%s' AND CONSTRAINT_SCHEMA='%s' AND CONSTRAINT_NAME='%s' ", constraintCatalog, constraintSchema, constraintName);
                ResultSet columnsUsageResultSet = columnsUsageStatement.executeQuery(columnsUsageQuery);
                try {
                    ArrayList<String> uniqueColumnNames = new ArrayList<String>();
                    while (columnsUsageResultSet.next()) {
                        String columnName = columnsUsageResultSet.getString(COLUMN_NAME);
                        uniqueColumnNames.add(columnName);
                    }
                    dbTableUniqueConstraint = new DbTableUniqueConstraint(tableName, uniqueColumnNames);
                    if (columnsUsageResultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (columnsUsageResultSet != null) {
                        try {
                            columnsUsageResultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                columnsUsageResultSet.close();
            }
            return dbTableUniqueConstraint;
        }
    }

    private DbTableCheckExpression getTableCheckExpression(Connection connectionToH2, String tableName, String constraintCatalog, String constraintSchema, String constraintName) throws SQLException {
        try (Statement checkClauseStatement = connectionToH2.createStatement();){
            String checkClauseQuery = String.format("SELECT CHECK_CLAUSE FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS WHERE CONSTRAINT_CATALOG='%s' AND CONSTRAINT_SCHEMA='%s' AND CONSTRAINT_NAME='%s' ", constraintCatalog, constraintSchema, constraintName);
            try (ResultSet checkClauseResultSet = checkClauseStatement.executeQuery(checkClauseQuery);){
                if (checkClauseResultSet.next()) {
                    String sqlCheckExpression = checkClauseResultSet.getString("CHECK_CLAUSE");
                    DbTableCheckExpression dbTableCheckExpression = new DbTableCheckExpression(tableName, "(" + sqlCheckExpression + ")");
                    return dbTableCheckExpression;
                }
                throw new IllegalArgumentException(String.format("Cannot find constraint such that CONSTRAINT_CATALOG='%s' AND CONSTRAINT_SCHEMA='%s' AND CONSTRAINT_NAME='%s' ", constraintCatalog, constraintSchema, constraintName));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DbTableConstraint> extractTableConstraintsVersionOneOrLower(Connection connectionToH2, DbInfoDto schemaDto) throws SQLException {
        ArrayList<DbTableConstraint> tableCheckExpressions = new ArrayList<DbTableConstraint>();
        Iterator iterator = schemaDto.tables.iterator();
        block22: while (iterator.hasNext()) {
            TableDto tableDto = (TableDto)iterator.next();
            String tableSchema = tableDto.id.schema;
            String tableName = tableDto.id.name;
            Statement statement = connectionToH2.createStatement();
            try {
                String query = String.format("Select CONSTRAINT_TYPE, CHECK_EXPRESSION, COLUMN_LIST From INFORMATION_SCHEMA.CONSTRAINTS\n where CONSTRAINTS.TABLE_SCHEMA='%s' \n and CONSTRAINTS.TABLE_NAME='%s' ", tableSchema, tableName);
                ResultSet constraints = statement.executeQuery(query);
                try {
                    block23: while (true) {
                        String constraintType;
                        if (!constraints.next()) continue block22;
                        switch (constraintType = constraints.getString(CONSTRAINT_TYPE)) {
                            case "UNIQUE": {
                                String columnList = constraints.getString(COLUMN_LIST);
                                List<String> uniqueColumnNames = Arrays.stream(columnList.split(",")).map(String::trim).collect(Collectors.toList());
                                DbTableConstraint constraint = new DbTableUniqueConstraint(tableName, uniqueColumnNames);
                                tableCheckExpressions.add(constraint);
                                continue block23;
                            }
                            case "PRIMARY_KEY": 
                            case "PRIMARY KEY": 
                            case "REFERENTIAL": {
                                continue block23;
                            }
                            case "CHECK": {
                                String sqlCheckExpression = constraints.getString(CHECK_EXPRESSION);
                                DbTableConstraint constraint = new DbTableCheckExpression(tableName, sqlCheckExpression);
                                tableCheckExpressions.add(constraint);
                                continue block23;
                            }
                        }
                        H2ConstraintExtractor.cannotHandle(constraintType);
                    }
                }
                finally {
                    if (constraints == null) continue;
                    constraints.close();
                    continue;
                }
            }
            finally {
                if (statement == null) continue;
                statement.close();
                continue;
            }
            break;
        }
        return tableCheckExpressions;
    }

    private List<DbTableConstraint> extractColumnConstraintsVersion1OrLower(Connection connectionToH2, DbInfoDto schemaDto, String h2DatabaseVersion) throws SQLException {
        if (H2VersionUtils.isVersionGreaterOrEqual(h2DatabaseVersion, "2.0.0")) {
            throw new IllegalArgumentException("Cannot extract column constraints for H2 version 2 or higher with H2 database version  " + h2DatabaseVersion);
        }
        ArrayList<DbTableConstraint> columnConstraints = new ArrayList<DbTableConstraint>();
        for (TableDto tableDto : schemaDto.tables) {
            String tableSchema = tableDto.id.schema;
            String tableName = tableDto.id.name;
            Statement statement = connectionToH2.createStatement();
            try {
                String query = String.format("Select * From INFORMATION_SCHEMA.COLUMNS where COLUMNS.TABLE_SCHEMA='%s' and COLUMNS.TABLE_NAME='%s' ", tableSchema, tableName);
                ResultSet columns = statement.executeQuery(query);
                try {
                    while (columns.next()) {
                        String sqlCheckExpression = columns.getString(CHECK_CONSTRAINT);
                        if (sqlCheckExpression == null || sqlCheckExpression.equals("")) continue;
                        DbTableCheckExpression constraint = new DbTableCheckExpression(tableName, sqlCheckExpression);
                        columnConstraints.add(constraint);
                    }
                }
                finally {
                    if (columns == null) continue;
                    columns.close();
                }
            }
            finally {
                if (statement == null) continue;
                statement.close();
            }
        }
        return columnConstraints;
    }
}

