/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.parser;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.repo.parser.PkgComponentHandler;
import org.expath.pkg.repo.parser.PkgHandlerDtd;
import org.expath.pkg.repo.parser.PkgHandlerUriFile;
import org.expath.pkg.repo.parser.XMLStreamHelper;

public class DescriptorParser {
    private static final Map<String, PkgComponentHandler> MY_HANDLERS;
    public static final String PKG_NS = "http://expath.org/ns/pkg";
    public static final XMLStreamHelper XS_HELPER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Package parse(Source desc, String rsrc_name, Storage storage, Repository repo) throws PackageException {
        XMLStreamReader parser = null;
        try {
            parser = XS_HELPER.makeParser(desc);
            XS_HELPER.ensureDocument(parser);
            XS_HELPER.ensureNextElement(parser, "package");
            String spec = XS_HELPER.getAttributeValue(parser, "spec");
            if (!"1.0".equals(spec)) {
                throw new PackageException("Spec version is not 1.0: '" + spec + "'");
            }
            String name = XS_HELPER.getAttributeValue(parser, "name");
            String abbrev = XS_HELPER.getAttributeValue(parser, "abbrev");
            String version = XS_HELPER.getAttributeValue(parser, "version");
            XS_HELPER.ensureNextElement(parser, "title");
            String title = XS_HELPER.getElementValue(parser);
            Package pkg = null;
            try {
                String home = null;
                parser.next();
                if (XS_HELPER.isElement(parser, "home")) {
                    home = XS_HELPER.getElementValue(parser);
                    parser.next();
                }
                Storage.PackageResolver resolver = storage.makePackageResolver(rsrc_name, abbrev);
                pkg = new Package(repo, resolver, name, abbrev, version, title, home);
                while (XS_HELPER.isElement(parser, "dependency")) {
                    this.handleDependency(parser, pkg);
                    parser.next();
                }
                while (parser.getEventType() == 1) {
                    this.handleComponent(parser, pkg);
                }
            }
            catch (XMLStreamException ex) {
                throw new PackageException("Error parsing the package descriptor", ex);
            }
            Package package_ = pkg;
            return package_;
        }
        finally {
            try {
                parser.close();
            }
            catch (XMLStreamException e) {
                throw new PackageException(e.getMessage(), e);
            }
        }
    }

    private void handleDependency(XMLStreamReader parser, Package pkg) throws PackageException, XMLStreamException {
        String pkg_name = parser.getAttributeValue(null, "package");
        String processor = parser.getAttributeValue(null, "processor");
        String versions = parser.getAttributeValue(null, "versions");
        String semver = parser.getAttributeValue(null, "semver");
        String min = parser.getAttributeValue(null, "semver-min");
        String max = parser.getAttributeValue(null, "semver-max");
        if (pkg_name == null && processor == null) {
            throw new PackageException("None of @package nor @processor are set on a dependency element");
        }
        if (pkg_name != null && processor != null) {
            throw new PackageException("@package and @processor are both set on a dependency element");
        }
        if (pkg_name != null) {
            pkg.addPackageDep(pkg_name, versions, semver, min, max);
        } else {
            pkg.addProcessorDep(processor, versions, semver, min, max);
        }
        parser.next();
    }

    private void handleComponent(XMLStreamReader parser, Package pkg) throws PackageException, XMLStreamException {
        if (PKG_NS.equals(parser.getNamespaceURI())) {
            String local = parser.getLocalName();
            PkgComponentHandler handler = MY_HANDLERS.get(local);
            if (handler == null) {
                throw new PackageException("Unknown component type: " + local);
            }
            handler.handleDescription(parser, pkg, XS_HELPER);
        } else {
            XS_HELPER.ignoreElement(parser);
        }
        parser.next();
    }

    static {
        HashMap<String, PkgComponentHandler> handlers = new HashMap<String, PkgComponentHandler>();
        try {
            handlers.put("xslt", new PkgHandlerUriFile(URISpace.XSLT, "import-uri", "file"));
            handlers.put("xproc", new PkgHandlerUriFile(URISpace.XPROC, "import-uri", "file"));
            handlers.put("xsd", new PkgHandlerUriFile(URISpace.XSD, "import-uri", "namespace", "file"));
            handlers.put("rng", new PkgHandlerUriFile(URISpace.RNG, "import-uri", "file"));
            handlers.put("rnc", new PkgHandlerUriFile(URISpace.RNC, "import-uri", "file"));
            handlers.put("schematron", new PkgHandlerUriFile(URISpace.SCHEMATRON, "import-uri", "file"));
            handlers.put("nvdl", new PkgHandlerUriFile(URISpace.NVDL, "import-uri", "file"));
            handlers.put("xquery", new PkgHandlerUriFile(URISpace.XQUERY, "import-uri", "namespace", "file"));
            handlers.put("dtd", new PkgHandlerDtd());
        }
        catch (PackageException ex) {
            throw new RuntimeException("Exception occured during static members initialization", ex);
        }
        MY_HANDLERS = handlers;
        XS_HELPER = new XMLStreamHelper(PKG_NS);
    }
}

