/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.XarSource;

public class XarUriSource
implements XarSource {
    private final URI uri;

    public XarUriSource(URI uri) {
        this.uri = uri;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public InputStream newInputStream() throws IOException {
        URLConnection connection = this.uri.toURL().openConnection();
        connection.connect();
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection hc = (HttpURLConnection)connection;
            int code = hc.getResponseCode();
            if (code == 404) {
                throw new IOException(new Repository.NotFoundException(this.uri));
            }
            if (code < 200 || code >= 300) {
                String msg = hc.getResponseMessage();
                throw new IOException(new Repository.HttpException(this.uri, code, msg));
            }
        }
        return connection.getInputStream();
    }
}

