/*
 * Decompiled with CFR 0.152.
 */
package org.fastquery.httpsign;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import org.fastquery.httpsign.AccessAccount;
import org.fastquery.httpsign.Algorithm;
import org.fastquery.httpsign.Code;
import org.fastquery.httpsign.DateUtil;
import org.fastquery.httpsign.Factor;
import org.fastquery.httpsign.RangeTime;
import org.fastquery.httpsign.ReplyBuilder;
import org.fastquery.httpsign.SignBuilder;

public abstract class AuthAbstractContainerRequestFilter
implements ContainerRequestFilter,
AccessAccount {
    @Context
    private HttpServletRequest request;

    private String buildQueryString(SortedMap<String, String> parameters) throws UnsupportedEncodingException {
        Iterator<String> it = parameters.keySet().iterator();
        StringBuilder queryStringTmp = new StringBuilder();
        while (it.hasNext()) {
            String name = it.next();
            queryStringTmp.append("&").append(this.specialUrlEncode(name)).append('=').append(this.specialUrlEncode((String)parameters.get(name)));
        }
        return queryStringTmp.substring(1);
    }

    private String specialUrlEncode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String sign;
        String nonce = this.request.getParameter("nonce");
        if (nonce == null) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40008).build());
            return;
        }
        if (RangeTime.exists(nonce)) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40300).build());
            return;
        }
        String clientAuth = requestContext.getHeaderString("Authorization");
        if (clientAuth == null) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40000).build());
            return;
        }
        if (clientAuth.length() != 34) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40001).build());
            return;
        }
        String accept = requestContext.getHeaderString("Accept");
        if (accept != null && !"application/json".equals(accept) && !"application/xml".equals(accept)) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40002).build());
            return;
        }
        String date = requestContext.getHeaderString("Date");
        if (date == null) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40003).build());
            return;
        }
        Date clientDate = null;
        try {
            clientDate = DateUtil.parseRfc822Date(date);
        }
        catch (ParseException e) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40003).build());
            return;
        }
        long current = System.currentTimeMillis();
        if (Math.abs(current - clientDate.getTime()) > 600000L) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40004).build());
            return;
        }
        RangeTime.add(current, nonce);
        String version = this.request.getParameter("version");
        if (version == null) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40005).build());
            return;
        }
        if (!"1".equals(version)) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40006).build());
            return;
        }
        String action = this.request.getParameter("action");
        if (action == null) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40007).build());
            return;
        }
        int nonceLen = nonce.length();
        if (nonceLen < 8 || nonceLen > 36) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40009).build());
            return;
        }
        String accessKeyId = this.request.getParameter("accessKeyId");
        if (accessKeyId == null || "".equals(accessKeyId)) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40010).build());
            return;
        }
        String accessKeySecret = this.getAccessKeySecret(accessKeyId);
        if (accessKeySecret == null) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40011).build());
            return;
        }
        String signatureMethod = this.request.getParameter("signatureMethod");
        if (signatureMethod != null && !Algorithm.HMACSHA1.name().equals(signatureMethod) && !Algorithm.HMACSHA256.name().equals(signatureMethod)) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40012).build());
            return;
        }
        if (signatureMethod == null) {
            signatureMethod = "HMACSHA1";
        }
        String httpMethod = requestContext.getMethod();
        String contentMD5 = requestContext.getHeaderString("Content-MD5");
        if (requestContext.hasEntity() && contentMD5 == null) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40015).build());
            return;
        }
        String uriPath = requestContext.getUriInfo().getRequestUri().getPath();
        TreeMap<String, String> parametersMap = new TreeMap<String, String>();
        Enumeration enumeration = this.request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            parametersMap.put(name, this.request.getParameter(name));
        }
        String requestParameters = this.buildQueryString(parametersMap);
        Enumeration enumHeaderNames = this.request.getHeaderNames();
        TreeMap<String, String> headerTreeMap = new TreeMap<String, String>();
        while (enumHeaderNames.hasMoreElements()) {
            String name = (String)enumHeaderNames.nextElement();
            String value = this.request.getHeader(name);
            if (!name.toLowerCase().startsWith("x-custom-")) continue;
            headerTreeMap.put(name, value);
        }
        Factor factor = new Factor(httpMethod, contentMD5, accept, date, uriPath, requestParameters, headerTreeMap);
        String stringFactor = SignBuilder.buidStringFactor(factor);
        try {
            sign = SignBuilder.sign(accessKeySecret, stringFactor, signatureMethod);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40017).build());
            return;
        }
        String authorization = SignBuilder.buidAuthorization(sign);
        if (!authorization.equals(clientAuth)) {
            requestContext.abortWith(ReplyBuilder.error(Code.E40018.appendMsg("\u670d\u52a1\u7aef\u8ba1\u7b97\u51fa\u7684Authorization\u7684\u662f" + authorization)).build());
        }
    }
}

