/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.embedding.jbang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JBangIntegration {
    private static final String PIP = "//PIP";
    private static final String PIP_DROP = "//PIP_DROP";
    private static final String PYTHON_LANGUAGE = "python-language";
    private static final String PYTHON_RESOURCES = "python-resources";
    private static final String PYTHON_LAUNCHER = "python-launcher";
    private static final String GRAALPY_GROUP = String.join((CharSequence)File.separator, "org", "graalvm", "python");
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final String LAUNCHER = IS_WINDOWS ? "graalpy.exe" : "graalpy.sh";
    private static final String BIN_DIR = IS_WINDOWS ? "Scripts" : "bin";
    private static final String EXE_SUFFIX = IS_WINDOWS ? ".exe" : "";

    public static Map<String, Object> postBuild(Path temporaryJar, Path pomFile, List<Map.Entry<String, String>> repositories, List<Map.Entry<String, Path>> dependencies, List<String> comments, boolean nativeImage) {
        Path home;
        Path vfs;
        block16: {
            vfs = temporaryJar.resolve("vfs");
            Path venv = vfs.resolve("venv");
            home = vfs.resolve("home");
            try {
                Files.createDirectories(vfs, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new Error(e);
            }
            for (String string : comments) {
                if (!string.startsWith(PIP)) continue;
                JBangIntegration.ensureVenv(venv, dependencies);
                JBangIntegration.runPip(venv, "install", string.substring(PIP.length()).trim());
            }
            ArrayList<String> dropFolders = new ArrayList<String>();
            dropFolders.add("pip");
            dropFolders.add("setuptools");
            for (String string : comments) {
                if (!string.startsWith(PIP_DROP)) continue;
                dropFolders.add(string.substring(PIP_DROP.length()).trim());
            }
            if (Files.exists(venv, new LinkOption[0])) {
                try {
                    Path path = Files.list(venv.resolve("lib")).filter(p -> p.getFileName().toString().startsWith("python3")).findFirst().get();
                    if (path == null) break block16;
                    for (String s : dropFolders) {
                        Path folder = path.resolve("site-packages").resolve(s);
                        if (!Files.exists(folder, new LinkOption[0])) continue;
                        Stream<Path> f = Files.walk(folder, new FileVisitOption[0]);
                        try {
                            f.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                        }
                        finally {
                            if (f == null) continue;
                            f.close();
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
        if (nativeImage) {
            JBangIntegration.runGraalPy(dependencies, "-c", String.format("__import__('shutil').copytree(__graalpython__.home, '%s', dirs_exist_ok=True)", home.toAbsolutePath().toString()));
            Path path = temporaryJar.resolve("META-INF").resolve("native-image");
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                Files.writeString(path.resolve("native-image.properties"), (CharSequence)"Args = -H:-CopyLanguageResources", new OpenOption[0]);
                Files.writeString(path.resolve("resource-config.json"), (CharSequence)"{\n  \"resources\": {\n    \"includes\": [\n      {\"pattern\": \"vfs/.*\"}\n    ]\n  }\n}\n", new OpenOption[0]);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        JBangIntegration.generateFilelist(vfs);
        return new HashMap<String, Object>();
    }

    private static void generateFilelist(Path vfs) {
        Path filesList = vfs.resolve("fileslist.txt");
        HashSet<String> ret = new HashSet<String>();
        String rootPath = JBangIntegration.makeDirPath(vfs.toAbsolutePath());
        int rootEndIdx = rootPath.lastIndexOf(File.separator, rootPath.lastIndexOf(File.separator) - 1);
        ret.add(rootPath.substring(rootEndIdx));
        try (Stream<Path> s = Files.walk(vfs, new FileVisitOption[0]);){
            s.forEach(p -> {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    String dirPath = JBangIntegration.makeDirPath(p.toAbsolutePath());
                    ret.add(dirPath.substring(rootEndIdx));
                } else if (Files.isRegularFile(p, new LinkOption[0])) {
                    ret.add(p.toAbsolutePath().toString().substring(rootEndIdx));
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Object[] a = (String[])ret.toArray(String[]::new);
        Arrays.sort(a);
        try (FileWriter wr = new FileWriter(filesList.toFile());){
            for (Object f : a) {
                if (((String)f).charAt(0) == '\\') {
                    f = ((String)f).replace("\\", "/");
                }
                wr.write((String)f);
                wr.write("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String makeDirPath(Path p) {
        Object ret = p.toString();
        if (!((String)ret).endsWith(File.separator)) {
            ret = (String)ret + File.separator;
        }
        return ret;
    }

    private static Path getLauncherPath(String projectPath) {
        return Paths.get(projectPath, LAUNCHER);
    }

    private static void generateLaunchers(List<Map.Entry<String, Path>> dependencies, String projectPath) {
        System.out.println("Generating GraalPy launchers");
        Path launcher = JBangIntegration.getLauncherPath(projectPath);
        if (!Files.exists(launcher, new LinkOption[0])) {
            File tmp;
            if (!IS_WINDOWS) {
                HashSet<String> classpath = JBangIntegration.calculateClasspath(dependencies);
                Path java = Paths.get(System.getProperty("java.home"), "bin", "java");
                String script = String.format("#!/usr/bin/env bash\nsource=\"${BASH_SOURCE[0]}\"\nsource=\"$(readlink \"$source\")\";\nlocation=\"$( cd -P \"$( dirname \"$source\" )\" && pwd )\"\nargs=\"$(printf \"\\v\")--python.Executable=$0\"\nfor var in \"$@\"; do args=\"${args}$(printf \"\\v\")${var}\"; done\ncurdir=`pwd`\nexport GRAAL_PYTHON_ARGS=\"${args}$(printf \"\\v\")\"\n%s -classpath %s %s\n", java, String.join((CharSequence)File.pathSeparator, classpath), "com.oracle.graal.python.shell.GraalPythonMain");
                try {
                    Path parent = launcher.getParent();
                    if (parent != null) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    Files.writeString(launcher, (CharSequence)script, new OpenOption[0]);
                    Set<PosixFilePermission> perms = Files.getPosixFilePermissions(launcher, new LinkOption[0]);
                    perms.addAll(List.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE));
                    Files.setPosixFilePermissions(launcher, perms);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            String script = String.format("import os, shutil, struct, venv\nfrom pathlib import Path\nvl = os.path.join(venv.__path__[0], 'scripts', 'nt', 'graalpy.exe')\ntl = os.path.join(r'%s')\nos.makedirs(Path(tl).parent.absolute())\nshutil.copy(vl, tl)\ncmd = r'mvn.cmd -f \"%s\" graalpy:exec \"-Dexec.workingdir=%s\"'\npyvenvcfg = os.path.join(os.path.dirname(tl), \"pyvenv.cfg\")\nwith open(pyvenvcfg, 'w', encoding='utf-8') as f:\n    f.write('venvlauncher_command = ')\n    f.write(cmd)\n", launcher, Paths.get(projectPath, "pom.xml").toString(), projectPath);
            try {
                tmp = File.createTempFile("create_launcher", ".py");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            tmp.deleteOnExit();
            try (FileWriter wr = new FileWriter(tmp);){
                wr.write(script);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            JBangIntegration.runGraalPy(dependencies, tmp.getAbsolutePath());
        }
    }

    private static void ensureVenv(Path venv, List<Map.Entry<String, Path>> dependencies) {
        if (Files.exists(venv, new LinkOption[0])) {
            return;
        }
        Path venvDirectory = venv.toAbsolutePath();
        Path parent = venv.getParent();
        if (parent != null) {
            String parentString = parent.toString();
            JBangIntegration.generateLaunchers(dependencies, parentString);
            JBangIntegration.runLauncher(parentString, "-m", "venv", venvDirectory.toString(), "--without-pip");
            JBangIntegration.runVenvBin(venvDirectory, "graalpy", List.of("-I", "-m", "ensurepip"));
        }
    }

    private static void runLauncher(String projectPath, String ... args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(JBangIntegration.getLauncherPath(projectPath).toString());
        cmd.addAll(List.of(args));
        System.out.println(String.join((CharSequence)" ", cmd));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        JBangIntegration.runProcess(pb);
    }

    private static void runPip(Path venvDirectory, String command, String pkg) {
        ArrayList<String> newArgs = new ArrayList<String>();
        newArgs.add("-m");
        newArgs.add("pip");
        JBangIntegration.addProxy(newArgs);
        newArgs.add(command);
        newArgs.add(pkg);
        JBangIntegration.runVenvBin(venvDirectory, "graalpy", newArgs);
    }

    private static void runVenvBin(Path venvDirectory, String bin, Collection<String> args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(venvDirectory.resolve(BIN_DIR).resolve(bin + EXE_SUFFIX).toString());
        cmd.addAll(args);
        System.out.println(String.join((CharSequence)" ", cmd));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        JBangIntegration.runProcess(pb);
    }

    private static void runGraalPy(List<Map.Entry<String, Path>> dependencies, String ... args) {
        HashSet<String> classpath = JBangIntegration.calculateClasspath(dependencies);
        String workdir = System.getProperty("exec.workingdir");
        Path java = Paths.get(System.getProperty("java.home"), "bin", "java");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(java.toString());
        cmd.add("-classpath");
        cmd.add(String.join((CharSequence)File.pathSeparator, classpath));
        cmd.add("com.oracle.graal.python.shell.GraalPythonMain");
        cmd.addAll(List.of(args));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (workdir != null) {
            pb.directory(new File(workdir));
            throw new RuntimeException("Not satisfied pip");
        }
        System.out.println(String.format("Running GraalPy: %s", String.join((CharSequence)" ", cmd)));
        JBangIntegration.runProcess(pb);
    }

    private static void addProxy(ArrayList<String> args) {
        if (System.getenv("http_proxy") == null && System.getenv("https_proxy") == null) {
            ProxySelector proxySelector = ProxySelector.getDefault();
            List<Proxy> proxies = proxySelector.select(URI.create("https://pypi.org"));
            String proxyAddr = null;
            for (Proxy proxy : proxies) {
                if (proxy.type() != Proxy.Type.HTTP) continue;
                proxyAddr = JBangIntegration.fixProtocol(proxy.address().toString(), "http");
                break;
            }
            if (proxyAddr != null) {
                args.add("--proxy");
                args.add(proxyAddr);
            }
        }
    }

    private static void runProcess(ProcessBuilder pb) {
        try {
            pb.redirectError();
            pb.redirectOutput();
            Process process = pb.start();
            Thread outputReader = new Thread(() -> {
                try (InputStream is = process.getInputStream();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            outputReader.start();
            process.waitFor();
            outputReader.join();
            if (process.exitValue() != 0) {
                JBangIntegration.printErrors(process);
                throw new RuntimeException(String.format("Running command: '%s' ended with code %d.See the error output above.", String.join((CharSequence)" ", pb.command()), process.exitValue()));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static String fixProtocol(String proxyAddress, String protocol) {
        return proxyAddress.startsWith(protocol) ? proxyAddress : protocol + "://" + proxyAddress;
    }

    private static Collection<Path> resolveProjectDependencies(List<Map.Entry<String, Path>> dependencies) {
        return dependencies.stream().map(e -> (Path)e.getValue()).collect(Collectors.toList());
    }

    private static void getGraalPyArtifact(List<Map.Entry<String, Path>> dependencies, String aid) {
        Collection<Path> projectArtifacts = JBangIntegration.resolveProjectDependencies(dependencies);
        for (Path a : projectArtifacts) {
            Path fileName;
            Path parent = a.getParent();
            if (parent == null || (fileName = a.getFileName()) == null || !parent.toString().contains(GRAALPY_GROUP) || !fileName.toString().contains(aid)) continue;
            return;
        }
        throw new RuntimeException(String.format("Missing GraalPy dependency %s:%s. Please add it to your pom", GRAALPY_GROUP, aid));
    }

    private static HashSet<String> calculateClasspath(List<Map.Entry<String, Path>> dependencies) {
        HashSet<String> classpath = new HashSet<String>();
        JBangIntegration.getGraalPyArtifact(dependencies, PYTHON_LANGUAGE);
        JBangIntegration.getGraalPyArtifact(dependencies, PYTHON_LAUNCHER);
        JBangIntegration.getGraalPyArtifact(dependencies, PYTHON_RESOURCES);
        for (Path r : JBangIntegration.resolveProjectDependencies(dependencies)) {
            classpath.add(r.toAbsolutePath().toString());
        }
        return classpath;
    }

    private static void printErrors(Process process) throws IOException {
        String line;
        InputStream errorStream = process.getErrorStream();
        InputStreamReader errorStreamReader = new InputStreamReader(errorStream);
        BufferedReader errorBufferedReader = new BufferedReader(errorStreamReader);
        System.out.println("========== Error Output: =========");
        while ((line = errorBufferedReader.readLine()) != null) {
            System.out.println(line);
        }
        System.out.println("==================================");
    }
}

