/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ReadlineModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@CoreFunctions(defineModule="readline")
public final class ReadlineModuleBuiltins
extends PythonBuiltins {
    private static final HiddenKey DATA = new HiddenKey("__data__");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ReadlineModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        core.lookupBuiltinModule(BuiltinNames.T_READLINE).setAttribute(DATA, new LocalData());
    }

    private static final class LocalData {
        private final HashMap<String, String> bindings = new HashMap();
        private final List<TruffleString> history = new ArrayList<TruffleString>();
        protected Object completer = null;
        protected boolean autoHistory = true;
        protected TruffleString completerDelims = null;

        private LocalData() {
        }
    }

    @Builtin(name="get_completer_delims", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class GetCompleterDelimsNode
    extends PythonBuiltinNode {
        GetCompleterDelimsNode() {
        }

        @Specialization
        Object getCompleterDelims(PythonModule self, @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            return data.completerDelims != null ? data.completerDelims : PNone.NONE;
        }
    }

    @Builtin(name="set_completer_delims", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class SetCompleterDelimsNode
    extends PythonBinaryBuiltinNode {
        SetCompleterDelimsNode() {
        }

        @Specialization
        PNone setCompleterDelims(PythonModule self, TruffleString completerDelims, @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            data.completerDelims = completerDelims;
            return PNone.NONE;
        }
    }

    @Builtin(name="set_auto_history", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class SetAutoHistoryNode
    extends PythonBinaryBuiltinNode {
        SetAutoHistoryNode() {
        }

        @Specialization
        PNone setCompleter(PythonModule self, boolean enabled, @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            data.autoHistory = enabled;
            return PNone.NONE;
        }
    }

    @Builtin(name="get_auto_history", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class GetAutoHistoryNode
    extends PythonUnaryBuiltinNode {
        GetAutoHistoryNode() {
        }

        @Specialization
        boolean setCompleter(PythonModule self, @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            return data.autoHistory;
        }
    }

    @Builtin(name="redisplay", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class RedisplayNode
    extends PythonBuiltinNode {
        RedisplayNode() {
        }

        @Specialization
        PNone setCompleter() {
            return PNone.NONE;
        }
    }

    @Builtin(name="insert_text", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class InsertTextNode
    extends PythonUnaryBuiltinNode {
        InsertTextNode() {
        }

        @Specialization
        PNone setCompleter(Object text) {
            return PNone.NONE;
        }
    }

    @Builtin(name="clear_history", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class ClearNode
    extends PythonUnaryBuiltinNode {
        ClearNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone setCompleter(PythonModule self, @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            data.history.clear();
            return PNone.NONE;
        }
    }

    @Builtin(name="write_history_file", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class WriteHistoryFileNode
    extends PythonBinaryBuiltinNode {
        WriteHistoryFileNode() {
        }

        @Specialization
        PNone setCompleter(PythonModule self, PString path, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached ReadAttributeFromObjectNode readNode) {
            return this.setCompleter(self, castToStringNode.execute(inliningTarget, path), readNode);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone setCompleter(PythonModule self, TruffleString path, @Cached.Shared @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            try {
                BufferedWriter writer = this.getContext().getEnv().getPublicTruffleFile(path.toJavaStringUncached()).newBufferedWriter(new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING});
                for (TruffleString l : data.history) {
                    writer.write(l.toJavaStringUncached());
                    writer.newLine();
                }
                writer.close();
            }
            catch (IOException e) {
                throw this.raise(PythonErrorType.IOError, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="read_history_file", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class ReadHistoryFileNode
    extends PythonBinaryBuiltinNode {
        ReadHistoryFileNode() {
        }

        @Specialization
        PNone setCompleter(PythonModule self, PString path, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ReadAttributeFromObjectNode readNode, @Cached CastToTruffleStringNode castToStringNode) {
            return this.setCompleter(self, castToStringNode.execute(inliningTarget, path), readNode);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone setCompleter(PythonModule self, TruffleString path, @Cached.Shared @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            try (GilNode.UncachedRelease gil = GilNode.uncachedRelease();){
                String line;
                BufferedReader reader = this.getContext().getEnv().getPublicTruffleFile(path.toJavaStringUncached()).newBufferedReader();
                while ((line = reader.readLine()) != null) {
                    data.history.add(PythonUtils.toTruffleStringUncached(line));
                }
                reader.close();
            }
            catch (IOException e) {
                throw this.raise(PythonErrorType.IOError, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="add_history", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class AddHistoryNode
    extends PythonBinaryBuiltinNode {
        AddHistoryNode() {
        }

        @Specialization
        PNone addHistory(PythonModule self, PString item, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ReadAttributeFromObjectNode readNode, @Cached CastToTruffleStringNode castToStringNode) {
            return this.addHistory(self, castToStringNode.execute(inliningTarget, item), readNode);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone addHistory(PythonModule self, TruffleString item, @Cached.Shared @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            data.history.add(item);
            return PNone.NONE;
        }
    }

    @Builtin(name="remove_history_item", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class DeleteItemNode
    extends PythonBinaryBuiltinNode {
        DeleteItemNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        TruffleString setCompleter(PythonModule self, int index, @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            try {
                return data.history.remove(index);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.raise(PythonErrorType.IndexError, ErrorMessages.INDEX_OUT_OF_BOUNDS);
            }
        }
    }

    @Builtin(name="replace_history_item", minNumOfPositionalArgs=3, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class ReplaceItemNode
    extends PythonTernaryBuiltinNode {
        ReplaceItemNode() {
        }

        @Specialization
        TruffleString setCompleter(PythonModule self, int index, PString string, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached ReadAttributeFromObjectNode readNode) {
            return this.setCompleter(self, index, castToStringNode.execute(inliningTarget, string), readNode);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        TruffleString setCompleter(PythonModule self, int index, TruffleString string, @Cached.Shared @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            try {
                return data.history.set(index, string);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.raise(PythonErrorType.IndexError, ErrorMessages.INDEX_OUT_OF_BOUNDS);
            }
        }
    }

    @Builtin(name="get_history_item", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class SetHistoryLengthNode
    extends PythonBinaryBuiltinNode {
        SetHistoryLengthNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        TruffleString setCompleter(PythonModule self, int index, @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            try {
                return data.history.get(index);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.raise(PythonErrorType.IndexError, ErrorMessages.INDEX_OUT_OF_BOUNDS);
            }
        }
    }

    @Builtin(name="get_current_history_length", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class GetHistoryLengthNode
    extends PythonUnaryBuiltinNode {
        GetHistoryLengthNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int setCompleter(PythonModule self, @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            return data.history.size();
        }
    }

    @Builtin(name="read_init_file", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class ReadInitNode
    extends PythonUnaryBuiltinNode {
        ReadInitNode() {
        }

        @Specialization
        PNone setCompleter(PythonModule self) {
            throw this.raise(PythonErrorType.OSError, ErrorMessages.NOT_IMPLEMENTED);
        }
    }

    @Builtin(name="parse_and_bind", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class ParseAndBindNode
    extends PythonBinaryBuiltinNode {
        ParseAndBindNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone setCompleter(PythonModule self, TruffleString tspec, @Cached ReadAttributeFromObjectNode readNode) {
            String spec = tspec.toJavaStringUncached();
            if (spec.startsWith("tab:")) {
                LocalData data = (LocalData)readNode.execute(self, DATA);
                data.bindings.put("tab", spec.split(":")[1].trim());
                return PNone.NONE;
            }
            throw this.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("any other binding than 'tab'"));
        }
    }

    @Builtin(name="set_completer", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class SetCompleterNode
    extends PythonBinaryBuiltinNode {
        SetCompleterNode() {
        }

        @Specialization
        PNone setCompleter(PythonModule self, Object callable, @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            data.completer = callable;
            return PNone.NONE;
        }
    }

    @Builtin(name="get_completer", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class GetCompleterNode
    extends PythonUnaryBuiltinNode {
        GetCompleterNode() {
        }

        @Specialization
        Object getCompleter(PythonModule self, @Cached ReadAttributeFromObjectNode readNode) {
            LocalData data = (LocalData)readNode.execute(self, DATA);
            if (data.completer != null) {
                return data.completer;
            }
            return PNone.NONE;
        }
    }
}

