/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.random;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.random.PRandom;
import com.oracle.graal.python.builtins.objects.random.RandomBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.random.RandomBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CastToJavaUnsignedLongNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PRandom})
public final class RandomBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return RandomBuiltinsFactory.getFactories();
    }

    @Builtin(name="getrandbits", minNumOfPositionalArgs=2, parameterNames={"$self", "k"})
    @ArgumentClinic(name="k", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    public static abstract class GetRandBitsNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return RandomBuiltinsClinicProviders.GetRandBitsNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"k < 0"})
        int negative(PRandom random, int k) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.NUMBER_OF_BITS_MUST_BE_NON_NEGATIVE);
        }

        @Specialization(guards={"k == 0"})
        int zero(PRandom random, int k) {
            return 0;
        }

        @Specialization(guards={"k >= 1", "k <= 31"})
        @CompilerDirectives.TruffleBoundary
        int genInt(PRandom random, int k) {
            return random.nextInt() >>> 32 - k;
        }

        @Specialization(guards={"k == 32"})
        @CompilerDirectives.TruffleBoundary
        long gen32Bits(PRandom random, int k) {
            return (long)random.nextInt() & 0xFFFFFFFFL;
        }

        @Specialization(guards={"k >= 33", "k <= 63"})
        @CompilerDirectives.TruffleBoundary
        long genLong(PRandom random, int k) {
            long x = (long)random.nextInt() & 0xFFFFFFFFL;
            long y = random.nextInt() >>> 64 - k;
            return y << 32 | x;
        }

        @Specialization(guards={"k >= 64"})
        @CompilerDirectives.TruffleBoundary
        PInt genBigInteger(PRandom random, int k) {
            int ints = (k + 31) / 32;
            ByteBuffer bb = ByteBuffer.wrap(new byte[4 * ints]).order(ByteOrder.BIG_ENDIAN);
            for (int i = ints - 1; i > 0; --i) {
                int x = random.nextInt();
                bb.putInt(4 * i, x);
            }
            bb.putInt(0, random.nextInt() >>> 32 - k % 32);
            return this.factory().createInt(new BigInteger(1, bb.array()));
        }
    }

    @Builtin(name="random", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class RandomNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        double random(PRandom random) {
            return random.nextDouble();
        }
    }

    @Builtin(name="getstate", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetStateNode
    extends PythonBuiltinNode {
        @Specialization
        PTuple getstate(PRandom random) {
            return this.factory().createTuple(GetStateNode.encodeState(random));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object[] encodeState(PRandom random) {
            int[] state = random.getState();
            Object[] encodedState = new Object[625];
            for (int i = 0; i < 624; ++i) {
                encodedState[i] = state[i] < 0 ? (Number)((long)state[i] & 0xFFFFFFFFL) : (Number)state[i];
            }
            encodedState[624] = random.getIndex();
            return encodedState;
        }
    }

    @Builtin(name="setstate", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBuiltinNode {
        @Specialization
        PNone setstate(PRandom random, PTuple tuple, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached CastToJavaUnsignedLongNode castNode) {
            Object[] arr = getObjectArrayNode.execute(inliningTarget, tuple);
            if (arr.length != 625) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.STATE_VECTOR_INVALID);
            }
            int[] state = new int[624];
            for (int i = 0; i < 624; ++i) {
                long l = castNode.execute(inliningTarget, arr[i]);
                state[i] = (int)l;
            }
            long index = castNode.execute(inliningTarget, arr[624]);
            if (index < 0L || index > 624L) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.STATE_VECTOR_INVALID);
            }
            random.restore(state, (int)index);
            return PNone.NONE;
        }

        @Fallback
        Object setstate(Object random, Object state) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.STATE_VECTOR_MUST_BE_A_TUPLE);
        }
    }

    @Builtin(name="seed", minNumOfPositionalArgs=1, parameterNames={"$self", "seed"})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class SeedNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone seedNone(PRandom random, PNone none) {
            SecureRandom secureRandom = this.getContext().getSecureRandom();
            int[] seed = new int[624];
            for (int i = 0; i < seed.length; ++i) {
                seed[i] = secureRandom.nextInt();
            }
            random.seed(seed);
            return PNone.NONE;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PNone seedLong(PRandom random, long inputSeed) {
            long absSeed = Math.abs(inputSeed);
            int hi = (int)(absSeed >>> 32);
            int lo = (int)absSeed;
            if (hi == 0) {
                random.seed(new int[]{lo});
            } else {
                random.seed(new int[]{lo, hi});
            }
            return PNone.NONE;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PNone seedBigInteger(PRandom random, PInt inputSeed) {
            byte[] bytes = inputSeed.abs().toByteArray();
            int startPos = bytes.length > 1 && bytes[0] == 0 ? 1 : 0;
            int numberOfBytes = bytes.length - startPos;
            int numberOfInts = numberOfBytes + 3 >> 2;
            ByteBuffer bb = ByteBuffer.allocate(numberOfInts * 4);
            bb.order(ByteOrder.BIG_ENDIAN);
            bb.position(bb.capacity() - numberOfBytes);
            bb.put(bytes, startPos, numberOfBytes);
            bb.rewind();
            int[] ints = new int[numberOfInts];
            for (int i = numberOfInts - 1; i >= 0; --i) {
                ints[i] = bb.getInt();
            }
            random.seed(ints);
            return PNone.NONE;
        }

        @Specialization(guards={"!canBeInteger(inputSeed)", "!isPNone(inputSeed)"})
        static PNone seedGeneric(VirtualFrame frame, PRandom random, Object inputSeed, @Bind(value="this") Node inliningTarget, @Cached PyObjectHashNode hash) {
            return SeedNode.seedLong(random, hash.execute((Frame)frame, inliningTarget, inputSeed));
        }
    }
}

