/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.WritableBufferConversionNodeGen;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;

public abstract class WritableBufferConversionNode
extends ArgumentCastNode.ArgumentCastNodeWithRaiseAndIndirectCall {
    private final String builtinName;

    public WritableBufferConversionNode(String builtinName) {
        this.builtinName = builtinName;
    }

    @Specialization(limit="getCallSiteInlineCacheMaxDepth()")
    Object doObject(VirtualFrame frame, Object value, @CachedLibrary(value="value") PythonBufferAcquireLibrary acquireLib) {
        try {
            return acquireLib.acquireWritable(value, frame, this.getContext(), this.getLanguage(), this);
        }
        catch (PException e) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.S_BRACKETS_ARG_MUST_BE_READ_WRITE_BYTES_LIKE_NOT_P, this.builtinName, value);
        }
    }

    @ClinicConverterFactory
    @NeverDefault
    public static WritableBufferConversionNode create(@ClinicConverterFactory.BuiltinName String builtinName) {
        return WritableBufferConversionNodeGen.create(builtinName);
    }
}

