/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.formatting;

import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.formatting.FormattingBuffer;
import com.oracle.graal.python.runtime.formatting.InternalFormat;

public class TextFormatter
extends InternalFormat.Formatter {
    public TextFormatter(PRaiseNode raiseNode, FormattingBuffer result, InternalFormat.Spec spec) {
        super(raiseNode, result, spec);
    }

    public TextFormatter(PRaiseNode raiseNode, InternalFormat.Spec spec) {
        super(raiseNode, new FormattingBuffer.StringFormattingBuffer(32), spec);
    }

    @Override
    public TextFormatter append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public TextFormatter append(CharSequence csq) {
        super.append(csq);
        return this;
    }

    @Override
    public TextFormatter append(CharSequence csq, int begin, int end) throws IndexOutOfBoundsException {
        super.append(csq, begin, end);
        return this;
    }

    public TextFormatter format(CharSequence value) {
        this.setStart();
        int p = this.spec.precision;
        int n = value.length();
        if (InternalFormat.Spec.specified(p) && p < n) {
            int space = Math.max(this.spec.width, p);
            this.result.ensureAdditionalCapacity(space + (this.bytes ? 0 : space / 4));
            int count = 0;
            while (count < p) {
                char c = value.charAt(count++);
                this.result.append(c);
                if (!Character.isHighSurrogate(c) || p >= n) continue;
                ++p;
            }
            this.lenWhole = count;
        } else {
            this.lenWhole = n;
            this.result.append(value);
        }
        return this;
    }

    @Override
    public TextFormatter pad() {
        int n = this.spec.width - this.result.codePointCount(this.mark, this.result.length());
        if (n > 0) {
            this.pad(this.mark, n);
        }
        return this;
    }
}

