// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.modules.BinasciiModuleBuiltins.A2bBase64Node;
import com.oracle.graal.python.builtins.modules.BinasciiModuleBuiltins.A2bHexNode;
import com.oracle.graal.python.builtins.modules.BinasciiModuleBuiltins.AsciiBufferConverter;
import com.oracle.graal.python.builtins.modules.BinasciiModuleBuiltins.B2aBase64Node;
import com.oracle.graal.python.builtins.modules.BinasciiModuleBuiltins.B2aHexNode;
import com.oracle.graal.python.builtins.modules.BinasciiModuleBuiltins.Crc32Node;
import com.oracle.graal.python.builtins.modules.BinasciiModuleBuiltins.HexlifyNode;
import com.oracle.graal.python.builtins.modules.BinasciiModuleBuiltins.UnhexlifyNode;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNodeGen;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleString.GetCodeRangeNode;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(BinasciiModuleBuiltins.class)
@SuppressWarnings("javadoc")
public final class BinasciiModuleBuiltinsFactory {

    private static final LibraryFactory<PythonBufferAcquireLibrary> PYTHON_BUFFER_ACQUIRE_LIBRARY_ = LibraryFactory.resolve(PythonBufferAcquireLibrary.class);
    private static final LibraryFactory<PythonBufferAccessLibrary> PYTHON_BUFFER_ACCESS_LIBRARY_ = LibraryFactory.resolve(PythonBufferAccessLibrary.class);

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(A2bBase64NodeFactory.getInstance(), A2bHexNodeFactory.getInstance(), B2aBase64NodeFactory.getInstance(), B2aHexNodeFactory.getInstance(), Crc32NodeFactory.getInstance(), HexlifyNodeFactory.getInstance(), UnhexlifyNodeFactory.getInstance());
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link AsciiBufferConverter#doObject}
     *     Activation probability: 0.27381
     *     With/without class size: 10/4 bytes
     *   Specialization {@link AsciiBufferConverter#doObject}
     *     Activation probability: 0.23095
     *     With/without class size: 6/0 bytes
     *   Specialization {@link AsciiBufferConverter#asciiString}
     *     Activation probability: 0.18810
     *     With/without class size: 6/0 bytes
     *   Specialization {@link AsciiBufferConverter#nonAsciiString}
     *     Activation probability: 0.14524
     *     With/without class size: 5/0 bytes
     *   Specialization {@link AsciiBufferConverter#string}
     *     Activation probability: 0.10238
     *     With/without class size: 7/14 bytes
     *   Specialization {@link AsciiBufferConverter#error}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(AsciiBufferConverter.class)
    @SuppressWarnings("javadoc")
    static final class AsciiBufferConverterNodeGen extends AsciiBufferConverter {

        private static final StateField STRING__ASCII_BUFFER_CONVERTER_STRING_STATE_0_UPDATER = StateField.create(StringData.lookup_(), "string_state_0_");
        static final ReferenceField<Object0Data> OBJECT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "object0_cache", Object0Data.class);
        /**
         * Source Info: <pre>
         *   Specialization: {@link AsciiBufferConverter#string}
         *   Parameter: {@link CastToTruffleStringNode} cast
         *   Inline method: {@link CastToTruffleStringNodeGen#inline}</pre>
         */
        private static final CastToTruffleStringNode INLINED_STRING_CAST_ = CastToTruffleStringNodeGen.inline(InlineTarget.create(CastToTruffleStringNode.class, STRING__ASCII_BUFFER_CONVERTER_STRING_STATE_0_UPDATER.subUpdater(0, 8), ReferenceField.create(StringData.lookup_(), "string_cast__field1_", Node.class), ReferenceField.create(StringData.lookup_(), "string_cast__field2_", Node.class), ReferenceField.create(StringData.lookup_(), "string_cast__field3_", Node.class)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AsciiBufferConverter#string}
         *   Parameter: {@link InlinedConditionProfile} asciiProfile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre>
         */
        private static final InlinedConditionProfile INLINED_STRING_ASCII_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STRING__ASCII_BUFFER_CONVERTER_STRING_STATE_0_UPDATER.subUpdater(8, 2)));

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link AsciiBufferConverter#doObject}
         *   1: SpecializationActive {@link AsciiBufferConverter#doObject}
         *   2: SpecializationActive {@link AsciiBufferConverter#asciiString}
         *   3: GuardActive[guardIndex=0] {@link AsciiBufferConverter#asciiString}
         *   4: SpecializationActive {@link AsciiBufferConverter#nonAsciiString}
         *   5: GuardActive[guardIndex=0] {@link AsciiBufferConverter#nonAsciiString}
         *   6: SpecializationActive {@link AsciiBufferConverter#string}
         *   7: SpecializationActive {@link AsciiBufferConverter#error}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link AsciiBufferConverter#asciiString}
         *   Parameter: {@link GetCodeRangeNode} getCodeRangeNode</pre>
         */
        @Child private GetCodeRangeNode getCodeRange;
        @UnsafeAccessedField @Child private Object0Data object0_cache;
        @Child private StringData string_cache;

        private AsciiBufferConverterNodeGen() {
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Object arg0Value) {
            if (!((state_0 & 0b10) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.doObject(VirtualFrame, Object, PythonBufferAcquireLibrary)] */) && ((PYTHON_BUFFER_ACQUIRE_LIBRARY_.getUncached()).hasBuffer(arg0Value))) {
                return false;
            }
            if (arg0Value instanceof TruffleString) {
                {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    GetCodeRangeNode getCodeRange_ = this.getCodeRange;
                    if ((((state_0 & 0b1000)) == 0 /* is-not GuardActive[specialization=BinasciiModuleBuiltins.AsciiBufferConverter.asciiString(TruffleString, GetCodeRangeNode), guardIndex=0] */ || getCodeRange_ == null || (PGuards.isAscii(arg0Value_, getCodeRange_)))) {
                        return false;
                    }
                }
                {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    GetCodeRangeNode getCodeRange_1 = this.getCodeRange;
                    if ((((state_0 & 0b100000)) == 0 /* is-not GuardActive[specialization=BinasciiModuleBuiltins.AsciiBufferConverter.nonAsciiString(TruffleString, GetCodeRangeNode), guardIndex=0] */ || getCodeRange_1 == null || (!(PGuards.isAscii(arg0Value_, getCodeRange_1))))) {
                        return false;
                    }
                }
            }
            if (!((state_0 & 0b1000000) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.string(PString, Node, CastToTruffleStringNode, GetCodeRangeNode, InlinedConditionProfile)] */) && arg0Value instanceof PString) {
                return false;
            }
            return true;
        }

        @ExplodeLoop
        @Override
        public Object execute(VirtualFrame frameValue, Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11010111) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.doObject(VirtualFrame, Object, PythonBufferAcquireLibrary)] || SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.doObject(VirtualFrame, Object, PythonBufferAcquireLibrary)] || SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.asciiString(TruffleString, GetCodeRangeNode)] || SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.nonAsciiString(TruffleString, GetCodeRangeNode)] || SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.string(PString, Node, CastToTruffleStringNode, GetCodeRangeNode, InlinedConditionProfile)] || SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.error(Object)] */) {
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.doObject(VirtualFrame, Object, PythonBufferAcquireLibrary)] || SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.doObject(VirtualFrame, Object, PythonBufferAcquireLibrary)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.doObject(VirtualFrame, Object, PythonBufferAcquireLibrary)] */) {
                        Object0Data s0_ = this.object0_cache;
                        while (s0_ != null) {
                            if ((s0_.acquireLib_.accepts(arg0Value)) && (s0_.acquireLib_.hasBuffer(arg0Value))) {
                                return doObject(frameValue, arg0Value, s0_.acquireLib_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.doObject(VirtualFrame, Object, PythonBufferAcquireLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                PythonBufferAcquireLibrary acquireLib__ = (PYTHON_BUFFER_ACQUIRE_LIBRARY_.getUncached());
                                if ((acquireLib__.hasBuffer(arg0Value))) {
                                    return doObject(frameValue, arg0Value, acquireLib__);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if ((state_0 & 0b10100) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.asciiString(TruffleString, GetCodeRangeNode)] || SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.nonAsciiString(TruffleString, GetCodeRangeNode)] */ && arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.asciiString(TruffleString, GetCodeRangeNode)] */) {
                        {
                            GetCodeRangeNode getCodeRange_ = this.getCodeRange;
                            if (getCodeRange_ != null) {
                                if ((PGuards.isAscii(arg0Value_, getCodeRange_))) {
                                    return asciiString(arg0Value_, getCodeRange_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.nonAsciiString(TruffleString, GetCodeRangeNode)] */) {
                        {
                            GetCodeRangeNode getCodeRange_1 = this.getCodeRange;
                            if (getCodeRange_1 != null) {
                                if ((!(PGuards.isAscii(arg0Value_, getCodeRange_1)))) {
                                    return nonAsciiString(arg0Value_, getCodeRange_1);
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.string(PString, Node, CastToTruffleStringNode, GetCodeRangeNode, InlinedConditionProfile)] */ && arg0Value instanceof PString) {
                    PString arg0Value_ = (PString) arg0Value;
                    StringData s4_ = this.string_cache;
                    if (s4_ != null) {
                        {
                            GetCodeRangeNode getCodeRange_2 = this.getCodeRange;
                            if (getCodeRange_2 != null) {
                                Node inliningTarget__ = (s4_);
                                return string(arg0Value_, inliningTarget__, INLINED_STRING_CAST_, getCodeRange_2, INLINED_STRING_ASCII_PROFILE_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.error(Object)] */) {
                    if (fallbackGuard_(state_0, arg0Value)) {
                        return error(arg0Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, arg0Value);
        }

        @SuppressWarnings("unused")
        private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
            int state_0 = this.state_0_;
            if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.doObject(VirtualFrame, Object, PythonBufferAcquireLibrary)] */) {
                while (true) {
                    int count0_ = 0;
                    Object0Data s0_ = OBJECT0_CACHE_UPDATER.getVolatile(this);
                    Object0Data s0_original = s0_;
                    while (s0_ != null) {
                        if ((s0_.acquireLib_.accepts(arg0Value)) && (s0_.acquireLib_.hasBuffer(arg0Value))) {
                            break;
                        }
                        count0_++;
                        s0_ = s0_.next_;
                    }
                    if (s0_ == null) {
                        {
                            PythonBufferAcquireLibrary acquireLib__ = this.insert((PYTHON_BUFFER_ACQUIRE_LIBRARY_.create(arg0Value)));
                            // assert (s0_.acquireLib_.accepts(arg0Value));
                            if ((acquireLib__.hasBuffer(arg0Value)) && count0_ < (PythonOptions.getCallSiteInlineCacheMaxDepth())) {
                                s0_ = this.insert(new Object0Data(s0_original));
                                Objects.requireNonNull(s0_.insert(acquireLib__), "Specialization 'doObject(VirtualFrame, Object, PythonBufferAcquireLibrary)' cache 'acquireLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.acquireLib_ = acquireLib__;
                                if (!OBJECT0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1 /* add SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.doObject(VirtualFrame, Object, PythonBufferAcquireLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                    if (s0_ != null) {
                        return doObject(frameValue, arg0Value, s0_.acquireLib_);
                    }
                    break;
                }
            }
            {
                PythonBufferAcquireLibrary acquireLib__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        {
                            acquireLib__ = (PYTHON_BUFFER_ACQUIRE_LIBRARY_.getUncached());
                            if ((acquireLib__.hasBuffer(arg0Value))) {
                                this.object0_cache = null;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.doObject(VirtualFrame, Object, PythonBufferAcquireLibrary)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.doObject(VirtualFrame, Object, PythonBufferAcquireLibrary)] */;
                                this.state_0_ = state_0;
                                return doObject(frameValue, arg0Value, acquireLib__);
                            }
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            if (arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                {
                    GetCodeRangeNode getCodeRange_;
                    GetCodeRangeNode getCodeRange__shared = this.getCodeRange;
                    if (getCodeRange__shared != null) {
                        getCodeRange_ = getCodeRange__shared;
                    } else {
                        getCodeRange_ = this.insert((GetCodeRangeNode.create()));
                        if (getCodeRange_ == null) {
                            throw new IllegalStateException("Specialization 'asciiString(TruffleString, GetCodeRangeNode)' contains a shared cache with name 'getCodeRangeNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (((state_0 & 0b1000)) == 0 /* is-not GuardActive[specialization=BinasciiModuleBuiltins.AsciiBufferConverter.asciiString(TruffleString, GetCodeRangeNode), guardIndex=0] */) {
                        if (this.getCodeRange == null) {
                            VarHandle.storeStoreFence();
                            this.getCodeRange = getCodeRange_;
                        }
                        state_0 = state_0 | 0b1000 /* add GuardActive[specialization=BinasciiModuleBuiltins.AsciiBufferConverter.asciiString(TruffleString, GetCodeRangeNode), guardIndex=0] */;
                    }
                    if ((PGuards.isAscii(arg0Value_, getCodeRange_))) {
                        if (this.getCodeRange == null) {
                            VarHandle.storeStoreFence();
                            this.getCodeRange = getCodeRange_;
                        }
                        state_0 = state_0 | 0b100 /* add SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.asciiString(TruffleString, GetCodeRangeNode)] */;
                        this.state_0_ = state_0;
                        return asciiString(arg0Value_, getCodeRange_);
                    }
                }
                {
                    GetCodeRangeNode getCodeRange_1;
                    GetCodeRangeNode getCodeRange_1_shared = this.getCodeRange;
                    if (getCodeRange_1_shared != null) {
                        getCodeRange_1 = getCodeRange_1_shared;
                    } else {
                        getCodeRange_1 = this.insert((GetCodeRangeNode.create()));
                        if (getCodeRange_1 == null) {
                            throw new IllegalStateException("Specialization 'nonAsciiString(TruffleString, GetCodeRangeNode)' contains a shared cache with name 'getCodeRangeNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (((state_0 & 0b100000)) == 0 /* is-not GuardActive[specialization=BinasciiModuleBuiltins.AsciiBufferConverter.nonAsciiString(TruffleString, GetCodeRangeNode), guardIndex=0] */) {
                        if (this.getCodeRange == null) {
                            VarHandle.storeStoreFence();
                            this.getCodeRange = getCodeRange_1;
                        }
                        state_0 = state_0 | 0b100000 /* add GuardActive[specialization=BinasciiModuleBuiltins.AsciiBufferConverter.nonAsciiString(TruffleString, GetCodeRangeNode), guardIndex=0] */;
                    }
                    if ((!(PGuards.isAscii(arg0Value_, getCodeRange_1)))) {
                        if (this.getCodeRange == null) {
                            VarHandle.storeStoreFence();
                            this.getCodeRange = getCodeRange_1;
                        }
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.nonAsciiString(TruffleString, GetCodeRangeNode)] */;
                        this.state_0_ = state_0;
                        return nonAsciiString(arg0Value_, getCodeRange_1);
                    }
                }
            }
            {
                Node inliningTarget__ = null;
                if (arg0Value instanceof PString) {
                    PString arg0Value_ = (PString) arg0Value;
                    StringData s4_ = this.insert(new StringData());
                    inliningTarget__ = (s4_);
                    GetCodeRangeNode getCodeRange_2;
                    GetCodeRangeNode getCodeRange_2_shared = this.getCodeRange;
                    if (getCodeRange_2_shared != null) {
                        getCodeRange_2 = getCodeRange_2_shared;
                    } else {
                        getCodeRange_2 = s4_.insert((GetCodeRangeNode.create()));
                        if (getCodeRange_2 == null) {
                            throw new IllegalStateException("Specialization 'string(PString, Node, CastToTruffleStringNode, GetCodeRangeNode, InlinedConditionProfile)' contains a shared cache with name 'getCodeRangeNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.getCodeRange == null) {
                        this.getCodeRange = getCodeRange_2;
                    }
                    VarHandle.storeStoreFence();
                    this.string_cache = s4_;
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.string(PString, Node, CastToTruffleStringNode, GetCodeRangeNode, InlinedConditionProfile)] */;
                    this.state_0_ = state_0;
                    return string(arg0Value_, inliningTarget__, INLINED_STRING_CAST_, getCodeRange_2, INLINED_STRING_ASCII_PROFILE_);
                }
            }
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[BinasciiModuleBuiltins.AsciiBufferConverter.error(Object)] */;
            this.state_0_ = state_0;
            return error(arg0Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11010111) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11010111) & ((state_0 & 0b11010111) - 1)) == 0 /* is-single  */) {
                    Object0Data s0_ = this.object0_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static AsciiBufferConverter create() {
            return new AsciiBufferConverterNodeGen();
        }

        @GeneratedBy(AsciiBufferConverter.class)
        @DenyReplace
        private static final class Object0Data extends Node implements SpecializationDataNode {

            @Child Object0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AsciiBufferConverter#doObject}
             *   Parameter: {@link PythonBufferAcquireLibrary} acquireLib</pre>
             */
            @Child PythonBufferAcquireLibrary acquireLib_;

            Object0Data(Object0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(AsciiBufferConverter.class)
        @DenyReplace
        private static final class StringData extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0-7: InlinedCache
             *        Specialization: {@link AsciiBufferConverter#string}
             *        Parameter: {@link CastToTruffleStringNode} cast
             *        Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link AsciiBufferConverter#string}
             *        Parameter: {@link InlinedConditionProfile} asciiProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int string_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AsciiBufferConverter#string}
             *   Parameter: {@link CastToTruffleStringNode} cast
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node string_cast__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AsciiBufferConverter#string}
             *   Parameter: {@link CastToTruffleStringNode} cast
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node string_cast__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AsciiBufferConverter#string}
             *   Parameter: {@link CastToTruffleStringNode} cast
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node string_cast__field3_;

            StringData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
    }
    @GeneratedBy(A2bBase64Node.class)
    static final class A2bBase64NodeFactory implements NodeFactory<A2bBase64Node> {

        private static final A2bBase64NodeFactory A2B_BASE64_NODE_FACTORY_INSTANCE = new A2bBase64NodeFactory();

        private A2bBase64NodeFactory() {
        }

        @Override
        public Class<A2bBase64Node> getNodeClass() {
            return A2bBase64Node.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public A2bBase64Node createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<A2bBase64Node> getInstance() {
            return A2B_BASE64_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static A2bBase64Node create() {
            return new A2bBase64NodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link A2bBase64Node#doConvert}
         *     Activation probability: 0.65000
         *     With/without class size: 19/4 bytes
         *   Specialization {@link A2bBase64Node#doConvert}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre>
         */
        @GeneratedBy(A2bBase64Node.class)
        @SuppressWarnings("javadoc")
        static final class A2bBase64NodeGen extends A2bBase64Node {

            static final ReferenceField<Convert0Data> CONVERT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "convert0_cache", Convert0Data.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link A2bBase64Node#doConvert}
             *   1: SpecializationActive {@link A2bBase64Node#doConvert}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private Convert0Data convert0_cache;

            private A2bBase64NodeGen() {
            }

            @ExplodeLoop
            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[BinasciiModuleBuiltins.A2bBase64Node.doConvert(VirtualFrame, Object, PythonBufferAccessLibrary)] || SpecializationActive[BinasciiModuleBuiltins.A2bBase64Node.doConvert(VirtualFrame, Object, PythonBufferAccessLibrary)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.A2bBase64Node.doConvert(VirtualFrame, Object, PythonBufferAccessLibrary)] */) {
                        Convert0Data s0_ = this.convert0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg0Value))) {
                                return doConvert(frameValue, arg0Value, s0_.bufferLib_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.A2bBase64Node.doConvert(VirtualFrame, Object, PythonBufferAccessLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                return doConvert(frameValue, arg0Value, bufferLib__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private PBytes executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[BinasciiModuleBuiltins.A2bBase64Node.doConvert(VirtualFrame, Object, PythonBufferAccessLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        Convert0Data s0_ = CONVERT0_CACHE_UPDATER.getVolatile(this);
                        Convert0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg0Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (s0_.bufferLib_.accepts(arg0Value));
                            if (count0_ < (3)) {
                                s0_ = this.insert(new Convert0Data(s0_original));
                                PythonBufferAccessLibrary bufferLib__ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arg0Value)));
                                Objects.requireNonNull(bufferLib__, "Specialization 'doConvert(VirtualFrame, Object, PythonBufferAccessLibrary)' cache 'bufferLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.bufferLib_ = bufferLib__;
                                if (!CONVERT0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1 /* add SpecializationActive[BinasciiModuleBuiltins.A2bBase64Node.doConvert(VirtualFrame, Object, PythonBufferAccessLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            return doConvert(frameValue, arg0Value, s0_.bufferLib_);
                        }
                        break;
                    }
                }
                {
                    PythonBufferAccessLibrary bufferLib__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                            this.convert0_cache = null;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[BinasciiModuleBuiltins.A2bBase64Node.doConvert(VirtualFrame, Object, PythonBufferAccessLibrary)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationActive[BinasciiModuleBuiltins.A2bBase64Node.doConvert(VirtualFrame, Object, PythonBufferAccessLibrary)] */;
                            this.state_0_ = state_0;
                            return doConvert(frameValue, arg0Value, bufferLib__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        Convert0Data s0_ = this.convert0_cache;
                        if ((s0_ == null || s0_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(A2bBase64Node.class)
            @DenyReplace
            private static final class Convert0Data extends Node implements SpecializationDataNode {

                @Child Convert0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link A2bBase64Node#doConvert}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre>
                 */
                @Child PythonBufferAccessLibrary bufferLib_;

                Convert0Data(Convert0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
    }
    @GeneratedBy(A2bHexNode.class)
    static final class A2bHexNodeFactory implements NodeFactory<A2bHexNode> {

        private static final A2bHexNodeFactory A2B_HEX_NODE_FACTORY_INSTANCE = new A2bHexNodeFactory();

        private A2bHexNodeFactory() {
        }

        @Override
        public Class<A2bHexNode> getNodeClass() {
            return A2bHexNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public A2bHexNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<A2bHexNode> getInstance() {
            return A2B_HEX_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static A2bHexNode create() {
            return new A2bHexNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link A2bHexNode#a2b(VirtualFrame, Object, PythonBufferAccessLibrary)}
         *     Activation probability: 0.65000
         *     With/without class size: 19/4 bytes
         *   Specialization {@link A2bHexNode#a2b(VirtualFrame, Object, PythonBufferAccessLibrary)}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre>
         */
        @GeneratedBy(A2bHexNode.class)
        @SuppressWarnings("javadoc")
        static final class A2bHexNodeGen extends A2bHexNode {

            static final ReferenceField<A2b0Data> A2B0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "a2b0_cache", A2b0Data.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link A2bHexNode#a2b(VirtualFrame, Object, PythonBufferAccessLibrary)}
             *   1: SpecializationActive {@link A2bHexNode#a2b(VirtualFrame, Object, PythonBufferAccessLibrary)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private A2b0Data a2b0_cache;

            private A2bHexNodeGen() {
            }

            @ExplodeLoop
            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] || SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */) {
                        A2b0Data s0_ = this.a2b0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg0Value))) {
                                return a2b(frameValue, arg0Value, s0_.bufferLib_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                return a2b(frameValue, arg0Value, bufferLib__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private PBytes executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        A2b0Data s0_ = A2B0_CACHE_UPDATER.getVolatile(this);
                        A2b0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg0Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (s0_.bufferLib_.accepts(arg0Value));
                            if (count0_ < (3)) {
                                s0_ = this.insert(new A2b0Data(s0_original));
                                PythonBufferAccessLibrary bufferLib__ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arg0Value)));
                                Objects.requireNonNull(bufferLib__, "Specialization 'a2b(VirtualFrame, Object, PythonBufferAccessLibrary)' cache 'bufferLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.bufferLib_ = bufferLib__;
                                if (!A2B0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1 /* add SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            return a2b(frameValue, arg0Value, s0_.bufferLib_);
                        }
                        break;
                    }
                }
                {
                    PythonBufferAccessLibrary bufferLib__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                            this.a2b0_cache = null;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */;
                            this.state_0_ = state_0;
                            return a2b(frameValue, arg0Value, bufferLib__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        A2b0Data s0_ = this.a2b0_cache;
                        if ((s0_ == null || s0_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(A2bHexNode.class)
            @DenyReplace
            private static final class A2b0Data extends Node implements SpecializationDataNode {

                @Child A2b0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link A2bHexNode#a2b(VirtualFrame, Object, PythonBufferAccessLibrary)}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre>
                 */
                @Child PythonBufferAccessLibrary bufferLib_;

                A2b0Data(A2b0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
    }
    @GeneratedBy(B2aBase64Node.class)
    static final class B2aBase64NodeFactory implements NodeFactory<B2aBase64Node> {

        private static final B2aBase64NodeFactory B2A_BASE64_NODE_FACTORY_INSTANCE = new B2aBase64NodeFactory();

        private B2aBase64NodeFactory() {
        }

        @Override
        public Class<B2aBase64Node> getNodeClass() {
            return B2aBase64Node.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public B2aBase64Node createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<B2aBase64Node> getInstance() {
            return B2A_BASE64_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static B2aBase64Node create(ReadArgumentNode[] arguments) {
            return new B2aBase64NodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link B2aBase64Node#b2aBuffer}
         *     Activation probability: 0.65000
         *     With/without class size: 19/4 bytes
         *   Specialization {@link B2aBase64Node#b2aBuffer}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre>
         */
        @GeneratedBy(B2aBase64Node.class)
        @SuppressWarnings("javadoc")
        static final class B2aBase64NodeGen extends B2aBase64Node {

            static final ReferenceField<B2aBuffer0Data> B2A_BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "b2aBuffer0_cache", B2aBuffer0Data.class);

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link B2aBase64Node#b2aBuffer}
             *   1: SpecializationActive {@link B2aBase64Node#b2aBuffer}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private B2aBuffer0Data b2aBuffer0_cache;

            private B2aBase64NodeGen(ReadArgumentNode[] arguments) {
                ReadArgumentNode[] arguments_ = arguments != null ? createCasts(arguments) : null;
                this.arguments0_ = arguments_ != null && 0 < arguments_.length ? arguments_[0] : null;
                this.arguments1_ = arguments_ != null && 1 < arguments_.length ? arguments_[1] : null;
            }

            @ExplodeLoop
            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aBase64Node.b2aBuffer(VirtualFrame, Object, int, PythonBufferAccessLibrary)] || SpecializationActive[BinasciiModuleBuiltins.B2aBase64Node.b2aBuffer(VirtualFrame, Object, int, PythonBufferAccessLibrary)] */ && arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (int) arguments1Value_;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aBase64Node.b2aBuffer(VirtualFrame, Object, int, PythonBufferAccessLibrary)] */) {
                        B2aBuffer0Data s0_ = this.b2aBuffer0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arguments0Value_))) {
                                return b2aBuffer(frameValue, arguments0Value_, arguments1Value__, s0_.bufferLib_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aBase64Node.b2aBuffer(VirtualFrame, Object, int, PythonBufferAccessLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                return b2aBuffer(frameValue, arguments0Value_, arguments1Value__, bufferLib__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_);
            }

            private PBytes executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                if (arguments1Value instanceof Integer) {
                    int arguments1Value_ = (int) arguments1Value;
                    if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[BinasciiModuleBuiltins.B2aBase64Node.b2aBuffer(VirtualFrame, Object, int, PythonBufferAccessLibrary)] */) {
                        while (true) {
                            int count0_ = 0;
                            B2aBuffer0Data s0_ = B2A_BUFFER0_CACHE_UPDATER.getVolatile(this);
                            B2aBuffer0Data s0_original = s0_;
                            while (s0_ != null) {
                                if ((s0_.bufferLib_.accepts(arguments0Value))) {
                                    break;
                                }
                                count0_++;
                                s0_ = s0_.next_;
                            }
                            if (s0_ == null) {
                                // assert (s0_.bufferLib_.accepts(arguments0Value));
                                if (count0_ < (3)) {
                                    s0_ = this.insert(new B2aBuffer0Data(s0_original));
                                    PythonBufferAccessLibrary bufferLib__ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arguments0Value)));
                                    Objects.requireNonNull(bufferLib__, "Specialization 'b2aBuffer(VirtualFrame, Object, int, PythonBufferAccessLibrary)' cache 'bufferLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s0_.bufferLib_ = bufferLib__;
                                    if (!B2A_BUFFER0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[BinasciiModuleBuiltins.B2aBase64Node.b2aBuffer(VirtualFrame, Object, int, PythonBufferAccessLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s0_ != null) {
                                return b2aBuffer(frameValue, arguments0Value, arguments1Value_, s0_.bufferLib_);
                            }
                            break;
                        }
                    }
                    {
                        PythonBufferAccessLibrary bufferLib__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                this.b2aBuffer0_cache = null;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[BinasciiModuleBuiltins.B2aBase64Node.b2aBuffer(VirtualFrame, Object, int, PythonBufferAccessLibrary)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationActive[BinasciiModuleBuiltins.B2aBase64Node.b2aBuffer(VirtualFrame, Object, int, PythonBufferAccessLibrary)] */;
                                this.state_0_ = state_0;
                                return b2aBuffer(frameValue, arguments0Value, arguments1Value_, bufferLib__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        B2aBuffer0Data s0_ = this.b2aBuffer0_cache;
                        if ((s0_ == null || s0_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(B2aBase64Node.class)
            @DenyReplace
            private static final class B2aBuffer0Data extends Node implements SpecializationDataNode {

                @Child B2aBuffer0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link B2aBase64Node#b2aBuffer}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre>
                 */
                @Child PythonBufferAccessLibrary bufferLib_;

                B2aBuffer0Data(B2aBuffer0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
    }
    @GeneratedBy(B2aHexNode.class)
    static final class B2aHexNodeFactory implements NodeFactory<B2aHexNode> {

        private static final B2aHexNodeFactory B2A_HEX_NODE_FACTORY_INSTANCE = new B2aHexNodeFactory();

        private B2aHexNodeFactory() {
        }

        @Override
        public Class<B2aHexNode> getNodeClass() {
            return B2aHexNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public B2aHexNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<B2aHexNode> getInstance() {
            return B2A_HEX_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static B2aHexNode create() {
            return new B2aHexNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link B2aHexNode#b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)}
         *     Activation probability: 0.65000
         *     With/without class size: 19/4 bytes
         *   Specialization {@link B2aHexNode#b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre>
         */
        @GeneratedBy(B2aHexNode.class)
        @SuppressWarnings("javadoc")
        static final class B2aHexNodeGen extends B2aHexNode {

            static final ReferenceField<B2a0Data> B2A0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "b2a0_cache", B2a0Data.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link B2aHexNode#b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)}
             *   1: SpecializationActive {@link B2aHexNode#b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private B2a0Data b2a0_cache;

            private B2aHexNodeGen() {
            }

            @ExplodeLoop
            @Override
            protected Object execute1(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] || SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */ && arg2Value instanceof Integer) {
                    int arg2Value_ = (int) arg2Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */) {
                        B2a0Data s0_ = this.b2a0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg0Value))) {
                                return b2a(frameValue, arg0Value, arg1Value, arg2Value_, s0_.bufferLib_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                return b2a(frameValue, arg0Value, arg1Value, arg2Value_, bufferLib__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            @ExplodeLoop
            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] || SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */ && arg2Value instanceof Integer) {
                    int arg2Value_ = (int) arg2Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */) {
                        B2a0Data s0_ = this.b2a0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg0Value))) {
                                return b2a(frameValue, arg0Value, arg1Value, arg2Value_, s0_.bufferLib_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                return b2a(frameValue, arg0Value, arg1Value, arg2Value_, bufferLib__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private PBytes executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (arg2Value instanceof Integer) {
                    int arg2Value_ = (int) arg2Value;
                    if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */) {
                        while (true) {
                            int count0_ = 0;
                            B2a0Data s0_ = B2A0_CACHE_UPDATER.getVolatile(this);
                            B2a0Data s0_original = s0_;
                            while (s0_ != null) {
                                if ((s0_.bufferLib_.accepts(arg0Value))) {
                                    break;
                                }
                                count0_++;
                                s0_ = s0_.next_;
                            }
                            if (s0_ == null) {
                                // assert (s0_.bufferLib_.accepts(arg0Value));
                                if (count0_ < (3)) {
                                    s0_ = this.insert(new B2a0Data(s0_original));
                                    PythonBufferAccessLibrary bufferLib__ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arg0Value)));
                                    Objects.requireNonNull(bufferLib__, "Specialization 'b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)' cache 'bufferLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s0_.bufferLib_ = bufferLib__;
                                    if (!B2A0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s0_ != null) {
                                return b2a(frameValue, arg0Value, arg1Value, arg2Value_, s0_.bufferLib_);
                            }
                            break;
                        }
                    }
                    {
                        PythonBufferAccessLibrary bufferLib__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                this.b2a0_cache = null;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */;
                                this.state_0_ = state_0;
                                return b2a(frameValue, arg0Value, arg1Value, arg2Value_, bufferLib__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        B2a0Data s0_ = this.b2a0_cache;
                        if ((s0_ == null || s0_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(B2aHexNode.class)
            @DenyReplace
            private static final class B2a0Data extends Node implements SpecializationDataNode {

                @Child B2a0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link B2aHexNode#b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre>
                 */
                @Child PythonBufferAccessLibrary bufferLib_;

                B2a0Data(B2a0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
    }
    @GeneratedBy(Crc32Node.class)
    static final class Crc32NodeFactory implements NodeFactory<Crc32Node> {

        private static final Crc32NodeFactory CRC32_NODE_FACTORY_INSTANCE = new Crc32NodeFactory();

        private Crc32NodeFactory() {
        }

        @Override
        public Class<Crc32Node> getNodeClass() {
            return Crc32Node.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public Crc32Node createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<Crc32Node> getInstance() {
            return CRC32_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static Crc32Node create() {
            return new Crc32NodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link Crc32Node#b2a}
         *     Activation probability: 0.65000
         *     With/without class size: 19/4 bytes
         *   Specialization {@link Crc32Node#b2a}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre>
         */
        @GeneratedBy(Crc32Node.class)
        @SuppressWarnings("javadoc")
        static final class Crc32NodeGen extends Crc32Node {

            static final ReferenceField<B2a0Data> B2A0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "b2a0_cache", B2a0Data.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link Crc32Node#b2a}
             *   1: SpecializationActive {@link Crc32Node#b2a}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private B2a0Data b2a0_cache;

            private Crc32NodeGen() {
            }

            @ExplodeLoop
            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[BinasciiModuleBuiltins.Crc32Node.b2a(VirtualFrame, Object, long, PythonBufferAccessLibrary)] || SpecializationActive[BinasciiModuleBuiltins.Crc32Node.b2a(VirtualFrame, Object, long, PythonBufferAccessLibrary)] */ && arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.Crc32Node.b2a(VirtualFrame, Object, long, PythonBufferAccessLibrary)] */) {
                        B2a0Data s0_ = this.b2a0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg0Value))) {
                                return b2a(frameValue, arg0Value, arg1Value_, s0_.bufferLib_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.Crc32Node.b2a(VirtualFrame, Object, long, PythonBufferAccessLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                return b2a(frameValue, arg0Value, arg1Value_, bufferLib__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private long executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[BinasciiModuleBuiltins.Crc32Node.b2a(VirtualFrame, Object, long, PythonBufferAccessLibrary)] */) {
                        while (true) {
                            int count0_ = 0;
                            B2a0Data s0_ = B2A0_CACHE_UPDATER.getVolatile(this);
                            B2a0Data s0_original = s0_;
                            while (s0_ != null) {
                                if ((s0_.bufferLib_.accepts(arg0Value))) {
                                    break;
                                }
                                count0_++;
                                s0_ = s0_.next_;
                            }
                            if (s0_ == null) {
                                // assert (s0_.bufferLib_.accepts(arg0Value));
                                if (count0_ < (3)) {
                                    s0_ = this.insert(new B2a0Data(s0_original));
                                    PythonBufferAccessLibrary bufferLib__ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arg0Value)));
                                    Objects.requireNonNull(bufferLib__, "Specialization 'b2a(VirtualFrame, Object, long, PythonBufferAccessLibrary)' cache 'bufferLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s0_.bufferLib_ = bufferLib__;
                                    if (!B2A0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[BinasciiModuleBuiltins.Crc32Node.b2a(VirtualFrame, Object, long, PythonBufferAccessLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s0_ != null) {
                                return b2a(frameValue, arg0Value, arg1Value_, s0_.bufferLib_);
                            }
                            break;
                        }
                    }
                    {
                        PythonBufferAccessLibrary bufferLib__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                this.b2a0_cache = null;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[BinasciiModuleBuiltins.Crc32Node.b2a(VirtualFrame, Object, long, PythonBufferAccessLibrary)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationActive[BinasciiModuleBuiltins.Crc32Node.b2a(VirtualFrame, Object, long, PythonBufferAccessLibrary)] */;
                                this.state_0_ = state_0;
                                return b2a(frameValue, arg0Value, arg1Value_, bufferLib__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        B2a0Data s0_ = this.b2a0_cache;
                        if ((s0_ == null || s0_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(Crc32Node.class)
            @DenyReplace
            private static final class B2a0Data extends Node implements SpecializationDataNode {

                @Child B2a0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Crc32Node#b2a}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre>
                 */
                @Child PythonBufferAccessLibrary bufferLib_;

                B2a0Data(B2a0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
    }
    @GeneratedBy(HexlifyNode.class)
    static final class HexlifyNodeFactory implements NodeFactory<HexlifyNode> {

        private static final HexlifyNodeFactory HEXLIFY_NODE_FACTORY_INSTANCE = new HexlifyNodeFactory();

        private HexlifyNodeFactory() {
        }

        @Override
        public Class<HexlifyNode> getNodeClass() {
            return HexlifyNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public HexlifyNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<HexlifyNode> getInstance() {
            return HEXLIFY_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HexlifyNode create() {
            return new HexlifyNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link B2aHexNode#b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)}
         *     Activation probability: 0.65000
         *     With/without class size: 19/4 bytes
         *   Specialization {@link B2aHexNode#b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre>
         */
        @GeneratedBy(HexlifyNode.class)
        @SuppressWarnings("javadoc")
        static final class HexlifyNodeGen extends HexlifyNode {

            static final ReferenceField<B2a0Data> B2A0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "b2a0_cache", B2a0Data.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link B2aHexNode#b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)}
             *   1: SpecializationActive {@link B2aHexNode#b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private B2a0Data b2a0_cache;

            private HexlifyNodeGen() {
            }

            @ExplodeLoop
            @Override
            protected Object execute1(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] || SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */ && arg2Value instanceof Integer) {
                    int arg2Value_ = (int) arg2Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */) {
                        B2a0Data s0_ = this.b2a0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg0Value))) {
                                return b2a(frameValue, arg0Value, arg1Value, arg2Value_, s0_.bufferLib_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                return b2a(frameValue, arg0Value, arg1Value, arg2Value_, bufferLib__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            @ExplodeLoop
            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] || SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */ && arg2Value instanceof Integer) {
                    int arg2Value_ = (int) arg2Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */) {
                        B2a0Data s0_ = this.b2a0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg0Value))) {
                                return b2a(frameValue, arg0Value, arg1Value, arg2Value_, s0_.bufferLib_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                return b2a(frameValue, arg0Value, arg1Value, arg2Value_, bufferLib__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private PBytes executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (arg2Value instanceof Integer) {
                    int arg2Value_ = (int) arg2Value;
                    if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */) {
                        while (true) {
                            int count0_ = 0;
                            B2a0Data s0_ = B2A0_CACHE_UPDATER.getVolatile(this);
                            B2a0Data s0_original = s0_;
                            while (s0_ != null) {
                                if ((s0_.bufferLib_.accepts(arg0Value))) {
                                    break;
                                }
                                count0_++;
                                s0_ = s0_.next_;
                            }
                            if (s0_ == null) {
                                // assert (s0_.bufferLib_.accepts(arg0Value));
                                if (count0_ < (3)) {
                                    s0_ = this.insert(new B2a0Data(s0_original));
                                    PythonBufferAccessLibrary bufferLib__ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arg0Value)));
                                    Objects.requireNonNull(bufferLib__, "Specialization 'b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)' cache 'bufferLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s0_.bufferLib_ = bufferLib__;
                                    if (!B2A0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s0_ != null) {
                                return b2a(frameValue, arg0Value, arg1Value, arg2Value_, s0_.bufferLib_);
                            }
                            break;
                        }
                    }
                    {
                        PythonBufferAccessLibrary bufferLib__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                this.b2a0_cache = null;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationActive[BinasciiModuleBuiltins.B2aHexNode.b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)] */;
                                this.state_0_ = state_0;
                                return b2a(frameValue, arg0Value, arg1Value, arg2Value_, bufferLib__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        B2a0Data s0_ = this.b2a0_cache;
                        if ((s0_ == null || s0_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(HexlifyNode.class)
            @DenyReplace
            private static final class B2a0Data extends Node implements SpecializationDataNode {

                @Child B2a0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link B2aHexNode#b2a(VirtualFrame, Object, Object, int, PythonBufferAccessLibrary)}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre>
                 */
                @Child PythonBufferAccessLibrary bufferLib_;

                B2a0Data(B2a0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
    }
    @GeneratedBy(UnhexlifyNode.class)
    static final class UnhexlifyNodeFactory implements NodeFactory<UnhexlifyNode> {

        private static final UnhexlifyNodeFactory UNHEXLIFY_NODE_FACTORY_INSTANCE = new UnhexlifyNodeFactory();

        private UnhexlifyNodeFactory() {
        }

        @Override
        public Class<UnhexlifyNode> getNodeClass() {
            return UnhexlifyNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public UnhexlifyNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<UnhexlifyNode> getInstance() {
            return UNHEXLIFY_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static UnhexlifyNode create() {
            return new UnhexlifyNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link A2bHexNode#a2b(VirtualFrame, Object, PythonBufferAccessLibrary)}
         *     Activation probability: 0.65000
         *     With/without class size: 19/4 bytes
         *   Specialization {@link A2bHexNode#a2b(VirtualFrame, Object, PythonBufferAccessLibrary)}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre>
         */
        @GeneratedBy(UnhexlifyNode.class)
        @SuppressWarnings("javadoc")
        static final class UnhexlifyNodeGen extends UnhexlifyNode {

            static final ReferenceField<A2b0Data> A2B0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "a2b0_cache", A2b0Data.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link A2bHexNode#a2b(VirtualFrame, Object, PythonBufferAccessLibrary)}
             *   1: SpecializationActive {@link A2bHexNode#a2b(VirtualFrame, Object, PythonBufferAccessLibrary)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private A2b0Data a2b0_cache;

            private UnhexlifyNodeGen() {
            }

            @ExplodeLoop
            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] || SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */) {
                        A2b0Data s0_ = this.a2b0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg0Value))) {
                                return a2b(frameValue, arg0Value, s0_.bufferLib_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                return a2b(frameValue, arg0Value, bufferLib__);
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private PBytes executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        A2b0Data s0_ = A2B0_CACHE_UPDATER.getVolatile(this);
                        A2b0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg0Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (s0_.bufferLib_.accepts(arg0Value));
                            if (count0_ < (3)) {
                                s0_ = this.insert(new A2b0Data(s0_original));
                                PythonBufferAccessLibrary bufferLib__ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arg0Value)));
                                Objects.requireNonNull(bufferLib__, "Specialization 'a2b(VirtualFrame, Object, PythonBufferAccessLibrary)' cache 'bufferLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.bufferLib_ = bufferLib__;
                                if (!A2B0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1 /* add SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            return a2b(frameValue, arg0Value, s0_.bufferLib_);
                        }
                        break;
                    }
                }
                {
                    PythonBufferAccessLibrary bufferLib__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                            this.a2b0_cache = null;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationActive[BinasciiModuleBuiltins.A2bHexNode.a2b(VirtualFrame, Object, PythonBufferAccessLibrary)] */;
                            this.state_0_ = state_0;
                            return a2b(frameValue, arg0Value, bufferLib__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        A2b0Data s0_ = this.a2b0_cache;
                        if ((s0_ == null || s0_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(UnhexlifyNode.class)
            @DenyReplace
            private static final class A2b0Data extends Node implements SpecializationDataNode {

                @Child A2b0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link A2bHexNode#a2b(VirtualFrame, Object, PythonBufferAccessLibrary)}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre>
                 */
                @Child PythonBufferAccessLibrary bufferLib_;

                A2b0Data(A2b0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
    }
}
