// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.asyncio;

import com.oracle.graal.python.builtins.objects.asyncio.AsyncGeneratorBuiltins.AClose;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGeneratorBuiltins.AIter;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGeneratorBuiltins.ANext;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGeneratorBuiltins.ASend;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGeneratorBuiltins.AThrow;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGeneratorBuiltins.GetAwait;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGeneratorBuiltins.GetCode;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGeneratorBuiltins.GetFrame;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGeneratorBuiltins.IsRunning;
import com.oracle.graal.python.builtins.objects.generator.GeneratorBuiltins.GetFrameNode;
import com.oracle.graal.python.builtins.objects.generator.GeneratorBuiltinsFactory.GetFrameNodeFactory;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(AsyncGeneratorBuiltins.class)
@SuppressWarnings("javadoc")
public final class AsyncGeneratorBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(GetCodeFactory.getInstance(), GetAwaitFactory.getInstance(), GetFrameFactory.getInstance(), IsRunningFactory.getInstance(), ASendFactory.getInstance(), AThrowFactory.getInstance(), AIterFactory.getInstance(), ANextFactory.getInstance(), ACloseFactory.getInstance());
    }

    @GeneratedBy(GetCode.class)
    public static final class GetCodeFactory implements NodeFactory<GetCode> {

        private static final GetCodeFactory GET_CODE_FACTORY_INSTANCE = new GetCodeFactory();

        private GetCodeFactory() {
        }

        @Override
        public Class<GetCode> getNodeClass() {
            return GetCode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GetCode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<GetCode> getInstance() {
            return GET_CODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetCode create() {
            return new GetCodeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetCode#getCode}
         *     Activation probability: 1.00000
         *     With/without class size: 24/1 bytes
         * </pre>
         */
        @GeneratedBy(GetCode.class)
        @SuppressWarnings("javadoc")
        public static final class GetCodeNodeGen extends GetCode {

            private static final StateField STATE_0_GetCode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetCode#getCode}
             *   Parameter: {@link InlinedConditionProfile} hasCodeProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private static final InlinedConditionProfile INLINED_HAS_CODE_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_GetCode_UPDATER.subUpdater(1, 2)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetCode#getCode}
             *   1-2: InlinedCache
             *        Specialization: {@link GetCode#getCode}
             *        Parameter: {@link InlinedConditionProfile} hasCodeProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private GetCodeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[AsyncGeneratorBuiltins.GetCode.getCode(PAsyncGen, Node, InlinedConditionProfile)] */ && arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    {
                        Node inliningTarget__ = (this);
                        return getCode(arg0Value_, inliningTarget__, INLINED_HAS_CODE_PROFILE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PAsyncGen) {
                        PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                        inliningTarget__ = (this);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[AsyncGeneratorBuiltins.GetCode.getCode(PAsyncGen, Node, InlinedConditionProfile)] */;
                        this.state_0_ = state_0;
                        return getCode(arg0Value_, inliningTarget__, INLINED_HAS_CODE_PROFILE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(GetAwait.class)
    public static final class GetAwaitFactory implements NodeFactory<GetAwait> {

        private static final GetAwaitFactory GET_AWAIT_FACTORY_INSTANCE = new GetAwaitFactory();

        private GetAwaitFactory() {
        }

        @Override
        public Class<GetAwait> getNodeClass() {
            return GetAwait.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GetAwait createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<GetAwait> getInstance() {
            return GET_AWAIT_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetAwait create() {
            return new GetAwaitNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetAwait#getAwait}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GetAwait.class)
        @SuppressWarnings("javadoc")
        public static final class GetAwaitNodeGen extends GetAwait {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetAwait#getAwait}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private GetAwaitNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[AsyncGeneratorBuiltins.GetAwait.getAwait(PAsyncGen)] */ && arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    return getAwait(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[AsyncGeneratorBuiltins.GetAwait.getAwait(PAsyncGen)] */;
                    this.state_0_ = state_0;
                    return getAwait(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(GetFrame.class)
    public static final class GetFrameFactory implements NodeFactory<GetFrame> {

        private static final GetFrameFactory GET_FRAME_FACTORY_INSTANCE = new GetFrameFactory();

        private GetFrameFactory() {
        }

        @Override
        public Class<GetFrame> getNodeClass() {
            return GetFrame.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GetFrame createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<GetFrame> getInstance() {
            return GET_FRAME_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetFrame create() {
            return new GetFrameNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetFrame#getFrame}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(GetFrame.class)
        @SuppressWarnings("javadoc")
        public static final class GetFrameNodeGen extends GetFrame {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetFrame#getFrame}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetFrame#getFrame}
             *   Parameter: {@link GetFrameNode} getFrame</pre>
             */
            @Child private GetFrameNode getFrame_;

            private GetFrameNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[AsyncGeneratorBuiltins.GetFrame.getFrame(VirtualFrame, PAsyncGen, GetFrameNode)] */ && arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    {
                        GetFrameNode getFrame__ = this.getFrame_;
                        if (getFrame__ != null) {
                            return getFrame(frameValue, arg0Value_, getFrame__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    GetFrameNode getFrame__ = this.insert((GetFrameNodeFactory.create()));
                    Objects.requireNonNull(getFrame__, "Specialization 'getFrame(VirtualFrame, PAsyncGen, GetFrameNode)' cache 'getFrame' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.getFrame_ = getFrame__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[AsyncGeneratorBuiltins.GetFrame.getFrame(VirtualFrame, PAsyncGen, GetFrameNode)] */;
                    this.state_0_ = state_0;
                    return getFrame(frameValue, arg0Value_, getFrame__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(IsRunning.class)
    public static final class IsRunningFactory implements NodeFactory<IsRunning> {

        private static final IsRunningFactory IS_RUNNING_FACTORY_INSTANCE = new IsRunningFactory();

        private IsRunningFactory() {
        }

        @Override
        public Class<IsRunning> getNodeClass() {
            return IsRunning.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public IsRunning createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<IsRunning> getInstance() {
            return IS_RUNNING_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IsRunning create() {
            return new IsRunningNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IsRunning#isRunning}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(IsRunning.class)
        @SuppressWarnings("javadoc")
        public static final class IsRunningNodeGen extends IsRunning {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IsRunning#isRunning}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private IsRunningNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[AsyncGeneratorBuiltins.IsRunning.isRunning(PAsyncGen)] */ && arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    return isRunning(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private boolean executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[AsyncGeneratorBuiltins.IsRunning.isRunning(PAsyncGen)] */;
                    this.state_0_ = state_0;
                    return isRunning(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(ASend.class)
    public static final class ASendFactory implements NodeFactory<ASend> {

        private static final ASendFactory A_SEND_FACTORY_INSTANCE = new ASendFactory();

        private ASendFactory() {
        }

        @Override
        public Class<ASend> getNodeClass() {
            return ASend.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ASend createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<ASend> getInstance() {
            return A_SEND_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ASend create() {
            return new ASendNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ASend#aSend}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(ASend.class)
        @SuppressWarnings("javadoc")
        public static final class ASendNodeGen extends ASend {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ASend#aSend}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ASend#aSend}
             *   Parameter: {@link CallUnaryMethodNode} callFirstIter</pre>
             */
            @Child private CallUnaryMethodNode callFirstIter_;

            private ASendNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[AsyncGeneratorBuiltins.ASend.aSend(VirtualFrame, PAsyncGen, Object, CallUnaryMethodNode)] */ && arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    {
                        CallUnaryMethodNode callFirstIter__ = this.callFirstIter_;
                        if (callFirstIter__ != null) {
                            return aSend(frameValue, arg0Value_, arg1Value, callFirstIter__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    CallUnaryMethodNode callFirstIter__ = this.insert((CallUnaryMethodNode.create()));
                    Objects.requireNonNull(callFirstIter__, "Specialization 'aSend(VirtualFrame, PAsyncGen, Object, CallUnaryMethodNode)' cache 'callFirstIter' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.callFirstIter_ = callFirstIter__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[AsyncGeneratorBuiltins.ASend.aSend(VirtualFrame, PAsyncGen, Object, CallUnaryMethodNode)] */;
                    this.state_0_ = state_0;
                    return aSend(frameValue, arg0Value_, arg1Value, callFirstIter__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(AThrow.class)
    public static final class AThrowFactory implements NodeFactory<AThrow> {

        private static final AThrowFactory A_THROW_FACTORY_INSTANCE = new AThrowFactory();

        private AThrowFactory() {
        }

        @Override
        public Class<AThrow> getNodeClass() {
            return AThrow.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public AThrow createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<AThrow> getInstance() {
            return A_THROW_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AThrow create(ReadArgumentNode[] arguments) {
            return new AThrowNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AThrow#athrow}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(AThrow.class)
        @SuppressWarnings("javadoc")
        public static final class AThrowNodeGen extends AThrow {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            @Child private ReadArgumentNode arguments2_;
            @Child private ReadArgumentNode arguments3_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AThrow#athrow}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AThrow#athrow}
             *   Parameter: {@link CallUnaryMethodNode} callFirstIter</pre>
             */
            @Child private CallUnaryMethodNode callFirstIter_;

            private AThrowNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue, PAsyncGen arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[AsyncGeneratorBuiltins.AThrow.athrow(VirtualFrame, PAsyncGen, Object, Object, Object, CallUnaryMethodNode)] */) {
                    {
                        CallUnaryMethodNode callFirstIter__ = this.callFirstIter_;
                        if (callFirstIter__ != null) {
                            return athrow(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, callFirstIter__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[AsyncGeneratorBuiltins.AThrow.athrow(VirtualFrame, PAsyncGen, Object, Object, Object, CallUnaryMethodNode)] */ && arguments0Value_ instanceof PAsyncGen) {
                    PAsyncGen arguments0Value__ = (PAsyncGen) arguments0Value_;
                    {
                        CallUnaryMethodNode callFirstIter__ = this.callFirstIter_;
                        if (callFirstIter__ != null) {
                            return athrow(frameValue, arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_, callFirstIter__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PAsyncGen) {
                    PAsyncGen arguments0Value_ = (PAsyncGen) arguments0Value;
                    CallUnaryMethodNode callFirstIter__ = this.insert((CallUnaryMethodNode.create()));
                    Objects.requireNonNull(callFirstIter__, "Specialization 'athrow(VirtualFrame, PAsyncGen, Object, Object, Object, CallUnaryMethodNode)' cache 'callFirstIter' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.callFirstIter_ = callFirstIter__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[AsyncGeneratorBuiltins.AThrow.athrow(VirtualFrame, PAsyncGen, Object, Object, Object, CallUnaryMethodNode)] */;
                    this.state_0_ = state_0;
                    return athrow(frameValue, arguments0Value_, arguments1Value, arguments2Value, arguments3Value, callFirstIter__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(AIter.class)
    public static final class AIterFactory implements NodeFactory<AIter> {

        private static final AIterFactory A_ITER_FACTORY_INSTANCE = new AIterFactory();

        private AIterFactory() {
        }

        @Override
        public Class<AIter> getNodeClass() {
            return AIter.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public AIter createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<AIter> getInstance() {
            return A_ITER_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AIter create() {
            return new AIterNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AIter#aIter}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(AIter.class)
        @SuppressWarnings("javadoc")
        public static final class AIterNodeGen extends AIter {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AIter#aIter}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private AIterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[AsyncGeneratorBuiltins.AIter.aIter(PAsyncGen)] */ && arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    return aIter(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[AsyncGeneratorBuiltins.AIter.aIter(PAsyncGen)] */;
                    this.state_0_ = state_0;
                    return aIter(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(ANext.class)
    public static final class ANextFactory implements NodeFactory<ANext> {

        private static final ANextFactory A_NEXT_FACTORY_INSTANCE = new ANextFactory();

        private ANextFactory() {
        }

        @Override
        public Class<ANext> getNodeClass() {
            return ANext.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ANext createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<ANext> getInstance() {
            return A_NEXT_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ANext create() {
            return new ANextNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ANext#aNext}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(ANext.class)
        @SuppressWarnings("javadoc")
        public static final class ANextNodeGen extends ANext {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ANext#aNext}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ANext#aNext}
             *   Parameter: {@link CallUnaryMethodNode} callFirstIter</pre>
             */
            @Child private CallUnaryMethodNode callFirstIter_;

            private ANextNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[AsyncGeneratorBuiltins.ANext.aNext(VirtualFrame, PAsyncGen, CallUnaryMethodNode)] */ && arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    {
                        CallUnaryMethodNode callFirstIter__ = this.callFirstIter_;
                        if (callFirstIter__ != null) {
                            return aNext(frameValue, arg0Value_, callFirstIter__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    CallUnaryMethodNode callFirstIter__ = this.insert((CallUnaryMethodNode.create()));
                    Objects.requireNonNull(callFirstIter__, "Specialization 'aNext(VirtualFrame, PAsyncGen, CallUnaryMethodNode)' cache 'callFirstIter' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.callFirstIter_ = callFirstIter__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[AsyncGeneratorBuiltins.ANext.aNext(VirtualFrame, PAsyncGen, CallUnaryMethodNode)] */;
                    this.state_0_ = state_0;
                    return aNext(frameValue, arg0Value_, callFirstIter__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(AClose.class)
    public static final class ACloseFactory implements NodeFactory<AClose> {

        private static final ACloseFactory A_CLOSE_FACTORY_INSTANCE = new ACloseFactory();

        private ACloseFactory() {
        }

        @Override
        public Class<AClose> getNodeClass() {
            return AClose.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public AClose createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<AClose> getInstance() {
            return A_CLOSE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AClose create() {
            return new ACloseNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AClose#aClose}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(AClose.class)
        @SuppressWarnings("javadoc")
        public static final class ACloseNodeGen extends AClose {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AClose#aClose}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AClose#aClose}
             *   Parameter: {@link CallUnaryMethodNode} callFirstIter</pre>
             */
            @Child private CallUnaryMethodNode callFirstIter_;

            private ACloseNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[AsyncGeneratorBuiltins.AClose.aClose(VirtualFrame, PAsyncGen, CallUnaryMethodNode)] */ && arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    {
                        CallUnaryMethodNode callFirstIter__ = this.callFirstIter_;
                        if (callFirstIter__ != null) {
                            return aClose(frameValue, arg0Value_, callFirstIter__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PAsyncGen) {
                    PAsyncGen arg0Value_ = (PAsyncGen) arg0Value;
                    CallUnaryMethodNode callFirstIter__ = this.insert((CallUnaryMethodNode.create()));
                    Objects.requireNonNull(callFirstIter__, "Specialization 'aClose(VirtualFrame, PAsyncGen, CallUnaryMethodNode)' cache 'callFirstIter' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.callFirstIter_ = callFirstIter__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[AsyncGeneratorBuiltins.AClose.aClose(VirtualFrame, PAsyncGen, CallUnaryMethodNode)] */;
                    this.state_0_ = state_0;
                    return aClose(frameValue, arg0Value_, callFirstIter__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
}
