// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import java.lang.invoke.VarHandle;

@GeneratedBy(PBytesLike.class)
@SuppressWarnings("javadoc")
public final class PBytesLikeGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<PythonBufferAccessLibrary> PYTHON_BUFFER_ACCESS_LIBRARY_ = LibraryFactory.resolve(PythonBufferAccessLibrary.class);

    static  {
        LibraryExport.register(PBytesLike.class, new PythonBufferAcquireLibraryExports(), new PythonBufferAccessLibraryExports());
    }

    private PBytesLikeGen() {
    }

    @GeneratedBy(PBytesLike.class)
    public static class PythonBufferAcquireLibraryExports extends LibraryExport<PythonBufferAcquireLibrary> {

        private PythonBufferAcquireLibraryExports() {
            super(PythonBufferAcquireLibrary.class, PBytesLike.class, false, false, 0);
        }

        @Override
        protected PythonBufferAcquireLibrary createUncached(Object receiver) {
            assert receiver instanceof PBytesLike;
            PythonBufferAcquireLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected PythonBufferAcquireLibrary createCached(Object receiver) {
            assert receiver instanceof PBytesLike;
            return new Cached(receiver);
        }

        @GeneratedBy(PBytesLike.class)
        public static class Cached extends PythonBufferAcquireLibrary {

            private final Class<? extends PBytesLike> receiverClass_;

            protected Cached(Object receiver) {
                PBytesLike castReceiver = ((PBytesLike) receiver) ;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public boolean hasBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasBuffer();
            }

            @Override
            public Object acquire(Object receiver, int flags) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).acquire(flags);
            }

        }
        @GeneratedBy(PBytesLike.class)
        public static class Uncached extends PythonBufferAcquireLibrary {

            private final Class<? extends PBytesLike> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((PBytesLike) receiver).getClass();
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public final boolean isAdoptable() {
                return false;
            }

            @Override
            public final NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean hasBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PBytesLike) receiver) .hasBuffer();
            }

            @TruffleBoundary
            @Override
            public Object acquire(Object receiver, int flags) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PBytesLike) receiver) .acquire(flags);
            }

        }
    }
    @GeneratedBy(PBytesLike.class)
    public static class PythonBufferAccessLibraryExports extends LibraryExport<PythonBufferAccessLibrary> {

        private PythonBufferAccessLibraryExports() {
            super(PythonBufferAccessLibrary.class, PBytesLike.class, false, false, 0);
        }

        @Override
        protected PythonBufferAccessLibrary createUncached(Object receiver) {
            assert receiver instanceof PBytesLike;
            PythonBufferAccessLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected PythonBufferAccessLibrary createCached(Object receiver) {
            assert receiver instanceof PBytesLike;
            return new Cached(receiver);
        }

        @GeneratedBy(PBytesLike.class)
        public static class Cached extends PythonBufferAccessLibrary {

            private final Class<? extends PBytesLike> receiverClass_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link PBytesLike#getBufferLength(PBytesLike, PythonBufferAccessLibrary)}
             *   1: SpecializationActive {@link PBytesLike#hasInternalByteArray(PBytesLike, PythonBufferAccessLibrary)}
             *   2: SpecializationActive {@link PBytesLike#getInternalByteArray(PBytesLike, PythonBufferAccessLibrary)}
             *   3: SpecializationActive {@link PBytesLike#readByte(PBytesLike, int, PythonBufferAccessLibrary)}
             *   4: SpecializationActive {@link PBytesLike#readShort(PBytesLike, int, PythonBufferAccessLibrary)}
             *   5: SpecializationActive {@link PBytesLike#readInt(PBytesLike, int, PythonBufferAccessLibrary)}
             *   6: SpecializationActive {@link PBytesLike#readLong(PBytesLike, int, PythonBufferAccessLibrary)}
             *   7: SpecializationActive {@link PBytesLike#readFloat(PBytesLike, int, PythonBufferAccessLibrary)}
             *   8: SpecializationActive {@link PBytesLike#readDouble(PBytesLike, int, PythonBufferAccessLibrary)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PBytesLike#getBufferLength}
             *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre>
             */
            @Child private PythonBufferAccessLibrary bufferLib;

            protected Cached(Object receiver) {
                PBytesLike castReceiver = ((PBytesLike) receiver) ;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            protected boolean isBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (CompilerDirectives.castExact(receiver, receiverClass_)).isBuffer();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PBytesLike#getBufferLength(PBytesLike, PythonBufferAccessLibrary)}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public int getBufferLength(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PBytesLike arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[PBytesLike.getBufferLength(PBytesLike, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.getBufferLength(bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getBufferLengthNode_AndSpecialize(arg0Value);
            }

            private int getBufferLengthNode_AndSpecialize(PBytesLike arg0Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'getBufferLength(PBytesLike, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1 /* add SpecializationActive[PBytesLike.getBufferLength(PBytesLike, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.getBufferLength(bufferLib_);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PBytesLike#hasInternalByteArray(PBytesLike, PythonBufferAccessLibrary)}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public boolean hasInternalByteArray(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PBytesLike arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[PBytesLike.hasInternalByteArray(PBytesLike, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.hasInternalByteArray(bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasInternalByteArrayNode_AndSpecialize(arg0Value);
            }

            private boolean hasInternalByteArrayNode_AndSpecialize(PBytesLike arg0Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'hasInternalByteArray(PBytesLike, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[PBytesLike.hasInternalByteArray(PBytesLike, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.hasInternalByteArray(bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PBytesLike#getInternalByteArray(PBytesLike, PythonBufferAccessLibrary)}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public byte[] getInternalByteArray(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PBytesLike arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[PBytesLike.getInternalByteArray(PBytesLike, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.getInternalByteArray(bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getInternalByteArrayNode_AndSpecialize(arg0Value);
            }

            private byte[] getInternalByteArrayNode_AndSpecialize(PBytesLike arg0Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'getInternalByteArray(PBytesLike, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[PBytesLike.getInternalByteArray(PBytesLike, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.getInternalByteArray(bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PBytesLike#readByte(PBytesLike, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public byte readByte(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PBytesLike arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[PBytesLike.readByte(PBytesLike, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readByte(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readByteNode_AndSpecialize(arg0Value, arg1Value);
            }

            private byte readByteNode_AndSpecialize(PBytesLike arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readByte(PBytesLike, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[PBytesLike.readByte(PBytesLike, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readByte(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PBytesLike#readShort(PBytesLike, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public short readShort(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PBytesLike arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[PBytesLike.readShort(PBytesLike, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readShort(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readShortNode_AndSpecialize(arg0Value, arg1Value);
            }

            private short readShortNode_AndSpecialize(PBytesLike arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readShort(PBytesLike, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[PBytesLike.readShort(PBytesLike, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readShort(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PBytesLike#readInt(PBytesLike, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public int readInt(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PBytesLike arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[PBytesLike.readInt(PBytesLike, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readInt(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readIntNode_AndSpecialize(arg0Value, arg1Value);
            }

            private int readIntNode_AndSpecialize(PBytesLike arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readInt(PBytesLike, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000 /* add SpecializationActive[PBytesLike.readInt(PBytesLike, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readInt(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PBytesLike#readLong(PBytesLike, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public long readLong(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PBytesLike arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[PBytesLike.readLong(PBytesLike, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readLong(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readLongNode_AndSpecialize(arg0Value, arg1Value);
            }

            private long readLongNode_AndSpecialize(PBytesLike arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readLong(PBytesLike, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[PBytesLike.readLong(PBytesLike, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readLong(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PBytesLike#readFloat(PBytesLike, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public float readFloat(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PBytesLike arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[PBytesLike.readFloat(PBytesLike, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readFloat(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readFloatNode_AndSpecialize(arg0Value, arg1Value);
            }

            private float readFloatNode_AndSpecialize(PBytesLike arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readFloat(PBytesLike, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[PBytesLike.readFloat(PBytesLike, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readFloat(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PBytesLike#readDouble(PBytesLike, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.11111
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public double readDouble(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PBytesLike arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[PBytesLike.readDouble(PBytesLike, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readDouble(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readDoubleNode_AndSpecialize(arg0Value, arg1Value);
            }

            private double readDoubleNode_AndSpecialize(PBytesLike arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readDouble(PBytesLike, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[PBytesLike.readDouble(PBytesLike, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readDouble(arg1Value, bufferLib_);
            }

        }
        @GeneratedBy(PBytesLike.class)
        public static class Uncached extends PythonBufferAccessLibrary {

            private final Class<? extends PBytesLike> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((PBytesLike) receiver).getClass();
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public final boolean isAdoptable() {
                return false;
            }

            @Override
            public final NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            protected boolean isBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PBytesLike) receiver) .isBuffer();
            }

            @TruffleBoundary
            @Override
            public int getBufferLength(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PBytesLike arg0Value = ((PBytesLike) arg0Value_);
                return arg0Value.getBufferLength((PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasInternalByteArray(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PBytesLike arg0Value = ((PBytesLike) arg0Value_);
                return arg0Value.hasInternalByteArray((PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public byte[] getInternalByteArray(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PBytesLike arg0Value = ((PBytesLike) arg0Value_);
                return arg0Value.getInternalByteArray((PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public byte readByte(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PBytesLike arg0Value = ((PBytesLike) arg0Value_);
                return arg0Value.readByte(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public short readShort(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PBytesLike arg0Value = ((PBytesLike) arg0Value_);
                return arg0Value.readShort(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public int readInt(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PBytesLike arg0Value = ((PBytesLike) arg0Value_);
                return arg0Value.readInt(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public long readLong(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PBytesLike arg0Value = ((PBytesLike) arg0Value_);
                return arg0Value.readLong(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public float readFloat(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PBytesLike arg0Value = ((PBytesLike) arg0Value_);
                return arg0Value.readFloat(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public double readDouble(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PBytesLike arg0Value = ((PBytesLike) arg0Value_);
                return arg0Value.readDouble(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

        }
    }
}
