// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.objects.itertools.ProductBuiltins.IterNode;
import com.oracle.graal.python.builtins.objects.itertools.ProductBuiltins.NextNode;
import com.oracle.graal.python.builtins.objects.itertools.ProductBuiltins.ReduceNode;
import com.oracle.graal.python.builtins.objects.itertools.ProductBuiltins.SetStateNode;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyLongAsIntNodeGen;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectGetItemNodeGen;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetClassNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.IntField;
import com.oracle.truffle.api.dsl.InlineSupport.LongField;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;

@GeneratedBy(ProductBuiltins.class)
@SuppressWarnings("javadoc")
public final class ProductBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(IterNodeFactory.getInstance(), NextNodeFactory.getInstance(), ReduceNodeFactory.getInstance(), SetStateNodeFactory.getInstance());
    }

    @GeneratedBy(IterNode.class)
    public static final class IterNodeFactory implements NodeFactory<IterNode> {

        private static final IterNodeFactory ITER_NODE_FACTORY_INSTANCE = new IterNodeFactory();

        private IterNodeFactory() {
        }

        @Override
        public Class<IterNode> getNodeClass() {
            return IterNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public IterNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<IterNode> getInstance() {
            return ITER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IterNode create() {
            return new IterNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IterNode#iter}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(IterNode.class)
        @SuppressWarnings("javadoc")
        public static final class IterNodeGen extends IterNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IterNode#iter}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private IterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ProductBuiltins.IterNode.iter(PProduct)] */ && arg0Value instanceof PProduct) {
                    PProduct arg0Value_ = (PProduct) arg0Value;
                    return IterNode.iter(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PProduct) {
                    PProduct arg0Value_ = (PProduct) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ProductBuiltins.IterNode.iter(PProduct)] */;
                    this.state_0_ = state_0;
                    return IterNode.iter(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(NextNode.class)
    public static final class NextNodeFactory implements NodeFactory<NextNode> {

        private static final NextNodeFactory NEXT_NODE_FACTORY_INSTANCE = new NextNodeFactory();

        private NextNodeFactory() {
        }

        @Override
        public Class<NextNode> getNodeClass() {
            return NextNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public NextNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<NextNode> getInstance() {
            return NEXT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NextNode create() {
            return new NextNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NextNode#next(PProduct, Node, InlinedLoopConditionProfile)}
         *     Activation probability: 0.48333
         *     With/without class size: 17/12 bytes
         *   Specialization {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
         *     Activation probability: 0.33333
         *     With/without class size: 14/13 bytes
         *   Specialization {@link NextNode#nextStopped}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre>
         */
        @GeneratedBy(NextNode.class)
        @SuppressWarnings("javadoc")
        public static final class NextNodeGen extends NextNode {

            private static final StateField STATE_0_NextNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next(PProduct, Node, InlinedLoopConditionProfile)}
             *   Parameter: {@link InlinedLoopConditionProfile} loopProfile
             *   Inline method: {@link InlinedLoopConditionProfile#inline}</pre>
             */
            private static final InlinedLoopConditionProfile INLINED_NEXT0_LOOP_PROFILE_ = InlinedLoopConditionProfile.inline(InlineTarget.create(InlinedLoopConditionProfile.class, LongField.create(MethodHandles.lookup(), "next0_loopProfile__field0_"), IntField.create(MethodHandles.lookup(), "next0_loopProfile__field1_")));
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
             *   Parameter: {@link InlinedConditionProfile} gearsProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private static final InlinedConditionProfile INLINED_NEXT1_GEARS_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_NextNode_UPDATER.subUpdater(3, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
             *   Parameter: {@link InlinedConditionProfile} indexProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private static final InlinedConditionProfile INLINED_NEXT1_INDEX_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_NextNode_UPDATER.subUpdater(5, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
             *   Parameter: {@link InlinedBranchProfile} wasStoppedProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_NEXT1_WAS_STOPPED_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_NextNode_UPDATER.subUpdater(7, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
             *   Parameter: {@link InlinedLoopConditionProfile} loopProfile
             *   Inline method: {@link InlinedLoopConditionProfile#inline}</pre>
             */
            private static final InlinedLoopConditionProfile INLINED_NEXT1_LOOP_PROFILE_ = InlinedLoopConditionProfile.inline(InlineTarget.create(InlinedLoopConditionProfile.class, LongField.create(MethodHandles.lookup(), "next1_loopProfile__field0_"), IntField.create(MethodHandles.lookup(), "next1_loopProfile__field1_")));
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
             *   Parameter: {@link InlinedBranchProfile} doneProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_NEXT1_DONE_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_NextNode_UPDATER.subUpdater(8, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NextNode#next(PProduct, Node, InlinedLoopConditionProfile)}
             *   1: SpecializationActive {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
             *   2: SpecializationActive {@link NextNode#nextStopped}
             *   3-4: InlinedCache
             *        Specialization: {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
             *        Parameter: {@link InlinedConditionProfile} gearsProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   5-6: InlinedCache
             *        Specialization: {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
             *        Parameter: {@link InlinedConditionProfile} indexProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   7: InlinedCache
             *        Specialization: {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
             *        Parameter: {@link InlinedBranchProfile} wasStoppedProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   8: InlinedCache
             *        Specialization: {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
             *        Parameter: {@link InlinedBranchProfile} doneProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next(PProduct, Node, InlinedLoopConditionProfile)}
             *   Parameter: {@link InlinedLoopConditionProfile} loopProfile
             *   Inline method: {@link InlinedLoopConditionProfile#inline}
             *   Inline field: long field0</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private long next0_loopProfile__field0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next(PProduct, Node, InlinedLoopConditionProfile)}
             *   Parameter: {@link InlinedLoopConditionProfile} loopProfile
             *   Inline method: {@link InlinedLoopConditionProfile#inline}
             *   Inline field: int field1</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int next0_loopProfile__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
             *   Parameter: {@link InlinedLoopConditionProfile} loopProfile
             *   Inline method: {@link InlinedLoopConditionProfile#inline}
             *   Inline field: long field0</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private long next1_loopProfile__field0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)}
             *   Parameter: {@link InlinedLoopConditionProfile} loopProfile
             *   Inline method: {@link InlinedLoopConditionProfile#inline}
             *   Inline field: int field1</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int next1_loopProfile__field1_;

            private NextNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[ProductBuiltins.NextNode.next(PProduct, Node, InlinedLoopConditionProfile)] || SpecializationActive[ProductBuiltins.NextNode.next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)] || SpecializationActive[ProductBuiltins.NextNode.nextStopped(PProduct)] */ && arg0Value instanceof PProduct) {
                    PProduct arg0Value_ = (PProduct) arg0Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[ProductBuiltins.NextNode.next(PProduct, Node, InlinedLoopConditionProfile)] */) {
                        if ((!(arg0Value_.isStopped())) && (!(NextNode.hasLst(arg0Value_)))) {
                            Node inliningTarget__ = (this);
                            return next(arg0Value_, inliningTarget__, INLINED_NEXT0_LOOP_PROFILE_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ProductBuiltins.NextNode.next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)] */) {
                        if ((!(arg0Value_.isStopped())) && (NextNode.hasLst(arg0Value_))) {
                            Node inliningTarget__1 = (this);
                            return next(arg0Value_, inliningTarget__1, INLINED_NEXT1_GEARS_PROFILE_, INLINED_NEXT1_INDEX_PROFILE_, INLINED_NEXT1_WAS_STOPPED_PROFILE_, INLINED_NEXT1_LOOP_PROFILE_, INLINED_NEXT1_DONE_PROFILE_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[ProductBuiltins.NextNode.nextStopped(PProduct)] */) {
                        if ((arg0Value_.isStopped())) {
                            return nextStopped(arg0Value_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PProduct) {
                    PProduct arg0Value_ = (PProduct) arg0Value;
                    {
                        Node inliningTarget__ = null;
                        if ((!(arg0Value_.isStopped())) && (!(NextNode.hasLst(arg0Value_)))) {
                            inliningTarget__ = (this);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[ProductBuiltins.NextNode.next(PProduct, Node, InlinedLoopConditionProfile)] */;
                            this.state_0_ = state_0;
                            return next(arg0Value_, inliningTarget__, INLINED_NEXT0_LOOP_PROFILE_);
                        }
                    }
                    {
                        Node inliningTarget__1 = null;
                        if ((!(arg0Value_.isStopped())) && (NextNode.hasLst(arg0Value_))) {
                            inliningTarget__1 = (this);
                            state_0 = state_0 | 0b10 /* add SpecializationActive[ProductBuiltins.NextNode.next(PProduct, Node, InlinedConditionProfile, InlinedConditionProfile, InlinedBranchProfile, InlinedLoopConditionProfile, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            return next(arg0Value_, inliningTarget__1, INLINED_NEXT1_GEARS_PROFILE_, INLINED_NEXT1_INDEX_PROFILE_, INLINED_NEXT1_WAS_STOPPED_PROFILE_, INLINED_NEXT1_LOOP_PROFILE_, INLINED_NEXT1_DONE_PROFILE_);
                        }
                    }
                    if ((arg0Value_.isStopped())) {
                        state_0 = state_0 | 0b100 /* add SpecializationActive[ProductBuiltins.NextNode.nextStopped(PProduct)] */;
                        this.state_0_ = state_0;
                        return nextStopped(arg0Value_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b111) & ((state_0 & 0b111) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(ReduceNode.class)
    public static final class ReduceNodeFactory implements NodeFactory<ReduceNode> {

        private static final ReduceNodeFactory REDUCE_NODE_FACTORY_INSTANCE = new ReduceNodeFactory();

        private ReduceNodeFactory() {
        }

        @Override
        public Class<ReduceNode> getNodeClass() {
            return ReduceNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ReduceNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<ReduceNode> getInstance() {
            return REDUCE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReduceNode create() {
            return new ReduceNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReduceNode#reduce}
         *     Activation probability: 0.48333
         *     With/without class size: 11/0 bytes
         *   Specialization {@link ReduceNode#reduceLst}
         *     Activation probability: 0.33333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link ReduceNode#reduceStopped}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre>
         */
        @GeneratedBy(ReduceNode.class)
        @SuppressWarnings("javadoc")
        public static final class ReduceNodeGen extends ReduceNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReduceNode#reduce}
             *   Parameter: {@link GetClassNode} getClassNode
             *   Inline method: {@link GetClassNodeGen#inline}</pre>
             */
            private static final GetClassNode INLINED_GET_CLASS_NODE = GetClassNodeGen.inline(InlineTarget.create(GetClassNode.class, STATE_0_UPDATER.subUpdater(3, 17), ReferenceField.create(MethodHandles.lookup(), "getClassNode_field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReduceNode#reduce}
             *   1: SpecializationActive {@link ReduceNode#reduceLst}
             *   2: SpecializationActive {@link ReduceNode#reduceStopped}
             *   3-19: InlinedCache
             *        Specialization: {@link ReduceNode#reduce}
             *        Parameter: {@link GetClassNode} getClassNode
             *        Inline method: {@link GetClassNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReduceNode#reduce}
             *   Parameter: {@link GetClassNode} getClassNode
             *   Inline method: {@link GetClassNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getClassNode_field1_;

            private ReduceNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[ProductBuiltins.ReduceNode.reduce(PProduct, Node, GetClassNode)] || SpecializationActive[ProductBuiltins.ReduceNode.reduceLst(PProduct, Node, GetClassNode)] || SpecializationActive[ProductBuiltins.ReduceNode.reduceStopped(PProduct, Node, GetClassNode)] */ && arg0Value instanceof PProduct) {
                    PProduct arg0Value_ = (PProduct) arg0Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[ProductBuiltins.ReduceNode.reduce(PProduct, Node, GetClassNode)] */) {
                        if ((!(arg0Value_.isStopped())) && (!(ReduceNode.hasLst(arg0Value_)))) {
                            Node inliningTarget__ = (this);
                            return reduce(arg0Value_, inliningTarget__, INLINED_GET_CLASS_NODE);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ProductBuiltins.ReduceNode.reduceLst(PProduct, Node, GetClassNode)] */) {
                        if ((!(arg0Value_.isStopped())) && (ReduceNode.hasLst(arg0Value_))) {
                            Node inliningTarget__1 = (this);
                            return reduceLst(arg0Value_, inliningTarget__1, INLINED_GET_CLASS_NODE);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[ProductBuiltins.ReduceNode.reduceStopped(PProduct, Node, GetClassNode)] */) {
                        if ((arg0Value_.isStopped())) {
                            Node inliningTarget__2 = (this);
                            return reduceStopped(arg0Value_, inliningTarget__2, INLINED_GET_CLASS_NODE);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PProduct) {
                    PProduct arg0Value_ = (PProduct) arg0Value;
                    {
                        Node inliningTarget__ = null;
                        if ((!(arg0Value_.isStopped())) && (!(ReduceNode.hasLst(arg0Value_)))) {
                            inliningTarget__ = (this);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[ProductBuiltins.ReduceNode.reduce(PProduct, Node, GetClassNode)] */;
                            this.state_0_ = state_0;
                            return reduce(arg0Value_, inliningTarget__, INLINED_GET_CLASS_NODE);
                        }
                    }
                    {
                        Node inliningTarget__1 = null;
                        if ((!(arg0Value_.isStopped())) && (ReduceNode.hasLst(arg0Value_))) {
                            inliningTarget__1 = (this);
                            state_0 = state_0 | 0b10 /* add SpecializationActive[ProductBuiltins.ReduceNode.reduceLst(PProduct, Node, GetClassNode)] */;
                            this.state_0_ = state_0;
                            return reduceLst(arg0Value_, inliningTarget__1, INLINED_GET_CLASS_NODE);
                        }
                    }
                    {
                        Node inliningTarget__2 = null;
                        if ((arg0Value_.isStopped())) {
                            inliningTarget__2 = (this);
                            state_0 = state_0 | 0b100 /* add SpecializationActive[ProductBuiltins.ReduceNode.reduceStopped(PProduct, Node, GetClassNode)] */;
                            this.state_0_ = state_0;
                            return reduceStopped(arg0Value_, inliningTarget__2, INLINED_GET_CLASS_NODE);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b111) & ((state_0 & 0b111) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(SetStateNode.class)
    public static final class SetStateNodeFactory implements NodeFactory<SetStateNode> {

        private static final SetStateNodeFactory SET_STATE_NODE_FACTORY_INSTANCE = new SetStateNodeFactory();

        private SetStateNodeFactory() {
        }

        @Override
        public Class<SetStateNode> getNodeClass() {
            return SetStateNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public SetStateNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<SetStateNode> getInstance() {
            return SET_STATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SetStateNode create() {
            return new SetStateNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link SetStateNode#setState}
         *     Activation probability: 1.00000
         *     With/without class size: 60/38 bytes
         * </pre>
         */
        @GeneratedBy(SetStateNode.class)
        @SuppressWarnings("javadoc")
        public static final class SetStateNodeGen extends SetStateNode {

            private static final StateField STATE_0_SetStateNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link PyObjectGetItem} getItemNode
             *   Inline method: {@link PyObjectGetItemNodeGen#inline}</pre>
             */
            private static final PyObjectGetItem INLINED_GET_ITEM_NODE_ = PyObjectGetItemNodeGen.inline(InlineTarget.create(PyObjectGetItem.class, STATE_0_SetStateNode_UPDATER.subUpdater(1, 4), ReferenceField.create(MethodHandles.lookup(), "getItemNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getItemNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getItemNode__field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getItemNode__field4_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link InlinedLoopConditionProfile} loopProfile
             *   Inline method: {@link InlinedLoopConditionProfile#inline}</pre>
             */
            private static final InlinedLoopConditionProfile INLINED_LOOP_PROFILE_ = InlinedLoopConditionProfile.inline(InlineTarget.create(InlinedLoopConditionProfile.class, LongField.create(MethodHandles.lookup(), "loopProfile__field0_"), IntField.create(MethodHandles.lookup(), "loopProfile__field1_")));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link PyLongAsIntNode} pyLongAsIntNode
             *   Inline method: {@link PyLongAsIntNodeGen#inline}</pre>
             */
            private static final PyLongAsIntNode INLINED_PY_LONG_AS_INT_NODE_ = PyLongAsIntNodeGen.inline(InlineTarget.create(PyLongAsIntNode.class, STATE_0_SetStateNode_UPDATER.subUpdater(5, 9), ReferenceField.create(MethodHandles.lookup(), "pyLongAsIntNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "pyLongAsIntNode__field2_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link InlinedBranchProfile} stoppedProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_STOPPED_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_SetStateNode_UPDATER.subUpdater(14, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link InlinedConditionProfile} indexProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private static final InlinedConditionProfile INLINED_INDEX_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_SetStateNode_UPDATER.subUpdater(15, 2)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link SetStateNode#setState}
             *   1-4: InlinedCache
             *        Specialization: {@link SetStateNode#setState}
             *        Parameter: {@link PyObjectGetItem} getItemNode
             *        Inline method: {@link PyObjectGetItemNodeGen#inline}
             *   5-13: InlinedCache
             *        Specialization: {@link SetStateNode#setState}
             *        Parameter: {@link PyLongAsIntNode} pyLongAsIntNode
             *        Inline method: {@link PyLongAsIntNodeGen#inline}
             *   14: InlinedCache
             *        Specialization: {@link SetStateNode#setState}
             *        Parameter: {@link InlinedBranchProfile} stoppedProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   15-16: InlinedCache
             *        Specialization: {@link SetStateNode#setState}
             *        Parameter: {@link InlinedConditionProfile} indexProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link PyObjectGetItem} getItemNode
             *   Inline method: {@link PyObjectGetItemNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItemNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link PyObjectGetItem} getItemNode
             *   Inline method: {@link PyObjectGetItemNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItemNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link PyObjectGetItem} getItemNode
             *   Inline method: {@link PyObjectGetItemNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItemNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link PyObjectGetItem} getItemNode
             *   Inline method: {@link PyObjectGetItemNodeGen#inline}
             *   Inline field: {@link Node} field4</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItemNode__field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link InlinedLoopConditionProfile} loopProfile
             *   Inline method: {@link InlinedLoopConditionProfile#inline}
             *   Inline field: long field0</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private long loopProfile__field0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link InlinedLoopConditionProfile} loopProfile
             *   Inline method: {@link InlinedLoopConditionProfile#inline}
             *   Inline field: int field1</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int loopProfile__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link PyLongAsIntNode} pyLongAsIntNode
             *   Inline method: {@link PyLongAsIntNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node pyLongAsIntNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link PyLongAsIntNode} pyLongAsIntNode
             *   Inline method: {@link PyLongAsIntNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node pyLongAsIntNode__field2_;

            private SetStateNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ProductBuiltins.SetStateNode.setState(VirtualFrame, PProduct, Object, Node, PyObjectGetItem, InlinedLoopConditionProfile, PyLongAsIntNode, InlinedBranchProfile, InlinedConditionProfile)] */ && arg0Value instanceof PProduct) {
                    PProduct arg0Value_ = (PProduct) arg0Value;
                    {
                        Node inliningTarget__ = (this);
                        return SetStateNode.setState(frameValue, arg0Value_, arg1Value, inliningTarget__, INLINED_GET_ITEM_NODE_, INLINED_LOOP_PROFILE_, INLINED_PY_LONG_AS_INT_NODE_, INLINED_STOPPED_PROFILE_, INLINED_INDEX_PROFILE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PProduct) {
                        PProduct arg0Value_ = (PProduct) arg0Value;
                        inliningTarget__ = (this);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ProductBuiltins.SetStateNode.setState(VirtualFrame, PProduct, Object, Node, PyObjectGetItem, InlinedLoopConditionProfile, PyLongAsIntNode, InlinedBranchProfile, InlinedConditionProfile)] */;
                        this.state_0_ = state_0;
                        return SetStateNode.setState(frameValue, arg0Value_, arg1Value, inliningTarget__, INLINED_GET_ITEM_NODE_, INLINED_LOOP_PROFILE_, INLINED_PY_LONG_AS_INT_NODE_, INLINED_STOPPED_PROFILE_, INLINED_INDEX_PROFILE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
}
