/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.NtModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.NtModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.PyOSFSPathNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="nt", isEager=true)
public final class NtModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return NtModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
            this.addBuiltinConstant("_LOAD_LIBRARY_SEARCH_DLL_LOAD_DIR", (Object)256);
            this.addBuiltinConstant("_LOAD_LIBRARY_SEARCH_DEFAULT_DIRS", (Object)4096);
            core.removeBuiltinModule(BuiltinNames.T_POSIX);
        } else {
            core.removeBuiltinModule(BuiltinNames.T_NT);
        }
    }

    @Builtin(name="device_encoding", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class DeviceEncodingNode
    extends PythonUnaryClinicBuiltinNode {
        DeviceEncodingNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object deviceEncoding(int fd) {
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return NtModuleBuiltinsClinicProviders.PathSplitRootNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="_path_splitroot", minNumOfPositionalArgs=1, parameterNames={"path"})
    @ArgumentClinic(name="path", conversionClass=PosixModuleBuiltins.PathConversionNode.class, args={"false", "false"})
    @GenerateNodeFactory
    static abstract class PathSplitRootNode
    extends PythonUnaryClinicBuiltinNode {
        PathSplitRootNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object splitroot(PosixModuleBuiltins.PosixPath path, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib) {
            int first;
            int len;
            TruffleString pathString = posixLib.getPathAsString(this.getPosixSupport(), path.value);
            int index = pathString.indexOfCodePointUncached(58, 0, len = pathString.codePointLengthUncached(PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING);
            if (index <= 0) {
                return this.factory().createTuple(new Object[]{StringLiterals.T_EMPTY_STRING, pathString});
            }
            if ((first = pathString.codePointAtIndexUncached(++index, PythonUtils.TS_ENCODING)) == 92 || first == 47) {
                ++index;
            }
            TruffleString root = pathString.substringUncached(0, index, PythonUtils.TS_ENCODING, false);
            TruffleString rest = pathString.substringUncached(index, len - index, PythonUtils.TS_ENCODING, false);
            return this.factory().createTuple(new Object[]{root, rest});
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return NtModuleBuiltinsClinicProviders.PathSplitRootNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="_getfullpathname", minNumOfPositionalArgs=1, parameterNames={"path"})
    @GenerateNodeFactory
    static abstract class GetfullpathnameNode
    extends PythonUnaryBuiltinNode {
        GetfullpathnameNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object getfullpathname(Object path, @Bind(value="this") Node inliningTarget, @Cached PyOSFSPathNode fsPathNode, @Cached CastToJavaStringNode castStr) {
            try {
                String fspath = castStr.execute(fsPathNode.execute(null, inliningTarget, path));
                return PythonUtils.toTruffleStringUncached(this.getContext().getEnv().getPublicTruffleFile(fspath).getAbsoluteFile().toString());
            }
            catch (CannotCastException e) {
                return path;
            }
        }
    }
}

