/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.array;

import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.function.builtins.clinic.IndexConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.JavaIntConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ReadableBufferConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.SliceIndexConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.TruffleStringConverterNode;

public class ArrayBuiltinsClinicProviders {

    public static final class FromUnicodeNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final FromUnicodeNodeClinicProviderGen INSTANCE = new FromUnicodeNodeClinicProviderGen();

        private FromUnicodeNodeClinicProviderGen() {
            super(1, 1, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return TruffleStringConverterNode.create("fromunicode");
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class InsertNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final InsertNodeClinicProviderGen INSTANCE = new InsertNodeClinicProviderGen();

        private InsertNodeClinicProviderGen() {
            super(5, 7, 5, 5, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return IndexConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class IMulNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final IMulNodeClinicProviderGen INSTANCE = new IMulNodeClinicProviderGen();

        private IMulNodeClinicProviderGen() {
            super(1, 3, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return IndexConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class FromFileNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final FromFileNodeClinicProviderGen INSTANCE = new FromFileNodeClinicProviderGen();

        private FromFileNodeClinicProviderGen() {
            super(3, 7, 3, 3, 4);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 2) {
                return IndexConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class ReduceExNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final ReduceExNodeClinicProviderGen INSTANCE = new ReduceExNodeClinicProviderGen();

        private ReduceExNodeClinicProviderGen() {
            super(1, 3, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return JavaIntConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class FromBytesNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final FromBytesNodeClinicProviderGen INSTANCE = new FromBytesNodeClinicProviderGen();

        private FromBytesNodeClinicProviderGen() {
            super(1, 1, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return ReadableBufferConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class PopNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final PopNodeClinicProviderGen INSTANCE = new PopNodeClinicProviderGen();

        private PopNodeClinicProviderGen() {
            super(1, 3, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return IndexConversionNode.create(-1, false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class IndexNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final IndexNodeClinicProviderGen INSTANCE = new IndexNodeClinicProviderGen();

        private IndexNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class MulNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final MulNodeClinicProviderGen INSTANCE = new MulNodeClinicProviderGen();

        private MulNodeClinicProviderGen() {
            super(1, 3, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return IndexConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }
}

