/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.CPyObjectArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativePointer;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonReplacingNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToJavaNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.common.NativeCExtSymbol;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.IndirectCallNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.argument.ReadIndexedArgumentNode;
import com.oracle.graal.python.nodes.argument.ReadVarArgsNode;
import com.oracle.graal.python.nodes.argument.ReadVarKeywordsNode;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.truffle.PythonTypes;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonContextFactory;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;

public abstract class ExternalFunctionNodes {
    private static final TruffleLogger LOGGER = CApiContext.getLogger(ExternalFunctionNodes.class);
    public static final TruffleString KW_CALLABLE = PythonUtils.tsLiteral("$callable");
    public static final TruffleString KW_CLOSURE = PythonUtils.tsLiteral("$closure");
    static final TruffleString[] KEYWORDS_HIDDEN_CALLABLE = new TruffleString[]{KW_CALLABLE};
    static final TruffleString[] KEYWORDS_HIDDEN_CALLABLE_AND_CLOSURE = new TruffleString[]{KW_CALLABLE, KW_CLOSURE};

    public static PKeyword[] createKwDefaults(Object callable) {
        assert (InteropLibrary.getUncached().isExecutable(callable));
        return new PKeyword[]{new PKeyword(KW_CALLABLE, callable)};
    }

    public static PKeyword[] createKwDefaults(Object callable, Object closure) {
        assert (InteropLibrary.getUncached().isExecutable(callable));
        return new PKeyword[]{new PKeyword(KW_CALLABLE, callable), new PKeyword(KW_CLOSURE, closure)};
    }

    public static Object tryGetHiddenCallable(PBuiltinFunction function) {
        if (function.getFunctionRootNode() instanceof MethodDescriptorRoot) {
            return ExternalFunctionNodes.getHiddenCallable(function.getKwDefaults());
        }
        return null;
    }

    public static Object getHiddenCallable(PKeyword[] kwDefaults) {
        if (kwDefaults.length >= KEYWORDS_HIDDEN_CALLABLE.length) {
            PKeyword kwDefault = kwDefaults[0];
            assert (KW_CALLABLE.equalsUncached((AbstractTruffleString)kwDefault.getName(), PythonUtils.TS_ENCODING)) : "invalid keyword defaults";
            return kwDefault.getValue();
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    static abstract class MethodDescriptorRoot
    extends PRootNode {
        @Node.Child
        private ExecutionContext.CalleeContext calleeContext = ExecutionContext.CalleeContext.create();
        @Node.Child
        private CallVarargsMethodNode invokeNode;
        @Node.Child
        private ExternalFunctionInvokeNode externalInvokeNode;
        @Node.Child
        private ReadIndexedArgumentNode readSelfNode;
        @Node.Child
        private ReadIndexedArgumentNode readCallableNode;
        @Node.Child
        private CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode;
        @Node.Children
        private final CExtToNativeNode[] convertArgs;
        private final TruffleString name;

        MethodDescriptorRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            this(language, name, isStatic, null);
        }

        MethodDescriptorRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language);
            CompilerAsserts.neverPartOfCompilation();
            this.name = name;
            if (provider != null) {
                this.externalInvokeNode = ExternalFunctionInvokeNode.create(provider);
                this.convertArgs = provider.createConvertArgNodes();
            } else {
                this.invokeNode = CallVarargsMethodNode.create();
                this.convertArgs = null;
            }
            if (!isStatic) {
                this.readSelfNode = ReadIndexedArgumentNode.create(0);
            }
        }

        @ExplodeLoop
        private void prepareArguments(Object[] arguments) {
            for (int i = 0; i < this.convertArgs.length; ++i) {
                if (this.convertArgs[i] == null) continue;
                arguments[i] = this.convertArgs[i].execute(arguments[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object execute(VirtualFrame frame) {
            this.calleeContext.enter(frame);
            try {
                Object callable = this.ensureReadCallableNode().execute(frame);
                if (this.externalInvokeNode != null) {
                    Object[] cArguments = this.prepareCArguments(frame);
                    this.prepareArguments(cArguments);
                    try {
                        Object object = this.externalInvokeNode.execute(frame, this.name, callable, cArguments);
                        return object;
                    }
                    finally {
                        this.postprocessCArguments(frame, cArguments);
                    }
                }
                assert (this.externalInvokeNode == null);
                Object object = this.invokeNode.execute((Frame)frame, callable, this.preparePArguments(frame), PArguments.getKeywordArguments((Frame)frame));
                return object;
            }
            finally {
                this.calleeContext.exit(frame, this);
            }
        }

        protected abstract Object[] prepareCArguments(VirtualFrame var1);

        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
        }

        protected Object[] preparePArguments(VirtualFrame frame) {
            Object[] variableArguments = PArguments.getVariableArguments((Frame)frame);
            int variableArgumentsLength = variableArguments != null ? variableArguments.length : 0;
            int userArgumentLength = PArguments.getUserArgumentLength(frame) - 1;
            int argumentsLength = userArgumentLength + variableArgumentsLength;
            Object[] arguments = new Object[argumentsLength];
            PythonUtils.arraycopy(frame.getArguments(), 9, arguments, 0, userArgumentLength);
            if (variableArguments != null) {
                PythonUtils.arraycopy(variableArguments, 0, arguments, userArgumentLength, variableArgumentsLength);
            }
            return arguments;
        }

        private ReadIndexedArgumentNode ensureReadCallableNode() {
            if (this.readCallableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int hiddenArg = this.getSignature().getParameterIds().length;
                this.readCallableNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(hiddenArg));
            }
            return this.readCallableNode;
        }

        protected final CExtNodes.ReleaseNativeWrapperNode ensureReleaseNativeWrapperNode() {
            if (this.releaseNativeWrapperNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.releaseNativeWrapperNode = (CExtNodes.ReleaseNativeWrapperNode)this.insert(CExtNodesFactory.ReleaseNativeWrapperNodeGen.create());
            }
            return this.releaseNativeWrapperNode;
        }

        @Override
        public boolean isCloningAllowed() {
            return true;
        }

        public String getName() {
            return this.name.toJavaStringUncached();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public String toString() {
            return "<METH root " + this.name + ">";
        }

        @Override
        public boolean isPythonInternal() {
            return true;
        }

        public boolean isInternal() {
            return true;
        }

        @Override
        public boolean setsUpCalleeContext() {
            return true;
        }

        protected final Object readSelf(VirtualFrame frame) {
            if (this.readSelfNode != null) {
                return this.readSelfNode.execute(frame);
            }
            return PNone.NO_VALUE;
        }
    }

    public static abstract class CheckInquiryResultNode
    extends CExtCommonNodes.CheckFunctionResultNode {
        @Specialization(guards={"result > 0"})
        boolean doLongTrue(PythonContext context, TruffleString name, long result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, false, false, context, errOccurredProfile);
            return true;
        }

        @Specialization(guards={"result == 0"})
        boolean doLongFalse(PythonContext context, TruffleString name, long result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, false, false, context, errOccurredProfile);
            return false;
        }

        @Specialization(guards={"!isMinusOne(result)"}, replaces={"doLongTrue", "doLongFalse"})
        boolean doLongNoError(PythonContext context, TruffleString name, long result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, false, false, context, errOccurredProfile);
            return result != 0L;
        }

        @Specialization(replaces={"doLongTrue", "doLongFalse", "doLongNoError"})
        boolean doLong(PythonContext context, TruffleString name, long result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, result == -1L, false, context, errOccurredProfile);
            return result != 0L;
        }

        @Specialization(replaces={"doLongTrue", "doLongFalse", "doLongNoError", "doLong"})
        boolean doGeneric(PythonContext context, TruffleString name, Object result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile, @CachedLibrary(limit="3") InteropLibrary lib) {
            if (lib.fitsInLong(result)) {
                try {
                    return this.doLong(context, name, lib.asLong(result), errOccurredProfile);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.SystemError, ErrorMessages.FUNC_DIDNT_RETURN_INT, name);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class CheckPrimitiveFunctionResultNode
    extends CExtCommonNodes.CheckFunctionResultNode {
        @Specialization(guards={"!isMinusOne(result)"})
        long doLongNoError(PythonContext context, TruffleString name, long result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, false, false, context, errOccurredProfile);
            return result;
        }

        @Specialization(guards={"isMinusOne(result)"})
        long doLongIndicatesError(PythonContext context, TruffleString name, long result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, true, false, context, errOccurredProfile);
            return result;
        }

        @Specialization(replaces={"doLongNoError", "doLongIndicatesError"})
        long doLong(PythonContext context, TruffleString name, long result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, result == -1L, false, context, errOccurredProfile);
            return result;
        }

        @Specialization(replaces={"doLongNoError", "doLongIndicatesError", "doLong"})
        long doGeneric(PythonContext context, TruffleString name, Object result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile, @CachedLibrary(limit="2") InteropLibrary lib) {
            if (lib.fitsInLong(result)) {
                try {
                    long ret = lib.asLong(result);
                    DefaultCheckFunctionResultNode.checkFunctionResult(this, name, ret == -1L, false, context, errOccurredProfile);
                    return ret;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"expected primitive function result but does not fit into Java long");
        }
    }

    @ImportStatic(value={PGuards.class})
    public static abstract class InitCheckFunctionResultNode
    extends CExtCommonNodes.CheckFunctionResultNode {
        @Specialization(guards={"result >= 0"})
        Object doNoError(PythonContext context, TruffleString name, int result, @Cached.Shared(value="p") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, false, true, context, errOccurredProfile);
            return PNone.NONE;
        }

        @Specialization(guards={"result < 0"})
        Object doError(PythonContext context, TruffleString name, int result, @Cached.Shared(value="p") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, true, true, context, errOccurredProfile);
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization(replaces={"doNoError", "doError"})
        Object notNumber(PythonContext context, TruffleString name, Object result, @Cached.Shared(value="p") @Cached ConditionProfile errOccurredProfile, @CachedLibrary(limit="2") InteropLibrary lib) {
            int ret = 0;
            if (lib.isNumber(result)) {
                try {
                    ret = lib.asInt(result);
                    if (ret >= 0) {
                        return PNone.NONE;
                    }
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, ret < 0, true, context, errOccurredProfile);
            return result;
        }
    }

    public static abstract class CheckIterNextResultNode
    extends CExtCommonNodes.CheckFunctionResultNode {
        @Specialization(limit="3")
        static Object doGeneric(PythonContext context, TruffleString name, Object result, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @CachedLibrary(value="result") InteropLibrary lib, @Cached PRaiseNode raiseNode) {
            if (lib.isNull(result)) {
                PException currentException = getThreadStateNode.getCurrentException(inliningTarget, context);
                if (currentException == null) {
                    throw raiseNode.raiseStopIteration();
                }
                getThreadStateNode.setCurrentException(inliningTarget, context, null);
                throw currentException.getExceptionForReraise(false);
            }
            return result;
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    public static abstract class DefaultCheckFunctionResultNode
    extends CExtCommonNodes.CheckFunctionResultNode {
        @Specialization
        Object doNativeWrapper(PythonContext context, TruffleString name, PythonNativeWrapper result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, false, true, context, errOccurredProfile);
            return result;
        }

        @Specialization(guards={"isNoValue(result)"})
        Object doNoValue(PythonContext context, TruffleString name, PNone result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, true, true, context, errOccurredProfile);
            return PNone.NO_VALUE;
        }

        @Specialization(guards={"!isNoValue(result)"})
        Object doPythonObject(PythonContext context, TruffleString name, PythonAbstractObject result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, false, true, context, errOccurredProfile);
            return result;
        }

        @Specialization
        Object doPythonNativeNull(PythonContext context, TruffleString name, PythonNativePointer result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, true, true, context, errOccurredProfile);
            return result;
        }

        @Specialization
        int doInteger(PythonContext context, TruffleString name, int result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, result == -1, false, context, errOccurredProfile);
            return result;
        }

        @Specialization
        long doLong(PythonContext context, TruffleString name, long result, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, result == -1L, false, context, errOccurredProfile);
            return result;
        }

        @Specialization(guards={"!isPythonNativeWrapper(result)", "!isPNone(result)"})
        Object doForeign(PythonContext context, TruffleString name, Object result, @Cached.Exclusive @Cached ConditionProfile isNullProfile, @Cached.Exclusive @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared(value="errOccurredProfile") @Cached ConditionProfile errOccurredProfile) {
            DefaultCheckFunctionResultNode.checkFunctionResult(this, name, isNullProfile.profile(lib.isNull(result)), true, context, errOccurredProfile);
            return result;
        }

        private static void checkFunctionResult(Node node, TruffleString name, boolean indicatesError, boolean strict, PythonContext context, ConditionProfile errOccurredProfile) {
            PythonLanguage language = PythonLanguage.get(node);
            DefaultCheckFunctionResultNode.checkFunctionResult(node, name, indicatesError, strict, language, context, errOccurredProfile, ErrorMessages.RETURNED_NULL_WO_SETTING_EXCEPTION, ErrorMessages.RETURNED_RESULT_WITH_EXCEPTION_SET);
        }

        protected static boolean isPythonNativeWrapper(Object object) {
            return object instanceof PythonNativeWrapper;
        }
    }

    @TypeSystemReference(value=PythonTypes.class)
    static abstract class MaterializePrimitiveNode
    extends Node {
        MaterializePrimitiveNode() {
        }

        public abstract Object execute(PythonObjectFactory var1, Object var2);

        @Specialization
        static PInt doInteger(PythonObjectFactory factory, int i) {
            return factory.createInt(i);
        }

        @Specialization(replaces={"doInteger"})
        static PInt doLong(PythonObjectFactory factory, long l) {
            return factory.createInt(l);
        }

        @Specialization
        static PFloat doDouble(PythonObjectFactory factory, double d) {
            return factory.createFloat(d);
        }

        @Specialization
        static PString doString(PythonObjectFactory factory, TruffleString s) {
            return factory.createString(s);
        }

        @Specialization(guards={"!needsMaterialization(object)"})
        static Object doObject(PythonObjectFactory factory, Object object) {
            return object;
        }

        static boolean needsMaterialization(Object object) {
            return object instanceof Integer || object instanceof Long || PGuards.isDouble(object) || object instanceof TruffleString;
        }
    }

    static abstract class CreateArgsTupleNode
    extends Node {
        CreateArgsTupleNode() {
        }

        public abstract PTuple execute(PythonObjectFactory var1, Object[] var2);

        @Specialization(guards={"args.length == cachedLen", "cachedLen <= 16"})
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
        static PTuple doCachedLen(PythonObjectFactory factory, Object[] args, @Cached(value="args.length") int cachedLen, @Cached(value="createMaterializeNodes(args.length)") MaterializePrimitiveNode[] materializePrimitiveNodes) {
            for (int i = 0; i < cachedLen; ++i) {
                args[i] = materializePrimitiveNodes[i].execute(factory, args[i]);
            }
            return factory.createTuple(args);
        }

        @Specialization(replaces={"doCachedLen"})
        static PTuple doGeneric(PythonObjectFactory factory, Object[] args, @Cached MaterializePrimitiveNode materializePrimitiveNode) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = materializePrimitiveNode.execute(factory, args[i]);
            }
            return factory.createTuple(args);
        }

        static MaterializePrimitiveNode[] createMaterializeNodes(int length) {
            MaterializePrimitiveNode[] materializePrimitiveNodes = new MaterializePrimitiveNode[length];
            for (int i = 0; i < length; ++i) {
                materializePrimitiveNodes[i] = ExternalFunctionNodesFactory.MaterializePrimitiveNodeGen.create();
            }
            return materializePrimitiveNodes;
        }
    }

    public static class SetterRoot
    extends GetSetRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "value"), KEYWORDS_HIDDEN_CALLABLE_AND_CLOSURE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArgNode;

        public SetterRoot(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg = this.ensureReadArgNode().execute(frame);
            return new Object[]{self, arg, this.readClosure(frame)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }

        private ReadIndexedArgumentNode ensureReadArgNode() {
            if (this.readArgNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArgNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(1));
            }
            return this.readArgNode;
        }
    }

    public static class GetterRoot
    extends GetSetRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE_AND_CLOSURE, true);

        public GetterRoot(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            return new Object[]{self, this.readClosure(frame)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static abstract class GetSetRootNode
    extends MethodDescriptorRoot {
        @Node.Child
        private ReadIndexedArgumentNode readClosureNode;

        GetSetRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
        }

        protected final Object readClosure(VirtualFrame frame) {
            if (this.readClosureNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int hiddenArg = this.getSignature().getParameterIds().length + 1;
                this.readClosureNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(hiddenArg));
            }
            return this.readClosureNode.execute(frame);
        }
    }

    static class IterNextFuncRootNode
    extends MethodDescriptorRoot {
        IterNextFuncRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        IterNextFuncRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            return new Object[]{this.readSelf(frame)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
        }

        @Override
        public Signature getSignature() {
            return MethNoargsRoot.SIGNATURE;
        }
    }

    static final class MethRichcmpOpRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "other"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArgNode = ReadIndexedArgumentNode.create(1);
        private final int op;

        MethRichcmpOpRootNode(PythonLanguage language, TruffleString name, int op) {
            super(language, name, false);
            this.op = op;
        }

        MethRichcmpOpRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider, int op) {
            super(language, name, false, provider);
            this.op = op;
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg = this.readArgNode.execute(frame);
            return new Object[]{self, arg, this.op};
        }

        @Override
        protected Object[] preparePArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg = this.readArgNode.execute(frame);
            return new Object[]{self, arg, this.op};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class MethRPowRootNode
    extends MethPowRootNode {
        MethRPowRootNode(PythonLanguage language, TruffleString name) {
            super(language, name);
        }

        MethRPowRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, provider);
        }

        @Override
        Object[] getArguments(Object arg0, Object arg1, Object arg2) {
            return new Object[]{arg1, arg0, arg2};
        }
    }

    static class MethPowRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(false, 0, false, PythonUtils.tsArray("args"), KEYWORDS_HIDDEN_CALLABLE);
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        private final ConditionProfile profile;

        MethPowRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
            this.profile = null;
        }

        MethPowRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readVarargsNode = ReadVarArgsNode.create(true);
            this.profile = ConditionProfile.create();
        }

        @Override
        protected final Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object[] varargs = this.readVarargsNode.executeObjectArray(frame);
            Object arg0 = varargs[0];
            PNone arg1 = this.profile.profile(varargs.length > 1) ? varargs[1] : PNone.NONE;
            return this.getArguments(self, arg0, arg1);
        }

        Object[] getArguments(Object arg0, Object arg1, Object arg2) {
            return new Object[]{arg0, arg1, arg2};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
            releaseNativeWrapperNode.execute(cArguments[2]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class MethReverseRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "obj"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArg0Node = ReadIndexedArgumentNode.create(0);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node = ReadIndexedArgumentNode.create(1);

        MethReverseRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        MethReverseRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object arg0 = this.readArg0Node.execute(frame);
            Object arg1 = this.readArg1Node.execute(frame);
            return new Object[]{arg1, arg0};
        }

        @Override
        protected Object[] preparePArguments(VirtualFrame frame) {
            Object arg0 = this.readArg0Node.execute(frame);
            Object arg1 = this.readArg1Node.execute(frame);
            return new Object[]{arg1, arg0};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class MpDelItemRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "i"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;

        MpDelItemRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        MpDelItemRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArg1Node = ReadIndexedArgumentNode.create(1);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg1 = this.readArg1Node.execute(frame);
            return new Object[]{self, arg1, PNone.NO_VALUE};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
            releaseNativeWrapperNode.execute(cArguments[2]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class DescrGetRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "obj", "type"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readObj;
        @Node.Child
        private ReadIndexedArgumentNode readType;

        public DescrGetRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        public DescrGetRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readObj = ReadIndexedArgumentNode.create(1);
            this.readType = ReadIndexedArgumentNode.create(2);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object obj = this.readObj.execute(frame);
            Object type = this.readType.execute(frame);
            return new Object[]{self, obj == PNone.NONE ? PNone.NO_VALUE : obj, type == PNone.NONE ? PNone.NO_VALUE : type};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
            releaseNativeWrapperNode.execute(cArguments[2]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class SetItemRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "i", "value"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private ReadIndexedArgumentNode readArg2Node;
        @Node.Child
        private CExtCommonNodes.GetIndexNode getIndexNode;

        SetItemRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        SetItemRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArg1Node = ReadIndexedArgumentNode.create(1);
            this.readArg2Node = ReadIndexedArgumentNode.create(2);
            this.getIndexNode = CExtCommonNodes.GetIndexNode.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg1 = this.readArg1Node.execute(frame);
            Object arg2 = this.readArg2Node.execute(frame);
            return new Object[]{self, this.getIndexNode.execute(self, arg1), arg2};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[2]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class GetItemRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "i"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private CExtCommonNodes.GetIndexNode getIndexNode;

        GetItemRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        GetItemRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArg1Node = ReadIndexedArgumentNode.create(1);
            this.getIndexNode = CExtCommonNodes.GetIndexNode.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg1 = this.readArg1Node.execute(frame);
            return new Object[]{self, this.getIndexNode.execute(self, arg1)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class RichCmpFuncRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "other", "op"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private ReadIndexedArgumentNode readArg2Node;
        @Node.Child
        private CExtCommonNodes.ConvertPIntToPrimitiveNode asSsizeTNode;

        RichCmpFuncRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        RichCmpFuncRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArg1Node = ReadIndexedArgumentNode.create(1);
            this.readArg2Node = ReadIndexedArgumentNode.create(2);
            this.asSsizeTNode = CExtCommonNodesFactory.ConvertPIntToPrimitiveNodeGen.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            try {
                Object self = this.readSelf(frame);
                Object arg1 = this.readArg1Node.execute(frame);
                Object arg2 = this.readArg2Node.execute(frame);
                return new Object[]{self, arg1, this.asSsizeTNode.executeInt(arg2, 1, 4)};
            }
            catch (UnexpectedResultException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class SetAttrFuncRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "key", "value"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private ReadIndexedArgumentNode readArg2Node;
        @Node.Child
        private CExtNodes.AsCharPointerNode asCharPointerNode;
        @Node.Child
        private CStructAccess.FreeNode free;

        SetAttrFuncRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        SetAttrFuncRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArg1Node = ReadIndexedArgumentNode.create(1);
            this.readArg2Node = ReadIndexedArgumentNode.create(2);
            this.asCharPointerNode = CExtNodesFactory.AsCharPointerNodeGen.create();
            this.free = CStructAccess.FreeNode.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg1 = this.readArg1Node.execute(frame);
            Object arg2 = this.readArg2Node.execute(frame);
            return new Object[]{self, this.asCharPointerNode.execute(arg1), arg2};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            this.free.free(cArguments[1]);
            releaseNativeWrapperNode.execute(cArguments[2]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class GetAttrFuncRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "key"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArgNode;
        @Node.Child
        private CExtNodes.AsCharPointerNode asCharPointerNode;
        @Node.Child
        private CStructAccess.FreeNode free;

        GetAttrFuncRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        GetAttrFuncRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArgNode = ReadIndexedArgumentNode.create(1);
            this.asCharPointerNode = CExtNodesFactory.AsCharPointerNodeGen.create();
            this.free = CStructAccess.FreeNode.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg = this.readArgNode.execute(frame);
            return new Object[]{self, this.asCharPointerNode.execute(arg)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
            this.free.free(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static class AllocFuncRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "nitems"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArgNode;
        @Node.Child
        private CExtCommonNodes.ConvertPIntToPrimitiveNode asSsizeTNode;

        AllocFuncRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        AllocFuncRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArgNode = ReadIndexedArgumentNode.create(1);
            this.asSsizeTNode = CExtCommonNodesFactory.ConvertPIntToPrimitiveNodeGen.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg = this.readArgNode.execute(frame);
            try {
                return new Object[]{self, this.asSsizeTNode.executeLong(arg, 1, 8)};
            }
            catch (UnexpectedResultException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethFastcallRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, 1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadVarArgsNode readVarargsNode;

        public MethFastcallRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethFastcallRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
            this.readVarargsNode = ReadVarArgsNode.create(true);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object[] args = this.readVarargsNode.executeObjectArray(frame);
            return new Object[]{self, new CPyObjectArrayWrapper(args), args.length};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            CPyObjectArrayWrapper wrapper = (CPyObjectArrayWrapper)cArguments[1];
            wrapper.free(this.ensureReleaseNativeWrapperNode());
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethMethodRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, true, 1, false, PythonUtils.tsArray("self", "cls"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private PythonObjectFactory factory;
        @Node.Child
        private ReadIndexedArgumentNode readClsNode;
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private ReadVarKeywordsNode readKwargsNode;

        public MethMethodRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethMethodRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
            this.factory = PythonObjectFactory.create();
            this.readClsNode = ReadIndexedArgumentNode.create(1);
            this.readVarargsNode = ReadVarArgsNode.create(true);
            this.readKwargsNode = ReadVarKeywordsNode.create(PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object cls = this.readClsNode.execute(frame);
            Object[] args = this.readVarargsNode.executeObjectArray(frame);
            PKeyword[] kwargs = this.readKwargsNode.executePKeyword(frame);
            Object[] fastcallArgs = new Object[args.length + kwargs.length];
            Object[] fastcallKwnames = new Object[kwargs.length];
            PythonUtils.arraycopy(args, 0, fastcallArgs, 0, args.length);
            for (int i = 0; i < kwargs.length; ++i) {
                fastcallKwnames[i] = kwargs[i].getName();
                fastcallArgs[args.length + i] = kwargs[i].getValue();
            }
            return new Object[]{self, cls, new CPyObjectArrayWrapper(fastcallArgs), args.length, this.factory.createTuple(fastcallKwnames)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
            CPyObjectArrayWrapper wrapper = (CPyObjectArrayWrapper)cArguments[2];
            wrapper.free(releaseNativeWrapperNode);
            releaseNativeWrapperNode.execute(cArguments[4]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethFastcallWithKeywordsRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, true, 1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private PythonObjectFactory factory;
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private ReadVarKeywordsNode readKwargsNode;

        public MethFastcallWithKeywordsRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethFastcallWithKeywordsRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
            this.factory = PythonObjectFactory.create();
            this.readVarargsNode = ReadVarArgsNode.create(true);
            this.readKwargsNode = ReadVarKeywordsNode.create(PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object[] args = this.readVarargsNode.executeObjectArray(frame);
            PKeyword[] kwargs = this.readKwargsNode.executePKeyword(frame);
            Object[] fastcallArgs = new Object[args.length + kwargs.length];
            Object[] fastcallKwnames = new Object[kwargs.length];
            PythonUtils.arraycopy(args, 0, fastcallArgs, 0, args.length);
            for (int i = 0; i < kwargs.length; ++i) {
                fastcallKwnames[i] = kwargs[i].getName();
                fastcallArgs[args.length + i] = kwargs[i].getValue();
            }
            return new Object[]{self, new CPyObjectArrayWrapper(fastcallArgs), args.length, this.factory.createTuple(fastcallKwnames)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            CPyObjectArrayWrapper wrapper = (CPyObjectArrayWrapper)cArguments[1];
            wrapper.free(this.ensureReleaseNativeWrapperNode());
            releaseNativeWrapperNode.execute(cArguments[3]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethORoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self", "arg"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private ReadIndexedArgumentNode readArgNode;

        public MethORoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethORoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
            this.readArgNode = ReadIndexedArgumentNode.create(1);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg = this.readArgNode.execute(frame);
            return new Object[]{self, arg};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethNoargsRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE, true);

        public MethNoargsRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethNoargsRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            return new Object[]{this.readSelf(frame), PNone.NONE};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethInquiryRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE, true);

        public MethInquiryRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethInquiryRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            return new Object[]{this.readSelf(frame)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethVarargsRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, false, 1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private PythonObjectFactory factory;
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private CreateArgsTupleNode createArgsTupleNode;

        public MethVarargsRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethVarargsRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
            this.factory = PythonObjectFactory.create();
            this.readVarargsNode = ReadVarArgsNode.create(true);
            this.createArgsTupleNode = ExternalFunctionNodesFactory.CreateArgsTupleNodeGen.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object[] args = this.readVarargsNode.executeObjectArray(frame);
            return new Object[]{self, this.createArgsTupleNode.execute(this.factory, args)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethKeywordsRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, true, 1, false, PythonUtils.tsArray("self"), KEYWORDS_HIDDEN_CALLABLE, true);
        @Node.Child
        private PythonObjectFactory factory;
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private ReadVarKeywordsNode readKwargsNode;
        @Node.Child
        private CreateArgsTupleNode createArgsTupleNode;

        public MethKeywordsRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethKeywordsRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
            this.factory = PythonObjectFactory.create();
            this.readVarargsNode = ReadVarArgsNode.create(true);
            this.readKwargsNode = ReadVarKeywordsNode.create(PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
            this.createArgsTupleNode = ExternalFunctionNodesFactory.CreateArgsTupleNodeGen.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object[] args = this.readVarargsNode.executeObjectArray(frame);
            PKeyword[] kwargs = this.readKwargsNode.executePKeyword(frame);
            return new Object[]{self, this.createArgsTupleNode.execute(this.factory, args), this.factory.createDict(kwargs)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
            releaseNativeWrapperNode.execute(cArguments[2]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class ExternalFunctionInvokeNode
    extends PNodeWithContext
    implements IndirectCallNode {
        private final CApiTiming timing;
        @Node.Child
        private CExtCommonNodes.CheckFunctionResultNode checkResultNode;
        @Node.Child
        private PForeignToPTypeNode fromForeign = PForeignToPTypeNode.create();
        @Node.Child
        private CExtToJavaNode convertReturnValue;
        @Node.Child
        private InteropLibrary lib;
        @Node.Child
        private PythonContext.GetThreadStateNode getThreadStateNode = PythonContextFactory.GetThreadStateNodeGen.create();
        @Node.Child
        private GilNode gilNode = GilNode.create();
        @CompilerDirectives.CompilationFinal
        private Assumption nativeCodeDoesntNeedExceptionState = Truffle.getRuntime().createAssumption();
        @CompilerDirectives.CompilationFinal
        private Assumption nativeCodeDoesntNeedMyFrame = Truffle.getRuntime().createAssumption();
        private final PExternalFunctionWrapper provider;

        public PExternalFunctionWrapper getWrapper() {
            return this.provider;
        }

        @Override
        public Assumption needNotPassFrameAssumption() {
            return this.nativeCodeDoesntNeedMyFrame;
        }

        @Override
        public Assumption needNotPassExceptionAssumption() {
            return this.nativeCodeDoesntNeedExceptionState;
        }

        public Node copy() {
            ExternalFunctionInvokeNode node = (ExternalFunctionInvokeNode)super.copy();
            node.nativeCodeDoesntNeedMyFrame = Truffle.getRuntime().createAssumption();
            node.nativeCodeDoesntNeedExceptionState = Truffle.getRuntime().createAssumption();
            return node;
        }

        @CompilerDirectives.TruffleBoundary
        ExternalFunctionInvokeNode(PExternalFunctionWrapper provider) {
            this.timing = CApiTiming.create(true, provider.name());
            CExtCommonNodes.CheckFunctionResultNode node = provider.createCheckFunctionResultNode();
            this.checkResultNode = node != null ? node : ExternalFunctionNodesFactory.DefaultCheckFunctionResultNodeGen.create();
            this.convertReturnValue = provider.createConvertRetNode();
            this.provider = provider;
        }

        public Object execute(VirtualFrame frame, TruffleString name, Object callable, Object[] cArguments) {
            if (this.lib == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lib = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(2)));
            }
            PythonContext ctx = PythonContext.get(this);
            PythonContext.PythonThreadState threadState = this.getThreadStateNode.executeCached(ctx);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, threadState, this);
            CApiTiming.enter();
            try {
                Object result = this.lib.execute(callable, cArguments);
                result = this.checkResultNode.execute(ctx, name, result);
                if (this.convertReturnValue != null) {
                    result = this.convertReturnValue.execute(result);
                }
                Object object = this.fromForeign.executeConvert(result);
                return object;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_FAILED, name, e);
            }
            catch (ArityException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_EXPECTED_ARGS, name, e.getExpectedMinArity(), e.getActualArity());
            }
            finally {
                CApiTiming.exit(this.timing);
                this.gilNode.acquire();
                if (frame != null) {
                    PArguments.setException((Frame)frame, threadState.getCaughtException());
                }
                ExecutionContext.IndirectCallContext.exit(frame, threadState, state);
            }
        }

        @NeverDefault
        public static ExternalFunctionInvokeNode create(PExternalFunctionWrapper provider) {
            return new ExternalFunctionInvokeNode(provider);
        }
    }

    static final class MethDirectRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = new Signature(-1, true, 0, false, null, KEYWORDS_HIDDEN_CALLABLE);

        private MethDirectRoot(PythonLanguage lang, TruffleString name, PExternalFunctionWrapper provider) {
            super(lang, name, true, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object[] varargs = PArguments.getVariableArguments((Frame)frame);
            return PythonUtils.arrayCopyOf(varargs, varargs.length);
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            for (int i = 0; i < cArguments.length; ++i) {
                this.ensureReleaseNativeWrapperNode().execute(cArguments[i]);
            }
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }

        @CompilerDirectives.TruffleBoundary
        public static MethDirectRoot create(PythonLanguage lang, TruffleString name, PExternalFunctionWrapper provider) {
            return new MethDirectRoot(lang, name, provider);
        }
    }

    public static final class PExternalFunctionWrapper
    extends Enum<PExternalFunctionWrapper>
    implements NativeCExtSymbol {
        public static final /* enum */ PExternalFunctionWrapper DIRECT = new PExternalFunctionWrapper(1, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper FASTCALL = new PExternalFunctionWrapper(2, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
        public static final /* enum */ PExternalFunctionWrapper FASTCALL_WITH_KEYWORDS = new PExternalFunctionWrapper(3, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper KEYWORDS = new PExternalFunctionWrapper(4, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper VARARGS = new PExternalFunctionWrapper(5, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper NOARGS = new PExternalFunctionWrapper(6, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper O = new PExternalFunctionWrapper(7, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper METHOD = new PExternalFunctionWrapper(8, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyTypeObject, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper ALLOC = new PExternalFunctionWrapper(10, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t);
        public static final /* enum */ PExternalFunctionWrapper GETATTR = new PExternalFunctionWrapper(11, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.CharPtrAsTruffleString);
        public static final /* enum */ PExternalFunctionWrapper SETATTR = new PExternalFunctionWrapper(12, ArgDescriptor.Int, ArgDescriptor.PyObject, ArgDescriptor.CharPtrAsTruffleString, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper RICHCMP = new PExternalFunctionWrapper(13, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper SETITEM = new PExternalFunctionWrapper(14, ArgDescriptor.Int, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper UNARYFUNC = new PExternalFunctionWrapper(15, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper BINARYFUNC = new PExternalFunctionWrapper(16, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper BINARYFUNC_L = new PExternalFunctionWrapper(17, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper BINARYFUNC_R = new PExternalFunctionWrapper(18, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper TERNARYFUNC = new PExternalFunctionWrapper(19, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper TERNARYFUNC_R = new PExternalFunctionWrapper(20, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper LT = new PExternalFunctionWrapper(21, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper LE = new PExternalFunctionWrapper(22, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper EQ = new PExternalFunctionWrapper(23, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper NE = new PExternalFunctionWrapper(24, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper GT = new PExternalFunctionWrapper(25, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper GE = new PExternalFunctionWrapper(26, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper ITERNEXT = new PExternalFunctionWrapper(27, ArgDescriptor.IterResult, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper INQUIRY = new PExternalFunctionWrapper(28, ArgDescriptor.InquiryResult, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper DELITEM = new PExternalFunctionWrapper(29, ArgDescriptor.Int, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper GETITEM = new PExternalFunctionWrapper(30, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t);
        public static final /* enum */ PExternalFunctionWrapper GETTER = new PExternalFunctionWrapper(31, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.Pointer);
        public static final /* enum */ PExternalFunctionWrapper SETTER = new PExternalFunctionWrapper(32, ArgDescriptor.Int, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Pointer);
        public static final /* enum */ PExternalFunctionWrapper INITPROC = new PExternalFunctionWrapper(33, ArgDescriptor.InitResult, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper HASHFUNC = new PExternalFunctionWrapper(34, ArgDescriptor.PrimitiveResult64, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper CALL = new PExternalFunctionWrapper(35, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper SETATTRO = new PExternalFunctionWrapper(36, ArgDescriptor.InitResult, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper DESCR_GET = new PExternalFunctionWrapper(37, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper DESCR_SET = new PExternalFunctionWrapper(38, ArgDescriptor.InitResult, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper LENFUNC = new PExternalFunctionWrapper(39, ArgDescriptor.PrimitiveResult64, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper OBJOBJPROC = new PExternalFunctionWrapper(40, ArgDescriptor.InquiryResult, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper OBJOBJARGPROC = new PExternalFunctionWrapper(41, ArgDescriptor.PrimitiveResult32, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper NEW = new PExternalFunctionWrapper(42, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper MP_DELITEM = new PExternalFunctionWrapper(43, ArgDescriptor.PrimitiveResult32, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper TP_STR = new PExternalFunctionWrapper(44, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper TP_REPR = new PExternalFunctionWrapper(45, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject);
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final PExternalFunctionWrapper[] VALUES;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final PExternalFunctionWrapper[] BY_ID;
        public final String signature;
        public final ArgDescriptor returnValue;
        public final ArgDescriptor[] arguments;
        private final int value;
        private static final /* synthetic */ PExternalFunctionWrapper[] $VALUES;

        public static PExternalFunctionWrapper[] values() {
            return (PExternalFunctionWrapper[])$VALUES.clone();
        }

        public static PExternalFunctionWrapper valueOf(String name) {
            return Enum.valueOf(PExternalFunctionWrapper.class, name);
        }

        private PExternalFunctionWrapper(int value, ArgDescriptor returnValue, ArgDescriptor ... arguments) {
            this.value = value;
            this.returnValue = returnValue;
            this.arguments = arguments;
            StringBuilder s = new StringBuilder("(");
            for (int i = 0; i < arguments.length; ++i) {
                s.append(i == 0 ? "" : ",");
                s.append(arguments[i].getNFISignature());
            }
            s.append("):").append(returnValue.getNFISignature());
            this.signature = s.toString();
        }

        static PExternalFunctionWrapper fromValue(int value) {
            return value >= 0 && value < BY_ID.length ? BY_ID[value] : null;
        }

        static PExternalFunctionWrapper fromMethodFlags(int flags) {
            if (CExtContext.isMethNoArgs(flags)) {
                return NOARGS;
            }
            if (CExtContext.isMethO(flags)) {
                return O;
            }
            if (CExtContext.isMethVarargsWithKeywords(flags)) {
                return KEYWORDS;
            }
            if (CExtContext.isMethVarargs(flags)) {
                return VARARGS;
            }
            if (CExtContext.isMethMethod(flags)) {
                return METHOD;
            }
            if (CExtContext.isMethFastcallWithKeywords(flags)) {
                return FASTCALL_WITH_KEYWORDS;
            }
            if (CExtContext.isMethFastcall(flags)) {
                return FASTCALL;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"illegal method flags");
        }

        @CompilerDirectives.TruffleBoundary
        static RootCallTarget getOrCreateCallTarget(PExternalFunctionWrapper sig, PythonLanguage language, TruffleString name, boolean doArgAndResultConversion, boolean isStatic) {
            Function rootNodeFunction;
            Class nodeKlass;
            switch (sig) {
                case ALLOC: {
                    nodeKlass = AllocFuncRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new AllocFuncRootNode((PythonLanguage)((Object)l), name, sig) : l -> new AllocFuncRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case DIRECT: 
                case DESCR_SET: 
                case LENFUNC: 
                case HASHFUNC: 
                case SETATTRO: 
                case OBJOBJPROC: 
                case OBJOBJARGPROC: 
                case UNARYFUNC: 
                case BINARYFUNC: 
                case BINARYFUNC_L: 
                case TP_STR: 
                case TP_REPR: {
                    if (!doArgAndResultConversion) {
                        return null;
                    }
                    nodeKlass = MethDirectRoot.class;
                    rootNodeFunction = l -> MethDirectRoot.create(language, name, sig);
                    break;
                }
                case CALL: 
                case INITPROC: 
                case KEYWORDS: 
                case NEW: {
                    if (!doArgAndResultConversion) {
                        return null;
                    }
                    nodeKlass = MethKeywordsRoot.class;
                    rootNodeFunction = l -> new MethKeywordsRoot((PythonLanguage)((Object)l), name, isStatic, sig);
                    break;
                }
                case VARARGS: {
                    nodeKlass = MethVarargsRoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethVarargsRoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethVarargsRoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case INQUIRY: {
                    nodeKlass = MethInquiryRoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethInquiryRoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethInquiryRoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case NOARGS: {
                    nodeKlass = MethNoargsRoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethNoargsRoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethNoargsRoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case O: {
                    nodeKlass = MethORoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethORoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethORoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case FASTCALL: {
                    nodeKlass = MethFastcallRoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethFastcallRoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethFastcallRoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case FASTCALL_WITH_KEYWORDS: {
                    nodeKlass = MethFastcallWithKeywordsRoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethFastcallWithKeywordsRoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethFastcallWithKeywordsRoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case METHOD: {
                    nodeKlass = MethMethodRoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethMethodRoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethMethodRoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case GETATTR: {
                    nodeKlass = GetAttrFuncRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new GetAttrFuncRootNode((PythonLanguage)((Object)l), name, sig) : l -> new GetAttrFuncRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case SETATTR: {
                    nodeKlass = SetAttrFuncRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new SetAttrFuncRootNode((PythonLanguage)((Object)l), name, sig) : l -> new SetAttrFuncRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case DESCR_GET: {
                    nodeKlass = DescrGetRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new DescrGetRootNode((PythonLanguage)((Object)l), name, sig) : l -> new DescrGetRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case RICHCMP: {
                    nodeKlass = RichCmpFuncRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new RichCmpFuncRootNode((PythonLanguage)((Object)l), name, sig) : l -> new RichCmpFuncRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case SETITEM: 
                case DELITEM: {
                    nodeKlass = SetItemRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new SetItemRootNode((PythonLanguage)((Object)l), name, sig) : l -> new SetItemRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case GETITEM: {
                    nodeKlass = GetItemRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new GetItemRootNode((PythonLanguage)((Object)l), name, sig) : l -> new GetItemRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case BINARYFUNC_R: {
                    nodeKlass = MethReverseRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethReverseRootNode((PythonLanguage)((Object)l), name, sig) : l -> new MethReverseRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case TERNARYFUNC: {
                    nodeKlass = MethPowRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethPowRootNode((PythonLanguage)((Object)l), name, sig) : l -> new MethPowRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case TERNARYFUNC_R: {
                    nodeKlass = MethRPowRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethRPowRootNode((PythonLanguage)((Object)l), name, sig) : l -> new MethRPowRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case GT: 
                case GE: 
                case LE: 
                case LT: 
                case EQ: 
                case NE: {
                    nodeKlass = MethRichcmpOpRootNode.class;
                    int op = PExternalFunctionWrapper.getCompareOpCode(sig);
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethRichcmpOpRootNode((PythonLanguage)((Object)l), name, sig, op) : l -> new MethRichcmpOpRootNode((PythonLanguage)((Object)l), name, op);
                    break;
                }
                case ITERNEXT: {
                    nodeKlass = IterNextFuncRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new IterNextFuncRootNode((PythonLanguage)((Object)l), name, sig) : l -> new IterNextFuncRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case GETTER: {
                    if (!doArgAndResultConversion) {
                        return null;
                    }
                    nodeKlass = GetterRoot.class;
                    rootNodeFunction = l -> new GetterRoot((PythonLanguage)((Object)l), name, sig);
                    break;
                }
                case SETTER: {
                    if (!doArgAndResultConversion) {
                        return null;
                    }
                    nodeKlass = SetterRoot.class;
                    rootNodeFunction = l -> new SetterRoot((PythonLanguage)((Object)l), name, sig);
                    break;
                }
                case MP_DELITEM: {
                    nodeKlass = MpDelItemRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MpDelItemRootNode((PythonLanguage)((Object)l), name, sig) : l -> new MpDelItemRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            return language.createCachedCallTarget((Function<PythonLanguage, RootNode>)rootNodeFunction, nodeKlass, sig, name, doArgAndResultConversion);
        }

        public static PBuiltinFunction createWrapperFunction(TruffleString name, Object callable, Object enclosingType, int flags, int sig, PythonLanguage language, PythonObjectFactory factory, boolean doArgAndResultConversion) {
            return PExternalFunctionWrapper.createWrapperFunction(name, callable, enclosingType, flags, PExternalFunctionWrapper.fromValue(sig), language, factory, doArgAndResultConversion);
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createWrapperFunction(TruffleString name, Object callable, Object enclosingType, int flags, PExternalFunctionWrapper sig, PythonLanguage language, PythonObjectFactory factory, boolean doArgAndResultConversion) {
            Object[] defaults;
            int numDefaults;
            RootCallTarget callTarget;
            LOGGER.finer(() -> PythonUtils.formatJString("ExternalFunctions.createWrapperFunction(%s, %s)", name, callable));
            InteropLibrary lib = InteropLibrary.getUncached((Object)callable);
            assert (!PExternalFunctionWrapper.isClosurePointer(PythonContext.get(null), callable, lib));
            if (flags < 0) {
                flags = 0;
            }
            if ((callTarget = PExternalFunctionWrapper.getOrCreateCallTarget(sig, language, name, doArgAndResultConversion, CExtContext.isMethStatic(flags))) == null) {
                return null;
            }
            int n = numDefaults = sig == DELITEM ? 1 : 0;
            if (numDefaults > 0) {
                defaults = new Object[numDefaults];
                Arrays.fill(defaults, PNone.NO_VALUE);
            } else {
                defaults = PythonUtils.EMPTY_OBJECT_ARRAY;
            }
            Object boundCallable = NativeCExtSymbol.ensureExecutable(callable, sig);
            Object type = enclosingType == PNone.NO_VALUE || SpecialMethodNames.T___NEW__.equalsUncached((AbstractTruffleString)name, PythonUtils.TS_ENCODING) ? null : enclosingType;
            switch (sig) {
                case KEYWORDS: 
                case VARARGS: 
                case NOARGS: 
                case O: 
                case FASTCALL: 
                case FASTCALL_WITH_KEYWORDS: 
                case METHOD: {
                    return factory.createBuiltinFunction(name, type, defaults, ExternalFunctionNodes.createKwDefaults(boundCallable), flags, callTarget);
                }
            }
            return factory.createWrapperDescriptor(name, type, defaults, ExternalFunctionNodes.createKwDefaults(boundCallable), flags, callTarget);
        }

        private static boolean isClosurePointer(PythonContext context, Object callable, InteropLibrary lib) {
            if (lib.isPointer(callable)) {
                try {
                    Object delegate = context.getCApiContext().getClosureDelegate(lib.asPointer(callable));
                    return delegate instanceof PBuiltinFunction;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return false;
        }

        private static int getCompareOpCode(PExternalFunctionWrapper sig) {
            switch (sig) {
                case LT: {
                    return 0;
                }
                case LE: {
                    return 1;
                }
                case EQ: {
                    return 2;
                }
                case NE: {
                    return 3;
                }
                case GT: {
                    return 4;
                }
                case GE: {
                    return 5;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        CExtCommonNodes.CheckFunctionResultNode createCheckFunctionResultNode() {
            return this.returnValue.createCheckResultNode();
        }

        CExtToJavaNode createConvertRetNode() {
            return this.returnValue.createNativeToPythonNode();
        }

        CExtToNativeNode[] createConvertArgNodes() {
            return PExternalFunctionWrapper.createConvertArgNodes(this.arguments);
        }

        public static CExtToNativeNode[] createConvertArgNodes(ArgDescriptor[] descriptors) {
            CExtToNativeNode[] result = new CExtToNativeNode[descriptors.length];
            for (int i = 0; i < descriptors.length; ++i) {
                result[i] = descriptors[i].createPythonToNativeNode();
            }
            return result;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public TruffleString getTsName() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        private static /* synthetic */ PExternalFunctionWrapper[] $values() {
            return new PExternalFunctionWrapper[]{DIRECT, FASTCALL, FASTCALL_WITH_KEYWORDS, KEYWORDS, VARARGS, NOARGS, O, METHOD, ALLOC, GETATTR, SETATTR, RICHCMP, SETITEM, UNARYFUNC, BINARYFUNC, BINARYFUNC_L, BINARYFUNC_R, TERNARYFUNC, TERNARYFUNC_R, LT, LE, EQ, NE, GT, GE, ITERNEXT, INQUIRY, DELITEM, GETITEM, GETTER, SETTER, INITPROC, HASHFUNC, CALL, SETATTRO, DESCR_GET, DESCR_SET, LENFUNC, OBJOBJPROC, OBJOBJARGPROC, NEW, MP_DELITEM, TP_STR, TP_REPR};
        }

        static {
            $VALUES = PExternalFunctionWrapper.$values();
            VALUES = PExternalFunctionWrapper.values();
            BY_ID = new PExternalFunctionWrapper[50];
            for (PExternalFunctionWrapper e : VALUES) {
                assert (BY_ID[e.value] == null);
                PExternalFunctionWrapper.BY_ID[e.value] = e;
            }
        }
    }

    public static final class ToPythonWrapperNode
    extends CExtToJavaNode {
        @Override
        public PythonNativeWrapper execute(Object object) {
            return CApiTransitions.nativeToPythonWrapper(object);
        }
    }

    public static final class ToPythonStringNode
    extends CExtToJavaNode {
        @Node.Child
        private CastToTruffleStringNode castToStringNode = CastToTruffleStringNode.create();
        @Node.Child
        private CApiTransitions.NativeToPythonNode nativeToPythonNode = CApiTransitionsFactory.NativeToPythonNodeGen.create();

        @Override
        public Object execute(Object object) {
            Object result = this.nativeToPythonNode.execute(object);
            if (result instanceof TruffleString) {
                return result;
            }
            if (result instanceof PString) {
                return this.castToStringNode.executeCached(result);
            }
            if (result == PNone.NO_VALUE) {
                return result;
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    public static final class WrappedPointerToPythonNode
    extends CExtToJavaNode {
        @Override
        public Object execute(Object object) {
            if (object instanceof PythonNativeWrapper) {
                return ((PythonNativeWrapper)object).getDelegate();
            }
            return object;
        }
    }

    @GenerateUncached
    public static abstract class ToNativeReplacedNode
    extends CExtToNativeNode {
        @Specialization
        public Object replace(Object object, @Bind(value="$node") Node inliningTarget, @Cached InlinedConditionProfile profile, @CachedLibrary(limit="3") InteropLibrary lib) {
            if (profile.profile(inliningTarget, object instanceof PythonReplacingNativeWrapper)) {
                if (!lib.isPointer(object)) {
                    lib.toNative(object);
                }
                return ((PythonReplacingNativeWrapper)object).getReplacement();
            }
            return object;
        }
    }

    public static final class ToNativeBorrowedNode
    extends CExtToNativeNode {
        @Node.Child
        private CApiTransitions.PythonToNativeNode toNative = CApiTransitionsFactory.PythonToNativeNodeGen.create();

        @Override
        public Object execute(Object object) {
            assert (object instanceof Double && Double.isNaN((Double)object) || !(object instanceof Number) && !(object instanceof TruffleString));
            return this.toNative.execute(object);
        }
    }

    public static abstract class ToInt32Node
    extends CExtToNativeNode {
        @Specialization
        static int doInt(int value) {
            return value;
        }
    }

    public static abstract class ToInt64Node
    extends CExtToNativeNode {
        @Specialization
        static long doInt(int value) {
            return value;
        }

        @Specialization
        static long doLong(long value) {
            return value;
        }

        @Fallback
        static Object doOther(Object value) {
            assert (CApiTransitions.isBackendPointerObject(value));
            return value;
        }
    }

    public static abstract class FromUInt32Node
    extends CExtToJavaNode {
        @Specialization
        static int doInt(int value) {
            return value;
        }

        @Specialization
        static int doLong(long value) {
            assert (value < 0x100000000L);
            return (int)value;
        }
    }

    public static abstract class FromLongNode
    extends CExtToJavaNode {
        @Specialization
        static long doInt(int value) {
            return (long)value & 0xFFFFFFFFL;
        }

        @Specialization
        static long doLong(long value) {
            return value;
        }

        @Fallback
        static Object doOther(Object value) {
            assert (CApiTransitions.isBackendPointerObject(value));
            return value;
        }
    }

    public static abstract class FinishArgNode
    extends PNodeWithContext {
        public abstract void execute(Object var1);
    }
}

