/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.dict;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictNodesFactory;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public abstract class DictNodes {

    @ImportStatic(value={HashingStorageNodes.HashingStorageGuards.class})
    public static abstract class UpdateNode
    extends PNodeWithContext {
        public abstract void execute(Frame var1, PDict var2, Object var3);

        @Specialization(guards={"isIdentical(self, other)"})
        static void updateSelf(VirtualFrame frame, PDict self, Object other) {
        }

        @Specialization(guards={"!mayHaveSideEffectingEq(self)"})
        static void updateDictNoSideEffects(PDict self, PDict other, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
            addAllToOther.execute(null, inliningTarget, other.getDictStorage(), self);
        }

        @Specialization(guards={"mayHaveSideEffectingEq(self)"})
        static void updateDictGeneric(VirtualFrame frame, PDict self, PDict other, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageTransferItem transferItem, @Cached HashingStorageNodes.HashingStorageGetIterator getOtherIter, @Cached HashingStorageNodes.HashingStorageIteratorNext iterNext, @Cached HashingStorageNodes.HashingStorageLen otherLenNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            HashingStorage selfStorage = self.getDictStorage();
            HashingStorage otherStorage = other.getDictStorage();
            int initialSize = otherLenNode.execute(inliningTarget, otherStorage);
            HashingStorageNodes.HashingStorageIterator itOther = getOtherIter.execute(inliningTarget, otherStorage);
            while (iterNext.execute(inliningTarget, otherStorage, itOther)) {
                selfStorage = transferItem.execute((Frame)frame, inliningTarget, otherStorage, itOther, selfStorage);
                if (initialSize == otherLenNode.execute(inliningTarget, otherStorage)) continue;
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.MUTATED_DURING_UPDATE, "dict");
            }
            self.setDictStorage(selfStorage);
        }

        @Specialization(guards={"!isDict(other)"})
        static void updateArg(VirtualFrame frame, PDict self, Object other, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached PyObjectLookupAttr lookupKeys, @Cached HashingStorage.ObjectToArrayPairNode toArrayPair) {
            Object keyAttr = lookupKeys.execute((Frame)frame, inliningTarget, other, SpecialMethodNames.T_KEYS);
            HashingStorage storage = HashingStorage.addKeyValuesToStorage(frame, self, other, keyAttr, inliningTarget, toArrayPair, setItem);
            self.setDictStorage(storage);
        }

        protected static boolean isIdentical(PDict dict, Object other) {
            return dict == other;
        }

        @NeverDefault
        public static UpdateNode create() {
            return DictNodesFactory.UpdateNodeGen.create();
        }
    }
}

