/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectGetAttrNodeGen;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyObjectGetAttr
extends Node {
    public static Object executeUncached(Object receiver, Object name) {
        return PyObjectGetAttr.getUncached().execute(null, null, receiver, name);
    }

    public final Object executeCached(Frame frame, Object receiver, Object name) {
        return this.execute(frame, this, receiver, name);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3, Object var4);

    public final Object execute(Node inliningTarget, Object receiver, Object name) {
        return this.execute(null, inliningTarget, receiver, name);
    }

    @Specialization(guards={"name == cachedName"}, limit="1")
    static Object getFixedAttr(VirtualFrame frame, Object receiver, TruffleString name, @Cached(value="name") TruffleString cachedName, @Cached(value="create(name)") GetAttributeNode.GetFixedAttributeNode getAttrNode) {
        return getAttrNode.execute(frame, receiver);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(replaces={"getFixedAttr"})
    static Object getDynamicAttr(Frame frame, Node inliningTarget, Object receiver, Object name, @Cached GetClassNode getClass, @Cached(parameters={"GetAttribute"}, inline=false) LookupSpecialMethodSlotNode lookupGetattribute, @Cached(parameters={"GetAttr"}, inline=false) LookupSpecialMethodSlotNode lookupGetattr, @Cached(inline=false) CallBinaryMethodNode callGetattribute, @Cached(inline=false) CallBinaryMethodNode callGetattr, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        Object result;
        Object type = getClass.execute(inliningTarget, receiver);
        Object getattribute = lookupGetattribute.execute(frame, type, receiver);
        if (!callGetattribute.isAdoptable() && (result = PyObjectLookupAttr.readAttributeQuickly(type, getattribute, receiver, name, codePointLengthNode, codePointAtIndexNode)) != null) {
            if (result == PNone.NO_VALUE) {
                Object getattr = lookupGetattr.execute(frame, type, receiver);
                if (getattr != PNone.NO_VALUE) {
                    return callGetattr.executeObject(frame, getattr, receiver, name);
                }
                throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, receiver, name);
            }
            return result;
        }
        try {
            return callGetattribute.executeObject(frame, getattribute, receiver, name);
        }
        catch (PException e) {
            e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, errorProfile);
            Object getattr = lookupGetattr.execute(frame, type, receiver);
            if (getattr != PNone.NO_VALUE) {
                return callGetattr.executeObject(frame, getattr, receiver, name);
            }
            throw e;
        }
    }

    @NeverDefault
    public static PyObjectGetAttr create() {
        return PyObjectGetAttrNodeGen.create();
    }

    public static PyObjectGetAttr getUncached() {
        return PyObjectGetAttrNodeGen.getUncached();
    }
}

