/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.nodes.call.special.CallReversibleMethodNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNodeGen;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@GenerateUncached
public abstract class CallTernaryMethodNode
extends CallReversibleMethodNode {
    @NeverDefault
    public static CallTernaryMethodNode create() {
        return CallTernaryMethodNodeGen.create();
    }

    public static CallTernaryMethodNode getUncached() {
        return CallTernaryMethodNodeGen.getUncached();
    }

    public abstract Object execute(Frame var1, Object var2, Object var3, Object var4, Object var5);

    @Specialization(guards={"cachedInfo == info", "node != null"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callSpecialMethodSlotInlined(VirtualFrame frame, BuiltinMethodDescriptor.TernaryBuiltinDescriptor info, Object arg1, Object arg2, Object arg3, @Cached(value="info") BuiltinMethodDescriptor.TernaryBuiltinDescriptor cachedInfo, @Cached(value="getBuiltin(cachedInfo)") PythonTernaryBuiltinNode node) {
        return node.execute(frame, arg1, arg2, arg3);
    }

    @Specialization(replaces={"callSpecialMethodSlotInlined"})
    @HostCompilerDirectives.InliningCutoff
    static Object callSpecialMethodSlotCallTarget(VirtualFrame frame, BuiltinMethodDescriptor.TernaryBuiltinDescriptor info, Object arg1, Object arg2, Object arg3, @Cached GenericInvokeNode invokeNode2) {
        RootCallTarget callTarget = PythonLanguage.get(invokeNode2).getDescriptorCallTarget(info);
        Object[] arguments = PArguments.create(3);
        PArguments.setArgument(arguments, 0, arg1);
        PArguments.setArgument(arguments, 1, arg2);
        PArguments.setArgument(arguments, 2, arg3);
        return invokeNode2.execute(frame, callTarget, arguments);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null", "!isReverse"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object doBuiltinFunctionCached(VirtualFrame frame, PBuiltinFunction func, Object arg1, Object arg2, Object arg3, @Cached(value="func") PBuiltinFunction cachedFunc, @Cached(value="isForReverseBinaryOperation(func.getCallTarget())") boolean isReverse, @Cached(value="getBuiltin(frame, func, 3)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callTernaryBuiltin(frame, builtinNode, arg1, arg2, arg3);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null", "isReverse"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object doBuiltinFunctionCachedReverse(VirtualFrame frame, PBuiltinFunction func, Object arg1, Object arg2, Object arg3, @Cached(value="func") PBuiltinFunction cachedFunc, @Cached(value="isForReverseBinaryOperation(func.getCallTarget())") boolean isReverse, @Cached(value="getBuiltin(frame, func, 3)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callTernaryBuiltin(frame, builtinNode, arg1, arg2, arg3);
    }

    @Specialization(guards={"func.getCallTarget() == ct", "builtinNode != null", "!isReverse"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object doBuiltinFunctionCtCached(VirtualFrame frame, PBuiltinFunction func, Object arg1, Object arg2, Object arg3, @Cached(value="func.getCallTarget()") RootCallTarget ct, @Cached(value="isForReverseBinaryOperation(func.getCallTarget())") boolean isReverse, @Cached(value="getBuiltin(frame, func, 3)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callTernaryBuiltin(frame, builtinNode, arg1, arg2, arg3);
    }

    @Specialization(guards={"func.getCallTarget() == ct", "builtinNode != null", "isReverse"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object doBuiltinFunctionCtCachedReverse(VirtualFrame frame, PBuiltinFunction func, Object arg1, Object arg2, Object arg3, @Cached(value="func.getCallTarget()") RootCallTarget ct, @Cached(value="isForReverseBinaryOperation(func.getCallTarget())") boolean isReverse, @Cached(value="getBuiltin(frame, func, 3)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callTernaryBuiltin(frame, builtinNode, arg1, arg2, arg3);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null", "!takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object doBuiltinMethodCached(VirtualFrame frame, PBuiltinMethod func, Object arg1, Object arg2, Object arg3, @Cached(value="func") PBuiltinMethod cachedFunc, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 3)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callTernaryBuiltin(frame, builtinNode, arg1, arg2, arg3);
    }

    @Specialization(guards={"builtinNode != null", "getCallTarget(func, getCt) == ct", "!takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object doBuiltinMethodCtCached(VirtualFrame frame, PBuiltinMethod func, Object arg1, Object arg2, Object arg3, @Cached.Shared @Cached FunctionNodes.GetCallTargetNode getCt, @Cached(value="getCallTarget(func, getCt)") RootCallTarget ct, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 3)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callTernaryBuiltin(frame, builtinNode, arg1, arg2, arg3);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null", "takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callSelfMethodSingleContext(VirtualFrame frame, PBuiltinMethod func, Object arg1, Object arg2, Object arg3, @Cached(value="func", weak=true) PBuiltinMethod cachedFunc, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 4)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callQuaternaryBuiltin(frame, builtinNode, func.getSelf(), arg1, arg2, arg3);
    }

    @Specialization(guards={"builtinNode != null", "getCallTarget(func, getCt) == ct", "takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callSelfMethod(VirtualFrame frame, PBuiltinMethod func, Object arg1, Object arg2, Object arg3, @Cached.Shared @Cached FunctionNodes.GetCallTargetNode getCt, @Cached(value="getCallTarget(func, getCt)") RootCallTarget ct, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 4)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callQuaternaryBuiltin(frame, builtinNode, func.getSelf(), arg1, arg2, arg3);
    }

    @Specialization(guards={"!isTernaryBuiltinDescriptor(func)"}, replaces={"doBuiltinFunctionCached", "doBuiltinFunctionCtCached", "doBuiltinFunctionCachedReverse", "doBuiltinFunctionCtCachedReverse", "doBuiltinMethodCached", "doBuiltinMethodCtCached", "callSelfMethodSingleContext", "callSelfMethod"})
    @HostCompilerDirectives.InliningCutoff
    @ReportPolymorphism.Megamorphic
    static Object call(VirtualFrame frame, Object func, Object arg1, Object arg2, Object arg3, @Bind(value="this") Node inliningTarget, @Cached CallNode callNode, @Cached InlinedConditionProfile isBoundProfile) {
        if (isBoundProfile.profile(inliningTarget, func instanceof BoundDescriptor)) {
            return callNode.execute((Frame)frame, ((BoundDescriptor)func).descriptor, new Object[]{arg2, arg3}, PKeyword.EMPTY_KEYWORDS);
        }
        return callNode.execute((Frame)frame, func, new Object[]{arg1, arg2, arg3}, PKeyword.EMPTY_KEYWORDS);
    }
}

