/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.classes;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.AbstractObjectGetBasesNode;
import com.oracle.graal.python.nodes.classes.AbstractObjectIsSubclassNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNodeGen;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@NodeInfo(shortName="cpython://Objects/abstract.c/recursive_issubclass")
@GenerateUncached
@ImportStatic(value={PythonOptions.class, PGuards.class})
public abstract class IsSubtypeNode
extends PNodeWithContext {
    protected abstract boolean executeInternal(Frame var1, Object var2, Object var3);

    public final boolean execute(VirtualFrame frame, Object derived, Object cls) {
        return this.executeInternal((Frame)frame, derived, cls);
    }

    public final boolean execute(Object derived, Object cls) {
        return this.executeInternal(null, derived, cls);
    }

    protected static boolean isSameType(Node inliningTarget, TypeNodes.IsSameTypeNode isSameTypeNode, Object cls, Object cachedCls) {
        return isSameTypeNode.execute(inliningTarget, cls, cachedCls);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
    protected static boolean isSubMro(Node inliningTarget, Object base, PythonAbstractClass[] derivedMroAry, int mroDiff, TypeNodes.IsSameTypeNode isSameTypeNode) {
        CompilerAsserts.partialEvaluationConstant((Object)base);
        CompilerAsserts.partialEvaluationConstant((int)mroDiff);
        for (int i = 0; i <= mroDiff; ++i) {
            if (!IsSubtypeNode.isSameType(inliningTarget, isSameTypeNode, derivedMroAry[i], base)) continue;
            return true;
        }
        return false;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
    protected static boolean isInMro(Node inliningTarget, Object cls, MroSequenceStorage mro, int sz, TypeNodes.IsSameTypeNode isSameTypeNode) {
        PythonAbstractClass[] mroAry = mro.getInternalClassArray();
        for (int i = 0; i < sz; ++i) {
            if (!IsSubtypeNode.isSameType(inliningTarget, isSameTypeNode, mroAry[i], cls)) continue;
            return true;
        }
        return false;
    }

    protected static PythonBuiltinClassType getType(Node inliningTarget, Object cls, InlinedConditionProfile builtinType, InlinedConditionProfile builtinClass) {
        if (builtinType.profile(inliningTarget, cls instanceof PythonBuiltinClassType)) {
            return (PythonBuiltinClassType)((Object)cls);
        }
        if (builtinClass.profile(inliningTarget, cls instanceof PythonBuiltinClass)) {
            return ((PythonBuiltinClass)cls).getType();
        }
        return null;
    }

    @Specialization(guards={"isSameType(inliningTarget, isSameTypeNode, derived, cls)"})
    static boolean isIdentical(Object derived, Object cls, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TypeNodes.IsSameTypeNode isSameTypeNode) {
        return true;
    }

    @Specialization(guards={"cachedDerived != null", "cachedCls != null", "getType(inliningTarget, derived, builtinTypeProfile, builtinClassProfile) == cachedDerived", "getType(inliningTarget, cls, builtinTypeProfile, builtinClassProfile) == cachedCls"}, limit="getVariableArgumentInlineCacheLimit()")
    @HostCompilerDirectives.InliningCutoff
    static boolean isSubtypeOfCachedMultiContext(Object derived, Object cls, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile builtinTypeProfile, @Cached.Shared @Cached InlinedConditionProfile builtinClassProfile, @Cached(value="getType(inliningTarget, derived, builtinTypeProfile, builtinClassProfile)") PythonBuiltinClassType cachedDerived, @Cached(value="getType(inliningTarget, cls, builtinTypeProfile, builtinClassProfile)") PythonBuiltinClassType cachedCls, @Cached.Shared @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Shared @Cached TypeNodes.GetMroStorageNode getMro, @Cached(value="isInMro(inliningTarget, cachedCls, getMro.execute(inliningTarget, cachedDerived), getMro.execute(inliningTarget, cachedDerived).getInternalClassArray().length, isSameTypeNode)") boolean isInMro) {
        return isInMro;
    }

    protected static int sub(int a, int b) {
        return a - b;
    }

    @Specialization(guards={"cachedCls != null", "getType(inliningTarget, cls, builtinTypeProfile, builtinClassProfile) == cachedCls", "isKindOfBuiltinClass(derived)", "mroAry.length == derivedMroLen", "mroDiff < 16"}, replaces={"isSubtypeOfCachedMultiContext"}, limit="getVariableArgumentInlineCacheLimit()")
    @HostCompilerDirectives.InliningCutoff
    static boolean isVariableSubtypeOfConstantTypeCachedMultiContext(Object derived, Object cls, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile builtinTypeProfile, @Cached.Shared @Cached InlinedConditionProfile builtinClassProfile, @Cached.Shared @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Shared @Cached TypeNodes.GetMroStorageNode getMro, @Bind(value="getMro.execute(inliningTarget, derived).getInternalClassArray()") PythonAbstractClass[] mroAry, @Cached(value="mroAry.length") int derivedMroLen, @Cached(value="getType(inliningTarget, cls, builtinTypeProfile, builtinClassProfile)") PythonBuiltinClassType cachedCls, @Cached(value="sub(derivedMroLen, getMro.execute(inliningTarget, cachedCls).getInternalClassArray().length)") int mroDiff) {
        return IsSubtypeNode.isSubMro(inliningTarget, (Object)cachedCls, mroAry, mroDiff, isSameTypeNode);
    }

    @Specialization(guards={"isSingleContext()", "isTypeDerived.execute(inliningTarget, derived)", "isTypeCls.execute(inliningTarget, cls)", "isSameType(inliningTarget, isSameDerivedNode, derived, cachedDerived)", "isSameType(inliningTarget, isSameClsNode, cls, cachedCls)"}, limit="getVariableArgumentInlineCacheLimit()", replaces={"isSubtypeOfCachedMultiContext", "isVariableSubtypeOfConstantTypeCachedMultiContext"}, assumptions={"mro.getLookupStableAssumption()"})
    @HostCompilerDirectives.InliningCutoff
    static boolean isSubtypeOfCached(Object derived, Object cls, @Bind(value="this") Node inliningTarget, @Cached(value="derived") Object cachedDerived, @Cached(value="cls") Object cachedCls, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeDerived, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeCls, @Cached.Shared @Cached TypeNodes.IsSameTypeNode isSameDerivedNode, @Cached.Shared @Cached TypeNodes.IsSameTypeNode isSameClsNode, @Cached.Shared @Cached TypeNodes.IsSameTypeNode isSameTypeInLoopNode, @Cached.Shared @Cached TypeNodes.GetMroStorageNode getMro, @Cached(value="getMro.execute(inliningTarget, cachedDerived)") MroSequenceStorage mro, @Cached(value="isInMro(inliningTarget, cachedCls, mro, mro.getInternalClassArray().length, isSameTypeInLoopNode)") boolean isInMro) {
        return isInMro;
    }

    @Specialization(guards={"isSingleContext()", "isTypeDerived.execute(inliningTarget, derived)", "isTypeCls.execute(inliningTarget, cls)", "isSameType(inliningTarget, isSameDerivedNode, derived, cachedDerived)", "mro.getInternalClassArray().length < 32"}, limit="getVariableArgumentInlineCacheLimit()", replaces={"isSubtypeOfCachedMultiContext", "isVariableSubtypeOfConstantTypeCachedMultiContext", "isSubtypeOfCached"}, assumptions={"mro.getLookupStableAssumption()"})
    @HostCompilerDirectives.InliningCutoff
    static boolean isSubtypeOfVariableTypeCached(Object derived, Object cls, @Bind(value="this") Node inliningTarget, @Cached(value="derived") Object cachedDerived, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeDerived, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeCls, @Cached.Shared @Cached TypeNodes.GetMroStorageNode getMro, @Cached(value="getMro.execute(inliningTarget, cachedDerived)") MroSequenceStorage mro, @Cached(value="mro.getInternalClassArray().length") int sz, @Cached.Shared @Cached TypeNodes.IsSameTypeNode isSameTypeInLoopNode, @Cached.Shared @Cached TypeNodes.IsSameTypeNode isSameDerivedNode) {
        return IsSubtypeNode.isInMro(inliningTarget, cls, mro, sz, isSameTypeInLoopNode);
    }

    @Specialization(guards={"isSingleContext()", "isKindOfBuiltinClass(derived)", "isKindOfBuiltinClass(cls)", "mroAry.length == derivedMroLen", "mroDiff < 16", "isSameType(inliningTarget, isSameClsNode, cls, cachedCls)"}, limit="getVariableArgumentInlineCacheLimit()", replaces={"isSubtypeOfCachedMultiContext", "isVariableSubtypeOfConstantTypeCachedMultiContext", "isSubtypeOfCached", "isSubtypeOfVariableTypeCached"}, assumptions={"baseMro.getLookupStableAssumption()"})
    @HostCompilerDirectives.InliningCutoff
    static boolean isVariableSubtypeOfConstantTypeCached(Object derived, Object cls, @Bind(value="this") Node inliningTarget, @Cached(value="cls") Object cachedCls, @Cached.Shared @Cached TypeNodes.GetMroStorageNode getMro, @Cached(value="getMro.execute(inliningTarget, cachedCls)") MroSequenceStorage baseMro, @Cached.Shared @Cached TypeNodes.IsSameTypeNode isSameTypeInLoopNode, @Bind(value="getMro.execute(inliningTarget, derived).getInternalClassArray()") PythonAbstractClass[] mroAry, @Cached(value="mroAry.length") int derivedMroLen, @Cached(value="sub(derivedMroLen, baseMro.getInternalClassArray().length)") int mroDiff, @Cached.Shared @Cached TypeNodes.IsSameTypeNode isSameClsNode) {
        return IsSubtypeNode.isSubMro(inliningTarget, cachedCls, mroAry, mroDiff, isSameTypeInLoopNode);
    }

    @Specialization(guards={"isTypeDerived.execute(inliningTarget, derived)", "isTypeCls.execute(inliningTarget, cls)", "mro.getInternalClassArray().length == sz", "sz < 16"}, limit="getVariableArgumentInlineCacheLimit()", replaces={"isSubtypeOfCachedMultiContext", "isVariableSubtypeOfConstantTypeCachedMultiContext", "isSubtypeOfCached", "isSubtypeOfVariableTypeCached", "isVariableSubtypeOfConstantTypeCached"})
    @HostCompilerDirectives.InliningCutoff
    static boolean isSubtypeGenericCachedLen(Object derived, Object cls, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeDerived, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeCls, @Cached.Shared @Cached TypeNodes.GetMroStorageNode getMro, @Bind(value="getMro.execute(inliningTarget, derived)") MroSequenceStorage mro, @Cached(value="mro.getInternalClassArray().length") int sz, @Cached.Shared @Cached TypeNodes.IsSameTypeNode isSameTypeInLoopNode) {
        return IsSubtypeNode.isInMro(inliningTarget, cls, mro, sz, isSameTypeInLoopNode);
    }

    @Specialization(guards={"isTypeDerived.execute(inliningTarget, derived)", "isTypeCls.execute(inliningTarget, cls)"}, replaces={"isVariableSubtypeOfConstantTypeCached", "isSubtypeOfCachedMultiContext", "isVariableSubtypeOfConstantTypeCachedMultiContext", "isSubtypeOfCached", "isSubtypeOfVariableTypeCached", "isSubtypeGenericCachedLen"}, limit="1")
    @HostCompilerDirectives.InliningCutoff
    @ReportPolymorphism.Megamorphic
    static boolean issubTypeGeneric(Object derived, Object cls, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeDerived, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeCls, @Cached.Exclusive @Cached InlinedConditionProfile builtinClassIsSubtypeProfile, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached TypeNodes.GetMroStorageNode getMro) {
        if (builtinClassIsSubtypeProfile.profile(inliningTarget, IsSubtypeNode.isBuiltinClass(derived) && !IsSubtypeNode.isBuiltinClass(cls))) {
            return false;
        }
        for (PythonAbstractClass n : getMro.execute(inliningTarget, derived).getInternalClassArray()) {
            if (!IsSubtypeNode.isSameType(inliningTarget, isSameTypeNode, n, cls)) continue;
            return true;
        }
        return false;
    }

    @Specialization(guards={"!isTypeDerived.execute(inliningTarget, derived) || !isTypeCls.execute(inliningTarget, cls)"}, limit="1")
    @HostCompilerDirectives.InliningCutoff
    @ReportPolymorphism.Megamorphic
    static boolean fallback(VirtualFrame frame, Object derived, Object cls, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeDerived, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeCls, @Cached AbstractObjectGetBasesNode getBasesNode, @Cached AbstractObjectIsSubclassNode abstractIsSubclassNode, @Cached.Exclusive @Cached InlinedConditionProfile exceptionDerivedProfile, @Cached.Exclusive @Cached InlinedConditionProfile exceptionClsProfile, @Cached PRaiseNode.Lazy raise) {
        if (exceptionDerivedProfile.profile(inliningTarget, getBasesNode.execute(frame, derived) == null)) {
            throw raise.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ARG_D_MUST_BE_S, "issubclass()", 1, "class");
        }
        if (exceptionClsProfile.profile(inliningTarget, getBasesNode.execute(frame, cls) == null)) {
            throw raise.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ISSUBCLASS_MUST_BE_CLASS_OR_TUPLE);
        }
        return abstractIsSubclassNode.execute(frame, derived, cls);
    }

    private static boolean isBuiltinClass(Object cls) {
        return cls instanceof PythonBuiltinClass || cls instanceof PythonBuiltinClassType;
    }

    @NeverDefault
    public static IsSubtypeNode create() {
        return IsSubtypeNodeGen.create();
    }

    public static IsSubtypeNode getUncached() {
        return IsSubtypeNodeGen.getUncached();
    }
}

